/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.web.multipart.MultipartFile;

public class Shp2GsonService {
    private String rootPath = null;

    public Shp2GsonService(String downloadPath) {
        this.rootPath = downloadPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startExchange(MultipartFile mulFile) {
        String filename = mulFile.getOriginalFilename();
        String dirPath = this.rootPath + "shp2gson\\gson";
        String zipPath = this.rootPath + "shp2gson\\shp";
        String jsonPath = dirPath + "\\" + filename.substring(0, filename.indexOf(".")) + ".geojson";
        FeatureJSON featureJson = new FeatureJSON();
        File zipFile = MulFileUtil.getFileFromMultipartFile(mulFile, ".zip", zipPath);
        File[] files = ZipUtil1s.unZip(zipFile, zipPath);
        if (files == null) {
            return null;
        }
        String zipDirFileName = zipPath + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
        File zipDirFile = new File(zipDirFileName);
        List shpFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.shp");
        File shpFile = new File((String)shpFileList.get(0));
        try {
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsonPath), "UTF-8"));
            ShapefileDataStore shpDataStore = null;
            shpDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shpDataStore.setCharset(Charset.forName("gbk"));
            String typeName = shpDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = null;
            featureSource = shpDataStore.getFeatureSource(typeName);
            int crsId = 4490;
            String crsData = CRS.toSRS((CoordinateReferenceSystem)shpDataStore.getSchema().getCoordinateReferenceSystem());
            if (crsData.toLowerCase().contains("epsg")) {
                crsId = Integer.parseInt(crsData.toLowerCase().replaceAll("[^0-9]", ""));
            } else {
                Map<String, String> crsDataMap = StrUtil.splitCrsData(crsData);
                crsId = StrUtil.getCrsId(crsDataMap);
            }
            out.write("{\"type\": \"FeatureCollection\",\"crs\": {\"type\":\"name\",\"properties\":{\"crs\":\"EPSG:" + crsId + "\"}},");
            out.write("\"features\": [");
            SimpleFeatureCollection result = featureSource.getFeatures();
            SimpleFeatureIterator itertor = result.features();
            int count = 1;
            while (itertor.hasNext()) {
                SimpleFeature feature = (SimpleFeature)itertor.next();
                StringWriter writer = new StringWriter();
                featureJson.writeFeature(feature, (Object)writer);
                out.write(writer.toString());
                if (count != result.size()) {
                    out.write(",");
                }
                ++count;
            }
            out.write("]}");
            itertor.close();
            out.flush();
            out.close();
            String string = jsonPath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            FileUtil.deleteFileAndDir((File)new File(zipPath));
        }
    }
}

