/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.web.multipart.MultipartFile;

public class Shp2TxtService {
    private Logger log = Logger.getLogger(this.getClass().toGenericString());
    private String rootPath = null;

    public Shp2TxtService(String downloadPath) {
        this.rootPath = downloadPath;
    }

    public String startExchange(MultipartFile shapeFile, String fileNum) {
        List dbfFileList;
        String shpDir = this.rootPath + "shp2txt\\shp";
        String txtDir = this.rootPath + "shp2txt\\txt";
        Object shpFile = null;
        File zipFile = MulFileUtil.getFileFromMultipartFile(shapeFile, ".zip", shpDir);
        File[] files = ZipUtil1s.unZip(zipFile, shpDir);
        if (files == null) {
            return null;
        }
        List<Geometry> geoms = null;
        List<Map> fields = null;
        JSONArray muTiPolygonList = new JSONArray();
        Map<String, String> headData = null;
        String zipDirFileName = shpDir + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
        File zipDirFile = new File(zipDirFileName);
        List prjFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.prj");
        if (prjFileList != null && prjFileList.size() > 0) {
            headData = Shp2TxtService.readPRJ((String)prjFileList.get(0));
        }
        List shpFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.shp");
        ShapeOprate shapeOprate = new ShapeOprate();
        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp((String)shpFileList.get(0));
            try {
                muTiPolygonList = Shp2TxtService.getMuTiPolygon(geoms);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((dbfFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.dbf")) != null && dbfFileList.size() > 0) {
            fields = MulFileUtil.readDBF((String)dbfFileList.get(0));
        }
        Map field = (Map)fields.get(0);
        for (Map.Entry head : field.entrySet()) {
            switch ((String)head.getKey()) {
                case "GSBB": {
                    headData.put("\u683c\u5f0f\u7248\u672c\u53f7", (String)head.getValue());
                    break;
                }
                case "SJCSDW": {
                    headData.put("\u6570\u636e\u4ea7\u751f\u5355\u4f4d", (String)head.getValue());
                    break;
                }
                case "SJCSRQ": {
                    headData.put("\u6570\u636e\u4ea7\u751f\u65e5\u671f", (String)head.getValue());
                    break;
                }
            }
        }
        String success = this.createTxt(headData, fields, muTiPolygonList, txtDir, shapeFile.getOriginalFilename(), fileNum);
        FileUtil.deleteFileAndDir((File)new File(shpDir));
        return success;
    }

    private static JSONArray muTi2single(String geoStr) {
        JSONArray muTiPolygonList = new JSONArray();
        String rex = "\\([^(]*[^)]\\)";
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(geoStr);
        while (matcher.find()) {
            if (matcher.group().contains(")), ((")) {
                Shp2TxtService.muTi2single(matcher.group());
                continue;
            }
            String tem = "[" + matcher.group().replaceAll("\\(|\\)", "") + "]";
            muTiPolygonList.addAll((Collection)JSONArray.parseArray((String)tem, (Feature[])new Feature[0]));
        }
        return muTiPolygonList;
    }

    private static JSONArray getMuTiPolygon(List<Geometry> geometries) {
        JSONArray muTiPolygonList = new JSONArray();
        for (Geometry geo : geometries) {
            if (geo == null || "".equals(geo.toString().replaceAll(" ", ""))) continue;
            String geoStr = geo.toString();
            muTiPolygonList.addAll((Collection)Shp2TxtService.muTi2single(geoStr));
        }
        return muTiPolygonList;
    }

    private static Map<String, String> readPRJ(String path) {
        String wkt = null;
        HashMap<String, String> headData = new HashMap<String, String>();
        ArrayList<String> unitList = new ArrayList<String>();
        try {
            File fin = new File(path);
            FileInputStream fis = new FileInputStream(fin);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                wkt = line;
            }
            br.close();
            fis.close();
            String rex = "(UNIT\\[[^]]*])";
            Pattern pattern = Pattern.compile(rex);
            Matcher matcher = pattern.matcher(wkt);
            while (matcher.find()) {
                unitList.add(matcher.group());
            }
            String head = CRS.parseWKT((String)wkt).getName().toString().toLowerCase();
            boolean is3Degree = true;
            String daiHao = null;
            if (unitList.size() > 0) {
                String measure = (String)unitList.get(0);
                headData.put("\u8ba1\u91cf\u5355\u4f4d", measure.substring(measure.indexOf("\"") + 1, measure.lastIndexOf("\"")));
            }
            if (head.contains("2000")) {
                headData.put("\u5750\u6807\u7cfb", "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb");
            }
            if (head.contains("gauss") || head.contains("kruger") || head.contains("gk")) {
                headData.put("\u6295\u5f71\u7c7b\u578b", "\u9ad8\u65af\u514b\u5415\u683c");
                String degreeRex = "3.*degree";
                Pattern degreePt = Pattern.compile(degreeRex);
                Matcher degreeMc = degreePt.matcher(head);
                if (degreeMc.find()) {
                    headData.put("\u51e0\u5ea6\u5206\u5e26", "3");
                } else {
                    headData.put("\u51e0\u5ea6\u5206\u5e26", "6");
                    is3Degree = false;
                }
                if (head.contains("zone")) {
                    daiHao = head.split("zone")[1].replaceAll("[^1-9]", "");
                } else if (head.contains("cm")) {
                    int longitude = Integer.parseInt(head.split("cm")[1].replaceAll("[^1-9]", ""));
                    daiHao = is3Degree ? Math.floor(longitude / 3) + "" : Math.floor((longitude + 3) / 6) + "";
                }
                headData.put("\u5e26\u53f7", daiHao);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        return headData;
    }

    private List<String> getTxtNum(List<List<String>> fieldList) {
        int index = fieldList.get(0).get(0) == null ? 4 : 0;
        ArrayList<String> symbolList = new ArrayList<String>();
        ArrayList<String> identical = new ArrayList<String>();
        for (int i = 0; i < fieldList.size(); ++i) {
            symbolList.add(fieldList.get(i).get(index));
        }
        for (String symbol : symbolList) {
            if (identical.contains(symbol)) continue;
            identical.add(symbol);
        }
        return identical;
    }

    private List<String> checkOrder(Map<String, String> field) {
        ArrayList<String> fieldList = new ArrayList<String>();
        String rex = ",,,,,,,";
        String rex1 = ",JZDSL,ZMJ,DKMC,XMMC,LX,SJTFH,DLMC";
        String rex2 = "\u7535\u5b50\u76d1\u7ba1\u53f7,\u754c\u5740\u70b9\u6570\u91cf,\u603b\u9762\u79ef,\u5730\u5757\u540d\u79f0,\u9879\u76ee\u540d\u79f0,\u7c7b\u578b,\u6d89\u53ca\u56fe\u5e45\u53f7,\u5730\u7c7b\u540d\u79f0";
        String rex3 = ",,,ZLDWMC,XMMC,,,";
        int format = 0;
        if (format == 0 && StrUtil.haveAttribute(rex1, field)) {
            format = 1;
        }
        if (format == 0 && StrUtil.haveAttribute(rex2, field)) {
            format = 2;
        }
        if (format == 0 && StrUtil.haveAttribute(rex3, field)) {
            format = 3;
        }
        switch (format) {
            case 1: {
                for (String attr : rex1.split(",")) {
                    fieldList.add(field.get(attr));
                }
                break;
            }
            case 2: {
                for (String attr : rex2.split(",")) {
                    fieldList.add(field.get(attr));
                }
                break;
            }
            case 3: {
                for (String attr : rex3.split(",")) {
                    if ("".equals(attr) || null == attr) {
                        fieldList.add(attr);
                        continue;
                    }
                    fieldList.add(field.get(attr));
                }
                break;
            }
            default: {
                for (String attr : rex.split(",")) {
                    if ("".equals(attr) || null == attr) {
                        fieldList.add(attr);
                        continue;
                    }
                    fieldList.add(field.get(attr));
                }
            }
        }
        return fieldList;
    }

    private String createTxt(Map<String, String> headData, List<Map> fields, JSONArray muTiPolygonList, String txtDir, String filename, String fileNum) {
        ArrayList<List<String>> fieldList = new ArrayList<List<String>>();
        for (int i = 0; i < fields.size(); ++i) {
            if (this.checkOrder(fields.get(i)) == null) {
                return null;
            }
            fieldList.add(this.checkOrder(fields.get(i)));
        }
        String filePath = txtDir + "\\" + filename.substring(0, filename.indexOf(".")) + "_" + fileNum;
        if ("multiple".equals(fileNum)) {
            List<String> identical = this.getTxtNum(fieldList);
            for (String symbol : identical) {
                if (null != this.writeFile(headData, fieldList, muTiPolygonList, txtDir, filename, symbol, fileNum)) continue;
                filePath = null;
                break;
            }
        } else if (null == this.writeFile(headData, fieldList, muTiPolygonList, txtDir, filename, null, fileNum)) {
            filePath = null;
        }
        return filePath;
    }

    private String writeFile(Map<String, String> headData, List<List<String>> fieldList, JSONArray muTiPolygonList, String txtDir, String filename, String symbol, String fileNum) {
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        String fileDir = txtDir + "\\" + filename.substring(0, filename.indexOf(".")) + "_" + fileNum;
        String txt = fileDir + "\\" + filename.substring(0, filename.indexOf(".")) + (symbol == null ? "" : "_" + symbol) + ".txt";
        try {
            File dir = new File(fileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(txt);
            fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            writer = new BufferedWriter(osw);
            writer.write("[\u5c5e\u6027\u63cf\u8ff0]\n");
            for (Map.Entry<String, String> head : headData.entrySet()) {
                writer.write(head.getKey() + "=" + head.getValue() + "\n");
            }
            writer.write("[\u5730\u5757\u5750\u6807]\n");
            for (int i = 0; i < fieldList.size(); ++i) {
                List<String> fieldListOrder = fieldList.get(i);
                boolean write = false;
                if (fieldListOrder == null) {
                    writer.close();
                    fos.close();
                    FileUtil.deleteFileAndDir((File)dir);
                    return null;
                }
                if ("multiple".equals(fileNum)) {
                    if (fieldListOrder.contains(symbol)) {
                        write = true;
                    }
                } else {
                    write = true;
                }
                if (!write) continue;
                if (muTiPolygonList.get(i) != null) {
                    JSONArray mulTiPolygon = muTiPolygonList.getJSONArray(i);
                    block7: for (int m = 0; m < mulTiPolygon.size(); ++m) {
                        JSONArray polygon = mulTiPolygon.getJSONArray(m);
                        Geometry geometry = StrUtil.wktToGeometry(Shp2TxtService.getWkt(polygon), StrUtil.getCrsId(headData));
                        if (Double.parseDouble(polygon.getString(0).split(" ")[0]) < 180.0) {
                            try {
                                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4490"), (CoordinateReferenceSystem)CRS.decode((String)("EPSG:" + StrUtil.epsgForArea(geometry))));
                                geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
                            }
                            catch (FactoryException e) {
                                e.printStackTrace();
                            }
                            catch (TransformException e) {
                                e.printStackTrace();
                            }
                        }
                        double squareMArea = geometry.getArea();
                        double squareKMArea = Double.parseDouble(String.format("%.4f", squareMArea / 10000.0));
                        int jzd = polygon.size();
                        writer.write(jzd + ",");
                        writer.write(squareKMArea + ",");
                        for (int n = 3; n < fieldListOrder.size(); ++n) {
                            String tem = fieldListOrder.get(n) == null ? "" : fieldListOrder.get(n);
                            writer.write(tem + ",");
                        }
                        writer.write("@\n");
                        for (int l = 0; l < polygon.size(); ++l) {
                            String[] point = polygon.get(l).toString().split(" ");
                            if (l == polygon.size() - 1) {
                                writer.write("J1,1," + point[1] + "," + point[0] + "\n");
                                continue block7;
                            }
                            writer.write("J" + (l + 1) + "," + 1 + "," + point[1] + "," + point[0] + "\n");
                        }
                    }
                    continue;
                }
                writer.close();
                fos.close();
                FileUtil.deleteFileAndDir((File)dir);
                return null;
            }
            writer.flush();
            writer.close();
            fos.close();
            return txt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getWkt(JSONArray polygon) {
        String wkt = "MULTIPOLYGON (";
        wkt = wkt + "((";
        for (int j = 0; j < polygon.size(); ++j) {
            String[] point = polygon.getString(j).split(" ");
            wkt = wkt + point[0] + " " + point[1] + ",";
        }
        wkt = wkt.substring(0, wkt.lastIndexOf(","));
        wkt = wkt + "))";
        wkt = wkt + ")";
        return wkt;
    }
}

