/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.landcloud.service.formatConversion.utils.FieldEntity;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class TransformShpService {
    String uploadDir;
    String downloadDir;
    RedisTemplate redisTemplate = null;
    private List<String> filePaths = new ArrayList<String>();

    public TransformShpService(String uploadDir, RedisTemplate redisTemplate, String downloadDir) {
        this.uploadDir = uploadDir;
        this.redisTemplate = redisTemplate;
        this.downloadDir = downloadDir;
    }

    public List<Integer> parsingShapeFile(HttpServletRequest request, String belt, String trans_rule) throws IOException {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<Integer> belts = new ArrayList<Integer>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                List shapeFile = multiRequest.getFiles((String)iter.next());
                String[] target = belt.split(",");
                String[] trans_rules = trans_rule.split(",");
                for (int i = 0; i < shapeFile.size(); ++i) {
                    String fileName;
                    if (shapeFile.get(i) == null || !(fileName = ((MultipartFile)shapeFile.get(i)).getOriginalFilename()).endsWith(".zip")) continue;
                    belts.add(this.shapeFile((MultipartFile)shapeFile.get(i), fileName, target[i], trans_rules[i]));
                }
            }
        }
        return belts;
    }

    public Integer shapeFile(MultipartFile shapeFile, String fileName, String belt, String trans_rule) throws IOException {
        File zipFile = this.getFileFromMultipartFile(shapeFile, ".zip");
        File[] files = ZipUtil1s.unZip(zipFile, this.uploadDir);
        if (files == null) {
            // empty if block
        }
        String zipDirFileName = this.uploadDir + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
        File zipDirFile = new File(zipDirFileName);
        List shpFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.shp");
        if (shpFileList.isEmpty()) {
            System.out.println("\u6ca1\u6709shp\u6587\u4ef6");
            return 0;
        }
        for (int i = 0; i < shpFileList.size(); ++i) {
            String fileShp = ((String)shpFileList.get(i)).toString();
            fileShp = fileShp.replaceAll("\\\\", "\\\\\\\\");
            shpFileList.set(i, fileShp);
        }
        this.filePaths.clear();
        Integer theBelt = this.shpInfo(shpFileList, fileName, belt, trans_rule);
        FileUtil.deleteFileAndDir((File)zipDirFile);
        return theBelt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public Integer shpInfo(List<String> shpFilePath, String zipName, String belt, String trans_rule) throws IOException {
        Integer tarEpsg = 0;
        for (int i = 0; i < shpFilePath.size(); ++i) {
            ShapefileDataStore dataStore = TransformShpService.buildDataStore(shpFilePath.get(i));
            long startTime = System.currentTimeMillis();
            File file = new File(shpFilePath.get(i));
            if (file == null) {
                // empty if block
            }
            FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = featureSource.getFeatures();
            SimpleFeatureIterator itertor = simpleFeatureCollection.features();
            ArrayList<List<Object>> datarows = new ArrayList<List<Object>>();
            ArrayList<FieldEntity> fields = new ArrayList<FieldEntity>();
            ArrayList equalEpsg = new ArrayList();
            Integer finalEpsg = 0;
            while (itertor.hasNext()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                SimpleFeature feature = (SimpleFeature)itertor.next();
                Collection p = feature.getProperties();
                Iterator it = p.iterator();
                ArrayList<FieldEntity> field = new ArrayList<FieldEntity>();
                ArrayList<Object> datarow = new ArrayList<Object>();
                Integer geoNum = 0;
                while (it.hasNext()) {
                    Property pro = (Property)it.next();
                    String name = pro.getName().toString();
                    name = name.equals("the_geom") ? "wkt" : name;
                    FieldEntity fieldEntity = new FieldEntity(pro.getName().toString(), pro.getValue().getClass());
                    field.add(geoNum, fieldEntity);
                    data.put(name, pro.getValue());
                    if (name == "wkt") {
                        if (geoNum == 0) {
                            finalEpsg = StrUtil.getEpsg((Geometry)pro.getValue(), belt);
                        }
                        Geometry transgeo = null;
                        try {
                            String wkt = dataStore.getSchema().getCoordinateReferenceSystem().toWKT();
                            CoordinateReferenceSystem crsTarget = CRS.decode((String)("EPSG:" + finalEpsg.toString()));
                            CoordinateReferenceSystem crsSource = CRS.parseWKT((String)wkt);
                            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crsSource, (CoordinateReferenceSystem)crsTarget, (boolean)true);
                            transgeo = JTS.transform((Geometry)((Geometry)pro.getValue()), (MathTransform)transform);
                        }
                        catch (UnsupportedOperationException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (FactoryException e) {
                            e.printStackTrace();
                        }
                        catch (TransformException e) {
                            e.printStackTrace();
                        }
                        datarow.add(transgeo);
                    } else {
                        datarow.add(pro.getValue());
                    }
                    Integer n = geoNum;
                    Integer n2 = geoNum = Integer.valueOf(geoNum + 1);
                }
                fields = field;
                datarows.add(datarow);
            }
            itertor.close();
            File tempFile = new File(shpFilePath.get(i).trim());
            String fileName = tempFile.getName();
            this.filePaths.add(this.downloadDir + "\\" + fileName);
            Boolean readyOut = i == shpFilePath.size() - 1;
            this.write(this.downloadDir + "\\" + fileName, fields, datarows, zipName, finalEpsg, readyOut, trans_rule);
            long endTime = System.currentTimeMillis();
            System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
            tarEpsg = finalEpsg;
            dataStore.dispose();
        }
        return tarEpsg;
    }

    public void write(String filepath, List<FieldEntity> fields, List<List<Object>> dataRows, String zipName, Integer targetCode, Boolean readyOut, String trans_rule) {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        if (filepath == null || fields == null || dataRows == null) {
            return;
        }
        if (dataRows.size() == 0) {
            System.out.println("\u672a\u83b7\u53d6\u5230\u5c5e\u6027\u503c\uff01");
        } else if (fields.size() != dataRows.get(0).size()) {
            return;
        }
        try {
            File file = new File(filepath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            tb.setCRS(CRS.decode((String)("EPSG:" + targetCode)));
            tb.setName("shapefile");
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader wtkreader = new WKTReader(geometryFactory);
            tb.setDefaultGeometry("the_geom");
            for (int i = 0; i < fields.size(); ++i) {
                if (fields.get((int)i).fieldName.equals("the_geom")) {
                    tb.add(fields.get((int)i).fieldName, fields.get((int)i).fieldType, CRS.decode((String)("EPSG:" + targetCode)));
                    continue;
                }
                tb.add(fields.get((int)i).fieldName, fields.get((int)i).fieldType);
            }
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            ds.setCharset(Charset.forName("ISO-8859-1"));
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            for (int index = 0; index < dataRows.size(); ++index) {
                List<Object> row = dataRows.get(index);
                if (row == null || fields.size() != row.size()) continue;
                SimpleFeature feature = (SimpleFeature)writer.next();
                for (int fIndex = 0; fIndex < row.size(); ++fIndex) {
                    if (row.get(fIndex).getClass() == fields.get((int)fIndex).fieldType) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, row.get(fIndex));
                        continue;
                    }
                    if (!fields.get((int)fIndex).fieldName.equals("the_geom") || row.get(fIndex).getClass() != String.class) continue;
                    String wkt = row.get(fIndex).toString();
                    Geometry geom = wtkreader.read(wkt);
                    if (fields.get((int)fIndex).fieldType == LineString.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((LineString)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType == Polygon.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((Polygon)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType == Point.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((Point)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType == MultiPoint.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((MultiPoint)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType == MultiLineString.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((MultiLineString)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType != MultiPolygon.class) continue;
                    feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((MultiPolygon)geom));
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            if (readyOut.booleanValue()) {
                this.zipShapeFile(zipName, trans_rule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zipShapeFile(String zipName, String trans_rule) {
        try {
            ArrayList<String> shpFiles = new ArrayList<String>();
            String outRoot = "";
            for (int i = 0; i < this.filePaths.size(); ++i) {
                File shpFile = new File(this.filePaths.get(i));
                String shpRoot = shpFile.getParentFile().getPath();
                String _shpName = shpFile.getName();
                String shpName = _shpName.substring(0, _shpName.lastIndexOf("."));
                outRoot = shpRoot;
                shpFiles.add(shpRoot + File.separator + shpName + ".dbf");
                shpFiles.add(shpRoot + File.separator + shpName + ".prj");
                shpFiles.add(shpRoot + File.separator + shpName + ".shp");
                shpFiles.add(shpRoot + File.separator + shpName + ".shx");
            }
            String zipPath = outRoot + File.separator + zipName;
            File zipFile = new File(zipPath);
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
            FileInputStream input = null;
            for (int j = 0; j < shpFiles.size(); ++j) {
                File _file = new File((String)shpFiles.get(j));
                input = new FileInputStream(_file);
                zipOut.putNextEntry(new ZipEntry(_file.getName()));
                int temp = 0;
                while ((temp = ((InputStream)input).read()) != -1) {
                    zipOut.write(temp);
                }
                ((InputStream)input).close();
                _file.delete();
            }
            File fixFile = new File(outRoot);
            if (!fixFile.exists() || !fixFile.isDirectory()) {
                return;
            }
            String[] tmpList = fixFile.list();
            if (tmpList != null) {
                for (String aTempList : tmpList) {
                    File tmpFile = new File(fixFile, aTempList);
                    if (!tmpFile.isFile() || !tmpFile.getName().endsWith(".fix")) continue;
                    tmpFile.delete();
                }
            }
            zipOut.close();
            this.redisTemplate.opsForList().rightPush((Object)"username", (Object)(zipFile.getName() + "|" + trans_rule));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore)factory.createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("UTF-8"));
            }
            return dataStore;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

