/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.springframework.web.multipart.MultipartFile;

public class Txt2ShpService {
    private String rootPath = null;

    public Txt2ShpService(String downloadPath) {
        this.rootPath = downloadPath;
    }

    public String startExchange(MultipartFile mulFile) {
        Map<String, Object> allShapeData = null;
        String path = this.rootPath + "txt2shp";
        File txtFile = MulFileUtil.getFileFromMultipartFile(mulFile, ".txt", path);
        allShapeData = Txt2ShpService.readTxtFile(txtFile);
        if (allShapeData == null) {
            return null;
        }
        String filename = mulFile.getOriginalFilename();
        allShapeData.put("fileName", filename);
        allShapeData.put("folderName", txtFile.getName());
        return this.createShp(allShapeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createShp(Map<String, Object> allShapeData) {
        ArrayList attrsMapList = (ArrayList)allShapeData.get("feature");
        Integer SRID = (Integer)allShapeData.get("crsId");
        List geometryList = (List)allShapeData.get("geometryList");
        Map headData = (Map)allShapeData.get("headData");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        try {
            tb.setCRS(CRS.decode((String)("EPSG:" + SRID)));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        tb.setName("shapefile");
        tb.add("the_geom", MultiPolygon.class);
        tb.setDefaultGeometry("the_geom");
        for (Map.Entry attr : ((Map)attrsMapList.get(0)).entrySet()) {
            tb.add((String)attr.getKey(), String.class);
        }
        for (Map.Entry head : headData.entrySet()) {
            tb.add((String)head.getKey(), String.class);
        }
        String path = this.rootPath + "txt2shp\\shp";
        String folderName = (String)allShapeData.get("folderName");
        String fileName = (String)allShapeData.get("fileName");
        folderName = folderName.substring(0, folderName.indexOf("."));
        fileName = fileName.substring(0, fileName.indexOf("."));
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File shapeFileFolder = null;
        ShapefileDataStore ds = null;
        FeatureWriter writer = null;
        String shapefileFolderPath = dir.getAbsolutePath() + File.separator + fileName;
        try {
            shapeFileFolder = new File(shapefileFolderPath);
            if (!shapeFileFolder.exists()) {
                shapeFileFolder.mkdirs();
            }
            String shapeFilePath = shapefileFolderPath + File.separator + fileName + ".shp";
            File file = new File(shapeFilePath);
            file.createNewFile();
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            ds.setCharset(Charset.forName("GBK"));
            String typeName = ds.getTypeNames()[0];
            writer = ds.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);
            for (int i = 0; i < attrsMapList.size(); ++i) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute("the_geom", geometryList.get(i));
                for (Map.Entry attr : ((Map)attrsMapList.get(i)).entrySet()) {
                    if ("ZMJ".equals(attr.getKey())) {
                        feature.setAttribute((String)attr.getKey(), (Object)Double.parseDouble(String.format("%.4f", ((Geometry)geometryList.get(i)).getArea() / 10000.0)));
                        continue;
                    }
                    feature.setAttribute((String)attr.getKey(), attr.getValue());
                }
                for (Map.Entry head : headData.entrySet()) {
                    feature.setAttribute((String)head.getKey(), head.getValue());
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            String string = shapefileFolderPath;
            return string;
        }
        catch (Exception e) {
            if (shapeFileFolder.exists()) {
                shapeFileFolder.delete();
            }
            String string = null;
            return string;
        }
        finally {
            try {
                writer.close();
                ds.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> readTxtFile(File file) {
        Geometry geometry = null;
        ArrayList<Geometry> geometryList = new ArrayList<Geometry>();
        JSONArray points = new JSONArray();
        HashMap<String, String> crsAttrs = new HashMap<String, String>();
        ArrayList<Map> feature = new ArrayList<Map>();
        HashMap<String, Object> allShapeData = new HashMap<String, Object>();
        HashMap<String, String> headData = new HashMap<String, String>();
        try {
            String encoding = MulFileUtil.getFileCharSet(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            String lineTxt = null;
            int i = -1;
            int j = 0;
            boolean flag = false;
            while ((lineTxt = br.readLine()) != null) {
                if (!flag && lineTxt.contains("=")) {
                    switch (lineTxt.split("=")[0]) {
                        case "\u5750\u6807\u7cfb": {
                            crsAttrs.put("\u5750\u6807\u7cfb", lineTxt.split("=")[1]);
                            break;
                        }
                        case "\u51e0\u5ea6\u5206\u5e26": {
                            crsAttrs.put("\u51e0\u5ea6\u5206\u5e26", lineTxt.split("=")[1]);
                            break;
                        }
                        case "\u5e26\u53f7": {
                            crsAttrs.put("\u5e26\u53f7", lineTxt.split("=")[1]);
                            break;
                        }
                        case "\u683c\u5f0f\u7248\u672c\u53f7": {
                            headData.put("GSBB", lineTxt.split("=")[1]);
                            break;
                        }
                        case "\u6570\u636e\u4ea7\u751f\u5355\u4f4d": {
                            headData.put("SJCSDW", lineTxt.split("=")[1]);
                            break;
                        }
                        case "\u6570\u636e\u4ea7\u751f\u65e5\u671f": {
                            headData.put("SJCSRQ", lineTxt.split("=")[1]);
                            break;
                        }
                    }
                }
                if (flag && !lineTxt.contains("@")) {
                    Point point = Txt2ShpService.createPoint(Double.parseDouble(lineTxt.split(",")[2]), Double.parseDouble(lineTxt.split(",")[3]));
                    Double[] arr = new Double[]{point.getY(), point.getX()};
                    HashMap<String, Object> tem = new HashMap<String, Object>();
                    tem.put("point", arr);
                    tem.put("region", lineTxt.split(",")[1]);
                    points.getJSONArray(i).getJSONArray(j).add(tem);
                }
                if (!lineTxt.contains("@")) continue;
                ++i;
                HashMap<String, String> shapeAttrs = new HashMap<String, String>();
                String[] attrs = lineTxt.split(",");
                shapeAttrs.put("JZDSL", attrs[0]);
                shapeAttrs.put("ZMJ", attrs[1]);
                shapeAttrs.put("DKMC", attrs[2]);
                shapeAttrs.put("XMMC", attrs[3]);
                shapeAttrs.put("LX", attrs[4]);
                shapeAttrs.put("SJTFH", attrs[5]);
                shapeAttrs.put("DLMC", attrs[6]);
                if (i > 0) {
                    Map previous = (Map)feature.get(i - 1);
                    String pjl = (String)previous.remove("JZDSL");
                    String sjl = (String)shapeAttrs.remove("JZDSL");
                    if (previous.equals(shapeAttrs)) {
                        try {
                            int pAddS = Integer.parseInt(pjl) + Integer.parseInt(sjl);
                            previous.put("JZDSL", pAddS + "");
                            feature.set(i - 1, previous);
                            points.getJSONArray(i - 1).add((Object)new JSONArray());
                            --i;
                            ++j;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        previous.put("JZDSL", pjl);
                        shapeAttrs.put("JZDSL", sjl);
                        feature.add(shapeAttrs);
                        JSONArray ja = new JSONArray();
                        ja.add((Object)new JSONArray());
                        points.add((Object)ja);
                        j = 0;
                    }
                } else {
                    feature.add(shapeAttrs);
                    JSONArray ja = new JSONArray();
                    ja.add((Object)new JSONArray());
                    points.add((Object)ja);
                    j = 0;
                }
                flag = true;
            }
            br.close();
            List<String> wktList = Txt2ShpService.getWktList(points);
            Integer crsId = StrUtil.getCrsId(crsAttrs);
            if (crsId == null) {
                Iterator<String> iterator = null;
                return iterator;
            }
            for (String wkt : wktList) {
                geometry = StrUtil.wktToGeometry(wkt, crsId);
                geometryList.add(geometry);
            }
            allShapeData.put("crsId", crsId);
            allShapeData.put("geometryList", geometryList);
            allShapeData.put("feature", feature);
            allShapeData.put("headData", headData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.deleteFileAndDir((File)file.getParentFile());
        }
        return allShapeData;
    }

    public static Point createPoint(double longitude, double latitude) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(longitude, latitude);
        Point point = gf.createPoint(coord);
        return point;
    }

    private static List<String> getWktList(JSONArray points) {
        ArrayList<String> wktList = new ArrayList<String>();
        for (int i = 0; i < points.size(); ++i) {
            JSONArray pointArr = points.getJSONArray(i);
            String wkt = "MULTIPOLYGON (";
            for (int j = 0; j < pointArr.size(); ++j) {
                JSONArray pointItem = pointArr.getJSONArray(j);
                wkt = wkt + "((";
                for (int m = 0; m < pointItem.size(); ++m) {
                    JSONObject map1 = (JSONObject)pointItem.get(m);
                    JSONObject map2 = new JSONObject();
                    if (m > 0) {
                        map2 = (JSONObject)pointItem.get(m - 1);
                    }
                    if (map2.get((Object)"region") != null && !map1.getString("region").equals(map2.getString("region"))) {
                        wkt = wkt.substring(0, wkt.lastIndexOf(","));
                        wkt = wkt + "),(";
                    }
                    JSONArray point = map1.getJSONArray("point");
                    wkt = wkt + point.getDouble(0) + " " + point.getDouble(1) + ",";
                }
                wkt = wkt.substring(0, wkt.lastIndexOf(","));
                wkt = wkt + ")),";
            }
            wkt = wkt.substring(0, wkt.lastIndexOf(","));
            wkt = wkt + ")";
            wktList.add(wkt);
        }
        return wktList;
    }
}

