/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class UploadShpService {
    String uploadDir;

    public UploadShpService(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public List<Integer> parsingShapeFile(HttpServletRequest request) throws IOException {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<Integer> belts = new ArrayList<Integer>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                List shapeFile = multiRequest.getFiles((String)iter.next());
                for (int i = 0; i < shapeFile.size(); ++i) {
                    if (shapeFile.get(i) == null) continue;
                    String fileName = ((MultipartFile)shapeFile.get(i)).getOriginalFilename();
                    if (fileName.endsWith(".zip")) {
                        belts.add(this.shapeFile((MultipartFile)shapeFile.get(i)));
                        continue;
                    }
                    ArrayList<Integer> error = new ArrayList<Integer>();
                    return error;
                }
            }
        }
        return belts;
    }

    public Integer shapeFile(MultipartFile shapeFile) throws IOException {
        File zipFile = this.getFileFromMultipartFile(shapeFile, ".zip");
        Long zipLong = zipFile.length();
        String zipString = zipLong.toString();
        Integer zipInteger = Integer.valueOf(zipString);
        if (zipInteger > 2000) {
            File[] files = ZipUtil1s.unZip(zipFile, this.uploadDir);
            if (files == null) {
                // empty if block
            }
            String zipDirFileName = this.uploadDir + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
            File zipDirFile = new File(zipDirFileName);
            List shpFileList = FileUtil.findFiles((String)zipDirFileName, (String)"*.shp");
            if (shpFileList.isEmpty()) {
                System.out.println("\u6ca1\u6709shp\u6587\u4ef6");
                return 0;
            }
            for (int i = 0; i < shpFileList.size(); ++i) {
                String fileShp = ((String)shpFileList.get(i)).toString();
                fileShp = fileShp.replaceAll("\\\\", "\\\\\\\\");
                shpFileList.set(i, fileShp);
            }
            Integer theBelt = this.shpInfo(shpFileList);
            FileUtil.deleteFileAndDir((File)zipDirFile);
            return theBelt;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public Integer shpInfo(List<String> shpFilePath) throws IOException {
        Integer tarEpsg = 0;
        int i = 0;
        if (i < shpFilePath.size()) {
            ShapefileDataStore dataStore = UploadShpService.buildDataStore(shpFilePath.get(i));
            File file = new File(shpFilePath.get(i));
            if (file == null) {
                // empty if block
            }
            FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = featureSource.getFeatures();
            SimpleFeatureIterator itertor = simpleFeatureCollection.features();
            ArrayList<Integer> equalEpsg = new ArrayList<Integer>();
            while (itertor.hasNext()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                SimpleFeature feature = (SimpleFeature)itertor.next();
                Collection p = feature.getProperties();
                for (Property pro : p) {
                    String name = pro.getName().toString();
                    name = name.equals("the_geom") ? "wkt" : name;
                    data.put(name, pro.getValue());
                    if (name != "wkt") continue;
                    equalEpsg.add(StrUtil.getTarget(dataStore));
                }
            }
            itertor.close();
            dataStore.dispose();
            return (Integer)equalEpsg.get(0);
        }
        return tarEpsg;
    }

    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore)factory.createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("UTF-8"));
            }
            return dataStore;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

