/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.springframework.web.multipart.MultipartFile;

public class MulFileUtil {
    public static String getFileCharSet(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read != -1) {
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = "UTF-8";
                    checked = true;
                }
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static List<Map> readDBF(String dbfPath) {
        ArrayList<Map> results = new ArrayList<Map>();
        String charset = MulFileUtil.getFileCharSet(new File(dbfPath));
        try {
            FileChannel in = new FileInputStream(dbfPath).getChannel();
            Charset cs = Charset.forName(charset);
            DbaseFileReader dbfReader = new DbaseFileReader((ReadableByteChannel)in, false, cs);
            DbaseFileHeader header = dbfReader.getHeader();
            int fields = header.getNumFields();
            while (dbfReader.hasNext()) {
                DbaseFileReader.Row row = dbfReader.readRow();
                HashMap<String, Object> item = new HashMap<String, Object>();
                for (int i = 0; i < fields; ++i) {
                    item.put(header.getFieldName(i), row.read(i));
                }
                results.add(item);
            }
            dbfReader.close();
            in.close();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJson(String filepath) {
        InputStreamReader re = null;
        BufferedReader buff = null;
        String line = "";
        try {
            File file = new File(filepath);
            re = new FileReader(file);
            buff = new BufferedReader(re);
            String tempString = null;
            while ((tempString = buff.readLine()) != null) {
                line = line + tempString.replaceAll(" ", "");
            }
            String string = line;
            return string;
        }
        catch (Exception e) {
            System.out.println("\u5931\u8d25\u4e86");
        }
        finally {
            try {
                re.close();
                buff.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFileFromMultipartFile(MultipartFile file, String suffix, String uploadDir) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }
}

