/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion.utils;

import com.geoway.landteam.landcloud.service.formatConversion.utils.FieldEntity;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeOprate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filepath, List<FieldEntity> fields, List<List<Object>> dataRows) {
        if (filepath == null || fields == null || dataRows == null) {
            return;
        }
        if (dataRows.size() != 0 && fields.size() != dataRows.get(0).size()) {
            return;
        }
        try {
            File file = new File(filepath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            tb.setName("shapefile");
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader wtkreader = new WKTReader(geometryFactory);
            tb.setDefaultGeometry("the_geom");
            for (int i = 0; i < fields.size(); ++i) {
                if (fields.get((int)i).fieldName.equals("the_geom")) {
                    tb.add(fields.get((int)i).fieldName, fields.get((int)i).fieldType, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    continue;
                }
                tb.add(fields.get((int)i).fieldName, fields.get((int)i).fieldType);
            }
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            ds.setCharset(Charset.forName("utf-8"));
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            for (int index = 0; index < dataRows.size(); ++index) {
                List<Object> row = dataRows.get(index);
                if (row == null || fields.size() != row.size()) continue;
                SimpleFeature feature = (SimpleFeature)writer.next();
                for (int fIndex = 0; fIndex < row.size(); ++fIndex) {
                    if (row.get(fIndex).getClass() == fields.get((int)fIndex).fieldType) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, row.get(fIndex));
                        continue;
                    }
                    if (!fields.get((int)fIndex).fieldName.equals("the_geom") || row.get(fIndex).getClass() != String.class) continue;
                    String wkt = row.get(fIndex).toString();
                    Geometry geom = wtkreader.read(wkt);
                    if (fields.get((int)fIndex).fieldType == LineString.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((LineString)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType == Polygon.class) {
                        feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((Polygon)geom));
                        continue;
                    }
                    if (fields.get((int)fIndex).fieldType != Point.class) continue;
                    feature.setAttribute(fields.get((int)fIndex).fieldName, (Object)((Point)geom));
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            ShpFiles shpFiles = new ShpFiles(filepath);
            try (ShapefileReader reader = new ShapefileReader(shpFiles, false, true, new GeometryFactory(), false);){
                while (reader.hasNext()) {
                    System.out.println(reader.nextRecord().shape());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Geometry> readShp(String shpPath) {
        ArrayList<Geometry> lists = new ArrayList<Geometry>();
        try {
            ShpFiles sf = new ShpFiles(shpPath);
            ShapefileReader r = new ShapefileReader(sf, false, false, new GeometryFactory());
            while (r.hasNext()) {
                Geometry shape = (Geometry)r.nextRecord().shape();
                lists.add(shape);
            }
            r.close();
            return lists;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Map> readDBF(String dbfPath) {
        ArrayList<Map> results = new ArrayList<Map>();
        try {
            FileChannel in = new FileInputStream(dbfPath).getChannel();
            Charset cs = Charset.forName("GBK");
            DbaseFileReader dbfReader = new DbaseFileReader((ReadableByteChannel)in, false, cs);
            DbaseFileHeader header = dbfReader.getHeader();
            int fields = header.getNumFields();
            while (dbfReader.hasNext()) {
                DbaseFileReader.Row row = dbfReader.readRow();
                HashMap<String, Object> item = new HashMap<String, Object>();
                for (int i = 0; i < fields; ++i) {
                    item.put(header.getFieldName(i), row.read(i));
                }
                results.add(item);
            }
            dbfReader.close();
            in.close();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transShape(String srcfilepath, String destfilepath) {
        if (srcfilepath == null || destfilepath == null) {
            return;
        }
        try {
            ShapefileDataStore shapeDS = (ShapefileDataStore)new ShapefileDataStoreFactory().createDataStore(new File(srcfilepath).toURI().toURL());
            HashMap<String, URL> params = new HashMap<String, URL>();
            ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
            params.put(ShapefileDataStoreFactory.URLP.key, new File(destfilepath).toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)factory.createNewDataStore(params);
            ContentFeatureSource fs = shapeDS.getFeatureSource(shapeDS.getTypeNames()[0]);
            ds.createSchema(SimpleFeatureTypeBuilder.retype((SimpleFeatureType)((SimpleFeatureType)fs.getSchema()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            try (SimpleFeatureIterator it = fs.getFeatures().features();){
                while (it.hasNext()) {
                    SimpleFeature f = (SimpleFeature)it.next();
                    SimpleFeature fNew = (SimpleFeature)writer.next();
                    fNew.setAttributes(f.getAttributes());
                    writer.write();
                }
            }
            writer.close();
            ds.dispose();
            shapeDS.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

