/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class StrUtil {
    public static Map<String, String> splitCrsData(String crsDataSource) {
        String degreeRex;
        Pattern degreePt;
        Matcher degreeMc;
        String crsData = crsDataSource.toLowerCase();
        HashMap<String, String> headData = new HashMap<String, String>();
        boolean is3Degree = true;
        String daiHao = "0";
        if (crsData.contains("cgcs2000")) {
            headData.put("\u5750\u6807\u7cfb", "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb");
        }
        if ((degreeMc = (degreePt = Pattern.compile(degreeRex = "3.*degree")).matcher(crsData)).find()) {
            headData.put("\u51e0\u5ea6\u5206\u5e26", "3");
        } else {
            headData.put("\u51e0\u5ea6\u5206\u5e26", "6");
            is3Degree = false;
        }
        if (crsData.contains("zone")) {
            daiHao = crsData.split("zone")[1].replaceAll("[^1-9]", "");
        } else {
            int longitude = Integer.parseInt(crsData.split("cm")[1].replaceAll("[^1-9]", ""));
            daiHao = is3Degree ? Math.floor(longitude / 3) + "" : Math.floor((longitude + 3) / 6) + "";
        }
        headData.put("\u5e26\u53f7", daiHao);
        return headData;
    }

    public static Integer getCrsId(Map<String, String> crsAttrs) {
        Integer crsId = null;
        if (!crsAttrs.containsKey("\u51e0\u5ea6\u5206\u5e26") && !crsAttrs.containsKey("\u5e26\u53f7") && "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb".equals(crsAttrs.get("\u5750\u6807\u7cfb"))) {
            crsId = 4490;
            return crsId;
        }
        Integer zoning = Integer.parseInt(crsAttrs.get("\u51e0\u5ea6\u5206\u5e26"));
        Integer zoningNum = Integer.parseInt(crsAttrs.get("\u5e26\u53f7"));
        String crs = crsAttrs.get("\u5750\u6807\u7cfb");
        crsId = zoning == 3 && "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb".equals(crs) ? Integer.valueOf(4513 + zoningNum - 25) : Integer.valueOf(4514 + zoningNum - 25);
        return crsId;
    }

    public static String getTargetFileSuffix(String suffix) {
        switch (suffix) {
            case "txt": {
                return "txt";
            }
            case "shp": {
                return "zip";
            }
            case "geojson": {
                return "geojson";
            }
        }
        return "";
    }

    public static Geometry wktToGeometry(String wktString, Integer crsId) {
        StringBuffer sbBuffer = new StringBuffer();
        WKTReader fromText = new WKTReader();
        String wkt = sbBuffer.append(wktString).toString();
        Geometry geom = null;
        try {
            geom = fromText.read(wkt);
            geom.setSRID(crsId.intValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Not a WKT string:" + wktString);
        }
        return geom;
    }

    public static boolean haveAttribute(String rex, Map<String, String> field) {
        for (String attr : rex.split(",")) {
            if ("".equals(attr) || attr == null) continue;
            boolean exist = false;
            for (String key : field.keySet()) {
                if (!key.contains(attr)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            return false;
        }
        return true;
    }

    public static int getTarget(ShapefileDataStore dataStore) {
        int epsg = 0;
        try {
            String wkt = dataStore.getSchema().getCoordinateReferenceSystem().toWKT();
            if (wkt.indexOf("PROJCS") != -1) {
                String str1 = wkt.substring(0, wkt.indexOf("GEOGCS[\""));
                String str2 = wkt.substring(str1.length() + 8, wkt.length());
                String str3 = str2.substring(0, str2.indexOf("\""));
                if (str3.equals("China Geodetic Coordinate System 2000") || str3.equals("GCS_CGCS_2000") || str3.equals("GCS_China_Geodetic_Coordinate_System_2000")) {
                    epsg = 4490;
                } else if (str3.equals("WGS 84") || str3.equals("GCS_WGS_1984")) {
                    epsg = 4326;
                }
            } else {
                String str1 = wkt.substring(0, wkt.indexOf("GEOGCS[\""));
                String str2 = wkt.substring(str1.length() + 8, wkt.length());
                String str3 = str2.substring(0, str2.indexOf("\""));
                if (str3.equals("China Geodetic Coordinate System 2000") || str3.equals("GCS_China_Geodetic_Coordinate_System_2000") || str3.equals("GCS_CGCS_2000")) {
                    epsg = 4535;
                } else if (str3.equals("WGS 84") || str3.equals("GCS_WGS_1984")) {
                    epsg = 3857;
                }
            }
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return epsg;
    }

    public static Integer getEpsg(Geometry geometry, String targetEpsg) {
        String str1 = targetEpsg.substring(0, targetEpsg.length() - 1);
        String str2 = targetEpsg.substring(targetEpsg.length() - 1, targetEpsg.length());
        if (targetEpsg.equals("CGCS-2000")) {
            targetEpsg = "4490";
        } else if (targetEpsg.equals("WGS-84")) {
            targetEpsg = "4326";
        } else if (targetEpsg.equals("WEB-\u58a8\u5361\u6258")) {
            targetEpsg = "3857";
        } else if (str1.equals("\u9ad8\u65af-\u514b\u5415\u683c")) {
            String belt = str2;
            Integer theBelt = Integer.parseInt(belt);
            String str = geometry.getEnvelope().toString();
            String pattern = "[^0-9.]";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(str);
            Integer theEpsg = 4514;
            Integer sixEpsg = 4492;
            if (m.find()) {
                int i;
                String strm = m.replaceAll(" ");
                String[] chunks = strm.split("\\s+");
                ArrayList<Double> lon = new ArrayList<Double>();
                for (i = 0; i < chunks.length; ++i) {
                    if (i % 2 == 0) continue;
                    lon.add(Double.parseDouble(chunks[i]));
                }
                Double left = (Double)lon.get(0);
                Double right = (Double)lon.get(2);
                if (theBelt == 3) {
                    if (right < 76.5) {
                        theEpsg = 4513;
                        targetEpsg = theEpsg.toString();
                    }
                    Double i2 = 76.5;
                    while (i2 < 133.5) {
                        if (i2 > left && i2 < right) {
                            System.out.println("\u8de8\u5e26\u4e86\uff01\uff01");
                        } else if (i2 < left && right < i2 + 3.0) {
                            targetEpsg = theEpsg.toString();
                        } else {
                            Integer n = theEpsg;
                            Integer n2 = theEpsg = Integer.valueOf(theEpsg + 1);
                        }
                        i2 = i2 + 3.0;
                    }
                } else if (theBelt == 6) {
                    if (right < 78.0) {
                        sixEpsg = 4491;
                        targetEpsg = sixEpsg.toString();
                    }
                    for (i = 78; i < 132; i += 6) {
                        if ((double)i > left && (double)i < right) {
                            System.out.println("\u8de8\u5e26\u4e86\uff01\uff01");
                            continue;
                        }
                        if ((double)i < left && right < (double)(i + 6)) {
                            targetEpsg = sixEpsg.toString();
                            continue;
                        }
                        Integer n = sixEpsg;
                        Integer n3 = sixEpsg = Integer.valueOf(sixEpsg + 1);
                    }
                }
            } else {
                System.out.println("nomatch=====");
            }
        }
        Integer finalEpsg = Integer.parseInt(targetEpsg);
        return finalEpsg;
    }

    public static Integer epsgForArea(Geometry geometry) {
        int targetEpsg = 0;
        String str = geometry.getEnvelope().toString();
        String pattern = "[^0-9.]";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        Integer theEpsg = 4514;
        if (m.find()) {
            String strm = m.replaceAll(" ");
            String[] chunks = strm.split("\\s+");
            ArrayList<Double> lon = new ArrayList<Double>();
            for (int i = 0; i < chunks.length; ++i) {
                if (i % 2 == 0) continue;
                lon.add(Double.parseDouble(chunks[i]));
            }
            Double left = (Double)lon.get(0);
            Double right = (Double)lon.get(2);
            if (right < 76.5) {
                theEpsg = 4513;
                targetEpsg = theEpsg;
            }
            Double i = 76.5;
            while (i < 133.5) {
                if (i > left && i < right) {
                    System.out.println("\u8de8\u5e26\u4e86\uff01\uff01");
                } else if (i < left && right < i + 3.0) {
                    targetEpsg = theEpsg;
                } else {
                    Integer n = theEpsg;
                    Integer n2 = theEpsg = Integer.valueOf(theEpsg + 1);
                }
                i = i + 3.0;
            }
        } else {
            System.out.println("nomatch=====");
        }
        return targetEpsg;
    }
}

