/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.config;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.service.jms.receive.ConsumerMessageListener;
import java.util.LinkedList;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

@EnableJms
@Configuration
public class ActiveMQConfig {
    @Value(value="${activemq.ip}")
    String ip;
    @Value(value="${activemq.port}")
    String port;
    @Value(value="${activemq.queueName}")
    String queueName;
    @Value(value="${activemq.passEnable}")
    String passEnable;
    @Value(value="${activemq.username}")
    String username;
    @Value(value="${activemq.password}")
    String password;
    @Value(value="${activemq.topicName}")
    String topicName;
    @Value(value="${activemq.maxConnections}")
    Integer maxConnections;
    @Value(value="${activemq.idleTimeout}")
    Integer idleTimeout;
    @Value(value="${Queue.accept.Tran:}")
    String queueAcceptTran;
    @Value(value="${Queue.accept.enable:false}")
    boolean queueAcceptEnable;
    @Autowired
    SysConfigService sysConfigService;

    @Bean
    public ActiveMQConnectionFactory connectionFactory() {
        StringBuffer url = new StringBuffer("tcp://");
        url.append(this.ip).append(":").append(this.port);
        ActiveMQConnectionFactory activeMQConnectionFactory = "true".equals(this.passEnable) ? new ActiveMQConnectionFactory(url.toString()) : new ActiveMQConnectionFactory(this.username, this.password, url.toString());
        return activeMQConnectionFactory;
    }

    @Bean
    public PooledConnectionFactory pooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory(connectionFactory);
        pooledConnectionFactory.setMaxConnections(this.maxConnections.intValue());
        pooledConnectionFactory.setIdleTimeout(this.idleTimeout.intValue());
        return pooledConnectionFactory;
    }

    @Bean
    public ActiveMQQueue queueDestination() {
        LinkedList<String> nameList = new LinkedList<String>();
        nameList.add("LandWork-Queue");
        if (this.queueAcceptEnable) {
            nameList.add("IMAGE-CAPTURE");
            nameList.add("TASK");
            if (StringUtils.isNotBlank((CharSequence)this.queueAcceptTran)) {
                nameList.add(this.queueAcceptTran);
            }
        }
        String queueName = StringUtils.join(nameList, (CharSequence)",");
        ActiveMQQueue activeMQQueue = new ActiveMQQueue(queueName);
        return activeMQQueue;
    }

    @Bean
    public JmsTemplate jmsTemplate(PooledConnectionFactory pooledConnectionFactory, ActiveMQQueue activeMQQueue) {
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory((ConnectionFactory)pooledConnectionFactory);
        jmsTemplate.setDefaultDestination((Destination)activeMQQueue);
        return jmsTemplate;
    }

    @Bean
    public ActiveMQTopic topicDestination() {
        ActiveMQTopic activeMQTopic = new ActiveMQTopic(this.topicName);
        return activeMQTopic;
    }

    @Bean
    public MessageListener queueListener() {
        ConsumerMessageListener listener = new ConsumerMessageListener();
        return listener;
    }

    @Bean
    public DefaultMessageListenerContainer jmsQueueListenerContainer(PooledConnectionFactory pooledConnectionFactory, ActiveMQQueue queueDestination, MessageListener listener) {
        DefaultMessageListenerContainer jmsContainer = new DefaultMessageListenerContainer();
        jmsContainer.setConnectionFactory((ConnectionFactory)pooledConnectionFactory);
        jmsContainer.setDestination((Destination)queueDestination);
        jmsContainer.setMessageListener((Object)listener);
        return jmsContainer;
    }

    @Bean
    public DefaultMessageListenerContainer jmsTopicListenerContainer(PooledConnectionFactory pooledConnectionFactory, ActiveMQTopic topicDestination, MessageListener listener) {
        DefaultMessageListenerContainer jmsContainer = new DefaultMessageListenerContainer();
        jmsContainer.setConnectionFactory((ConnectionFactory)pooledConnectionFactory);
        jmsContainer.setDestination((Destination)topicDestination);
        jmsContainer.setMessageListener((Object)listener);
        return jmsContainer;
    }
}

