/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.jmx;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JmxApiService {
    private static final GiLoger logger = GwLoger.getLoger(JmxApiService.class);
    public static String QueueSize = "QueueSize";
    public static String EnqueueCount = "EnqueueCount";
    public static String DequeueCount = "DequeueCount";
    public static String ConsumerCount = "ConsumerCount";
    public static String ProducerCount = "ProducerCount";
    @Value(value="${activemq.ip}")
    String ip;
    @Value(value="${activemq.jmx.port}")
    Integer port;
    @Value(value="${activemq.queueName}")
    String queueName;
    @Value(value="${activemq.topicName}")
    String topicName;
    @Value(value="${activemq.jmx.username}")
    String username;
    @Value(value="${activemq.jmx.password}")
    String password;
    @Value(value="${activemq.jmx.connectTimeout}")
    Integer timeout;

    public Long getDefQueuePendingNum() {
        return this.getQueuePendingNum(this.queueName);
    }

    public Long getQueueEnqueueCount(String queueName) {
        Long length = 0L;
        String result = this.sendJmxHttp(queueName, EnqueueCount);
        JSONObject obj = JSONObject.parseObject((String)result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq\u961f\u5217\u5df2\u63a5\u6536\u6d88\u606f\u6570\u91cf\u63a5\u53e3\u8bbf\u95ee\u6210\u529f\uff0c\u6570\u91cf\uff1a" + length, new Object[0]);
        }
        return length;
    }

    public Long getQueueDequeueCount(String queueName) {
        Long length = 0L;
        String result = this.sendJmxHttp(queueName, DequeueCount);
        JSONObject obj = JSONObject.parseObject((String)result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq\u961f\u5217\u5df2\u6d88\u8d39\u6d88\u606f\u6570\u91cf\u63a5\u53e3\u8bbf\u95ee\u6210\u529f\uff0c\u6570\u91cf\uff1a" + length, new Object[0]);
        }
        return length;
    }

    public Long getQueueConsumerCount(String queueName) {
        Long length = 0L;
        String result = this.sendJmxHttp(queueName, ConsumerCount);
        JSONObject obj = JSONObject.parseObject((String)result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq\u961f\u5217\u6d88\u8d39\u8005\u6570\u91cf\u63a5\u53e3\u8bbf\u95ee\u6210\u529f\uff0c\u6570\u91cf\uff1a" + length, new Object[0]);
        }
        return length;
    }

    public Long getQueueProducerCount(String queueName) {
        Long length = 0L;
        String result = this.sendJmxHttp(queueName, ProducerCount);
        JSONObject obj = JSONObject.parseObject((String)result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq\u961f\u5217\u751f\u4ea7\u8005\u6570\u91cf\u63a5\u53e3\u8bbf\u95ee\u6210\u529f\uff0c\u6570\u91cf\uff1a" + length, new Object[0]);
        }
        return length;
    }

    public Long getQueuePendingNum(String queueName) {
        Long length = 0L;
        String result = this.sendJmxHttp(queueName, QueueSize);
        JSONObject obj = JSONObject.parseObject((String)result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq\u961f\u5217\u672a\u6d88\u8d39\u6d88\u606f\u6570\u91cf\u63a5\u53e3\u8bbf\u95ee\u6210\u529f\uff0c\u6570\u91cf\uff1a" + length, new Object[0]);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendJmxHttp(String queueName, String method) {
        CloseableHttpClient httpClient = null;
        String result = null;
        try {
            String url = String.format("/api/jolokia/read/org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=%s/%s", queueName, method);
            HttpHost targetHost = new HttpHost(this.ip, this.port.intValue(), "http");
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout.intValue()).setConnectTimeout(this.timeout.intValue()).setConnectionRequestTimeout(this.timeout.intValue()).build();
            httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig).build();
            HttpGet httpget = new HttpGet(targetHost.toURI() + url);
            httpget.addHeader("Content-Type", "application/json;charset=UTF-8");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            System.out.println(result);
            CloudMsgUtil.closeHttpClient((CloseableHttpClient)httpClient);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            CloudMsgUtil.closeHttpClient(httpClient);
        }
        return result;
    }
}

