/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.jmx;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JmxService {
    private static final GiLoger logger = GwLoger.getLoger(JmxService.class);
    @Value(value="${activemq.ip}")
    String ip;
    @Value(value="${activemq.jmx.port}")
    String port;
    @Value(value="${activemq.queueName}")
    String queueName;
    @Value(value="${activemq.topicName}")
    String topicName;

    public Long getDefQueuePendingNum() {
        return 0L;
    }

    public Long getQueuePendingNum(String queueName) {
        Long length = 0L;
        try {
            Map<String, Long> map = this.getQueuesInfo();
            if (map.size() > 0) {
                length = map.get(queueName);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        return length;
    }

    private Map<String, Long> getQueuesInfo() throws Exception {
        HashMap<String, Long> map = new HashMap<String, Long>();
        StringBuffer url = new StringBuffer("service:jmx:rmi:///jndi/rmi://");
        url.append(this.ip).append(":").append(this.port).append("/jmxrmi");
        JMXServiceURL address = new JMXServiceURL(url.toString());
        JMXConnector connector = JMXConnectorFactory.connect(address);
        MBeanServerConnection mbsc = connector.getMBeanServerConnection();
        connector.connect();
        ObjectName objectName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost");
        if (objectName != null) {
            BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, BrokerViewMBean.class, true);
            for (ObjectName queueName : broker.getQueues()) {
                QueueViewMBean queueMBean = MBeanServerInvocationHandler.newProxyInstance(mbsc, queueName, QueueViewMBean.class, true);
                map.put(queueMBean.getName(), queueMBean.getQueueSize());
            }
        }
        connector.close();
        return map;
    }
}

