/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.receive;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyJsonService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.jms.service.factory.StrategyServiceFactory;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQDestination;

public class ConsumerMessageListener
implements MessageListener {
    private static final GiLoger logger = GwLoger.getLoger(ConsumerMessageListener.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        try {
            ActiveMQDestination queues = (ActiveMQDestination)message.getJMSDestination();
            switch (queues.getPhysicalName()) {
                case "LandWork-QueueLoadData": {
                    break;
                }
                case "LandWork-QueueCreateDB": {
                    break;
                }
                case "LandWork-QueueAssign": {
                    System.out.println("\u6570\u636e\u4e0b\u53d1");
                    break;
                }
                case "LandWork-QueueSubmit": {
                    break;
                }
            }
            logger.info("-----\u6d88\u8d39\u8005\u63a5\u53d7\u5230\u6d88\u606f\u4e86-----", new Object[0]);
            if (message instanceof TextMessage) {
                TextMessage tmessage = (TextMessage)message;
                String msg = tmessage.getText();
                JSONObject obj = JSONObject.parseObject((String)msg);
                if (!obj.containsKey((Object)ActiveMQConstant.SERVICE_NAME)) throw new JMSException(this.getClass().getName() + ": json\u53c2\u6570\u4e2d\u7f3a\u5c11serviceName\u5c5e\u6027");
                String id = obj.getString(ActiveMQConstant.SERVICE_NAME);
                IConsumerStrategyJsonService service = StrategyServiceFactory.getJsonService(id);
                service.execute(obj);
                return;
            } else if (message instanceof MapMessage) {
                MapMessage messageMap = (MapMessage)message;
                String id = messageMap.getString(ActiveMQConstant.SERVICE_NAME);
                if (id == null) throw new JMSException(this.getClass().getName() + ": map\u53c2\u6570\u4e2d\u7f3a\u5c11serviceName\u952e\u503c\u5bf9");
                IConsumerStrategyService service = StrategyServiceFactory.getService(id);
                service.execute(messageMap);
                return;
            } else {
                if (!(message instanceof BytesMessage)) return;
                String string = (BytesMessage)message;
            }
            return;
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

