/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.send;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

@Component
public class ProducerService {
    private static final GiLoger logger = GwLoger.getLoger(ProducerService.class);
    @Autowired
    private JmsTemplate jmsTemplate;
    @Resource(name="queueDestination")
    private Destination queueDestination;

    public void sendTextMessage2Queue(final String json) {
        logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606f[\u6d88\u606f\u7c7b\u578bText]-----", new Object[0]);
        logger.info("\u751f\u4ea7\u8005\u53d1\u9001\u7684\u4e00\u6761\u6d88\u606f\uff1atext", new Object[0]);
        this.jmsTemplate.send(this.queueDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage();
                message.setText(json);
                logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606fSUCCESS[\u6d88\u606f\u7c7b\u578bText]-----", new Object[0]);
                return message;
            }
        });
    }

    public void sendMapMessage2Queue(final Map<String, Object> map) {
        logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606f[\u6d88\u606f\u7c7b\u578bMap]-----", new Object[0]);
        logger.info("\u751f\u4ea7\u8005\u53d1\u9001\u7684\u4e00\u6761\u6d88\u606f\uff1aMap", new Object[0]);
        this.jmsTemplate.send(this.queueDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                MapMessage message = session.createMapMessage();
                ProducerService.this.transformMapMessage(message, map);
                logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606fSUCCESS[\u6d88\u606f\u7c7b\u578bMap]-----", new Object[0]);
                return message;
            }
        });
    }

    public void sendMapMessage2Queue(final Map<String, Object> map, String queueName) {
        this.jmsTemplate.send(queueName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                MapMessage message = session.createMapMessage();
                ProducerService.this.transformMapMessage(message, map);
                logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606fSUCCESS[\u6d88\u606f\u7c7b\u578bMap]-----", new Object[0]);
                return message;
            }
        });
    }

    public void sendObjectMessage2Queue(final Serializable obj) {
        logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606f[\u6d88\u606f\u7c7b\u578bObject]-----", new Object[0]);
        logger.info("\u751f\u4ea7\u8005\u53d1\u9001\u7684\u4e00\u6761\u6d88\u606f\uff1aObject", new Object[0]);
        this.jmsTemplate.send(this.queueDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage();
                message.setObject(obj);
                logger.info("------\u751f\u4ea7\u8005\u53d1\u9001\u7684\u6d88\u606fSUCCESS[\u6d88\u606f\u7c7b\u578bObject]-----", new Object[0]);
                return message;
            }
        });
    }

    private void transformMapMessage(MapMessage message, Map<String, Object> map) throws JMSException {
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof Boolean) {
                message.setBoolean(key, ((Boolean)obj).booleanValue());
                continue;
            }
            if (obj instanceof Byte) {
                message.setByte(key, ((Byte)obj).byteValue());
                continue;
            }
            if (obj instanceof Short) {
                message.setShort(key, ((Short)obj).shortValue());
                continue;
            }
            if (obj instanceof Character) {
                message.setChar(key, ((Character)obj).charValue());
                continue;
            }
            if (obj instanceof Integer) {
                message.setInt(key, ((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Long) {
                message.setLong(key, ((Long)obj).longValue());
                continue;
            }
            if (obj instanceof Float) {
                message.setFloat(key, ((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Double) {
                message.setDouble(key, ((Double)obj).doubleValue());
                continue;
            }
            if (obj instanceof String) {
                message.setString(key, (String)obj);
                continue;
            }
            message.setObject(key, obj);
        }
    }
}

