/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.jms.service.factory;

import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyJsonService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class StrategyServiceFactory
implements ApplicationContextAware {
    private static final Map<String, IConsumerStrategyService> serviceMap = new HashMap<String, IConsumerStrategyService>();
    private static final Map<String, IConsumerStrategyJsonService> jsonServiceMap = new HashMap<String, IConsumerStrategyJsonService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(IConsumerStrategyService.class);
        for (String key : map.keySet()) {
            IConsumerStrategyService service = (IConsumerStrategyService)map.get(key);
            serviceMap.put(service.getCode(), service);
        }
    }

    public static IConsumerStrategyService getService(String serviceName) {
        return serviceMap.get(serviceName);
    }

    public static IConsumerStrategyJsonService getJsonService(String serviceName) {
        return jsonServiceMap.get(serviceName);
    }
}

