/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.service.util.TbbhUtil;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.mapper.pub.DmDictValueMapper;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class InnerPatrolTaskTransmitAcceptService {
    private static final Logger log = LoggerFactory.getLogger(InnerPatrolTaskTransmitAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Autowired
    TbbhUtil tbbhUtil;
    @Autowired
    RegionService regionService;
    @Resource
    private DmDictValueMapper dictValueDao;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    private LandUserService landuserService;

    public void execute(JSONObject jsonObject, Map<String, String> fileMap, File dbFile) {
        try {
            String mode = jsonObject.getString("mode");
            String taskName = jsonObject.getString("taskName");
            Long userId = jsonObject.getLong("userId");
            this.handDbFile(dbFile, fileMap, taskName, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handDbFile(File dbFile, Map<String, String> fileMap, String taskId, Long userId) throws Exception {
        try {
            SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            SysConfig sysConfig = this.sysConfigService.findOne("scgtyBizId");
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)sysConfig.getValue()).orElse(null);
            TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.findById((Object)tskTaskBiz.getTableId()).orElse(null);
            List tbtskFieldsByTableid = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            List<String> collect = tbtskFieldsByTableid.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            List dmDictValues = this.dictValueDao.queryTop(Long.valueOf(10012510L));
            String sql = "select * from media";
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                String f_id = rs.getString("f_id");
                Map mapdata = this.dataBizService.selectByID("tb_app_media", "f_id", "'" + f_id + "'");
                int rowSize = metaData.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rowSize; ++i) {
                    String labelName = metaData.getColumnName(i);
                    Object obj = rs.getObject(labelName);
                    map.put(labelName, obj);
                }
                String f_serverpath = map.get("f_serverpath").toString();
                String fiename = f_serverpath.substring(f_serverpath.lastIndexOf("/") + 1, f_serverpath.length());
                map.put("f_serverpath", fileMap.get(fiename));
                map.put("f_bizid", tskTaskBiz.getId());
                map.put("f_username", this.landuserService.queryUserById(userId).getName());
                if (mapdata == null) {
                    this.dataBizService.insertData("tb_app_media", map, null);
                    continue;
                }
                this.dataBizService.updateData("tb_app_media", map, " f_id = '" + f_id + "'");
            }
            String dataSql = "select * from  basic";
            ResultSet dataRs = statement.executeQuery(dataSql);
            ArrayList<Map<String, Object>> datalist = new ArrayList<Map<String, Object>>();
            while (dataRs.next()) {
                this.handXsData(dataRs, datalist, userId, collect, dmDictValues);
            }
            this.dataBizService.insertDatasBatchByTimeStamp(tableInfo.getfTablename(), datalist, "f_shape");
            connPool.closeAll(connection, statement, rs);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void handXsData(ResultSet resultSet, List<Map<String, Object>> datalist, Long userId, List<String> collect, List<DmDictValue> dmDictValues) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Double lon = resultSet.getDouble("f_lon");
        Double lat = resultSet.getDouble("f_lat");
        map.put("f_id", resultSet.getString("f_id"));
        map.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
        map.put("f_review_stage", 93);
        map.put("f_lon", lon);
        map.put("f_lat", lat);
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_committime", System.currentTimeMillis() + "");
        map.put("f_userid", userId.toString());
        map.put("f_upload_userid", userId.toString());
        map.put("f_submit_userid", userId.toString());
        map.put("f_ismy", "0");
        this.completeBasicRegionInfo(map, lon, lat);
        map.put("f_tbmc", resultSet.getString("f_name"));
        map.put("f_tbmj", resultSet.getDouble("f_mj"));
        Object objShape = resultSet.getObject("f_shape");
        if (objShape != null && StringUtils.isNotBlank((CharSequence)objShape.toString())) {
            map.put("f_shape", objShape.toString());
            map.put("f_shape1", objShape.toString());
        }
        this.fillRequiredFieldNames(map, collect, resultSet, userId, dmDictValues);
        datalist.add(map);
    }

    private void completeBasicRegionInfo(Map<String, Object> map, Double lon, Double lat) throws Exception {
        if (lon == null || lat == null) {
            return;
        }
        String wkt = "POINT(" + lon + " " + lat + ")";
        RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
        if (region == null) {
            region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
        }
        if (region == null) {
            map.put("f_xzqdmsys", null);
            map.put("f_xzqdm", null);
            return;
        }
        String county = "";
        String city = "";
        String province = "";
        if (region.getLevel() == 3) {
            county = region.getCode();
        } else if (region.getLevel() == 2) {
            // empty if block
        }
        RegionVillage village = this.regionService.queryVillageCotain(wkt, 0);
        map.put("f_xzqdmsys", village != null ? village.getCode() : county);
        map.put("f_xzqdm", county);
    }

    private void fillRequiredFieldNames(Map<String, Object> map, List<String> collect, ResultSet resultSet, Long userId, List<DmDictValue> dmDictValues) throws SQLException {
        if (collect.contains("f_xsmc")) {
            map.put("f_xsmc", resultSet.getString("f_heading"));
        }
        if (collect.contains("f_jhID")) {
            map.put("f_jhid", resultSet.getString("f_jhid"));
        }
        if (collect.contains("f_xsrwID")) {
            map.put("f_xsrwid", resultSet.getString("f_xsrwid"));
        }
        if (collect.contains("f_xsbh") && map.get("f_xzqdmsys") != null && StringUtils.isNotBlank((CharSequence)map.get("f_xzqdmsys").toString())) {
            String xsbh = this.tbbhUtil.generateTbbh(map.get("f_xzqdmsys").toString(), "TB", this.tbbhUtil.getUserLevelCode(userId));
            map.put("f_xsbh", xsbh);
            map.put("f_tbbh", xsbh);
        }
        if (collect.contains("f_xzqmc") && map.get("f_xzqdm") != null && StringUtils.isNotBlank((CharSequence)map.get("f_xzqdm").toString())) {
            map.put("f_xzqmc", this.regionService.getName(map.get("f_xzqdm").toString()));
        }
        if (collect.contains("f_xsms") && StringUtils.isNotBlank((CharSequence)resultSet.getString("f_desc"))) {
            map.put("f_xsms", resultSet.getString("f_desc"));
        }
        if (collect.contains("f_wfdd")) {
            map.put("f_wfdd", resultSet.getString("f_name"));
        }
        if (collect.contains("f_xcsj")) {
            map.put("f_xcsj", new Timestamp(System.currentTimeMillis()));
        }
        if (collect.contains("f_yswflx") && StringUtils.isNotBlank((CharSequence)resultSet.getString("f_type"))) {
            String type = resultSet.getString("f_type");
            for (DmDictValue dmDictValue : dmDictValues) {
                if (!dmDictValue.getName().equalsIgnoreCase(resultSet.getString("f_type"))) continue;
                type = dmDictValue.getCode();
            }
            map.put("f_yswflx", type);
        }
        if (collect.contains("f_xslx")) {
            List dmDictValues1 = this.dictValueDao.queryTop(Long.valueOf(10012511L));
            String type = resultSet.getString("f_xslx");
            for (DmDictValue dmDictValue : dmDictValues1) {
                if (!dmDictValue.getName().equalsIgnoreCase(resultSet.getString("f_xslx"))) continue;
                type = dmDictValue.getCode();
            }
            map.put("f_xslx", type);
        }
        if (collect.contains("f_xcry")) {
            map.put("f_xcry", this.landuserService.queryUserById(userId).getName());
        }
    }
}

