/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InnerProgramTransmitService {
    private GiLoger logger = GwLoger.getLoger(InnerProgramTransmitService.class);
    @Resource
    ProducerService producerService;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    public void syncPatrolPlanAndTask(JSONObject object) throws Exception {
        String type = object.getString("type");
        Long userId = object.getLongValue("operUserId");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String tempFolderPath = this.uploadDir + File.separator + UUID.randomUUID().toString();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(JSONObject.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            String url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            JSONObject result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "userTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

    public void publishTranMsg(String url) {
        try {
            String queueName = "Base-Outer-Tran";
            this.logger.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + url, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ActiveMQConstant.SERVICE_NAME, "OUTER-RECEIVE-MESSAGE");
            map.put("appkey", PropertyUtil.getProperty((String)"transmit.appkey"));
            map.put("module", PropertyUtil.getProperty((String)"transmit.module"));
            map.put("name", "\u6d4b\u8bd5");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "OUTER-RECEIVE-MESSAGE");
            this.producerService.sendMapMessage2Queue(map, queueName);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
        }
    }
}

