/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.dao.task.TbtskRejectDefDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFlowDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskBizFlowService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.BizArea;
import com.geoway.landteam.customtask.task.entity.TbtskFlowDef;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBizFlow;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskAssignJobService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class InnerTaskTransmitService {
    private GiLoger logger = GwLoger.getLoger(InnerTaskTransmitService.class);
    @Autowired
    RedisTemplate redisTemplate;
    @Resource
    ProducerService producerService;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Autowired
    TaskRecordService taskRecordService;
    @Resource
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Resource
    TbtskTaskBizFlowService tbtskTaskBizFlowService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskFlowService tbtskFlowService;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    MTaskAssignJobService taskAssignJobService;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskRejectDefDao rejectDefDao;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;

    public void assignData(TaskDataDbParameter parameter) throws Exception {
        String recordId = parameter.getRecordId();
        TaskRecord one = this.taskRecordService.findOne(recordId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(parameter.getTaskId());
        if (table == null) {
            return;
        }
        String sql = "update " + table.getfTablename() + " a\nset f_status=2\nwhere f_status=1 and exists (select null from tbsys_task_record_temp b where b.f_dataid=a.f_id and  b.f_recordid = '" + recordId + "')";
        this.dataBizService.excuteSql(sql);
        JSONArray users = new JSONArray();
        if (parameter.getOrgs() != null) {
            users.addAll((Collection)parameter.getOrgs());
        }
        if (parameter.getGroups() != null) {
            users.addAll((Collection)parameter.getGroups());
        }
        this.taskAssignJobService.assignTaskArea(users, parameter.getTaskId(), recordId, table);
        Pair<String, String> pair = this.createTaskZip(parameter);
        this.dataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='" + recordId + "'");
        one.setEndtime(new Date());
        one.setState(Integer.valueOf(3));
        one.setData((String)pair.getLeft());
        one.setResult((String)pair.getRight());
        this.taskRecordService.save(one);
    }

    public void assignDataByCondition(JSONObject paramsObject, TaskRecord record) throws Exception {
        TaskQueryParameter queryParameter = (TaskQueryParameter)JSONObject.parseObject((String)paramsObject.getString("taskQueryParameter"), TaskQueryParameter.class);
        List data = this.tbtskFlowService.getConfigTaskDataListNew(queryParameter);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(queryParameter.getTaskId());
        if (table == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        data.forEach(a -> sb.append("'" + a.get("f_id") + "',"));
        String sql = "update " + table.getfTablename() + " a set f_status=2 , f_reject_status = 1where f_status=1 and f_id in (" + sb.toString().substring(0, sb.length() - 1) + ")";
        this.dataBizService.excuteSql(sql);
        JSONArray users = new JSONArray();
        if (paramsObject.getString("orgs") != null) {
            users.addAll((Collection)paramsObject.getJSONArray("orgs"));
        }
        if (paramsObject.getString("groups") != null) {
            users.addAll((Collection)paramsObject.getJSONArray("groups"));
        }
        this.taskAssignJobService.assignTaskAreaByCond(users, queryParameter.getTaskId(), data, table);
        Pair<String, String> pair = this.createTaskDbByCond(paramsObject, data);
        record.setEndtime(new Date());
        record.setState(Integer.valueOf(3));
        record.setData((String)pair.getLeft());
        record.setResult((String)pair.getRight());
        this.taskRecordService.save(record);
    }

    public void pushTaskData(JSONObject paramsObject, TaskRecord record) throws Exception {
        String recordId = record.getData();
        Long userId = paramsObject.getLongValue("userId");
        String taskId = paramsObject.getString("taskId");
        Pair<String, String> pair = this.createPushTaskZip(userId, taskId, recordId);
        this.dataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='" + recordId + "'");
        record.setEndtime(new Date());
        record.setState(Integer.valueOf(3));
        record.setData((String)pair.getLeft());
        record.setResult((String)pair.getRight());
        this.taskRecordService.save(record);
    }

    public Pair<String, String> createPushTaskZip(Long userId, String taskId, String recordId) throws Exception {
        String url = "";
        JSONObject result = new JSONObject();
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        List tskTaskBizArea = this.tskTaskBizService.getTskTaskBizAreaByBizId(taskId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
        String sql = "SELECT a.*\nFROM\n\t" + table.getfTablename() + " A \nWHERE\n\tEXISTS (\nSELECT NULL \nFROM\n\ttbsys_task_record_temp b \nWHERE\n\tb.f_dataid = A.f_id \n\tAND b.f_recordid = '" + recordId + "')";
        List list = this.dataBizService.queryDataBySql(sql);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            List userBiz2s;
            Object t;
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskUtils.createInfo(this.tskTaskBizService, table, task, statement);
            Long classId = task.getClassId();
            sql = String.format("select * from tbtsk_task_class where f_id in (\nWITH RECURSIVE parents AS (\n    SELECT f_id, f_parentid\n    FROM tbtsk_task_class\n    WHERE f_id = '%s' -- \u66ff\u6362\u4e3a\u4f60\u8981\u67e5\u8be2\u7684\u5b50\u7ea7ID\n    UNION ALL\n    SELECT n.f_id, n.f_parentid\n    FROM tbtsk_task_class n\n    INNER JOIN parents p ON n.f_id = p.f_parentid\n)\nSELECT f_id\nFROM parents\n)", classId);
            List taskClassMaps = this.dataBizService.queryDataBySql(sql);
            ArrayList<TbtskTaskClass> taskClassLst = new ArrayList<TbtskTaskClass>();
            for (Map m : taskClassMaps) {
                t = new TbtskTaskClass();
                t.setId(Long.valueOf(Long.parseLong(m.get("f_id").toString())));
                t.setName(m.get("f_name").toString());
                t.setParentId(Long.valueOf(Long.parseLong(m.get("f_parentid").toString())));
                t.setUserId(Long.valueOf(Long.parseLong(m.get("f_userid").toString())));
                t.setLevel(Long.valueOf(Long.parseLong(m.get("f_level").toString())));
                taskClassLst.add((TbtskTaskClass)t);
            }
            TaskUtils.creaTaskClass(statement, taskClassLst);
            TbtskTaskBizFlow tbtskTaskBizFlow = this.tbtskTaskBizFlowService.selectByTaskId(taskId);
            if (tbtskTaskBizFlow != null) {
                TbtskFlowDef tbtskFlowDef = this.tbtskFlowDefRepository.findById((Object)tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow, tbtskFlowDef, statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId).map(arg_0 -> ((TbtskRejectDefDao)this.rejectDefDao).selectByTaskId(arg_0)).ifPresent(e -> TaskUtils.createTaskReject(e, finalStatement));
            TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            if (list != null && !list.isEmpty()) {
                t = this.taskAssignJobService.insertData(list, statement, table, task.getMode().toString());
            }
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("group", (Object)"task");
            jsonObject.put("type", (Object)"pushTaskData");
            jsonObject.put("mode", (Object)"1");
            jsonObject.put("userId", (Object)userId);
            jsonObject.put("taskId", (Object)taskId);
            List arealist = this.bizAreaRepository.findByBizId(taskId);
            if (!arealist.isEmpty()) {
                jsonObject.put("taskArea", (Object)((BizArea)arealist.get(0)).getArea());
            }
            if (!(userBiz2s = this.userBiz2Repository.findByBizIdAndRole(taskId, Integer.valueOf(0))).isEmpty()) {
                jsonObject.put("taskCreateUserId", (Object)((UserBiz2)userBiz2s.get(0)).getUserId());
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = StringUtils.deleteWhitespace((String)task.getName()).replaceAll(":", "").replaceAll("/", "") + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e2) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e2.getMessage());
        }
        return Pair.of((Object)url, (Object)JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public Pair<String, String> createTaskZip(TaskDataDbParameter parameter) throws Exception {
        String url = "";
        JSONObject result = new JSONObject();
        if (parameter == null) {
            throw new GwValidateException("parameter\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        List ids = this.taskRecordService.getDataIdListByRecordId(parameter.getRecordId());
        JSONArray orgs = parameter.getOrgs();
        JSONArray groups = parameter.getGroups();
        Long userId = parameter.getUserId();
        String taskId = parameter.getTaskId();
        String mode = parameter.getMode();
        this.tskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
        String sql = "SELECT a.*\nFROM\n\t" + table.getfTablename() + " A \nWHERE\n\tEXISTS (\nSELECT NULL \nFROM\n\ttbsys_task_record_temp b \nWHERE\n\tb.f_dataid = A.f_id \n\tAND b.f_recordid = '" + parameter.getRecordId() + "')";
        List list = this.dataBizService.queryDataBySql(sql);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskUtils.createInfo(this.tskTaskBizService, table, task, statement);
            TbtskTaskBizFlow tbtskTaskBizFlow = this.tbtskTaskBizFlowService.selectByTaskId(taskId);
            if (tbtskTaskBizFlow != null) {
                TbtskFlowDef tbtskFlowDef = this.tbtskFlowDefRepository.findById((Object)tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow, tbtskFlowDef, statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId).map(arg_0 -> ((TbtskRejectDefDao)this.rejectDefDao).selectByTaskId(arg_0)).ifPresent(e -> TaskUtils.createTaskReject(e, finalStatement));
            TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            Set<String> set = this.taskAssignJobService.insertData(list, statement, table, mode);
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("group", (Object)"task");
            jsonObject.put("type", (Object)"assignBiz");
            jsonObject.put("mode", (Object)"1");
            jsonObject.put("userId", (Object)userId);
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("assignUserIds", this.userIdList(orgs, groups));
            jsonObject.put("tbIds", (Object)ids);
            List arealist = this.bizAreaRepository.findByBizId(taskId);
            if (!arealist.isEmpty()) {
                jsonObject.put("taskArea", (Object)((BizArea)arealist.get(0)).getArea());
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = task.getName() + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e2) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e2.getMessage());
        }
        return Pair.of((Object)url, (Object)JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private Pair<String, String> createTaskDbByCond(JSONObject paramsObject, List<Map> data) throws Exception {
        String url = "";
        JSONObject result = new JSONObject();
        if (paramsObject == null) {
            throw new GwValidateException("parameter\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)paramsObject.getString("taskId")).orElse(null);
        ArrayList ids = new ArrayList();
        data.forEach(a -> ids.add(a.get("f_id").toString()));
        JSONArray orgs = paramsObject.getJSONArray("orgs");
        JSONArray groups = paramsObject.getJSONArray("groups");
        Long userId = paramsObject.getLongValue("userId");
        String taskId = paramsObject.getString("taskId");
        String mode = String.valueOf(tskTaskBiz.getMode());
        this.tskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskUtils.createInfo(this.tskTaskBizService, table, task, statement);
            TbtskTaskBizFlow tbtskTaskBizFlow = this.tbtskTaskBizFlowService.selectByTaskId(taskId);
            if (tbtskTaskBizFlow != null) {
                TbtskFlowDef tbtskFlowDef = this.tbtskFlowDefRepository.findById((Object)tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow, tbtskFlowDef, statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId).map(arg_0 -> ((TbtskRejectDefDao)this.rejectDefDao).selectByTaskId(arg_0)).ifPresent(e -> TaskUtils.createTaskReject(e, finalStatement));
            TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            Set<String> set = this.taskAssignJobService.insertData(data, statement, table, mode);
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mode", (Object)"1");
            jsonObject.put("group", (Object)"task");
            jsonObject.put("type", (Object)"assignBiz");
            jsonObject.put("userId", (Object)userId);
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("userIds", this.userIdList(orgs, groups));
            jsonObject.put("tbIds", ids);
            List list = this.bizAreaRepository.findByBizId(taskId);
            if (!list.isEmpty()) {
                jsonObject.put("taskArea", (Object)((BizArea)list.get(0)).getArea());
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = task.getName() + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e2) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e2.getMessage());
        }
        return Pair.of((Object)url, (Object)JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        url = this.uploadFileToCloudDisk(userId, safeFileName);
        url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

    public List<String> userIdList(JSONArray orgs, JSONArray groups) {
        JSONObject jsonObject;
        int i;
        ArrayList<String> userIds = new ArrayList<String>();
        JSONArray array = new JSONArray();
        for (i = 0; i < orgs.size(); ++i) {
            jsonObject = orgs.getJSONObject(i);
            array.addAll((Collection)jsonObject.getJSONArray("userids"));
        }
        for (i = 0; i < groups.size(); ++i) {
            jsonObject = groups.getJSONObject(i);
            array.addAll((Collection)jsonObject.getJSONArray("userids"));
        }
        for (int j = 0; j < array.size(); ++j) {
            String userid = array.getString(j);
            if (userIds.contains(userid)) continue;
            userIds.add(userid);
        }
        return userIds;
    }

    public void syncTask(Long userId, String taskId) throws Exception {
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskUtils.createInfo(this.tskTaskBizService, table, task, statement);
            TbtskTaskBizFlow tbtskTaskBizFlow = this.tbtskTaskBizFlowService.selectByTaskId(taskId);
            if (tbtskTaskBizFlow != null) {
                TbtskFlowDef tbtskFlowDef = this.tbtskFlowDefRepository.findById((Object)tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow, tbtskFlowDef, statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId).map(arg_0 -> ((TbtskRejectDefDao)this.rejectDefDao).selectByTaskId(arg_0)).ifPresent(e -> TaskUtils.createTaskReject(e, finalStatement));
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mode", (Object)"1");
            jsonObject.put("group", (Object)"task");
            jsonObject.put("type", (Object)"addBiz");
            jsonObject.put("userId", (Object)userId);
            jsonObject.put("taskId", (Object)taskId);
            List list = this.bizAreaRepository.findByBizId(taskId);
            if (!list.isEmpty()) {
                jsonObject.put("taskArea", (Object)((BizArea)list.get(0)).getArea());
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = task.getName() + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e2) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e2.getMessage());
        }
    }

    public void publishTranMsg(String url) {
        try {
            String queueName = "SC-out-taskTran";
            this.logger.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + url, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ActiveMQConstant.SERVICE_NAME, "TASKTRAN-RECEIVE-MESSAGE");
            map.put("appkey", PropertyUtil.getProperty((String)"transmit.appkey"));
            map.put("module", PropertyUtil.getProperty((String)"transmit.module"));
            map.put("name", "\u6d4b\u8bd5");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "TASKTRAN-RECEIVE-MESSAGE");
            this.producerService.sendMapMessage2Queue(map, queueName);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
        }
    }
}

