/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.GeometryUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.AtlasTaskInfo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.jms.MapMessage;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class InnerTxtShpResolverAdapterConsumer
implements IConsumerStrategyService {
    GiLoger logger = GwLoger.getLoger(InnerTxtShpResolverAdapterConsumer.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.txtdown.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.txtdown.module:}")
    String transmitModule;
    @Autowired
    protected SysConfigService sysConfigService;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    TaskRecordService taskRecordService;
    String key = "txt-down-config";

    @Override
    public String getCode() {
        return "INNER-TXT-DOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MapMessage mapMessage) {
        String messageId = "";
        try {
            SysConfig sysconfig = this.sysConfigService.findOne(this.key);
            if (sysconfig == null) {
                this.logger.error("\u5185\u7f51\u7f51\u95f4\u4f20\u8f93\u63a5\u6536txt-down\u4efb\u52a1\u5904\u7406\u5931\u8d25,\u672a\u914d\u7f6e\u53e0\u52a0\u6570\u53ca\u53e0\u52a0\u5206\u6790\u670d\u52a1", new Object[0]);
                return;
            }
            TxtDownConfig config = (TxtDownConfig)JSONObject.parseObject((String)sysconfig.getValue(), TxtDownConfig.class);
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)storageType)) {
                String objectStorag;
                if ("0".equals(storageType.trim())) {
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) {
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];
                    recvFile = this.buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), (File)recvFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(objectStorag = mapMessage.getString("objectStorage")))) {
                    String signed = this.temporarySignedUrlService.getTemporarySignedUrl("", objectStorag, null);
                    URL url = new URL(signed);
                    HttpURLConnection conn = null;
                    if (url != null) {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(3000);
                        conn.setRequestProperty("Charset", "UTF-8");
                        recvFile = this.buildTempUploadFile();
                        FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)recvFile);
                    }
                    conn.disconnect();
                }
            }
            this.resove(recvFile, config);
            FileUtils.deleteQuietly(recvFile);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)messageId)) {
                try {
                    JSONObject e = HttpUtil.sendRequestById(messageId, this.transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex) {
                    this.logger.error("\u7f51\u95f4\u4f20\u8f93\u56de\u8c03\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    public void runTask(TaskRecord record) {
        SysConfig sysconfig = this.sysConfigService.findOne(this.key);
        if (sysconfig == null) {
            this.logger.error("\u5185\u7f51\u7f51\u95f4\u4f20\u8f93\u63a5\u6536txt-down\u4efb\u52a1\u5904\u7406\u5931\u8d25,\u672a\u914d\u7f6e\u53e0\u52a0\u6570\u636e\u53ca\u53e0\u52a0\u5206\u6790\u670d\u52a1", new Object[0]);
            return;
        }
        TempParam param = (TempParam)JSONObject.parseObject((String)record.getParam(), TempParam.class);
        if (param.getAtlasState() != null && param.getAtlasState().equals(1)) {
            JSONObject body;
            TxtDownConfig config = (TxtDownConfig)JSONObject.parseObject((String)sysconfig.getValue(), TxtDownConfig.class);
            String atlasId = param.getAtlasId();
            String atlasUrl = config.atlasUrl;
            String url = atlasUrl.substring(0, atlasUrl.indexOf("/analysis"));
            url = url + "/task/get?id=" + atlasId;
            HttpRequest get = cn.hutool.http.HttpUtil.createGet((String)url);
            HttpResponse execute = get.execute();
            String bodyStr = execute.body();
            if (execute.getStatus() == 200 && (body = JSONObject.parseObject((String)bodyStr)).get((Object)"code").equals(200)) {
                AtlasTaskInfo taskDto = (AtlasTaskInfo)JSONObject.parseObject((String)body.get((Object)"data").toString(), AtlasTaskInfo.class);
                if (taskDto.getFinished().booleanValue()) {
                    if (taskDto.getSucceed().booleanValue()) {
                        param.setAtlasState(2);
                        record.setParam(JSONObject.toJSONString((Object)param));
                        record.setState(JobConstants.JOB_STATE_RUNNING);
                    } else {
                        param.setAtlasState(3);
                        record.setParam(JSONObject.toJSONString((Object)param));
                        record.setState(JobConstants.JOB_STATE_FAILED);
                        TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
                    }
                }
                this.taskRecordService.save(record);
                try {
                    if (param.getAtlasState().equals(2)) {
                        String tempTable = param.getTempTable();
                        ArrayList<String> fields = new ArrayList<String>();
                        fields.add("st_astext(f_shape) as f_shape");
                        fields.add("aid");
                        fields.add(config.getHzField());
                        List maps = this.dataBizMapper.queryAllData(tempTable, fields, null);
                        if (maps != null && !maps.isEmpty()) {
                            this.writeTxtTbfw(record.getId(), maps, config);
                        }
                        String resultTable = param.getResultTable();
                        fields.clear();
                        fields.add("st_astext(shape) as f_shape");
                        fields.add("aid_1");
                        fields.add(config.getHzField() + "_1 as " + config.getHzField());
                        fields.add(config.getFjsydDlmcField() + "_2 as " + config.getFjsydDlmcField());
                        maps = this.dataBizMapper.queryAllData(resultTable, fields, null);
                        if (maps != null && !maps.isEmpty()) {
                            this.writeTxtFjsyd(record.getId(), maps, config);
                            this.writeTxtDlmc(record.getId(), maps, config);
                        }
                        this.generateConfig(this.uploadDir + File.separator + record.getId(), record.getId());
                        String foler = this.uploadDir + File.separator + record.getId();
                        String file = this.uploadDir + File.separator + record.getId() + ".zip";
                        Zip4jUtils.zip((String)foler, (String)file, (boolean)false, (String)"");
                        JSONObject httpResult = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(file), this.transmitUrl + "/monitor/trans/transData.action");
                        if (httpResult == null || !"200".equals(httpResult.getString("code"))) {
                            this.logger.error("\u53d1\u9001\u6587\u4ef6\u5931\u8d25" + httpResult == null ? "" : httpResult.toJSONString(), new Object[0]);
                            record.setLog("\u53d1\u9001\u6587\u4ef6\u5931\u8d25");
                            record.setState(JobConstants.JOB_STATE_FAILED);
                            this.taskRecordService.save(record);
                            TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
                            TableUtil.dropTable(param.resultTable, this.jdbcTemplate);
                            return;
                        }
                        record.setState(JobConstants.JOB_STATE_SUCCESS);
                        this.taskRecordService.save(record);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("\u5199txt\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                    record.setLog("\u5199txt\u5931\u8d25");
                    record.setState(JobConstants.JOB_STATE_FAILED);
                    this.taskRecordService.save(record);
                    TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
                    TableUtil.dropTable(param.resultTable, this.jdbcTemplate);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateConfig(String folderPath, String id) {
        if (StringUtils.isNotBlank((CharSequence)folderPath)) {
            FileUtil.creatDirectoryIfNotExist((String)folderPath);
            String fileName = folderPath + File.separator + "config.json";
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                Writer writer = null;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                try {
                    writer = new FileWriter(file, true);
                    writer.write(jsonObject.toJSONString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resove(File recvFile, TxtDownConfig config) throws Exception {
        String dbleft;
        TaskRecord record = new TaskRecord();
        String zipName = recvFile.getAbsolutePath();
        String unzipFileDir = this.uploadDir + File.separator + UuidUtil.get16UUID();
        FileUtil.creatDirectoryIfNotExist((String)unzipFileDir);
        Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"", (Boolean)true);
        File file = new File(unzipFileDir);
        File[] contents = file.listFiles();
        File metaFile = Arrays.stream(contents).filter(f -> f.getName().endsWith("config.json")).findFirst().orElseThrow(() -> new RuntimeException("\u7f3a\u5c11\u5143\u6570\u636e"));
        JSONObject meta = InnerTxtShpResolverAdapterConsumer.readMeta(metaFile);
        String id = meta.getString("id");
        record.setId(id);
        record.setTasktype(JobConstants.JOB_TYPE_TXT_DOWN_INNER_ATLAS);
        record.setState(JobConstants.JOB_STATE_FAILED);
        record.setStarttime(new Date());
        File shpFile = Arrays.stream(contents).filter(f -> f.getName().endsWith(".shp")).findFirst().orElseThrow(() -> new RuntimeException("\u7f3a\u5c11shp\u6570\u636e"));
        String tablename = "temp_txt_" + UUID.randomUUID().toString().replace("-", "");
        String dbright = dbleft = this.getDB();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.fjsydDb)) {
            dbright = config.fjsydDb;
        }
        String resultname = "intersect_" + UUID.randomUUID().toString().replace("-", "");
        try {
            this.importData(shpFile, tablename);
            String template = this.getTemplate("intersect.json");
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("{left}", dbleft + "/" + tablename);
            mapParam.put("{leftPkField}", "aid");
            mapParam.put("{leftShapeField}", "f_shape");
            mapParam.put("{leftWhere}", "1=1");
            mapParam.put("{right}", dbright + "/" + config.fjsydTable);
            mapParam.put("{rightPkField}", config.fjsydPkField);
            mapParam.put("{rightShapeField}", config.fjsydShapeField);
            mapParam.put("{rightWhere}", "1=1");
            mapParam.put("{result}", resultname);
            mapParam.put("{resultdb}", dbleft + "/" + resultname);
            for (Map.Entry kv : mapParam.entrySet()) {
                template = template.replace((CharSequence)kv.getKey(), (CharSequence)kv.getValue());
            }
            this.logger.info("atlas service url:" + config.atlasUrl + " param:" + template, new Object[0]);
            String result = cn.hutool.http.HttpUtil.createPost((String)config.atlasUrl).body(template).execute().body();
            this.logger.info("atlas service url:" + config.atlasUrl + " http result: " + result, new Object[0]);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result)) {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    TempParam param = new TempParam();
                    param.setAtlasId(taskId);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(1);
                    record.setParam(JSONObject.toJSONString((Object)param));
                    record.setState(JobConstants.JOB_STATE_CREATE);
                } else {
                    TempParam param = new TempParam();
                    param.setAtlasId(null);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(3);
                    record.setParam(JSONObject.toJSONString((Object)param));
                    record.setState(JobConstants.JOB_STATE_FAILED);
                    record.setLog("\u521b\u5efaatlas\u4efb\u52a1\u5931\u8d25");
                    TableUtil.dropTable(tablename, this.jdbcTemplate);
                }
            }
            this.taskRecordService.save(record);
        }
        catch (Exception ex) {
            TableUtil.dropTable(tablename, this.jdbcTemplate);
            this.logger.error("\u5bfc\u5165shp\u5931\u8d25" + ExceptionUtil.getStackTrace(ex), new Object[0]);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(unzipFileDir));
        }
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = org.apache.commons.lang3.StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }

    private static JSONObject readMeta(File file) throws Exception {
        InputStreamReader read;
        StringBuilder sb = new StringBuilder();
        String encoding = "UTF-8";
        if (file.isFile() && file.exists()) {
            read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                sb.append(lineTxt);
            }
        } else {
            throw new Exception("\u627e\u4e0d\u5230\u6307\u5b9a\u7684mate\u6587\u4ef6");
        }
        read.close();
        String meta = sb.toString();
        return JSONObject.parseObject((String)meta);
    }

    private void importData(File file, String tableName) throws Exception {
        String shp = file.getAbsolutePath();
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (Exception ex) {
            throw new RuntimeException("shp\u6587\u4ef6\u8def\u5f84\u5f02\u5e38:" + shp);
        }
        int totalcount = 0;
        int importcount = 0;
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        shpDataStore.setCharset(Charset.forName("GBK"));
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        Query query = new Query();
        try {
        }
        catch (Exception ex) {
            this.logger.error("shp\u6587\u4ef6\u8ba1\u7b97\u56fe\u6591\u6570\u91cf\u5f02\u5e38:" + shp + ExceptionUtil.getErrorString(ex), new Object[0]);
            throw new RuntimeException("shp\u6587\u4ef6\u8ba1\u7b97\u56fe\u6591\u6570\u91cf\u5f02\u5e38:" + shp);
        }
        if ((totalcount += featureSource.getCount(query)) == 0) {
            this.logger.error("shp\u6587\u4ef6\u8ba1\u7b97\u56fe\u6591\u6570\u91cf\u4e3a0:" + shp, new Object[0]);
            throw new RuntimeException("shp\u6587\u4ef6\u8ba1\u7b97\u56fe\u6591\u6570\u91cf\u4e3a0:" + shp);
        }
        Map<String, String> mapFields = null;
        try {
            mapFields = this.getShpToTableColumns(shpDataStore);
        }
        catch (Exception ex) {
            this.logger.error("shp\u5b57\u6bb5\u83b7\u53d6\u5f02\u5e38:" + shp + ExceptionUtil.getErrorString(ex), new Object[0]);
            throw new RuntimeException("shp\u5b57\u6bb5\u83b7\u53d6\u5f02\u5e38:" + shp);
        }
        this.createShpTable(mapFields, this.jdbcTemplate, tableName);
        List<String> fields = mapFields.keySet().stream().collect(Collectors.toList());
        FeatureCollection collection = null;
        try {
            collection = featureSource.getFeatures();
        }
        catch (Exception ex) {
            this.logger.error("shp\u83b7\u53d6\u8981\u7d20\u96c6\u5408\u5f02\u5e38:" + shp + ExceptionUtil.getErrorString(ex), new Object[0]);
            throw new RuntimeException("shp\u83b7\u53d6\u8981\u7d20\u96c6\u5408\u5f02\u5e38:" + shp);
        }
        FeatureIterator itertor = collection.features();
        SimpleFeature sf = null;
        ArrayList<Map<String, Object>> tbList = new ArrayList<Map<String, Object>>();
        while (itertor.hasNext()) {
            sf = (SimpleFeature)itertor.next();
            Map<String, Object> tb = this.getFromSimpleFeature(sf, fields);
            tbList.add(tb);
            if (tbList.size() != 100) continue;
            importcount += 100;
            this.dataBizMapper.insertBatch(tableName, tbList, "f_shape");
            tbList.clear();
        }
        if (!tbList.isEmpty()) {
            importcount += tbList.size();
            this.dataBizMapper.insertBatch(tableName, tbList, "f_shape");
            tbList.clear();
        }
    }

    private Map<String, String> getShpToTableColumns(ShapefileDataStore shpDataStore) throws IOException {
        String[] typeNames = shpDataStore.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType featureType = shpDataStore.getSchema(typeName);
        String shapeField = featureType.getGeometryDescriptor().getLocalName();
        List ads = featureType.getAttributeDescriptors();
        List fieldNames = ads.stream().map(descriptor -> descriptor.getLocalName()).collect(Collectors.toList());
        HashMap<String, String> mapFields = new HashMap<String, String>();
        for (String f : fieldNames) {
            if (f.equals(shapeField)) {
                mapFields.put("f_shape", "public.geometry NOT NULL");
                continue;
            }
            mapFields.put(f, "varchar(100) NULL");
        }
        return mapFields;
    }

    private void createShpTable(Map<String, String> mapFields, JdbcTemplate jdbcTemplate, String tableName) {
        if (!TableUtil.tableExist(tableName, jdbcTemplate)) {
            String sql = "create table " + tableName + " (";
            for (Map.Entry<String, String> kv : mapFields.entrySet()) {
                sql = sql + kv.getKey() + " " + kv.getValue() + ",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql = sql + " )";
            jdbcTemplate.execute(sql);
            jdbcTemplate.execute("select updategeometrysrid('" + tableName + "','f_shape',4490)");
            TableUtil.createSequence(tableName, "aid", tableName + "_aid", jdbcTemplate);
        }
    }

    private Map<String, Object> getFromSimpleFeature(SimpleFeature sf, List<String> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Geometry geo = (Geometry)sf.getDefaultGeometry();
        geo.setSRID(4490);
        for (String f : fields) {
            if (f.equals("f_shape")) continue;
            map.put(f, sf.getAttribute(f));
        }
        map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
        return map;
    }

    private String getTemplate(String fileName) {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/" + fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u5206\u6790\u6a21\u578b\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
            return null;
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("downtxt-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTxtTbfw(String recordId, List<Map> maps, TxtDownConfig config) throws Exception {
        String path = this.uploadDir + File.separator + recordId;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        Map<String, List<Map>> kvMap = maps.stream().collect(Collectors.groupingBy(t -> t.get(config.hzField).toString()));
        for (Map.Entry<String, List<Map>> kv : kvMap.entrySet()) {
            String hz = kv.getKey();
            List<Map> values = kv.getValue();
            String wkt = values.get(0).get("f_shape").toString();
            WKTReader reader = new WKTReader();
            Geometry geo = reader.read(wkt);
            Integer projNo = GeometryUtil.getProjNum((Geometry)geo);
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
            HashMap<Integer, CoordinateReferenceSystem> mapRef = new HashMap<Integer, CoordinateReferenceSystem>();
            mapRef.put(projNo, ref);
            ArrayList<String> contents = new ArrayList<String>();
            contents.add("[\u5c5e\u6027\u63cf\u8ff0]\n");
            contents.add("\u5750\u6807\u7cfb=2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\n");
            contents.add("\u51e0\u5ea6\u5206\u5e26=3\n");
            contents.add("\u6295\u5f71\u7c7b\u578b=\u9ad8\u65af\u514b\u5415\u683c\n");
            contents.add("\u8ba1\u91cf\u5355\u4f4d=\u7c73\n");
            contents.add("\u5e26\u53f7=" + projNo + "\n");
            contents.add("\u7cbe\u5ea6=0.0001\n");
            contents.add("\u8f6c\u6362\u53c2\u6570=0,0,0,0,0,0,0\n");
            contents.add("[\u5730\u5757\u5750\u6807]\n");
            int index = 0;
            DecimalFormat df = new DecimalFormat("#.000");
            for (Map map : values) {
                wkt = map.get("f_shape").toString();
                geo = reader.read(wkt);
                projNo = GeometryUtil.getProjNum((Geometry)geo);
                if (mapRef.containsKey(projNo)) {
                    ref = (CoordinateReferenceSystem)mapRef.get(projNo);
                } else {
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
                    mapRef.put(projNo, prjRef);
                    ref = prjRef;
                }
                Geometry projGeo = GeometryUtil.transCgcs2000ToPrj((Geometry)geo, (CoordinateReferenceSystem)ref);
                int geoCount = projGeo.getNumGeometries();
                for (int i = 0; i < geoCount; ++i) {
                    Geometry childGeo = projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo = childGeo.getCoordinates().length + "," + area + "," + ++index + ",\u5730\u5757" + index + ",\u9762,,\u519c\u6751\u5b85\u57fa\u5730,,@";
                    contents.add(dkInfo + "\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for (int j = 0; j < coordinates.length; ++j) {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y = df.format(bigy.doubleValue());
                        contents.add("J" + (j + 1) + ",1," + y + "," + x + "\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y = df.format(bigy.doubleValue());
                    contents.add("J1,1," + y + "," + x + "\n");
                }
            }
            String fileName = path + File.separator + (hz + "\u9009\u5740\u8303\u56f4.txt");
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true);
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u5199\u9009\u5740\u8303\u56f4.txt\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTxtFjsyd(String recordId, List<Map> maps, TxtDownConfig config) throws Exception {
        String path = this.uploadDir + File.separator + recordId;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        Map<String, List<Map>> kvMap = maps.stream().collect(Collectors.groupingBy(t -> t.get(config.hzField).toString()));
        for (Map.Entry<String, List<Map>> kv : kvMap.entrySet()) {
            String hz = kv.getKey();
            List<Map> values = kv.getValue();
            WKTReader reader = new WKTReader();
            ArrayList<TempGeo> geos = new ArrayList<TempGeo>();
            int index = 0;
            for (Map map : values) {
                String wkt = values.get(0).get("f_shape").toString();
                Geometry geo = reader.read(wkt);
                TempGeo tempGeo = new TempGeo();
                tempGeo.setGeo(geo);
                tempGeo.setIndex(index);
                geos.add(tempGeo);
                ++index;
            }
            int size = geos.size();
            for (int i = 0; i < size; ++i) {
                TempGeo self = (TempGeo)geos.get(i);
                for (int j = i + 1; j < size; ++j) {
                    TempGeo other = (TempGeo)geos.get(j);
                    if (self.getIndex() == other.index || self.getIndex() < i || !self.getGeo().touches(other.getGeo())) continue;
                    Geometry union = self.getGeo().union(other.getGeo());
                    self.setGeo(union);
                    other.setGeo(union);
                    other.setIndex(self.getIndex());
                }
            }
            Map<Integer, List<TempGeo>> mapGeos = geos.stream().collect(Collectors.groupingBy(t -> t.getIndex()));
            Integer projNo = GeometryUtil.getProjNum((Geometry)((TempGeo)geos.get(0)).getGeo());
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
            HashMap<Integer, CoordinateReferenceSystem> mapRef = new HashMap<Integer, CoordinateReferenceSystem>();
            mapRef.put(projNo, ref);
            ArrayList<String> contents = new ArrayList<String>();
            contents.add("[\u5c5e\u6027\u63cf\u8ff0]\n");
            contents.add("\u5750\u6807\u7cfb=2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\n");
            contents.add("\u51e0\u5ea6\u5206\u5e26=3\n");
            contents.add("\u6295\u5f71\u7c7b\u578b=\u9ad8\u65af\u514b\u5415\u683c\n");
            contents.add("\u8ba1\u91cf\u5355\u4f4d=\u7c73\n");
            contents.add("\u5e26\u53f7=" + projNo + "\n");
            contents.add("\u7cbe\u5ea6=0.0001\n");
            contents.add("\u8f6c\u6362\u53c2\u6570=0,0,0,0,0,0,0\n");
            contents.add("[\u5730\u5757\u5750\u6807]\n");
            index = 0;
            DecimalFormat df = new DecimalFormat("#.000");
            for (Map.Entry<Integer, List<TempGeo>> kvTemp : mapGeos.entrySet()) {
                Geometry geo = kvTemp.getValue().get(0).getGeo();
                projNo = GeometryUtil.getProjNum((Geometry)geo);
                if (mapRef.containsKey(projNo)) {
                    ref = (CoordinateReferenceSystem)mapRef.get(projNo);
                } else {
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
                    mapRef.put(projNo, prjRef);
                    ref = prjRef;
                }
                Geometry projGeo = GeometryUtil.transCgcs2000ToPrj((Geometry)geo, (CoordinateReferenceSystem)ref);
                int geoCount = projGeo.getNumGeometries();
                for (int i = 0; i < geoCount; ++i) {
                    Geometry childGeo = projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo = childGeo.getCoordinates().length + "," + area + "," + ++index + ",\u5730\u5757" + index + ",\u9762,,\u975e\u5efa\u8bbe\u7528\u5730,,@";
                    contents.add(dkInfo + "\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for (int j = 0; j < coordinates.length; ++j) {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y = df.format(bigy.doubleValue());
                        contents.add("J" + (j + 1) + ",1," + y + "," + x + "\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y = df.format(bigy.doubleValue());
                    contents.add("J1,1," + y + "," + x + "\n");
                }
            }
            String fileName = path + File.separator + (hz + "\u975e\u5efa\u8bbe\u7528\u5730\u8303\u56f4.txt");
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true);
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u5199\u975e\u5efa\u8bbe\u7528\u5730\u8303\u56f4.txt\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTxtDlmc(String recordId, List<Map> maps, TxtDownConfig config) throws Exception {
        String path = this.uploadDir + File.separator + recordId;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        Map<String, List<Map>> kvMap = maps.stream().collect(Collectors.groupingBy(t -> t.get(config.hzField).toString()));
        for (Map.Entry<String, List<Map>> kv : kvMap.entrySet()) {
            String hz = kv.getKey();
            List<Map> values = kv.getValue();
            String wkt = values.get(0).get("f_shape").toString();
            WKTReader reader = new WKTReader();
            Geometry geo = reader.read(wkt);
            Integer projNo = GeometryUtil.getProjNum((Geometry)geo);
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
            HashMap<Integer, CoordinateReferenceSystem> mapRef = new HashMap<Integer, CoordinateReferenceSystem>();
            mapRef.put(projNo, ref);
            ArrayList<String> contents = new ArrayList<String>();
            contents.add("[\u5c5e\u6027\u63cf\u8ff0]\n");
            contents.add("\u5750\u6807\u7cfb=2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb\n");
            contents.add("\u51e0\u5ea6\u5206\u5e26=3\n");
            contents.add("\u6295\u5f71\u7c7b\u578b=\u9ad8\u65af\u514b\u5415\u683c\n");
            contents.add("\u8ba1\u91cf\u5355\u4f4d=\u7c73\n");
            contents.add("\u5e26\u53f7=" + projNo + "\n");
            contents.add("\u7cbe\u5ea6=0.0001\n");
            contents.add("\u8f6c\u6362\u53c2\u6570=0,0,0,0,0,0,0\n");
            contents.add("[\u5730\u5757\u5750\u6807]\n");
            int index = 0;
            DecimalFormat df = new DecimalFormat("#.000");
            for (Map map : values) {
                Object dlmcObj = map.get(config.getFjsydDlmcField());
                String dlmc = dlmcObj == null ? "" : dlmcObj.toString();
                wkt = map.get("f_shape").toString();
                geo = reader.read(wkt);
                projNo = GeometryUtil.getProjNum((Geometry)geo);
                if (mapRef.containsKey(projNo)) {
                    ref = (CoordinateReferenceSystem)mapRef.get(projNo);
                } else {
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem((int)projNo);
                    mapRef.put(projNo, prjRef);
                    ref = prjRef;
                }
                Geometry projGeo = GeometryUtil.transCgcs2000ToPrj((Geometry)geo, (CoordinateReferenceSystem)ref);
                int geoCount = projGeo.getNumGeometries();
                for (int i = 0; i < geoCount; ++i) {
                    Geometry childGeo = projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo = childGeo.getCoordinates().length + "," + area + "," + ++index + ",\u5730\u5757" + index + ",\u9762,," + dlmc + ",,@";
                    contents.add(dkInfo + "\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for (int j = 0; j < coordinates.length; ++j) {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y = df.format(bigy.doubleValue());
                        contents.add("J" + (j + 1) + ",1," + y + "," + x + "\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y = df.format(bigy.doubleValue());
                    contents.add("J1,1," + y + "," + x + "\n");
                }
            }
            String fileName = path + File.separator + (hz + "\u975e\u5efa\u8bbe\u7528\u5730\u8303\u56f4\u5185\u5404\u5730\u7c7b\u60c5\u51b5.txt");
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true);
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u5199\u975e\u5efa\u8bbe\u7528\u5730\u8303\u56f4\u5185\u5404\u5730\u7c7b\u60c5\u51b5.txt\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    private class TempGeo {
        private int index;
        private Geometry geo;

        private TempGeo() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Geometry getGeo() {
            return this.geo;
        }

        public void setGeo(Geometry geo) {
            this.geo = geo;
        }
    }

    private class TempParam {
        private String atlasId;
        private String tempTable;
        private String resultTable;
        private Integer atlasState;

        private TempParam() {
        }

        public String getAtlasId() {
            return this.atlasId;
        }

        public void setAtlasId(String atlasId) {
            this.atlasId = atlasId;
        }

        public String getTempTable() {
            return this.tempTable;
        }

        public void setTempTable(String tempTable) {
            this.tempTable = tempTable;
        }

        public String getResultTable() {
            return this.resultTable;
        }

        public void setResultTable(String resultTable) {
            this.resultTable = resultTable;
        }

        public Integer getAtlasState() {
            return this.atlasState;
        }

        public void setAtlasState(Integer atlasState) {
            this.atlasState = atlasState;
        }
    }

    public class TxtDownConfig {
        private String atlasUrl;
        private String fjsydDb;
        private String fjsydTable;
        private String fjsydShapeField;
        private String fjsydPkField;
        private String hzField;
        private String fjsydDlmcField;

        public String getAtlasUrl() {
            return this.atlasUrl;
        }

        public void setAtlasUrl(String atlasUrl) {
            this.atlasUrl = atlasUrl;
        }

        public String getFjsydDb() {
            return this.fjsydDb;
        }

        public void setFjsydDb(String fjsydDb) {
            this.fjsydDb = fjsydDb;
        }

        public String getFjsydTable() {
            return this.fjsydTable;
        }

        public void setFjsydTable(String fjsydTable) {
            this.fjsydTable = fjsydTable;
        }

        public String getFjsydShapeField() {
            return this.fjsydShapeField;
        }

        public void setFjsydShapeField(String fjsydShapeField) {
            this.fjsydShapeField = fjsydShapeField;
        }

        public String getHzField() {
            return this.hzField;
        }

        public void setHzField(String hzField) {
            this.hzField = hzField;
        }

        public String getFjsydDlmcField() {
            return this.fjsydDlmcField;
        }

        public void setFjsydDlmcField(String fjsydDlmcField) {
            this.fjsydDlmcField = fjsydDlmcField;
        }

        public String getFjsydPkField() {
            return this.fjsydPkField;
        }

        public void setFjsydPkField(String fjsydPkField) {
            this.fjsydPkField = fjsydPkField;
        }
    }
}

