/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbsysUserTrackRecordRepository;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.task.entity.TbsysUserTrackRecord;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InnerUserTrackTransmitAcceptService {
    private static final Logger log = LoggerFactory.getLogger(InnerUserTrackTransmitAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TbsysUserTrackRecordRepository tbsysUserTrackRecordRepository;

    public void execute(JSONObject jsonObject, Map<String, String> fileMap, File dbFile) {
        try {
            String type = jsonObject.getString("type");
            Long userId = jsonObject.getLong("userId");
            this.handDbFile(dbFile, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handDbFile(File dbFile, Long userId) {
        try {
            SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(" select * from track");
            ArrayList<TbsysUserTrackRecord> tbsysUserTrackRecordList = new ArrayList<TbsysUserTrackRecord>();
            while (rs.next()) {
                TbsysUserTrackRecord bean = new TbsysUserTrackRecord();
                bean.setId(rs.getString("f_id"));
                bean.setLat(Double.valueOf(rs.getDouble("f_lat")));
                bean.setLon(Double.valueOf(rs.getDouble("f_lon")));
                bean.setPlanId(rs.getString("f_jhid"));
                bean.setXsrwId(rs.getString("f_xsrwid"));
                if (rs.findColumn("f_batch") > 0) {
                    bean.setBatch(rs.getString("f_batch"));
                }
                bean.setUserId(userId);
                bean.setCreateTime(new Timestamp(Long.valueOf(rs.getString("f_createtime"))));
                tbsysUserTrackRecordList.add(bean);
                if (tbsysUserTrackRecordList.size() < 500) continue;
                this.tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                tbsysUserTrackRecordList.clear();
            }
            if (tbsysUserTrackRecordList.size() > 0) {
                this.tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
            }
            connPool.closeAll(connection, statement, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

