/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.customtask.repository.task.TbsysInspectionRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.task.entity.TbsysInspectionRecord;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UisApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.model.oauth.SyncUserInfo;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class InnerUserTransmitAcceptService {
    private static final Logger log = LoggerFactory.getLogger(InnerUserTransmitAcceptService.class);
    private GiLoger logger = GwLoger.getLoger(InnerUserTransmitAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${oauth.appkey}")
    protected String appkey;
    @Value(value="${oauth.appkeys}")
    protected String appkeys;
    @Autowired
    LandRegUserRepository landRegUserRepository;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    LandUserService userService;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;
    @Autowired
    UserApplicationRepository userApplicationDao;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    UserCloudAreaRepository userCloudAreaDao;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Autowired
    UisApplicationRepository UisApplicationDao;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    TbsysInspectionRecordRepository tbsysInspectionRecordRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    OauthUserService oauthUserService;

    public void execute(JSONObject jsonObject, Map<String, String> fileMap, File dbFile) {
        try {
            this.handData(jsonObject);
        }
        catch (Exception e) {
            this.logger.error("\u5185\u7f51\u7528\u6237\u63a5\u6536\u5f02\u5e38:" + ExceptionUtil.getStackTrace(e), new Object[0]);
        }
    }

    public void handData(JSONObject jsonObject) throws Exception {
        String type = jsonObject.getString("type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "insert": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.syncAddBusUser(landUser);
                    break;
                }
                case "update": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.syncUpdateBusUser(landUser);
                    break;
                }
                case "updatePassWord": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.changePasswordByUsername(landUser.getUserName(), landUser.getPassWord());
                }
                case "updatePhoneNumber": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.renewPhoneNum(landUser.getMidUserId(), landUser.getPhone());
                    break;
                }
                case "forbidden": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.setUserEnable(landUser.getMidUserId(), landUser.getEnable());
                    break;
                }
                case "register": {
                    LandRegUser landRegUser = (LandRegUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    this.landRegUserRepository.save((Object)landRegUser);
                    break;
                }
                case "zeroReport": {
                    if (jsonObject.get((Object)"TbsysInspectionRecord") == null) break;
                    TbsysInspectionRecord record = (TbsysInspectionRecord)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("TbsysInspectionRecord"), TbsysInspectionRecord.class);
                    this.tbsysInspectionRecordRepository.save((Object)record);
                    break;
                }
                case "patrolCase": {
                    if (jsonObject.get((Object)"PatrolGzqk") == null) break;
                    JSONObject patrolGzqk = jsonObject.getJSONObject("PatrolGzqk");
                    StringBuffer sql = new StringBuffer();
                    sql.append("insert into tb_patrol_gzqk (f_id, f_planid, f_xsrwid,  f_xcsj, f_xcry, f_xcqylx, f_qxywlx, f_xclx, f_xcjbqk,  f_createtime, f_userid) values (");
                    sql.append("'" + patrolGzqk.getString("fId") + "',");
                    sql.append("'" + patrolGzqk.getString("fPlanid") + "',");
                    sql.append("'" + patrolGzqk.getString("fXsrwid") + "',");
                    String fXcsj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(patrolGzqk.get((Object)"fXcsj"));
                    sql.append("'" + fXcsj + "',");
                    sql.append("'" + patrolGzqk.getString("fXcry") + "',");
                    sql.append("'" + patrolGzqk.getString("fXcqylx") + "',");
                    sql.append("'" + patrolGzqk.getString("fQxywlx") + "',");
                    sql.append("'" + patrolGzqk.getString("fXclx") + "',");
                    sql.append("'" + patrolGzqk.getString("fXcjbqk") + "',");
                    String fCreatetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(patrolGzqk.get((Object)"fXcsj"));
                    sql.append("'" + fCreatetime + "',");
                    sql.append(patrolGzqk.getInteger("fUserid") + ")");
                    this.jdbcTemplate.execute(sql.toString());
                    break;
                }
                default: {
                    throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
    }
}

