/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InnerUserTransmitDataService {
    private GiLoger logger = GwLoger.getLoger(InnerUserTransmitDataService.class);
    @Resource
    ProducerService producerService;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    OrganizationRepository organizationRepository;

    public void syncUserInfo(JSONObject userInfo) throws Exception {
        String type = userInfo.getString("type");
        Long userId = userInfo.getLongValue("operUserId");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String tempFolderPath = this.uploadDir + File.separator + UUID.randomUUID().toString();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            switch (type) {
                case "insert": {
                    jsonObject.put("group", (Object)"user");
                    jsonObject.put("type", (Object)"insert");
                    Organization organization = this.organizationRepository.findById((Object)userInfo.getString("organizationId")).orElse(null);
                    jsonObject.put("user", (Object)userInfo.getJSONObject("user"));
                    jsonObject.put("organization", (Object)organization);
                    jsonObject.put("userRegionCode", userInfo.get((Object)"userRegionCode"));
                    jsonObject.put("userRoles", userInfo.get((Object)"userRoles"));
                    jsonObject.put("userCloudArea", userInfo.get((Object)"userCloudArea"));
                    jsonObject.put("userCloudQueryConfig", userInfo.get((Object)"userCloudQueryConfig"));
                    jsonObject.put("userBiz", userInfo.get((Object)"userBiz"));
                    jsonObject.put("userTaskClass", userInfo.get((Object)"userTaskClass"));
                    break;
                }
                case "update": {
                    jsonObject.put("group", (Object)"user");
                    jsonObject.put("type", (Object)"update");
                    Organization organization = this.organizationRepository.findById((Object)userInfo.getString("organizationId")).orElse(null);
                    jsonObject.put("organization", (Object)organization);
                    jsonObject.put("user", (Object)userInfo.getJSONObject("user"));
                    jsonObject.put("userRegionCode", userInfo.get((Object)"userRegionCode"));
                    jsonObject.put("userRoles", userInfo.get((Object)"userRoles"));
                    jsonObject.put("userCloudArea", userInfo.get((Object)"userCloudArea"));
                    jsonObject.put("userCloudQueryConfig", userInfo.get((Object)"userCloudQueryConfig"));
                    jsonObject.put("userBiz", userInfo.get((Object)"userBiz"));
                    jsonObject.put("userTaskClass", userInfo.get((Object)"userTaskClass"));
                    break;
                }
                case "updatePassWord": {
                    jsonObject.put("group", (Object)"user");
                    jsonObject.put("type", (Object)"updatePassWord");
                    jsonObject.put("user", (Object)userInfo.getJSONObject("user"));
                    break;
                }
                case "delete": {
                    jsonObject.put("group", (Object)"user");
                    jsonObject.put("type", (Object)"delete");
                    jsonObject.put("userId", (Object)userInfo.getLongValue("userId"));
                    jsonObject.put("deleteReason", (Object)userInfo.getString("deleteReason"));
                    break;
                }
                case "forbidden": {
                    jsonObject.put("group", (Object)"user");
                    jsonObject.put("type", (Object)"forbidden");
                    jsonObject.put("userId", (Object)userInfo.getLongValue("userId"));
                    jsonObject.put("state", (Object)userInfo.getString("state"));
                    jsonObject.put("operUserId", (Object)userId);
                    break;
                }
                default: {
                    throw new GwValidateException("\u7c7b\u578b\u9519\u8bef");
                }
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            String url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            JSONObject result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
    }

    public void syncUserBusInfo(JSONObject userBusInfo) {
        String type = userBusInfo.getString("type");
        Long userId = userBusInfo.getLongValue("operUserId");
        try {
            if (StringUtils.isNotBlank((CharSequence)type)) {
                String tempFolderPath = this.uploadDir + File.separator + UUID.randomUUID().toString();
                FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
                String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
                File file = new File(jsonPath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                JSONObject jsonObject = new JSONObject();
                switch (type) {
                    case "insert": {
                        jsonObject.put("type", (Object)"insert");
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    case "update": {
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("type", (Object)"update");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    case "updatePassWord": {
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("type", (Object)"updatePassWord");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    case "updatePhoneNumber": {
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("type", (Object)"updatePhoneNumber");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    case "delete": {
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("type", (Object)"delete");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    case "forbidden": {
                        jsonObject.put("group", (Object)"user");
                        jsonObject.put("type", (Object)"forbidden");
                        jsonObject.put("user", (Object)userBusInfo.getJSONObject("user"));
                        break;
                    }
                    default: {
                        throw new GwValidateException("\u7c7b\u578b\u9519\u8bef");
                    }
                }
                OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                write.write(JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                ((Writer)write).flush();
                ((Writer)write).close();
                String safeFileName = UuidUtil.get16UUID();
                String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                String url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
                JSONObject result = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
                this.publishTranMsg(fileNameNoSuffix + ".zip");
                FileUtils.deleteQuietly((File)new File(tempFolderPath));
            }
        }
        catch (Exception e) {
            this.logger.error("\u5916\u7f51\u7528\u6237\u540c\u6b65\u5f02\u5e38:" + ExceptionUtil.getStackTrace(e), new Object[0]);
        }
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "userTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

    public void publishTranMsg(String url) {
        try {
            String queueName = "SC-out-patrolTran1";
            this.logger.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + url, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appkey", PropertyUtil.getProperty((String)"transmit.appkey"));
            map.put("module", PropertyUtil.getProperty((String)"transmit.module"));
            map.put("name", "\u6d4b\u8bd5");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "PATROLTRAN-RECEIVE-MESSAGE");
            this.producerService.sendMapMessage2Queue(map, queueName);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
        }
    }
}

