/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.jms.MapMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InnerXzjsydmjResolverAdapterConsumer
implements IConsumerStrategyService {
    GiLoger logger = GwLoger.getLoger(InnerXzjsydmjResolverAdapterConsumer.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.xzjsydmj.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.xzjsydmj.module:}")
    String transmitModule;
    @Autowired
    protected SysConfigService sysConfigService;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MXzjsydmjService mXzjsydmjService;
    String key = "xzjsydmj-config";

    @Override
    public String getCode() {
        return "INNER-XZJSYDMJ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MapMessage mapMessage) {
        String messageId = "";
        File recvFile = null;
        try {
            SysConfig sysconfig = this.sysConfigService.findOne(this.key);
            if (sysconfig == null) {
                this.logger.error("\u5185\u7f51\u7f51\u95f4\u4f20\u8f93\u63a5\u6536XZJSYDMJ\u4efb\u52a1\u5904\u7406\u5931\u8d25,\u672a\u914d\u7f6e\u64e6\u9664\u6570\u636e\u53ca\u64e6\u9664\u5206\u6790\u670d\u52a1", new Object[0]);
                return;
            }
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            if (StringUtils.isNotBlank((CharSequence)storageType)) {
                String objectStorag;
                if ("0".equals(storageType.trim())) {
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) {
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];
                    recvFile = this.buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), (File)recvFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim()) && StringUtils.isNotBlank((CharSequence)(objectStorag = mapMessage.getString("objectStorage")))) {
                    URL url = new URL(objectStorag);
                    HttpURLConnection conn = null;
                    if (url != null) {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(3000);
                        conn.setRequestProperty("Charset", "UTF-8");
                        recvFile = this.buildTempUploadFile();
                        FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)recvFile);
                    }
                    conn.disconnect();
                }
            }
            this.mXzjsydmjService.resoveInner(recvFile);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly(recvFile);
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                try {
                    JSONObject e = HttpUtil.sendRequestById(messageId, this.transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex) {
                    this.logger.error("\u7f51\u95f4\u4f20\u8f93\u56de\u8c03\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("xzjsydmj-%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }
}

