/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.DbResolverProvider;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.DirectoryResolverProvider;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.jms.MapMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WpzfMessageConsumerImpl
implements IConsumerStrategyService {
    GiLoger logger = GwLoger.getLoger(WpzfMessageConsumerImpl.class);
    private static final String UNZIP_PASSWORD = "cc9b219c799c417ca95418ef5f0e05e5";
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Autowired
    protected SysConfigService sysConfigService;
    @Autowired
    protected DbResolverProvider dbResolverProvider;
    @Autowired
    protected DirectoryResolverProvider directoryResolverProvider;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;

    @Override
    public String getCode() {
        return "WPZF";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MapMessage mapMessage) {
        String messageId = "";
        try {
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if (StringUtils.isNotBlank((CharSequence)storageType)) {
                String objectStorag;
                if ("0".equals(storageType.trim())) {
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) {
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];
                    recvFile = this.buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), (File)recvFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim()) && StringUtils.isNotBlank((CharSequence)(objectStorag = mapMessage.getString("objectStorage")))) {
                    String signed = this.temporarySignedUrlService.getTemporarySignedUrl("", objectStorag, null);
                    URL url = new URL(signed);
                    HttpURLConnection conn = null;
                    if (url != null) {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(3000);
                        conn.setRequestProperty("Charset", "UTF-8");
                        recvFile = this.buildTempUploadFile();
                        FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)recvFile);
                    }
                    conn.disconnect();
                }
            }
            String zipName = recvFile.getAbsolutePath();
            String unzipFileDir = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)unzipFileDir);
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)UNZIP_PASSWORD, (Boolean)true);
            File unzipPath = new File(unzipFileDir);
            File[] contents = unzipPath.listFiles();
            File dbFile = Arrays.stream(contents).filter(f -> f.getName().endsWith(".db")).findFirst().orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684db\u6587\u4ef6"));
            SqlliteConnTool connTool = null;
            try {
                connTool = new SqlliteConnTool(dbFile.getAbsolutePath());
                String sql = "select code from paraminfo";
                ResultSetInfo result = connTool.doQuery(sql);
                ResultSet rs = result.getResultSet();
                rs.next();
                String busiz = rs.getString("code");
                DbResolver resolver = this.dbResolverProvider.getHandler(busiz);
                resolver.resolve(connTool);
                List<File> otherFiles = Arrays.stream(contents).filter(f -> !f.getName().endsWith(".db")).collect(Collectors.toList());
                AttachFileParam param = AttachFileParam.create((SqlliteConnTool)connTool, (String)busiz);
                this.resolveOtherFiles(otherFiles, param);
            }
            finally {
                connTool.Dispose();
            }
            FileUtils.deleteQuietly((File)new File(unzipFileDir));
            FileUtils.deleteQuietly((File)recvFile);
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtil.getErrorString(e), new Object[0]);
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                try {
                    JSONObject e = HttpUtil.sendRequestById(messageId, this.transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex) {
                    this.logger.error("\u7f51\u95f4\u4f20\u8f93\u56de\u8c03\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    protected void resolveOtherFiles(List<File> files, AttachFileParam param) throws Exception {
        String resloverPrefix = "wpzf_";
        for (File file : files) {
            this.directoryResolverProvider.handle(file, param, resloverPrefix + file.getName());
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("wpzf-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }
}

