/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskTemplateService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.AppConfigDTO;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterProgramTransmitAcceptService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterTaskTransmitAcceptService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterUserTranAcceptService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TranFileUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import javax.jms.MapMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class OuterDataTransmitAcceptService
implements IConsumerStrategyService {
    private static final Logger log = LoggerFactory.getLogger(OuterDataTransmitAcceptService.class);
    private final GiLoger logger = GwLoger.getLoger(OuterDataTransmitAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Resource
    private DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    OuterUserTranAcceptService outerUserTranAcceptService;
    @Resource
    OuterTaskTransmitAcceptService outerTaskTransmitAcceptService;
    @Resource
    OuterProgramTransmitAcceptService outerProgramTransmitAcceptService;
    @Resource
    TbtskFieldsService tbtskFieldsService;
    @Resource
    TbtskTemplateService templateService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Resource
    TbtskTaskClassRepository tbtskTaskClassRepository;

    @Override
    public String getCode() {
        return "OUTER-RECEIVE-MESSAGE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MapMessage mapMessage) {
        String messageId = "";
        try {
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File zipFile = null;
            if (StringUtils.isNotBlank((CharSequence)storageType)) {
                String objectStorag;
                if ("0".equals(storageType.trim())) {
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    zipFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) {
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];
                    zipFile = this.buildTempUploadFile("101");
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), (File)zipFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim()) && StringUtils.isNotBlank((CharSequence)(objectStorag = mapMessage.getString("objectStorage")))) {
                    URL url = new URL(objectStorag);
                    HttpURLConnection conn = null;
                    if (url != null) {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(3000);
                        conn.setRequestProperty("Charset", "UTF-8");
                        zipFile = this.buildTempUploadFile("101");
                        FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)zipFile);
                    }
                    conn.disconnect();
                }
            }
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)unzipFileDir);
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"");
            this.resolveFiles(unzipFileDir);
            FileUtils.deleteQuietly((File)new File(unzipFileDir));
            FileUtils.deleteQuietly((File)zipFile);
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u6536\u5185\u7f51\u63a8\u9001\u6570\u636e\u5305\u5f02\u5e38" + ExceptionUtil.getErrorString(e), new Object[0]);
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                try {
                    JSONObject e = HttpUtil.sendRequestById(messageId, this.transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex) {
                    this.logger.error("\u7f51\u95f4\u4f20\u8f93\u56de\u8c03\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    public void resolveFiles(String unzipDir) throws Exception {
        File file = new File(unzipDir);
        File dbFile = null;
        File jsonFile = null;
        File[] content = file.listFiles();
        HashMap<String, String> fileMap = new HashMap<String, String>();
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (content[j].getName().endsWith(".json")) {
                jsonFile = content[j];
                continue;
            }
            if (content[j].getName().endsWith(".db")) {
                dbFile = content[j];
                continue;
            }
            File mediafile = content[j];
            String fiename = mediafile.getName();
            String sendObjName = "patrolTaskTran/media/" + fiename;
            String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, mediafile);
            fileMap.put(fiename, resultUrl);
        }
        String jsonContext = TranFileUtil.readFile(jsonFile.getAbsolutePath());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonContext);
        String group = jsonObject.getString("group");
        if (StringUtils.isNotBlank((CharSequence)group)) {
            block6 : switch (group) {
                case "patrol": {
                    this.outerProgramTransmitAcceptService.execute(jsonObject);
                    break;
                }
                case "user": {
                    this.outerUserTranAcceptService.execute(jsonObject);
                    break;
                }
                case "task": {
                    String type;
                    switch (type = jsonObject.getString("type")) {
                        case "addBiz": 
                        case "assignBiz": {
                            this.outerTaskTransmitAcceptService.execute(jsonObject, fileMap, dbFile, type);
                            break block6;
                        }
                        case "pushTaskData": {
                            this.outerTaskTransmitAcceptService.execute(jsonObject, fileMap, dbFile, type);
                            break block6;
                        }
                        case "updateGroup": {
                            AppConfigDTO appconfig = (AppConfigDTO)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("appconfig"), AppConfigDTO.class);
                            String sys = jsonObject.getString("sys");
                            this.tbtskFieldsService.saveAppConfigByTaskId(appconfig, sys);
                            TskTaskBiz task = this.tskTaskBizService.findByTableId(appconfig.getBizId());
                            task.setStructDbUrl(null);
                            this.tskTaskBizService.save(task);
                            break block6;
                        }
                        case "updateField": {
                            TbtskFields field = (TbtskFields)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("tbtskFields"), TbtskFields.class);
                            this.templateService.saveField(field);
                            TskTaskBiz task = this.tskTaskBizService.findByTableId(field.getfTableid());
                            task.setStructDbUrl(null);
                            this.tskTaskBizService.save(task);
                            break block6;
                        }
                        case "deleteTBData": {
                            String taskId = jsonObject.getString("taskId");
                            String dataIds = jsonObject.getString("dataIds");
                            TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
                            if (taskBiz == null) break;
                            this.tskTaskBizService.deleteBatchByDataId(dataIds, taskId);
                            TbtskObjectinfo tableInfo = this.tskTaskBizService.getTableByTableId(taskBiz.getTableId());
                            if (!StringUtils.isNotBlank((CharSequence)tableInfo.getfTablename())) break;
                            Integer count = this.dataBizService.getCount(tableInfo.getfTablename(), "");
                            taskBiz.setTotal(count);
                            this.tskTaskBizService.update(taskBiz);
                        }
                    }
                    throw new GwValidateException("\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
                case "taskClass": {
                    String type;
                    switch (type = jsonObject.getString("type")) {
                        case "insert": 
                        case "update": {
                            TbtskTaskClass tbtskTaskClass = (TbtskTaskClass)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("TbtskTaskClass"), TbtskTaskClass.class);
                            TbtskTaskClass save = (TbtskTaskClass)this.tbtskTaskClassRepository.save((Object)tbtskTaskClass);
                            this.tbtskTaskClassRepository.updateIdById(tbtskTaskClass.getId(), save.getId());
                            break block6;
                        }
                        case "delete": {
                            String id = jsonObject.getString("id");
                            TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(Long.valueOf(Long.parseLong(id)));
                            if (tbtskTaskClass == null) {
                                throw new RuntimeException("\u8be5\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
                            }
                            this.tbtskTaskClassRepository.deleteById(Long.valueOf(Long.parseLong(id)));
                            break block6;
                        }
                    }
                    throw new GwValidateException("\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
                default: {
                    throw new GwValidateException("\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
    }

    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("tran-%s-%s-%s.zip", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }
}

