/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanContentMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeServiceMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanTaskMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolProgramMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanArea;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanContent;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScope;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeService;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanTask;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolProgram;
import com.gw.base.data.GwValidateException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OuterProgramTransmitAcceptService {
    private static final Logger log = LoggerFactory.getLogger(OuterProgramTransmitAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaMapper;
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;

    public void execute(JSONObject jsonObject) {
        try {
            this.handPatrolData(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handPatrolData(JSONObject jsonObject) throws Exception {
        String type;
        switch (type = jsonObject.getString("type")) {
            case "insert": {
                JSONArray objects;
                if (jsonObject.getJSONObject("patrolPlan") != null) {
                    PatrolPlan patrolPlan = (PatrolPlan)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                    this.patrolPlanMapper.gwDeleteByPK((Serializable)((Object)patrolPlan.getfId()));
                    this.patrolPlanMapper.insert((Object)patrolPlan);
                }
                if (jsonObject.getJSONObject("PatrolProgram") != null) {
                    PatrolProgram patrolProgram = (PatrolProgram)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("PatrolProgram"), PatrolProgram.class);
                    this.patrolProgramMapper.gwDeleteByPK((Serializable)((Object)patrolProgram.getfId()));
                    this.patrolProgramMapper.insert((Object)patrolProgram);
                }
                if (jsonObject.getJSONArray("patrolPlanArea") != null && !(objects = jsonObject.getJSONArray("patrolPlanArea")).isEmpty()) {
                    List patrolPlanAreas = objects.toJavaList(PatrolPlanArea.class);
                    this.patrolPlanAreaMapper.deleteByPlanId(((PatrolPlanArea)patrolPlanAreas.get(0)).getfPlanid());
                    for (Object p : patrolPlanAreas) {
                        this.patrolPlanAreaMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanAreaMapper.insertSelective(p);
                    }
                }
                if (jsonObject.getJSONArray("patrolPlanTask") != null && !(objects = jsonObject.getJSONArray("patrolPlanTask")).isEmpty()) {
                    List patrolPlanTasks = objects.toJavaList(PatrolPlanTask.class);
                    this.patrolPlanTaskMapper.deleteByPlanId(((PatrolPlanTask)patrolPlanTasks.get(0)).getfPlanid());
                    for (Object p : patrolPlanTasks) {
                        this.patrolPlanTaskMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanTaskMapper.insertSelective(p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanScope") != null && !(objects = jsonObject.getJSONArray("PatrolPlanScope")).isEmpty()) {
                    List patrolPlanScopes = objects.toJavaList(PatrolPlanScope.class);
                    Iterator ids = patrolPlanScopes.stream().map(PatrolPlanScope::getfId).collect(Collectors.toList());
                    this.patrolPlanScopeMapper.deleteByIds(ids);
                    for (PatrolPlanScope p : patrolPlanScopes) {
                        this.patrolPlanScopeMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanScopeMapper.insertSelective((Object)p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanContent") != null && !(objects = jsonObject.getJSONArray("PatrolPlanContent")).isEmpty()) {
                    List patrolPlanContents = objects.toJavaList(PatrolPlanContent.class);
                    this.patrolPlanContentMapper.deleteByPlanId(((PatrolPlanContent)patrolPlanContents.get(0)).getfPlanid());
                    this.patrolPlanContentMapper.insertList(patrolPlanContents);
                    for (Object p : patrolPlanContents) {
                        this.patrolPlanContentMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanContentMapper.insertSelective(p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanScopeService") == null || (objects = jsonObject.getJSONArray("PatrolPlanScopeService")).isEmpty()) break;
                List patrolPlanScopeServices = objects.toJavaList(PatrolPlanScopeService.class);
                this.patrolPlanScopeServiceMapper.deleteByPlanId(((PatrolPlanScopeService)patrolPlanScopeServices.get(0)).getfPlanid());
                for (Object p : patrolPlanScopeServices) {
                    this.patrolPlanScopeServiceMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                    this.patrolPlanScopeServiceMapper.insertSelective(p);
                }
                break;
            }
            case "update": {
                JSONArray objects;
                String planId = "";
                if (jsonObject.get((Object)"patrolPlan") != null) {
                    PatrolPlan patrolPlan = (PatrolPlan)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                    planId = patrolPlan.getfId();
                    this.patrolPlanMapper.deleteByPrimaryKey((Object)patrolPlan.getfId());
                    this.patrolPlanMapper.insert((Object)patrolPlan);
                }
                if (jsonObject.getJSONObject("PatrolProgram") != null) {
                    PatrolProgram patrolProgram = (PatrolProgram)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("PatrolProgram"), PatrolProgram.class);
                    this.patrolProgramMapper.gwDeleteByPK((Serializable)((Object)patrolProgram.getfId()));
                    this.patrolProgramMapper.insert((Object)patrolProgram);
                }
                if (jsonObject.getJSONArray("patrolPlanArea") != null && !(objects = jsonObject.getJSONArray("patrolPlanArea")).isEmpty()) {
                    List patrolPlanAreas = objects.toJavaList(PatrolPlanArea.class);
                    this.patrolPlanAreaMapper.deleteByPlanId(planId);
                    for (PatrolPlanArea p : patrolPlanAreas) {
                        this.patrolPlanAreaMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanAreaMapper.insertSelective((Object)p);
                    }
                }
                if (jsonObject.getJSONArray("patrolPlanTask") != null && !(objects = jsonObject.getJSONArray("patrolPlanTask")).isEmpty()) {
                    List patrolPlanTasks = objects.toJavaList(PatrolPlanTask.class);
                    if (StringUtils.isNotBlank((CharSequence)planId)) {
                        this.patrolPlanTaskMapper.deleteByPlanId(planId);
                    }
                    for (PatrolPlanArea p : patrolPlanTasks) {
                        this.patrolPlanTaskMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanTaskMapper.insertSelective((Object)p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanContent") != null && !(objects = jsonObject.getJSONArray("PatrolPlanContent")).isEmpty()) {
                    List patrolPlanContents = objects.toJavaList(PatrolPlanContent.class);
                    if (StringUtils.isNotBlank((CharSequence)planId)) {
                        this.patrolPlanContentMapper.deleteByPlanId(planId);
                    }
                    for (PatrolPlanArea p : patrolPlanContents) {
                        this.patrolPlanContentMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanContentMapper.insertSelective((Object)p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanScope") != null && !(objects = jsonObject.getJSONArray("PatrolPlanScope")).isEmpty()) {
                    List scopeByFPlanid;
                    List patrolPlanScopes = objects.toJavaList(PatrolPlanScope.class);
                    if (StringUtils.isNotBlank((CharSequence)planId) && !(scopeByFPlanid = this.patrolPlanScopeServiceMapper.queryByPlanId(planId)).isEmpty()) {
                        this.patrolPlanScopeMapper.deleteByIds(scopeByFPlanid);
                    }
                    for (PatrolPlanArea p : patrolPlanScopes) {
                        this.patrolPlanScopeMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                        this.patrolPlanScopeMapper.insertSelective((Object)p);
                    }
                }
                if (jsonObject.getJSONArray("PatrolPlanScopeService") == null || (objects = jsonObject.getJSONArray("PatrolPlanScopeService")).isEmpty()) break;
                List patrolPlanScopeServices = objects.toJavaList(PatrolPlanScopeService.class);
                if (StringUtils.isNotBlank((CharSequence)planId)) {
                    this.patrolPlanScopeServiceMapper.deleteByPlanId(planId);
                }
                for (PatrolPlanArea p : patrolPlanScopeServices) {
                    this.patrolPlanScopeServiceMapper.gwDeleteByPK((Serializable)((Object)p.getfId()));
                    this.patrolPlanScopeServiceMapper.insertSelective((Object)p);
                }
                break;
            }
            case "delete": {
                if (jsonObject.get((Object)"planId") == null) break;
                String planId = jsonObject.getString("planId");
                this.patrolPlanMapper.deleteByPrimaryKey((Object)planId);
                this.patrolPlanAreaMapper.deleteByPlanId(planId);
                this.patrolPlanTaskMapper.deleteByPlanId(planId);
                this.patrolPlanContentMapper.deleteByPlanId(planId);
                List scopeByFPlanid = this.patrolPlanScopeServiceMapper.queryByPlanId(planId);
                if (!scopeByFPlanid.isEmpty()) {
                    this.patrolPlanScopeMapper.deleteByIds(scopeByFPlanid);
                }
                this.patrolPlanScopeServiceMapper.deleteByPlanId(planId);
                break;
            }
            case "revoke": {
                if (jsonObject.getJSONObject("patrolPlan") == null) break;
                PatrolPlan patrolPlan = (PatrolPlan)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                this.patrolPlanMapper.deleteByPrimaryKey((Object)patrolPlan.getfId());
                this.patrolPlanMapper.insert((Object)patrolPlan);
                this.patrolPlanTaskMapper.deleteByPlanId(patrolPlan.getfId());
                break;
            }
            default: {
                throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
            }
        }
    }
}

