/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.dao.task.TbtskRevokeRecordDao;
import com.geoway.landteam.customtask.dao.task.TbtskSubmitReportRecordDao;
import com.geoway.landteam.customtask.dao.task.TbtskSyncRecordDao;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskSyncRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterTaskTransmitDataService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OuterTaskDataSyncService {
    private static final Logger log = LoggerFactory.getLogger(OuterTaskDataSyncService.class);
    private GiLoger logger = GwLoger.getLoger(OuterTaskTransmitDataService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskAssignJobService taskAssignJobService;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    TemporarySignedUrlService temporarySignedUrlService;
    @Resource
    AppMediaRepository appMediaRepository;
    @Resource
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Resource
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Resource
    TbtskRevokeRecordDao tbtskRevokeRecordDao;
    @Resource
    TbtskSubmitReportRecordDao tbtskSubmitReportRecordDao;
    @Autowired
    TbtskSyncRecordDao tbtskSyncRecordDao;
    @Autowired
    MDataBizService dataBizService;

    public void doWork(String taskId, List<TbtskSyncRecord> list) throws Exception {
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = this.tskTaskBizService.getTableByTableId(task.getTableId());
        List dataIds = list.stream().filter(r -> r.getDataId() != null).map(r -> r.getDataId()).collect(Collectors.toList());
        String sql = "select * from " + table.getfTablename() + " where  f_id  in('" + StringUtils.join((Object[])dataIds.toArray(), (String)"','") + "')";
        List<Map> tempList = this.dataBizService.queryDataBySql(sql);
        try {
            String childsql;
            List<Map> childList;
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            Set set = this.taskAssignJobService.insertData(tempList, statement, table, "2");
            ArrayList<Object> allDataIds = new ArrayList<Object>();
            allDataIds.addAll(dataIds);
            if (StringUtils.isNotBlank((CharSequence)table.getSplitTableName()) && this.dataBizService.isExistTableName(table.getSplitTableName()) && (childList = this.dataBizService.queryDataBySql(childsql = "select f_id from " + table.getSplitTableName() + " where f_splitedid  in('" + StringUtils.join((Object[])dataIds.toArray(), (String)"','") + "')")).size() > 0) {
                for (Map mapdata : childList) {
                    String f_id = MapUtils.getString((Map)mapdata, (Object)"f_id");
                    allDataIds.add(f_id);
                }
            }
            List listMedia = this.appMediaRepository.queryByGalleryids(allDataIds);
            ArrayList<AppMedia> mediaList = new ArrayList<AppMedia>();
            for (int i = 0; i < listMedia.size(); ++i) {
                String accessUrl = "";
                if (((AppMedia)listMedia.get(i)).getServerpath() != null && !((AppMedia)listMedia.get(i)).getServerpath().contains("AccessKeyId")) {
                    accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", ((AppMedia)listMedia.get(i)).getServerpath(), null);
                }
                String fiename = ((AppMedia)listMedia.get(i)).getServerpath().substring(((AppMedia)listMedia.get(i)).getServerpath().lastIndexOf("/") + 1, ((AppMedia)listMedia.get(i)).getServerpath().length());
                String path = tempFolderPath + File.separator + fiename;
                File lsFile = new File(path);
                if (!lsFile.exists()) {
                    FileUtils.copyURLToFile((URL)new URL(accessUrl), (File)lsFile);
                }
                mediaList.add((AppMedia)listMedia.get(i));
            }
            TaskUtils.createMdeiaStruct(mediaList, statement);
            JSONObject jsonObject = new JSONObject();
            List tbtskApproveRecords = this.tbtskApproveRecordRepository.findApproveRecordOrderByIds(taskId, dataIds);
            jsonObject.put("TbtskApproveRecords", (Object)JSONObject.toJSONString((Object)tbtskApproveRecords, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            List tbtskRejectRecords = this.tbtskRejectRecordRepository.findByTaskIdAndTbIds(taskId, dataIds);
            jsonObject.put("TbtskRejectRecords", (Object)JSONObject.toJSONString((Object)tbtskRejectRecords, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            List tbtskRevokeRecords = this.tbtskRevokeRecordDao.selectByTaskIdAndTbIds(taskId, dataIds);
            jsonObject.put("TbtskRevokeRecords", (Object)JSONObject.toJSONString((Object)tbtskRevokeRecords, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            List tbtskSubmitReportRecords = this.tbtskSubmitReportRecordDao.queryByDataids(taskId, dataIds);
            jsonObject.put("TbtskSubmitReportRecords", (Object)JSONObject.toJSONString((Object)tbtskSubmitReportRecords, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            jsonObject.put("mode", (Object)"3");
            jsonObject.put("group", (Object)"task");
            jsonObject.put("userId", (Object)101);
            jsonObject.put("taskId", (Object)taskId);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = task.getName() + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            String url = this.afterExport(101L, tempFolderPath, safeFileName, fileNameNoSuffix);
            HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }
}

