/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OuterTaskTransmitDataService {
    private GiLoger logger = GwLoger.getLoger(OuterTaskTransmitDataService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Resource
    ProducerService producerService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskAssignJobService taskAssignJobService;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    TemporarySignedUrlService temporarySignedUrlService;
    @Resource
    AppMediaRepository appMediaRepository;

    public void doWork(List<Map<String, Object>> datas, String bizId, List<AppMedia> listMedia, Long userId) throws Exception {
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(bizId);
        try {
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            ArrayList list = new ArrayList();
            datas.forEach(a -> list.add(a));
            Set set = this.taskAssignJobService.insertData(list, statement, table, "2");
            ArrayList<AppMedia> mediaList = new ArrayList<AppMedia>();
            for (int i = 0; i < listMedia.size(); ++i) {
                AppMedia one = this.appMediaRepository.findById((Object)listMedia.get(i).getId()).orElse(null);
                if (one != null) continue;
                String accessUrl = "";
                if (listMedia.get(i).getServerpath() != null && !listMedia.get(i).getServerpath().contains("AccessKeyId")) {
                    accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", listMedia.get(i).getServerpath(), null);
                }
                String fiename = listMedia.get(i).getServerpath().substring(listMedia.get(i).getServerpath().lastIndexOf("/") + 1, listMedia.get(i).getServerpath().length());
                String path = tempFolderPath + File.separator + fiename;
                File lsFile = new File(path);
                if (!lsFile.exists()) {
                    FileUtils.copyURLToFile((URL)new URL(accessUrl), (File)lsFile);
                }
                mediaList.add(listMedia.get(i));
            }
            TaskUtils.createMdeiaStruct(mediaList, statement);
            tool.closeAll(conn, statement, null);
            String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
            File file = new File(jsonPath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mode", (Object)"3");
            jsonObject.put("group", (Object)"task");
            jsonObject.put("userId", (Object)userId);
            jsonObject.put("taskId", (Object)bizId);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            ((Writer)write).flush();
            ((Writer)write).close();
            String safeFileName = task.getName() + UuidUtil.get16UUID();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            String url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
            HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e) {
            this.logger.error("\u5916\u7f51\u63a8\u9001\u4efb\u52a1\u6570\u636e\u5305\u5230\u5185\u7f51\u5931\u8d25" + ExceptionUtil.getErrorString(e), new Object[0]);
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        url = this.uploadFileToCloudDisk(userId, safeFileName);
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

    public void publishTranMsg(String url) {
        try {
            String queueName = "Shandong-Outer-Tran";
            this.logger.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + url, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ActiveMQConstant.SERVICE_NAME, "OUTER-RECEIVE-MESSAGE");
            map.put("appkey", PropertyUtil.getProperty((String)"tran.appkey"));
            map.put("module", PropertyUtil.getProperty((String)"tran.module"));
            map.put("name", "\u6d4b\u8bd5");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "OUTER-RECEIVE-MESSAGE");
            this.producerService.sendMapMessage2Queue(map, queueName);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
        }
    }
}

