/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TranFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.jms.BytesMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OuterTaskTransmitService {
    private static final Logger log = LoggerFactory.getLogger(OuterTaskTransmitService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Resource
    DataBizService dataBizService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskRecordService taskRecordService;

    public void execute(BytesMessage bytesMessage) {
        try {
            String fileName = bytesMessage.getStringProperty("FileName");
            FileOutputStream out = new FileOutputStream(this.uploadDir + "/" + fileName);
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = bytesMessage.readBytes(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
            File zipFile = new File(this.uploadDir + "/" + fileName);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"");
            File file = new File(unzipFileDir);
            File dbFile = null;
            File jsonFile = null;
            File[] content = file.listFiles();
            int ln = content.length;
            for (int j = 0; j < ln; ++j) {
                if (content[j].getName().endsWith(".json")) {
                    jsonFile = content[j];
                }
                if (!content[j].getName().endsWith(".db")) continue;
                dbFile = content[j];
            }
            String jsonContext = TranFileUtil.readFile(jsonFile.getAbsolutePath());
            JSONObject jsonObject = JSONObject.parseObject((String)jsonContext);
            String taskId = jsonObject.getString("taskId");
            String mode = jsonObject.getString("mode");
            Long userId = jsonObject.getLong("userId");
            List userIds = jsonObject.getJSONArray("assignUserIds").toJavaList(String.class);
            List tbIds = jsonObject.getJSONArray("tbIds").toJavaList(String.class);
            TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
            if ("1".equals(mode)) {
                if (task == null) {
                    this.handDbFile(dbFile, true);
                } else {
                    this.handDbFile(dbFile, false);
                }
            }
            this.assignTask(userId, task, userIds, tbIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handDbFile(File dbFile, Boolean isCreate) {
        try {
            SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            String taskId = "";
            String tableName = "";
            String sql = "select * from task_biz";
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                taskId = rs.getString("f_id");
                if (!isCreate.booleanValue()) continue;
                int rowSize = metaData.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rowSize; ++i) {
                    String labelName = metaData.getColumnName(i);
                    Object obj = rs.getObject(labelName);
                    map.put(labelName, obj);
                }
                map.put("f_source", "\u5185\u7f51\u4efb\u52a1");
                this.dataBizService.insertData("tbtsk_task_biz", map, null);
            }
            String objectSql = "select * from task_biz";
            ResultSet objectRs = statement.executeQuery(objectSql);
            ResultSetMetaData objectmetaData = objectRs.getMetaData();
            while (objectRs.next()) {
                tableName = objectRs.getString("f_tablename");
                if (!isCreate.booleanValue()) continue;
                int rowSize = objectmetaData.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rowSize; ++i) {
                    String labelName = objectmetaData.getColumnName(i);
                    Object obj = objectRs.getObject(labelName);
                    map.put(labelName, obj);
                }
                this.dataBizService.insertData("tbtsk_objectinfo", map, null);
            }
            if (isCreate.booleanValue()) {
                String fieldSql = "select * from task_biz";
                ResultSet fieldRs = statement.executeQuery(fieldSql);
                ResultSetMetaData fieldmetaData = fieldRs.getMetaData();
                ArrayList fieldlist = new ArrayList();
                while (fieldRs.next()) {
                    int rowSize = fieldmetaData.getColumnCount();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (int i = 1; i <= rowSize; ++i) {
                        String labelName = fieldmetaData.getColumnName(i);
                        Object obj = fieldRs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    fieldlist.add(map);
                }
                this.dataBizService.insertDatasBatch("tbtsk_fields", fieldlist, null);
                String groupSql = "select * from task_biz";
                ResultSet groupRs = statement.executeQuery(groupSql);
                ResultSetMetaData groupmetaData = groupRs.getMetaData();
                ArrayList grouplist = new ArrayList();
                while (groupRs.next()) {
                    int rowSize = groupmetaData.getColumnCount();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (int i = 1; i <= rowSize; ++i) {
                        String labelName = groupmetaData.getColumnName(i);
                        Object obj = groupRs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    grouplist.add(map);
                }
                this.dataBizService.insertDatasBatch("tbtsk_group", grouplist, null);
                TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
                this.tskTaskBizService.createTable(tskTaskBiz, table);
            }
            String dataSql = "select * from " + tableName;
            ResultSet dataRs = statement.executeQuery(dataSql);
            ResultSetMetaData datametaData = dataRs.getMetaData();
            ArrayList datalist = new ArrayList();
            while (dataRs.next()) {
                String f_id = dataRs.getString("f_id");
                Map mapdata = this.dataBizService.selectByID(tableName, "f_id", "'" + f_id + "'");
                int rowSize = datametaData.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rowSize; ++i) {
                    String labelName = datametaData.getColumnName(i);
                    Object obj = dataRs.getObject(labelName);
                    map.put(labelName, obj);
                }
                if (mapdata == null) {
                    this.dataBizService.insertDatasBatch(tableName, datalist, "f_shape");
                    continue;
                }
                this.dataBizService.updateData(tableName, map, " f_id = '" + f_id + "'");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void assignTask(Long userId, TskTaskBiz tskTaskBiz, List<String> userIds, List<String> tbIds) {
        String recordId = UUID.randomUUID().toString();
        List<String> list = tbIds;
        JSONObject additionJson = new JSONObject();
        additionJson.put("count", (Object)tbIds.size());
        additionJson.put("addOrUpdate", (Object)"UPDATE");
        additionJson.put("taskMode", (Object)tskTaskBiz.getMode());
        additionJson.put("curMode", (Object)"assign");
        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(null);
        parameter.setTaskId(tskTaskBiz.getId());
        JSONArray array = new JSONArray();
        for (String s : userIds) {
            array.add((Object)Integer.parseInt(s));
        }
        parameter.setOrgs(array);
        parameter.setUserId(userId);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"checkFilter");
        params.put("userId", (Object)userId);
        params.put("TaskDataDbParameter", (Object)parameter);
        params.put("taskId", (Object)tskTaskBiz.getId());
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
        ArrayList<TaskRecordTemp> tempList = new ArrayList<TaskRecordTemp>();
        for (int i = 0; i < list.size(); ++i) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }
        this.taskRecordService.saveTaskRecordTemp(tempList);
    }
}

