/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import javax.jms.MapMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OuterTxtShpResolverAdapterConsumer
implements IConsumerStrategyService {
    GiLoger logger = GwLoger.getLoger(OuterTxtShpResolverAdapterConsumer.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Override
    public String getCode() {
        return "OUTER-TXT-DOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MapMessage mapMessage) {
        String messageId = "";
        try {
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if (StringUtils.isNotBlank((CharSequence)storageType)) {
                String objectStorag;
                if ("0".equals(storageType.trim())) {
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) {
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];
                    recvFile = this.buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile((InputStream)FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), (File)recvFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim()) && StringUtils.isNotBlank((CharSequence)(objectStorag = mapMessage.getString("objectStorage")))) {
                    URL url = new URL(objectStorag);
                    HttpURLConnection conn = null;
                    if (url != null) {
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(3000);
                        conn.setRequestProperty("Charset", "UTF-8");
                        recvFile = this.buildTempUploadFile();
                        FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)recvFile);
                    }
                    conn.disconnect();
                }
            }
            this.resove(recvFile);
            FileUtils.deleteQuietly(recvFile);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                try {
                    JSONObject e = HttpUtil.sendRequestById(messageId, this.transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex) {
                    this.logger.error("\u7f51\u95f4\u4f20\u8f93\u56de\u8c03\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("downtxt-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }

    public static JSONObject readMeta(File file) throws Exception {
        InputStreamReader read;
        StringBuilder sb = new StringBuilder();
        String encoding = "UTF-8";
        if (file.isFile() && file.exists()) {
            read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                sb.append(lineTxt);
            }
        } else {
            throw new Exception("\u627e\u4e0d\u5230\u6307\u5b9a\u7684mate\u6587\u4ef6");
        }
        read.close();
        String meta = sb.toString();
        return JSONObject.parseObject((String)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resove(File recvFile) throws Exception {
        DataDownloadRecord record;
        File metaFile;
        String zipFile;
        File zip;
        String unzipFileDir;
        block5: {
            unzipFileDir = null;
            zip = null;
            String zipName = recvFile.getAbsolutePath();
            unzipFileDir = this.uploadDir + File.separator + UuidUtil.get16UUID();
            zipFile = unzipFileDir + ".zip";
            FileUtil.creatDirectoryIfNotExist((String)unzipFileDir);
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"", (Boolean)true);
            File file = new File(unzipFileDir);
            File[] contents = file.listFiles();
            metaFile = Arrays.stream(contents).filter(f -> f.getName().endsWith("config.json")).findFirst().orElseThrow(() -> new RuntimeException("\u7f3a\u5c11\u5143\u6570\u636e"));
            JSONObject meta = OuterTxtShpResolverAdapterConsumer.readMeta(metaFile);
            String id = meta.getString("id");
            record = this.dataDownloadRecordService.findeOne(id);
            if (record != null) break block5;
            FileUtils.deleteQuietly((File)new File(unzipFileDir));
            FileUtils.deleteQuietly(zip);
            return;
        }
        try {
            FileUtils.deleteQuietly((File)metaFile);
            Zip4jUtils.zip((String)unzipFileDir, (String)zipFile, (String)"");
            zip = new File(zipFile);
            record.setState(DataDownloadStateEnum.FINISTHE);
            String sendObject = "/dailyTask/download/txt/" + record.getUserId() + "/" + zip.getName();
            String url = this.ossOperatorService.sendObject2Oss(sendObject, zip);
            record.setUrl(url);
            record.setEndTime(new Date());
            this.dataDownloadRecordService.update(record);
        }
        catch (Exception ex) {
            try {
                this.logger.error("\u5916\u7f51\u63a5\u6536txt\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly((File)new File(unzipFileDir));
                FileUtils.deleteQuietly(zip);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)new File(unzipFileDir));
            FileUtils.deleteQuietly(zip);
        }
        FileUtils.deleteQuietly((File)new File(unzipFileDir));
        FileUtils.deleteQuietly((File)zip);
    }
}

