/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OuterUserTrackTranService {
    private static final Logger log = LoggerFactory.getLogger(OuterUserTrackTranService.class);
    private GiLoger logger = GwLoger.getLoger(OuterUserTrackTranService.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.task.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.task.module:}")
    String transmitModule;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    ProducerService producerService;

    public void syscUserTrack(Long userId, MultipartFile fileOfDB) throws IOException {
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
        FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
        String fileName = UUID.randomUUID().toString() + ".db";
        File tempUploadFile = new File(tempFolderPath + File.separator + fileName);
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        String jsonPath = tempFolderPath + File.separator + UUID.randomUUID().toString() + ".json";
        File file = new File(jsonPath);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"userTrack");
        jsonObject.put("group", (Object)"userTrack");
        jsonObject.put("userId", (Object)userId);
        jsonObject.put("taskName", (Object)"\u52a8\u6001\u5de1\u67e5");
        OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        write.write(jsonObject.toJSONString());
        ((Writer)write).flush();
        ((Writer)write).close();
        String safeFileName = "\u52a8\u6001\u5de1\u67e5" + UuidUtil.get16UUID();
        String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
        String url = this.afterExport(userId, tempFolderPath, safeFileName, fileNameNoSuffix);
        HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
        FileUtils.deleteQuietly((File)new File(tempFolderPath));
        FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
    }

    public void publishTranMsg(String url) {
        try {
            String queueName = "SC-Inner-UserTrackTran";
            this.logger.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + url, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ActiveMQConstant.SERVICE_NAME, "USERTRACKTRAN-RECEIVE-MESSAGE");
            map.put("appkey", PropertyUtil.getProperty((String)"transmit.appkey"));
            map.put("module", PropertyUtil.getProperty((String)"transmit.module"));
            map.put("name", "\u6d4b\u8bd5");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "USERTRACKTRAN-RECEIVE-MESSAGE");
            this.producerService.sendMapMessage2Queue(map, queueName);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
        }
    }

    public String afterExport(Long userId, String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url = "";
        this.logger.info(" \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        return url;
    }

    public String uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "patrolTaskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }
}

