/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskUserTaskClass;
import com.geoway.landteam.customtask.task.entity.User2Biz;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleInfo;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UisApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.SyncUserInfo;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.google.common.collect.Lists;
import com.gw.base.data.GwValidateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class OuterUserTranAcceptService {
    private static final Logger log = LoggerFactory.getLogger(OuterUserTranAcceptService.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Resource
    LandRegUserRepository landRegUserRepository;
    @Resource
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;
    @Resource
    LandUserRepository landUserDao;
    @Resource
    LandUserService userService;
    @Resource
    TskRightAreaRepository tskRightAreaRepository;
    @Resource
    UserRoleInfoRepository userRoleInfoDao;
    @Resource
    UserApplicationRepository userApplicationDao;
    @Resource
    User2BizRepository userBiz2Dao;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    @Resource
    Organization2UserRepository organization2UserDao;
    @Resource
    UserCloudAreaRepository userCloudAreaDao;
    @Resource
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Resource
    UisApplicationRepository UisApplicationDao;
    @Resource
    OrganizationRepository organizationRepository;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Autowired
    OauthUserService oauthUserService;

    public void execute_old(JSONObject jsonObject) throws Exception {
        String type = jsonObject.getString("type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "insert": {
                    String[] tempKeys;
                    String config;
                    Organization organization;
                    LandUser landUser = (LandUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), LandUser.class);
                    LandUser landUser1 = (LandUser)this.landUserDao.save((Object)landUser);
                    this.landUserDao.updateUserId(landUser1.getId().longValue(), landUser.getId().longValue());
                    String userRegionCode = jsonObject.getString("userRegionCode");
                    String userRoles = jsonObject.getString("userRoles");
                    String userCloudAreas = jsonObject.getString("userCloudArea");
                    String userCloudQueryConfig = jsonObject.getString("userCloudQueryConfig");
                    Object organizationBean = JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("organization"), Organization.class);
                    String orgId = "";
                    if (organizationBean != null && (organization = (Organization)organizationBean) != null) {
                        Organization organizations = this.organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                        if (organizations == null) {
                            String[] organization1 = (String[])this.organizationRepository.save((Object)organization);
                            orgId = organization1.getId();
                        } else {
                            orgId = organizations.getId();
                        }
                    }
                    Organization2User organization2User = new Organization2User();
                    organization2User.setId(UUID.randomUUID().toString());
                    organization2User.setOrganizationId(orgId);
                    organization2User.setUserId(landUser.getId());
                    this.organization2UserDao.save((Object)organization2User);
                    String[] roles = userRoles.split(",");
                    if (userRoles.indexOf(";") > -1) {
                        roles = userRoles.split(";");
                    }
                    for (String role : roles) {
                        String uid = UUID.randomUUID().toString();
                        UserRoleInfo userRole = new UserRoleInfo();
                        userRole.setId(uid);
                        userRole.setRoleinfoid(role);
                        userRole.setUserid(landUser.getId());
                        this.userRoleInfoDao.save((Object)userRole);
                    }
                    String regionCode = userRegionCode;
                    if (StringUtils.isNotBlank((CharSequence)regionCode)) {
                        LandUser2Area landUser2Area = new LandUser2Area();
                        landUser2Area.setUserId(landUser.getId());
                        landUser2Area.setCreateTime(landUser.getCreateTime());
                        landUser2Area.setState(Integer.valueOf(1));
                        landUser2Area.setRegionCode(regionCode);
                        this.landUser2AreaDao.save((Object)landUser2Area);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)userCloudAreas)) {
                        Object[] cloudAreas = userCloudAreas.split(",");
                        ArrayList cloudList = Lists.newArrayList((Object[])cloudAreas);
                        ArrayList<String[]> userCloudAreaList = new ArrayList<String[]>();
                        for (String cloud : cloudList) {
                            String[] userCloudArea = new UserCloudArea();
                            userCloudArea.setCode(cloud);
                            userCloudArea.setUserId(landUser.getId());
                            userCloudArea.setCreateTime(new Date());
                            userCloudArea.setState(Integer.valueOf(1));
                            userCloudAreaList.add(userCloudArea);
                        }
                        this.userCloudAreaDao.saveAll(userCloudAreaList);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(config = userCloudQueryConfig))) {
                        String[] strs = config.split(",");
                        ArrayList<RoleCloudQueryRel> list = new ArrayList<RoleCloudQueryRel>();
                        for (int i = 0; i < strs.length; ++i) {
                            RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                            ucc.setUid(landUser.getId().toString());
                            ucc.setCid(strs[i].trim());
                            list.add(ucc);
                        }
                        this.roleCloudQueryRelRepository.saveAll(list);
                    }
                    if (jsonObject.get((Object)"userTaskClass") != null) {
                        String userTaskClass = jsonObject.getString("userTaskClass");
                        this.updateUserClass(userTaskClass, landUser.getId());
                    }
                    if (jsonObject.get((Object)"userBiz") != null) {
                        String userBiz = jsonObject.getString("userBiz");
                        this.updateUserBiz(landUser.getId(), userBiz);
                    }
                    String appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
                    String appkeys = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEYS.getKey());
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.add(appkey);
                    for (String tempKey : tempKeys = appkeys.split(",")) {
                        if (keys.indexOf(tempKey) >= 0) continue;
                        keys.add(tempKey);
                    }
                    List appIds = this.UisApplicationDao.getIdByAppKey(keys);
                    for (String key : appIds) {
                        UserApplication userApp = new UserApplication();
                        String uid = UUID.randomUUID().toString();
                        userApp.setId(uid);
                        userApp.setApplicationId(key);
                        userApp.setUserId(landUser.getId());
                        this.userApplicationDao.save((Object)userApp);
                    }
                    break;
                }
                case "update": {
                    Organization organization;
                    LandUser landUser = (LandUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), LandUser.class);
                    LandUser landUser1 = (LandUser)this.landUserDao.save((Object)landUser);
                    this.landUserDao.updateUserId(landUser1.getId().longValue(), landUser.getId().longValue());
                    Object organizationBean = JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("organization"), Organization.class);
                    String orgId = "";
                    if (organizationBean != null && (organization = (Organization)organizationBean) != null) {
                        Organization organizations = this.organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                        if (organizations == null) {
                            Organization organization1 = (Organization)this.organizationRepository.save((Object)organization);
                            orgId = organization1.getId();
                        } else {
                            orgId = organizations.getId();
                        }
                    }
                    this.organization2UserDao.deleteByUserId(landUser.getId());
                    Organization2User organization2User = new Organization2User();
                    organization2User.setId(UUID.randomUUID().toString());
                    organization2User.setOrganizationId(orgId);
                    organization2User.setUserId(landUser.getId());
                    this.organization2UserDao.save((Object)organization2User);
                    String userRegionCode = jsonObject.getString("userRegionCode");
                    Integer count = this.landUser2AreaDao.queryUserAreasIsExists(landUser.getId(), userRegionCode);
                    if (count <= 0) {
                        LandUser2Area landUser2Area = new LandUser2Area();
                        landUser2Area.setUserId(landUser.getId());
                        landUser2Area.setCreateTime(landUser.getCreateTime());
                        landUser2Area.setState(Integer.valueOf(1));
                        landUser2Area.setRegionCode(userRegionCode);
                        this.landUser2AreaDao.save((Object)landUser2Area);
                    }
                    String userRoles = jsonObject.getString("userRoles");
                    this.userRoleInfoDao.deleteByUserId(landUser.getId());
                    String[] roles = userRoles.split(",");
                    if (userRoles.indexOf(";") > -1) {
                        roles = userRoles.split(";");
                    }
                    for (String role : roles) {
                        String uid = UUID.randomUUID().toString();
                        UserRoleInfo userRole = new UserRoleInfo();
                        userRole.setId(uid);
                        userRole.setRoleinfoid(role);
                        userRole.setUserid(landUser.getId());
                        this.userRoleInfoDao.save((Object)userRole);
                    }
                    String userCloudAreas = jsonObject.getString("userCloudArea");
                    this.userCloudAreaDao.delteByUserId(landUser.getId());
                    if (StringUtils.isNotEmpty((CharSequence)userCloudAreas)) {
                        Object[] cloudAreas = userCloudAreas.split(",");
                        ArrayList cloudList = Lists.newArrayList((Object[])cloudAreas);
                        ArrayList<UserCloudArea> userCloudAreaList = new ArrayList<UserCloudArea>();
                        for (String cloud : cloudList) {
                            UserCloudArea userCloudArea = new UserCloudArea();
                            userCloudArea.setCode(cloud);
                            userCloudArea.setUserId(landUser.getId());
                            userCloudArea.setCreateTime(new Date());
                            userCloudArea.setState(Integer.valueOf(1));
                            userCloudAreaList.add(userCloudArea);
                        }
                        this.userCloudAreaDao.saveAll(userCloudAreaList);
                    }
                    String userCloudQueryConfig = jsonObject.getString("userCloudQueryConfig");
                    this.roleCloudQueryRelRepository.deleteByUid(landUser.getId().toString());
                    String config = userCloudQueryConfig;
                    if (StringUtils.isNotBlank((CharSequence)config)) {
                        String[] strs = config.split(",");
                        ArrayList<RoleCloudQueryRel> list = new ArrayList<RoleCloudQueryRel>();
                        for (int i = 0; i < strs.length; ++i) {
                            RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                            ucc.setUid(landUser.getId().toString());
                            ucc.setCid(strs[i].trim());
                            list.add(ucc);
                        }
                        this.roleCloudQueryRelRepository.saveAll(list);
                    }
                    if (jsonObject.get((Object)"userTaskClass") != null) {
                        String userTaskClass = jsonObject.getString("userTaskClass");
                        this.updateUserClass(userTaskClass, landUser.getId());
                    }
                    if (jsonObject.get((Object)"userBiz") == null) break;
                    String userBiz = jsonObject.getString("userBiz");
                    this.updateUserBiz(landUser.getId(), userBiz);
                    break;
                }
                case "updatePassWord": {
                    LandUser landUser = (LandUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), LandUser.class);
                    this.landUserDao.save((Object)landUser);
                    break;
                }
                case "delete": {
                    Long userId = jsonObject.getLongValue("userId");
                    String deleteReason = jsonObject.getString("userRegionCode");
                    LandUser user = this.landUserDao.findById((Object)userId).orElse(null);
                    if (user == null) break;
                    this.userService.deleteUserByLiaison(Long.valueOf(101L), Long.valueOf(userId), deleteReason);
                    this.roleCloudQueryRelRepository.deleteByUid(userId.toString());
                    this.tskRightAreaRepository.deleteByUserId(userId.toString());
                    break;
                }
                case "forbidden": {
                    Long userId = jsonObject.getLongValue("userId");
                    String state = jsonObject.getString("state");
                    this.landUserDao.forbiddenoruserUser(userId, Integer.valueOf(Integer.parseInt(state)));
                    break;
                }
                case "register": {
                    LandRegUser landRegUser = (LandRegUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    this.landRegUserRepository.save((Object)landRegUser);
                    break;
                }
                default: {
                    throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
    }

    public void execute(JSONObject jsonObject) throws Exception {
        this.handData(jsonObject);
    }

    public void updateUserBiz(Long userid, String biz) {
        this.userBiz2Dao.deleteByUserIdLeftTskTaskBiz(userid);
        if (StringUtils.isNotBlank((CharSequence)biz) && !"".equalsIgnoreCase(biz)) {
            List<String> arrays = Arrays.asList(biz.split(","));
            ArrayList<User2Biz> list = new ArrayList<User2Biz>();
            for (int i = 0; i < arrays.size(); ++i) {
                List byBizidAndUserid = this.userBiz2Dao.getByBizidAndUserid(arrays.get(i), userid);
                if (!byBizidAndUserid.isEmpty()) continue;
                User2Biz userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(userid);
                userBiz.setRole(Integer.valueOf(3));
                userBiz.setBizid(arrays.get(i));
                list.add(userBiz);
            }
            this.userBiz2Dao.saveAll(list);
        }
    }

    public void updateUserClass(String userTaskClass, Long userId) {
        this.tbtskUserTaskClassRepository.deleteByUserId(userId);
        if (userTaskClass != null && !"".equalsIgnoreCase(userTaskClass)) {
            String[] classIds = userTaskClass.split(",");
            ArrayList<TbtskUserTaskClass> list = new ArrayList<TbtskUserTaskClass>();
            for (int i = 0; i < classIds.length; ++i) {
                List tbtskUserTaskClasses = this.tbtskUserTaskClassRepository.queryByUserIdAndClassId(userId, Long.valueOf(classIds[i]));
                if (!tbtskUserTaskClasses.isEmpty()) continue;
                TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
                tbtskUserTaskClass.setUserId(userId);
                tbtskUserTaskClass.setCreateDate(new Date());
                tbtskUserTaskClass.setClassId(Long.valueOf(classIds[i]));
                list.add(tbtskUserTaskClass);
            }
            this.tbtskUserTaskClassRepository.saveAll(list);
        }
    }

    public void handData(JSONObject jsonObject) throws Exception {
        String type = jsonObject.getString("type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "insert": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.syncAddBusUser(landUser);
                    break;
                }
                case "update": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.syncUpdateBusUser(landUser);
                    break;
                }
                case "updatePassWord": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.changePasswordByUsername(landUser.getUserName(), landUser.getPassWord());
                }
                case "updatePhoneNumber": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.renewPhoneNum(landUser.getMidUserId(), landUser.getPhone());
                    break;
                }
                case "forbidden": {
                    SyncUserInfo landUser = (SyncUserInfo)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    this.oauthUserService.setUserEnable(landUser.getMidUserId(), landUser.getEnable());
                    break;
                }
                case "register": {
                    LandRegUser landRegUser = (LandRegUser)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    this.landRegUserRepository.save((Object)landRegUser);
                    break;
                }
                default: {
                    throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
    }
}

