/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.oauth;

import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.oauth.OrganizationCertificateResoDto;
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.platform.mgruser.MgrUserRes3Sdk;
import com.geoway.landteam.platform.mgruser.res3user.api.user.MgrUserRes3UserService;
import com.geoway.landteam.platform.mgruser.res3user.api.user.reso.SysUserReso;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.organization.OrganizationRes3UserSdk;
import com.geoway.landteam.platform.organization.res3.api.OrganizationCertificateRes3Service;
import com.geoway.landteam.platform.organization.res3.api.OrganizationSelectRes3Service;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationCertificateReso;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationCertificateSearchReso;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationPager;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationReso;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationSearchReso;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationTypeReso;
import com.geoway.landteam.platform.organization.res3user.api.OrganizationCertificateRes3UserService;
import com.geoway.landteam.platform.organization.res3user.api.OrganizationSelectRes3UserService;
import com.geoway.landteam.platform.organization.res3user.api.em.OrganizationCertificateEnum;
import com.geoway.landteam.platform.organization.res3user.api.ro.MsgRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationCertificateRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationRo;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserSelectRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.gw.base.util.GutilStr;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OatuhOrganizationServiceImpl
implements OauthOrganizationService {
    private OrganizationSelectRes3UserService organizationSelectRes3UserService = OrganizationRes3UserSdk.getOrganizationSelectRes3UserService();
    private OrganizationSelectRes3Service organizationSelectRes3Service = OrganizationRes3Sdk.getOrganizationSelectRes3Service();
    private MgrUserRes3UserService mgrUserRes3UserSdkService = MgrUserRes3Sdk.getMgrUserRes3UserService();
    private OrganizationCertificateRes3UserService organizationCertificateRes3UserService = OrganizationRes3UserSdk.getOrganizationCertificateRes3UserService();
    private OrganizationCertificateRes3Service organizationCertificateRes3Service = OrganizationRes3Sdk.getOrganizationCertificateRes3Service();
    private EpaUserSelectRes3Service epaUserSelectRes3Service = UcsRes3Sdk.getEpaUserSelectRes3Service();
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    RegionRepository regionRepository;

    public List<OrganizationRo> getUserOrganization(String pid, Integer type, String orgRegion, String orgName, AuthUserInfo authUserInfo) {
        List types;
        List organizationTypeResos = this.organizationSelectRes3Service.orgTypeList(false);
        if (organizationTypeResos != null && (types = organizationTypeResos.stream().map(OrganizationTypeReso::getOrgTypeName).collect(Collectors.toList())).contains(pid)) {
            String finalPid = pid;
            type = organizationTypeResos.stream().filter(t -> t.getOrgTypeName().equals(finalPid)).findFirst().get().getOrgTypeCode();
            pid = null;
        }
        ArrayList<OrganizationRo> result = new ArrayList();
        SysUserReso userReso = null;
        try {
            userReso = this.mgrUserRes3UserSdkService.findByMidUserId(authUserInfo.getMidUserId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userReso != null) {
            List organizationResos;
            OrganizationReso organizationReso = this.organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId());
            orgRegion = organizationReso.getRegionCode();
            orgName = null;
            if (orgRegion.endsWith("0000")) {
                orgRegion = null;
            }
            if ((organizationResos = this.organizationSelectRes3Service.searchOrganizationChildrenById(pid, type, orgRegion, orgName)) != null) {
                for (OrganizationReso reso : organizationResos) {
                    OrganizationRo ro = new OrganizationRo();
                    BeanUtils.copyProperties((Object)reso, (Object)ro);
                    result.add(ro);
                }
            }
        } else {
            result = this.organizationSelectRes3UserService.searchOrganizationByPid(pid, type, orgRegion, orgName);
        }
        return result;
    }

    public OrganizationReso getOrganization(String id) {
        return this.organizationSelectRes3Service.searchOrganizationById(id);
    }

    public List<OrganizationTypeReso> getOrganizationTypeList() {
        List organizationTypeResos = this.organizationSelectRes3Service.orgTypeList(false);
        return organizationTypeResos;
    }

    public List<OrganizationReso> getOrganizations(String id, Integer type, String orgRegion, String orgName) {
        return this.organizationSelectRes3Service.searchOrganizationChildrenById(id, type, orgRegion, orgName);
    }

    public String getOrgFullNameById(String id) {
        return this.organizationSelectRes3Service.getOrgFullNameById(id);
    }

    public OrganizationPager OrganizationByCodeAndKeyWord(String orgType, String regionName, String sjsf, String keyWord, int page, int rows) throws Exception {
        RegionVersion defaultVersion;
        String regionCode = GutilStr.isBlank((CharSequence)sjsf) ? ("\u5168\u56fd".equals(regionName) ? "1" : this.regionRepository.getCodeByNameAndVersion(regionName, (defaultVersion = this.regionVersionRepository.getRegionVersionByDefault()) != null ? defaultVersion.getVersion() : "2018")) : sjsf;
        OrganizationSearchReso searchReso = new OrganizationSearchReso();
        searchReso.setRegionCode(regionCode);
        if (StringUtils.isNotBlank((CharSequence)orgType)) {
            searchReso.setOrgTypeCode(Integer.valueOf(Integer.parseInt(orgType)));
        }
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            searchReso.setOrgName(keyWord);
        }
        OrganizationPager pages = this.organizationSelectRes3Service.searchOrganizationPage(searchReso, Integer.valueOf(page), Integer.valueOf(rows));
        return pages;
    }

    public OrganizationPager getLikelyParentOrg(String sjsf, String orgType, String keyWord, int page, int rows) throws Exception {
        OrganizationSearchReso searchReso = new OrganizationSearchReso();
        if (GutilStr.isNotBlank((CharSequence)keyWord)) {
            searchReso.setOrgName(keyWord);
        }
        if (GutilStr.isNotBlank((CharSequence)orgType)) {
            searchReso.setOrgTypeCode(Integer.valueOf(Integer.parseInt(orgType)));
        }
        if ("1".equals(sjsf)) {
            searchReso.setRegionCode("1");
        } else {
            RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
            Region region = this.regionRepository.findByCodeAndVersion(sjsf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
            if (region == null) {
                throw new RuntimeException("\u884c\u653f\u533a\u4ee3\u7801\u6709\u8bef");
            }
            String pCode = region.getPcode();
            if ("-1".equalsIgnoreCase(pCode)) {
                pCode = "1";
            }
            String[] regions = new String[]{sjsf, pCode};
            searchReso.setAndRegionCodeIn(regions);
        }
        OrganizationPager pages = this.organizationSelectRes3Service.searchOrganizationPage(searchReso, Integer.valueOf(page), Integer.valueOf(rows));
        return pages;
    }

    public OrganizationCertificateResoDto submitCertificateFile(AuthUserInfo authUserInfo, String orgId, String typeCertificate, MultipartFile file) throws Exception {
        OrganizationReso organizationReso;
        boolean hasPemission = false;
        if (authUserInfo.getAdminMgr().booleanValue()) {
            hasPemission = true;
        }
        if (authUserInfo.getMgr().booleanValue() && authUserInfo.getOrgId().equals(orgId)) {
            hasPemission = true;
        }
        if ((organizationReso = this.organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId())) != null && organizationReso.getOrgTypeCode().equals(2) && authUserInfo.getMgr().booleanValue()) {
            hasPemission = true;
        }
        if (!hasPemission) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\u4e0a\u4f20\u5355\u4f4d\u8d44\u8d28\u6587\u4ef6");
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (!fileSuffix.toLowerCase().equals("pdf")) {
            throw new Exception("\u5f53\u524d\u6587\u4ef6\u4e0d\u662fpdf\u683c\u5f0f");
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("\u8425\u4e1a\u6267\u7167");
        types.add("\u627f\u8bfa\u4e66");
        types.add("\u6d4b\u7ed8\u8d44\u8d28");
        if (!types.contains(typeCertificate)) {
            throw new Exception("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
        File tempFile = null;
        File folder = null;
        try {
            filename = filename.substring(0, filename.lastIndexOf("."));
            String temp = this.uploadDir + File.separator + UUID.randomUUID().toString();
            folder = new File(temp);
            folder.mkdir();
            temp = temp + File.separator + file.getOriginalFilename();
            tempFile = new File(temp);
            file.transferTo(tempFile);
            OrganizationCertificateRo ro = this.organizationCertificateRes3UserService.submitFile(orgId, typeCertificate, filename, tempFile, fileSuffix);
            OrganizationCertificateResoDto result = new OrganizationCertificateResoDto();
            result.setSubmitUserName(authUserInfo.getUsername());
            BeanUtils.copyProperties((Object)ro, (Object)result);
            OrganizationCertificateResoDto organizationCertificateResoDto = result;
            return organizationCertificateResoDto;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                FileUtils.deleteQuietly((File)tempFile);
            }
            if (folder != null && folder.exists()) {
                FileUtils.deleteQuietly((File)folder);
            }
        }
    }

    public List<OrganizationCertificateResoDto> searchCertificateList(AuthUserInfo authUserInfo, OrganizationCertificateSearchReso searchReso) throws Exception {
        OrganizationReso organizationReso;
        boolean hasPemission = false;
        if (authUserInfo.getAdminMgr().booleanValue()) {
            hasPemission = true;
        }
        if (authUserInfo.getMgr().booleanValue() && authUserInfo.getOrgId().equals(searchReso.getOrgId())) {
            hasPemission = true;
        }
        if ((organizationReso = this.organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId())) != null && organizationReso.getOrgTypeCode().equals(2) && authUserInfo.getMgr().booleanValue()) {
            hasPemission = true;
        }
        if (!hasPemission) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\u67e5\u770b\u5355\u4f4d\u8d44\u8d28\u6587\u4ef6");
        }
        List results = this.organizationCertificateRes3Service.searchList(searchReso);
        if (results == null || results.isEmpty()) {
            return null;
        }
        ArrayList<OrganizationCertificateResoDto> resoDtos = new ArrayList<OrganizationCertificateResoDto>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (OrganizationCertificateReso reso : results) {
            OrganizationCertificateResoDto dto = new OrganizationCertificateResoDto();
            BeanUtils.copyProperties((Object)reso, (Object)dto);
            String username = null;
            if (!map.containsKey(reso.getMidUserCreate())) {
                EpaUserReso epaUserReso = this.epaUserSelectRes3Service.getUserByUserId(reso.getMidUserCreate());
                map.put(reso.getMidUserCreate(), epaUserReso != null ? epaUserReso.getUserName() : "");
            }
            username = (String)map.get(reso.getMidUserCreate());
            dto.setSubmitUserName(username);
            OrganizationCertificateEnum organizationCertificateEnum = OrganizationCertificateEnum.valueOf((String)dto.getTypeCertificate());
            dto.setIndex(Integer.valueOf(organizationCertificateEnum.ordinal()));
            resoDtos.add(dto);
        }
        Collections.sort(resoDtos, (reso1, reso2) -> reso1.getIndex().compareTo(reso2.getIndex()));
        return resoDtos;
    }

    public String getCertificateFileAccessUrl(String fileObjectId) {
        return this.organizationCertificateRes3Service.getFileAccessUrl(fileObjectId);
    }

    public MsgRo deleteCertificate(String certificateId) {
        return this.organizationCertificateRes3UserService.delFile(certificateId);
    }

    public Boolean hasCertificatePermission(AuthUserInfo authUserInfo) {
        OrganizationReso organizationReso;
        boolean hasPemission = false;
        if (authUserInfo.getAdminMgr().booleanValue()) {
            hasPemission = true;
        }
        if (authUserInfo.getMgr().booleanValue()) {
            hasPemission = true;
        }
        if ((organizationReso = this.organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId())) != null && organizationReso.getOrgTypeCode().equals(2) && authUserInfo.getMgr().booleanValue()) {
            hasPemission = true;
        }
        return hasPemission;
    }

    public List<String> getAllChildIds(String orgId) {
        List orgs = this.organizationSelectRes3Service.searchOrganizationChildrenByIdAanLevel(orgId, null, null);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        return orgs.stream().map(OrganizationReso::getOrgId).collect(Collectors.toList());
    }
}

