/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.oauth;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.as.Oauth2Provider;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClientService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.core.AuthorizationGrantType;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2AccessToken;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2RefreshToken;
import com.geoway.landteam.gac.oauth2.mini.util.URLUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.dto.MyRegion;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserSimpleInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.dto.RegUserInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.repository.user.YXUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.SecurityService;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.VertifyServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.oauth.AddUserInfo;
import com.geoway.landteam.landcloud.model.oauth.ApproveUserInfo;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.oauth.BusUserDetailPagerDto;
import com.geoway.landteam.landcloud.model.oauth.BusUserDetailResoDto;
import com.geoway.landteam.landcloud.model.oauth.RegUserDetialDto;
import com.geoway.landteam.landcloud.model.oauth.SyncUserInfo;
import com.geoway.landteam.landcloud.model.oauth.WebRegUserInfo;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.RSA;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.business.res3.api.bususer.BusUserRes3Service;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserAddReso;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserUpdateReso;
import com.geoway.landteam.platform.business.res3.api.orguser.OrgUserSelectRes3Service;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailPager;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserSearchReso;
import com.geoway.landteam.platform.mgruser.MgrUserRes3Sdk;
import com.geoway.landteam.platform.mgruser.res3user.api.user.MgrUserRes3UserService;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.organization.res3.api.OrganizationSelectRes3Service;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationReso;
import com.geoway.landteam.platform.permission.PermissionRes3UserSdk;
import com.geoway.landteam.platform.permission.res3user.api.pmc.Res3UserPermissionService;
import com.geoway.landteam.platform.permission.res3user.api.pmc.ro.RoleResourceDetailRo;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.landteam.platform.ucs.UcsRes3UserSdk;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaRegisterUserRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserRealNameRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserSelectRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserUpdateRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaRealNameAddReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaRealNameReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserAddReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.geoway.landteam.platform.ucs.res3user.api.user.EpaUserSelectRes3UserService;
import com.geoway.landteam.platform.ucs.res3user.api.user.reso.EpaUserInfoReso;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class OauthUserServiceImpl
implements OauthUserService {
    private GiLoger logger = GwLoger.getLoger(OauthUserServiceImpl.class);
    @Autowired
    UserCloudAreaRepository userCloudAreaRepository;
    @Autowired
    RoleCloudQueryRepository roleCloudQueryRepository;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Autowired
    TbsysUserSubjectRelRepository tbsysUserSubjectRelRepository;
    @Autowired
    LandUserService landUserService;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    YXUserRepository yxUserRepository;
    @Autowired
    FriendsServiceImpl friendsService;
    @Autowired
    VertifyServiceImpl vertifyService;
    @Autowired
    SecurityService securityService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    User2BizRepository user2BizRepository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;
    @Autowired
    UserCloudAreaRepository userCloudAreaDao;
    @Autowired
    LandRegUserRepository landRegUserRepository;
    @Autowired
    LandRegUserService regUserService;
    @Autowired
    LandRegUserRepository landRegUserDao;
    @Autowired
    RegionService regionService;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    RegionTownRepository regionTownDao;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    OauthOrganizationService oauthOrganizationService;
    private OrgUserSelectRes3Service orgUserSelectRes3Service = BusinessRes3Sdk.getOrgUserSelectRes3Service();
    private BusUserRes3Service busUserRes3SdkService = BusinessRes3Sdk.getBusUserRes3Service();
    private EpaRegisterUserRes3Service epaRegisterUserRes3Service = UcsRes3Sdk.getEpaRegisterUserRes3Service();
    private EpaUserSelectRes3Service epaUserSelectRes3Service = UcsRes3Sdk.getEpaUserSelectRes3Service();
    private EpaUserRealNameRes3Service epaUserRealNameRes3Service = UcsRes3Sdk.getEpaUserRealNameRes3Service();
    private EpaUserUpdateRes3Service epaUserUpdateRes3Service = UcsRes3Sdk.getEpaUserUpdateRes3Service();
    private EpaUserSelectRes3UserService epaUserSelectRes3UserService = UcsRes3UserSdk.getEpaUserSelectRes3UserService();
    private OrganizationSelectRes3Service organizationSelectRes3Service = OrganizationRes3Sdk.getOrganizationSelectRes3Service();
    private MgrUserRes3UserService mgrUserRes3UserSdkService = MgrUserRes3Sdk.getMgrUserRes3UserService();
    private Res3UserPermissionService res3UserPermissionService = PermissionRes3UserSdk.getPermissionRes3UserService();

    public List<RoleResourceDetailRo> getUserResource() {
        List resource = this.res3UserPermissionService.getServiceResourceListByUser();
        return resource;
    }

    public String getRealName(String busUserId) {
        EpaRealNameReso realNameReso = this.epaUserRealNameRes3Service.searchRealNameByUserId(busUserId);
        return realNameReso != null ? realNameReso.getRealName() : null;
    }

    public EpaUserReso getMidtUser(String midUserId) {
        return this.epaUserSelectRes3Service.getUserByUserId(midUserId);
    }

    public EpaUserReso getMidtUser(Long userId) {
        List subjectRels = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjectRels == null || subjectRels.isEmpty()) {
            return null;
        }
        return this.getMidtUser(((TbsysUserSubjectRel)subjectRels.get(0)).getMidUserId());
    }

    public EpaUserReso getMidtUserByPhone(String phoneNumber) {
        return this.epaUserSelectRes3Service.getUserByUserphone(phoneNumber);
    }

    public BusUserInfoReso getBusUser(String busUserId) {
        return this.busUserRes3SdkService.userInfo(busUserId);
    }

    public BusUserInfoReso getBusUserByPhone(String phoneNumber) {
        return this.busUserRes3SdkService.getUserInfo(null, null, null, phoneNumber);
    }

    public EpaUserReso getMidtUserByUserName(String userName) {
        return this.epaUserSelectRes3Service.getUserByUsername(userName);
    }

    public String getUserpasswordByMidUserId(String midUserId) {
        return this.epaUserSelectRes3Service.getUserpasswordByUserId(midUserId);
    }

    public boolean match(String userName, String password) {
        String passwordMD5;
        EpaUserReso epaUserReso = this.epaUserSelectRes3Service.getUserByUsername(userName);
        if (epaUserReso == null) {
            return false;
        }
        String pwd = this.epaUserSelectRes3Service.getUserpasswordByUserId(epaUserReso.getUserId());
        if (pwd.startsWith("{") && pwd.contains("}")) {
            pwd = pwd.split("}")[1];
        }
        if (!(password.equals(pwd) || (passwordMD5 = Md5Util.calFileMd5ByByte((byte[])password.getBytes())).equals(pwd) || passwordMD5.endsWith(pwd))) {
            BCrypt.Verifyer verifyer = BCrypt.verifyer();
            BCrypt.Result result = verifyer.verify(password.toCharArray(), pwd.toCharArray());
            if (!result.verified) {
                return false;
            }
        }
        return true;
    }

    public BusUserDetailPagerDto listOrganizationAndBusUserPage(BusUserSearchReso searchReso, Integer pageNum, Integer pageSize) {
        BusUserDetailPager pages = this.orgUserSelectRes3Service.listOrganizationAndBusUserPage(searchReso, pageNum, pageSize);
        ArrayList<BusUserDetailResoDto> userDtos = new ArrayList<BusUserDetailResoDto>();
        BusUserDetailPagerDto pageDto = new BusUserDetailPagerDto();
        pageDto.setPageNum(pages.getPageNum());
        pageDto.setPageParam(pages.getPageParam());
        pageDto.setPageSize(pages.getPageSize());
        pageDto.setTotal(pages.getTotal());
        pageDto.setStartRow(pages.getStartRow());
        if (pages.getList() != null) {
            for (BusUserDetailReso user : pages.getList()) {
                BusUserDetailResoDto dto = new BusUserDetailResoDto();
                dto.setBusUserId(user.getBusUserId());
                dto.setEmail(user.getEmail());
                dto.setMidUserId(user.getMidUserId());
                dto.setOrgId(user.getOrgId());
                dto.setOrgName(user.getOrgName());
                dto.setOrgRole(user.getOrgRole());
                dto.setEnable(user.getEnable());
                dto.setOrgRegion(user.getOrgRegion());
                dto.setOrgType(user.getOrgType());
                dto.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
                dto.setRealName(user.getRealName());
                dto.setUserName(user.getUserName());
                dto.setRegionCode(user.getRegionCode());
                dto.setTimeCreate(user.getTimeCreate());
                dto.setTimeExpire(user.getTimeExpire());
                List subjectUser = this.tbsysUserSubjectRelRepository.findByMidUserId(user.getMidUserId());
                if (subjectUser != null && subjectUser.size() > 0) {
                    TbsysUserSubjectRel subjectRel = (TbsysUserSubjectRel)subjectUser.get(0);
                    dto.setUserId(subjectRel.getUserId());
                }
                userDtos.add(dto);
            }
        }
        pageDto.setList(userDtos);
        return pageDto;
    }

    public RegUserDetialDto getRegUserDetial(String id) {
        LandRegUser regUser = this.landRegUserDao.findById((Object)id).orElse(null);
        RegUserDetialDto regUserDetialDto = new RegUserDetialDto();
        regUserDetialDto.setOrgRole(this.getOrgRoleByRoleId(regUser.getRoleIds()));
        regUserDetialDto.setOrgName(regUser.getPostId());
        regUserDetialDto.setOrgId(regUser.getDepNo());
        regUserDetialDto.setPhone(regUser.getPhone());
        regUserDetialDto.setUserName(regUser.getName());
        regUserDetialDto.setRealName(regUser.getRname());
        regUserDetialDto.setRegionCode(regUser.getRegionCode());
        regUserDetialDto.setEmail(regUser.getEmail());
        OrganizationReso org = this.organizationSelectRes3Service.searchOrganizationById(regUser.getDepNo());
        if (org != null) {
            regUserDetialDto.setOrgRegion(org.getRegionCode());
            regUserDetialDto.setOrgType(org.getOrgType());
        }
        ArrayList<UserCloudArea> cloudAreas = new ArrayList<UserCloudArea>();
        UserCloudArea cloudArea = new UserCloudArea();
        cloudArea.setCode(regUser.getRegionCode());
        cloudArea.setCodeName(this.regionService.getName(regUser.getRegionCode()));
        cloudAreas.add(cloudArea);
        regUserDetialDto.setCloudAreas(cloudAreas);
        Map<String, Object> map = this.regionCodeLevel(regUser.getRegionCode());
        String cloudRole = map.get("cloudRole").toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(cloudRole);
        List cloudRoles = this.roleCloudQueryRepository.findByIds(ids);
        regUserDetialDto.setCloudRoles(cloudRoles);
        return regUserDetialDto;
    }

    public void setUserEnable(Long userId, Integer enable) throws Exception {
        List subjectRel = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjectRel == null || subjectRel.isEmpty()) {
            throw new Exception("\u672a\u627e\u5230\u7528\u6237:" + userId + "\u5bf9\u5e94\u7684\u7edf\u4e00\u7528\u6237");
        }
        String midUserId = ((TbsysUserSubjectRel)subjectRel.get(0)).getMidUserId();
        this.busUserRes3SdkService.updateEnable(midUserId, enable);
    }

    public void setUserEnable(String midUserId, Integer enable) {
        this.busUserRes3SdkService.updateEnable(midUserId, enable);
    }

    public SyncUserInfo setUserInfo(Long userId, String orgId, String regionCode, String orgRole, String cloudRoleId, String cloudArea) throws Exception {
        SyncUserInfo syncUserInfo = new SyncUserInfo();
        this.setUserInfo(userId, orgId, regionCode, orgRole, syncUserInfo);
        this.userCloudAreaRepository.delteByUserId(userId);
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(userId);
        userCloudArea.setCode(cloudArea);
        userCloudArea.setState(Integer.valueOf(1));
        userCloudArea.setCreateTime(new Date());
        this.userCloudAreaRepository.save((Object)userCloudArea);
        this.roleCloudQueryRelRepository.deleteByUserId(userId.toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(userId.toString());
        roleCloudQueryRel.setCid(cloudRoleId);
        this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        syncUserInfo.setCloudArea(cloudArea);
        syncUserInfo.setCloudRoleId(cloudRoleId);
        LandUser landUser = this.landUserRepository.queryUserById(userId);
        syncUserInfo.setUserName(landUser.getName());
        return syncUserInfo;
    }

    public void setUserInfo2(Long userId, String phone, String email, String regionCode) throws Exception {
        List subjectRel = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjectRel == null || subjectRel.isEmpty()) {
            throw new Exception("\u672a\u627e\u5230\u7528\u6237:" + userId + "\u5bf9\u5e94\u7684\u4e1a\u52a1\u7528\u6237");
        }
        String busUserId = ((TbsysUserSubjectRel)subjectRel.get(0)).getSubjectUserId();
        if (StringUtils.isNotBlank((CharSequence)phone) || StringUtils.isNotBlank((CharSequence)email)) {
            this.epaUserSelectRes3UserService.updateUserInfo(phone, email, null, null, null, null);
        }
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            BusUserUpdateReso userUpdateReso = new BusUserUpdateReso();
            userUpdateReso.setBusUserId(busUserId);
            userUpdateReso.setRegionCode(regionCode);
            this.busUserRes3SdkService.updateBusUser(userUpdateReso);
        }
    }

    public UserSimpleInfo getUserInfo(Long ownerId, Long userId) throws Exception {
        UserSimpleInfo userSimpleInfo = new UserSimpleInfo();
        List subjects = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjects == null || subjects.isEmpty()) {
            return null;
        }
        EpaUserReso userReso = this.epaUserSelectRes3Service.getUserByUserId(((TbsysUserSubjectRel)subjects.get(0)).getSubjectUserId());
        if (userReso == null) {
            return null;
        }
        EpaRealNameReso realNameReso = this.epaUserRealNameRes3Service.searchRealNameByUserId(((TbsysUserSubjectRel)subjects.get(0)).getSubjectUserId());
        userSimpleInfo.setUserId(userId.longValue());
        userSimpleInfo.setUserRefName(realNameReso == null ? "" : realNameReso.getRealName());
        userSimpleInfo.setPost(userReso.getEmail());
        userSimpleInfo.setPhoneNumber(userReso.getPhoneNumber());
        YXUser yxUser = this.yxUserRepository.findById((Object)userId).orElse(null);
        if (yxUser != null) {
            userSimpleInfo.setAccid(yxUser.getAccid());
        }
        userSimpleInfo.setMyFriend(Boolean.valueOf(this.isMyFriend(ownerId, userId)));
        return userSimpleInfo;
    }

    public boolean isPhoneRegistered(String phone) {
        EpaUserReso userReso = this.epaUserSelectRes3Service.getUserByUserphone(phone);
        return userReso != null;
    }

    public void renewPhoneNum(Long userId, String newPhoneNum, String verifyCode) {
        LandUser landUser = this.landUserService.queryUserById(userId);
        if (landUser == null) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (this.isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
        }
        List curVerty = this.vertifyService.findByFilter(newPhoneNum, verifyCode);
        if (curVerty.size() == 0) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.epaUserSelectRes3UserService.updateUserInfo(newPhoneNum, null, null, null, null, null);
    }

    public void renewPhoneNum(String midUserId, String newPhoneNum) {
    }

    public void changePasswordByUsername(String username, String password, String oldPassword, String pswtip) throws Exception {
        String passwordMD5;
        EpaUserReso userReso = this.epaUserSelectRes3Service.getUserByUsername(username);
        if (userReso == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u5f53\u524d\u7528\u6237\u540d\u672a\u6ce8\u518c!");
        }
        List subjects = this.tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if (subjects == null || subjects.isEmpty()) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        LandUser landUser = this.landUserService.queryUserById(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
        if (landUser == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        String op = this.epaUserSelectRes3Service.getUserpasswordByUserId(userReso.getUserId());
        if (op.startsWith("{") && op.contains("}")) {
            op = op.split("}")[1];
        }
        if (!(oldPassword.equals(op) || (passwordMD5 = Md5Util.calFileMd5ByByte((byte[])oldPassword.getBytes())).equals(op) || passwordMD5.endsWith(op))) {
            BCrypt.Verifyer verifyer = BCrypt.verifyer();
            BCrypt.Result result = verifyer.verify(oldPassword.toCharArray(), (CharSequence)op);
            if (!result.verified) {
                throw new Exception("\u7528\u6237\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
        }
        landUser.setPswtip(pswtip);
        this.landUserService.saveUser(landUser);
        this.epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), password);
        this.securityService.updateToken(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
    }

    public void changePasswordByUsername(String username, String newPassword) throws Exception {
        EpaUserReso userReso = this.epaUserSelectRes3Service.getUserByUsername(username);
        if (userReso == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u5f53\u524d\u7528\u6237\u540d\u672a\u6ce8\u518c!");
        }
        List subjects = this.tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if (subjects == null || subjects.isEmpty()) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        LandUser landUser = this.landUserService.queryUserById(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
        if (landUser == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        this.epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), newPassword);
        this.securityService.updateToken(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
    }

    public void changePasswordByPhone(String phone, String code, String password, String pswtip) throws Exception {
        EpaUserReso userReso = this.epaUserSelectRes3Service.getUserByUserphone(phone);
        if (userReso == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u5f53\u524d\u624b\u673a\u53f7\u672a\u6ce8\u518c!");
        }
        List subjects = this.tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if (subjects == null || subjects.isEmpty()) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        LandUser landUser = this.landUserService.queryUserById(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
        if (landUser == null) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u6620\u5c04\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        List curVerty = this.vertifyService.findByFilter(phone, code);
        if (curVerty.size() == 0) {
            throw new Exception("\u4fee\u6539\u5bc6\u7801\u5931\u8d25,\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e!");
        }
        landUser.setPswtip(pswtip);
        this.landUserService.saveUser(landUser);
        this.epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), password);
        this.securityService.updateToken(((TbsysUserSubjectRel)subjects.get(0)).getUserId());
    }

    public void resetPasswordByAdmin(Long userId, String newPassword) throws Exception {
        List subjectRel = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjectRel == null || subjectRel.isEmpty()) {
            throw new Exception("\u672a\u627e\u5230\u7528\u6237:" + userId + "\u5bf9\u5e94\u7684\u4e1a\u52a1\u7528\u6237");
        }
        String midUserId = ((TbsysUserSubjectRel)subjectRel.get(0)).getMidUserId();
        newPassword = "{MD5}" + newPassword;
        this.epaUserUpdateRes3Service.updateEncryptionPassword(midUserId, newPassword);
    }

    public void registerByWeb(WebRegUserInfo user) throws Exception {
        if (StringUtils.isBlank((CharSequence)user.getOrgRole())) {
            throw new RuntimeException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getRegionCode())) {
            throw new RuntimeException("\u6240\u5728\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getOrgId())) {
            throw new RuntimeException("\u6240\u5728\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getOrgName())) {
            throw new RuntimeException("\u6240\u5728\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getRealName())) {
            throw new RuntimeException("\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EpaUserInfoReso epaUserInfoReso = this.epaUserSelectRes3UserService.getUserInfo();
        LandRegUser newUser = new LandRegUser();
        newUser.setPhone(epaUserInfoReso.getPhoneNumber());
        newUser.setName(epaUserInfoReso.getUserName());
        newUser.setRname(user.getRealName());
        newUser.setSjsf(user.getRegionCode());
        newUser.setRegionCode(user.getRegionCode());
        newUser.setDepName(user.getOrgName());
        newUser.setPostId(user.getOrgName());
        newUser.setDepNo(user.getOrgId());
        newUser.setRoleIds(this.getRoleIdByOrgRole(user.getOrgRole(), user.getRegionCode()));
        newUser.setState(Integer.valueOf(0));
        newUser.setCreateTime(new Date());
        newUser.setUserId(Long.valueOf(1L));
        newUser.setPassword("");
        newUser.setAppId(user.getAppId());
        this.landRegUserRepository.save((Object)newUser);
    }

    public void registerByApp(RegUserInfo user) throws Exception {
        EpaUserReso userReso;
        if (this.isPhoneRegistered(user.getPhone())) {
            throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
        List landRegUser = this.landRegUserDao.queryRegUserByPhone(user.getPhone());
        if (landRegUser != null && !landRegUser.isEmpty()) {
            LandRegUser regUser = (LandRegUser)landRegUser.get(0);
            if (regUser.getState().equals(0)) {
                throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5ba1\u6838");
            }
            if (regUser.getState().equals(1)) {
                throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\u4e14\u901a\u8fc7\u5ba1\u6838");
            }
        }
        if ((userReso = this.epaUserSelectRes3Service.getUserByUsername(user.getName())) != null) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (StringUtils.isBlank((CharSequence)user.getRoleIds())) {
            throw new RuntimeException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getSjsf())) {
            throw new RuntimeException("\u6240\u5728\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String password = "{MD5}" + Md5Util.calFileMd5ByByte((byte[])RSA.decryptByUrlDecoder(user.getPassword(), RSA.getPrivateKey()).getBytes());
        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties((Object)user, (Object)newUser);
        newUser.setDepName(user.getDepName());
        if (StringUtils.isNotBlank((CharSequence)user.getSjsf())) {
            newUser.setRegionCode(user.getSjsf());
        }
        if (StringUtils.isBlank((CharSequence)user.getDepNo())) {
            throw new RuntimeException("\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        newUser.setState(Integer.valueOf(0));
        newUser.setCreateTime(new Date());
        newUser.setUserId(Long.valueOf(2L));
        newUser.setPassword(password);
        newUser.setName(user.getName());
        newUser.setRname(user.getRname());
        newUser.setPhone(user.getPhone());
        newUser.setSjsf(user.getSjsf());
        newUser.setDepNo(user.getDepNo());
        newUser.setRoleIds(user.getRoleIds());
        this.landRegUserRepository.save((Object)newUser);
    }

    public void deleteUser(Long userId, String reason, AuthUserInfo loginUser) {
        throw new GwValidateException("\u5f53\u524d\u529f\u80fd\u6682\u4e0d\u53ef\u7528");
    }

    public void changeUserRealName(String userRName, String midUserId) {
        EpaRealNameAddReso realNameAddReso = new EpaRealNameAddReso();
        realNameAddReso.setRealName(userRName);
        realNameAddReso.setUserId(midUserId);
        this.epaUserRealNameRes3Service.updateUserRealName(realNameAddReso);
    }

    public String getRoleIdByOrgRole(String orgRole, String regionCode) {
        String roleId = "";
        if (StringUtils.isBlank((CharSequence)orgRole)) {
            roleId = "10017";
            return roleId;
        }
        switch (orgRole) {
            case "\u7ba1\u7406\u5458": {
                roleId = "10022";
                break;
            }
            case "\u8054\u7edc\u5458": {
                roleId = "10020";
                break;
            }
            case "\u5ba1\u6838\u5458": {
                roleId = "10024";
                break;
            }
            case "\u590d\u6838\u5458": {
                roleId = "10025";
                break;
            }
            case "\u666e\u901a\u7528\u6237": {
                int level = this.getRegionCodeLevel(regionCode);
                switch (level) {
                    case 1: {
                        roleId = "10012";
                        break;
                    }
                    case 2: {
                        roleId = "10003";
                        break;
                    }
                    case 3: {
                        roleId = "10018";
                        break;
                    }
                    case 4: {
                        roleId = "10019";
                        break;
                    }
                    case 5: {
                        roleId = "10017";
                    }
                }
                break;
            }
            default: {
                roleId = "10017";
            }
        }
        return roleId;
    }

    public String getOrgRoleByRoleId(String roleIds) {
        if (StringUtils.isBlank((CharSequence)roleIds)) {
            return null;
        }
        String[] roleIdArr = roleIds.split(",");
        String orgRole = roleIds;
        String[] stringArray = roleIdArr;
        int n = stringArray.length;
        block18: for (int i = 0; i < n; ++i) {
            String role;
            switch (role = stringArray[i]) {
                case "10022": {
                    orgRole = "\u7ba1\u7406\u5458";
                    continue block18;
                }
                case "10020": {
                    orgRole = "\u8054\u7edc\u5458";
                    continue block18;
                }
                case "10024": {
                    orgRole = "\u5ba1\u6838\u5458";
                    continue block18;
                }
                case "10025": {
                    orgRole = "\u590d\u6838\u5458";
                    continue block18;
                }
                case "10012": 
                case "10003": 
                case "10018": 
                case "10019": 
                case "10017": {
                    orgRole = "\u666e\u901a\u7528\u6237";
                    continue block18;
                }
                default: {
                    orgRole = "\u666e\u901a\u7528\u6237";
                }
            }
        }
        return orgRole;
    }

    public int getRegionCodeLevel(String regionCode) {
        int level = 0;
        if (regionCode.length() <= 6) {
            level = regionCode.endsWith("0000") ? 1 : (regionCode.endsWith("00") ? 2 : 3);
        } else if (regionCode.length() == 9) {
            level = 4;
        } else if (regionCode.length() == 12) {
            level = 5;
        }
        return level;
    }

    public SyncUserInfo addBusUser(ApproveUserInfo approveUserInfo) throws Exception {
        Optional landRegUser = this.landRegUserDao.findById((Object)approveUserInfo.getId());
        if (!landRegUser.isPresent()) {
            throw new Exception("\u5f85\u5ba1\u6838\u8bb0\u5f55:" + approveUserInfo.getId() + "\u4e0d\u5b58\u5728");
        }
        LandRegUser regUser = (LandRegUser)landRegUser.get();
        LandUser landUser = new LandUser();
        landUser.setName(approveUserInfo.getUserName());
        landUser.setState(Integer.valueOf(0));
        landUser.setIsdel(Integer.valueOf(0));
        landUser = this.landUserService.saveUser(landUser);
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(approveUserInfo.getCloudArea());
        userCloudArea.setState(Integer.valueOf(1));
        userCloudArea.setCreateTime(new Date());
        this.userCloudAreaRepository.save((Object)userCloudArea);
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(approveUserInfo.getCloudRoleId());
        this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        EpaUserReso epaUserReso = null;
        if (regUser.getUserId().equals(1L)) {
            epaUserReso = this.epaUserSelectRes3Service.getUserByUsername(regUser.getName());
            if (epaUserReso == null) {
                throw new Exception("\u7edf\u4e00\u8ba4\u8bc1\u7528\u6237:" + regUser.getName() + "\u4e0d\u5b58\u5728");
            }
        } else {
            epaUserReso = this.epaUserSelectRes3Service.getUserByUserphone(regUser.getPhone());
        }
        if (epaUserReso == null) {
            EpaUserAddReso userAddReso = new EpaUserAddReso();
            userAddReso.setUserName(regUser.getName());
            userAddReso.setRealName(regUser.getRname());
            userAddReso.setPhoneNumber(regUser.getPhone());
            userAddReso.setEncryptionPassword(regUser.getPassword());
            epaUserReso = this.epaRegisterUserRes3Service.registerEpaUser(userAddReso);
        }
        BusUserInfoReso busUser = null;
        try {
            busUser = this.busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (busUser == null) {
            String sql;
            List map;
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(approveUserInfo.getOrgId());
            addReso.setRegionCode(approveUserInfo.getRegionCode());
            addReso.setOrgRole(approveUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = this.busUserRes3SdkService.registerBusUser(addReso);
            this.changeUserRealName(approveUserInfo.getRealName(), busUser.getMidUserId());
            if (StringUtils.isNotBlank((CharSequence)regUser.getAppId()) && (map = this.jdbcTemplate.queryForList(sql = " select * from bus_apps_config where f_apps_id  ='" + ((LandRegUser)landRegUser.get()).getAppId() + "'")) != null && !map.isEmpty()) {
                String clientId = ((Map)map.get(0)).get("f_app_key").toString();
                this.busUserRes3SdkService.addBusUserAc(busUser.getBusUserId(), clientId, null);
            }
        } else {
            boolean update = false;
            if (StringUtils.isBlank((CharSequence)busUser.getOrgId()) || !busUser.getOrgId().equals(approveUserInfo.getOrgId())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)busUser.getRegionCode()) || !busUser.getRegionCode().equals(approveUserInfo.getRegionCode())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)busUser.getOrgRole()) || !busUser.getOrgRole().equals(approveUserInfo.getOrgRole())) {
                update = true;
            }
            if (update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(approveUserInfo.getOrgId());
                updateReso.setRegionCode(approveUserInfo.getRegionCode());
                updateReso.setOrgRole(approveUserInfo.getOrgRole());
                updateReso.setBusUserId(busUser.getBusUserId());
                busUser = this.busUserRes3SdkService.updateBusUser(updateReso);
            }
            if (StringUtils.isBlank((CharSequence)busUser.getRealName()) || !busUser.getRealName().equals(approveUserInfo.getRealName())) {
                this.changeUserRealName(approveUserInfo.getRealName(), busUser.getMidUserId());
            }
        }
        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        this.landUserService.updateUserInfo(landUser);
        SyncUserInfo syncUserInfo = new SyncUserInfo();
        syncUserInfo.setMidUserId(busUser.getMidUserId());
        syncUserInfo.setEpaUserId(busUser.getBusUserId());
        syncUserInfo.setUserId(landUser.getId());
        syncUserInfo.setUserName(busUser.getUserName());
        syncUserInfo.setEnable(Integer.valueOf(1));
        syncUserInfo.setCloudArea(approveUserInfo.getCloudArea());
        syncUserInfo.setCloudRoleId(approveUserInfo.getCloudRoleId());
        syncUserInfo.setPhone(busUser.getPhone());
        syncUserInfo.setOrgId(busUser.getOrgId());
        syncUserInfo.setOrgRole(busUser.getOrgRole());
        syncUserInfo.setRegionCode(busUser.getRegionCode());
        syncUserInfo.setRealName(busUser.getRealName());
        syncUserInfo.setPassWord(this.epaUserSelectRes3Service.getUserpasswordByUserId(busUser.getMidUserId()));
        return syncUserInfo;
    }

    public void syncAddBusUser(SyncUserInfo syncUserInfo) throws Exception {
        EpaUserReso epaUserReso = this.epaUserSelectRes3Service.getUserByUsername(syncUserInfo.getUserName());
        if (epaUserReso == null && StringUtils.isNotBlank((CharSequence)syncUserInfo.getPassWord())) {
            EpaUserAddReso userAddReso = new EpaUserAddReso();
            userAddReso.setUserName(syncUserInfo.getUserName());
            userAddReso.setRealName(syncUserInfo.getRealName());
            userAddReso.setPhoneNumber(syncUserInfo.getPhone());
            userAddReso.setEncryptionPassword(syncUserInfo.getPassWord());
            epaUserReso = this.epaRegisterUserRes3Service.registerEpaUser(userAddReso);
        }
        LandUser landUser = null;
        List sub = this.tbsysUserSubjectRelRepository.findByMidUserId(epaUserReso.getUserId());
        if (sub == null || sub.isEmpty()) {
            landUser = new LandUser();
            landUser.setName(syncUserInfo.getUserName());
            landUser.setState(Integer.valueOf(0));
            landUser.setIsdel(Integer.valueOf(0));
            landUser = this.landUserService.saveUser(landUser);
        } else {
            landUser = new LandUser();
            landUser.setMidUserId(((TbsysUserSubjectRel)sub.get(0)).getMidUserId());
            landUser.setSubjectUserId(((TbsysUserSubjectRel)sub.get(0)).getSubjectUserId());
            landUser.setId(((TbsysUserSubjectRel)sub.get(0)).getUserId());
            landUser.setName(((TbsysUserSubjectRel)sub.get(0)).getUserName());
        }
        this.userCloudAreaRepository.delteByUserId(landUser.getId());
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(syncUserInfo.getCloudArea());
        userCloudArea.setState(Integer.valueOf(1));
        userCloudArea.setCreateTime(new Date());
        this.userCloudAreaRepository.save((Object)userCloudArea);
        this.roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(syncUserInfo.getCloudRoleId());
        this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        BusUserInfoReso busUser = null;
        BusUserInfoReso existUser = null;
        try {
            existUser = this.busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (existUser == null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(syncUserInfo.getOrgId());
            addReso.setRegionCode(syncUserInfo.getRegionCode());
            addReso.setOrgRole(syncUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = this.busUserRes3SdkService.registerBusUser(addReso);
            this.changeUserRealName(syncUserInfo.getRealName(), busUser.getMidUserId());
        } else {
            boolean update = false;
            if (StringUtils.isBlank((CharSequence)existUser.getOrgId()) || !existUser.getOrgId().equals(syncUserInfo.getOrgId())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getRegionCode()) || !existUser.getRegionCode().equals(syncUserInfo.getRegionCode())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getOrgRole()) || !existUser.getOrgRole().equals(syncUserInfo.getOrgRole())) {
                update = true;
            }
            if (update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(syncUserInfo.getOrgId());
                updateReso.setRegionCode(syncUserInfo.getRegionCode());
                updateReso.setOrgRole(syncUserInfo.getOrgRole());
                updateReso.setBusUserId(existUser.getBusUserId());
                this.busUserRes3SdkService.updateBusUser(updateReso);
            }
            if (StringUtils.isBlank((CharSequence)existUser.getRealName()) || !existUser.getRealName().equals(syncUserInfo.getRealName())) {
                this.changeUserRealName(syncUserInfo.getRealName(), busUser.getMidUserId());
            }
        }
        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        this.landUserService.updateUserInfo(landUser);
    }

    public void syncUpdateBusUser(SyncUserInfo syncUserInfo) throws Exception {
        EpaUserReso epaUserReso = this.epaUserSelectRes3Service.getUserByUserId(syncUserInfo.getUserName());
        if (epaUserReso == null) {
            throw new Exception("\u7edf\u4e00\u8ba4\u8bc1\u7528\u6237:" + syncUserInfo.getUserName() + "\u4e0d\u5b58\u5728");
        }
        LandUser landUser = null;
        List sub = this.tbsysUserSubjectRelRepository.findByMidUserId(epaUserReso.getUserId());
        if (sub == null || sub.isEmpty()) {
            landUser = new LandUser();
            landUser.setName(syncUserInfo.getUserName());
            landUser.setState(Integer.valueOf(0));
            landUser.setIsdel(Integer.valueOf(0));
            landUser = this.landUserService.saveUser(landUser);
        } else {
            landUser = new LandUser();
            landUser.setMidUserId(((TbsysUserSubjectRel)sub.get(0)).getMidUserId());
            landUser.setSubjectUserId(((TbsysUserSubjectRel)sub.get(0)).getSubjectUserId());
            landUser.setId(((TbsysUserSubjectRel)sub.get(0)).getUserId());
            landUser.setName(((TbsysUserSubjectRel)sub.get(0)).getUserName());
        }
        this.userCloudAreaRepository.delteByUserId(landUser.getId());
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(syncUserInfo.getCloudArea());
        userCloudArea.setState(Integer.valueOf(1));
        userCloudArea.setCreateTime(new Date());
        this.userCloudAreaRepository.save((Object)userCloudArea);
        this.roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(syncUserInfo.getCloudRoleId());
        this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        BusUserInfoReso busUser = null;
        BusUserInfoReso existUser = null;
        try {
            existUser = this.busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (existUser == null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(syncUserInfo.getOrgId());
            addReso.setRegionCode(syncUserInfo.getRegionCode());
            addReso.setOrgRole(syncUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = this.busUserRes3SdkService.registerBusUser(addReso);
        } else {
            boolean update = false;
            if (StringUtils.isBlank((CharSequence)existUser.getOrgId()) || !existUser.getOrgId().equals(syncUserInfo.getOrgId())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getRegionCode()) || !existUser.getRegionCode().equals(syncUserInfo.getRegionCode())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getOrgRole()) || !existUser.getOrgRole().equals(syncUserInfo.getOrgRole())) {
                update = true;
            }
            if (update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(syncUserInfo.getOrgId());
                updateReso.setRegionCode(syncUserInfo.getRegionCode());
                updateReso.setOrgRole(syncUserInfo.getOrgRole());
                updateReso.setBusUserId(existUser.getBusUserId());
                this.busUserRes3SdkService.updateBusUser(updateReso);
            }
            if (StringUtils.isBlank((CharSequence)existUser.getRealName()) || !existUser.getRealName().equals(syncUserInfo.getRealName())) {
                this.changeUserRealName(syncUserInfo.getRealName(), busUser.getMidUserId());
            }
        }
    }

    public String getUserRegion(Long userId) throws Exception {
        LandUser user = this.landUserService.queryUserById(userId);
        if (user == null) {
            throw new Exception("\u7528\u6237:" + userId + "\u4e0d\u5b58\u5728");
        }
        BusUserInfoReso busUserInfoReso = this.getBusUser(user.getSubjectUserId());
        if (busUserInfoReso == null) {
            throw new Exception("\u4e1a\u52a1\u7528\u6237:" + userId + "\u4e0d\u5b58\u5728");
        }
        return busUserInfoReso.getRegionCode();
    }

    public JSONObject queryOfCommonRegister(AuthUserInfo userInfo, String regionCode, String namePhone, String role, String orgId, int page, int size) throws Exception {
        List orgIds;
        JSONObject result = new JSONObject();
        ArrayList<String> wheres = new ArrayList<String>();
        wheres.add("f_state = 0");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            wheres.add("f_depno ='" + orgId + "'");
        } else if (!(userInfo.getAdminMgr() != null && userInfo.getAdminMgr().booleanValue() || (orgIds = this.oauthOrganizationService.getAllChildIds(userInfo.getOrgId())) == null || orgIds.isEmpty())) {
            wheres.add("f_depno in('" + StringUtils.join((List)orgIds, (CharSequence)"','") + "')");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)namePhone)) {
            wheres.add("(f_username like '%" + namePhone + "%' or f_phonework like '%" + namePhone + "%')");
        }
        if (role != null && !role.equals("")) {
            if (role.equals("1")) {
                wheres.add("f_roleids like '%10022%'");
            }
            if (role.equals("2")) {
                wheres.add("f_roleids like '%10020%'");
            }
            if (role.equals("3")) {
                wheres.add("f_roleids not like '%10022%' and f_roleids not like '%10020%'");
            }
        }
        if (regionCode != null && !regionCode.equals("")) {
            if (regionCode.length() == 6) {
                if (regionCode.endsWith("0000")) {
                    regionCode = regionCode.substring(0, 2);
                } else if (regionCode.endsWith("00")) {
                    regionCode = regionCode.substring(0, 4);
                }
            }
            wheres.add("f_sjsf like '" + regionCode + "%'");
        }
        String where = org.apache.commons.lang3.StringUtils.join(wheres, (String)" and ");
        Map mapCount = this.jdbcTemplate.queryForMap("select count(*) as f_count from tb_reguser where " + where);
        int totalCount = Integer.parseInt(mapCount.get("f_count").toString());
        if (totalCount > 0) {
            int offset = (page - 1) * size;
            List maps = this.jdbcTemplate.queryForList("select * from tb_reguser where " + where + " order by f_create_date offset " + offset + " limit " + size);
            ArrayList<LandRegUser> regUsers = new ArrayList<LandRegUser>();
            SimpleDateFormat dr = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            for (Map m : maps) {
                LandRegUser user = new LandRegUser();
                user.setId(m.get("f_id") != null ? m.get("f_id").toString() : "");
                user.setName(m.get("f_username") != null ? m.get("f_username").toString() : "");
                user.setRname(m.get("f_rname") != null ? m.get("f_rname").toString() : "");
                user.setUserId(m.get("f_userid") != null ? Long.valueOf(Long.parseLong(m.get("f_userid").toString())) : null);
                user.setPassword(m.get("f_password") != null ? m.get("f_password").toString() : "");
                user.setPhone(m.get("f_phonework") != null ? m.get("f_phonework").toString() : "");
                user.setDepNo(m.get("f_depno") != null ? m.get("f_depno").toString() : "");
                user.setAppId(m.get("f_appid") != null ? m.get("f_appid").toString() : "");
                user.setDepName(m.get("f_depname") != null ? m.get("f_depname").toString() : "");
                user.setRegionCode(m.get("f_regergion") != null ? m.get("f_regergion").toString() : "");
                user.setRoleIds(m.get("f_roleids") != null ? m.get("f_roleids").toString() : "");
                user.setPostId(m.get("f_userposid") != null ? m.get("f_userposid").toString() : "");
                user.setPost(m.get("f_post") != null ? m.get("f_post").toString() : "");
                user.setSjsf(m.get("f_sjsf") != null ? m.get("f_sjsf").toString() : "");
                user.setCreateTime(m.get("f_create_date") != null ? dr.parse(m.get("f_create_date").toString()) : null);
                regUsers.add(user);
            }
            RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
            for (LandRegUser reg : regUsers) {
                String phoneVal;
                LandRegUser regUser = new LandRegUser();
                BeanUtils.copyProperties((Object)reg, (Object)regUser);
                this.completeRegUserInfo1(regUser, defaultVersion);
                if (regUser.getRegion() != null && regUser.getRegion().getTown() != null) {
                    regUser.getRegion().getTown().setShape(null);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(phoneVal = regUser.getPhone())) && phoneVal.length() >= 11) {
                    regUser.setPhone(phoneVal.substring(0, 3) + "****" + phoneVal.substring(7, 11));
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reg.getBizRegion())) continue;
                JSONObject brJson = JSONObject.parseObject((String)reg.getBizRegion());
                JSONObject reJson = new JSONObject();
                for (String key : brJson.keySet()) {
                    TskTaskBiz biz = this.tskTaskBizService.getTskTaskBizById(key);
                    if (biz == null) continue;
                    String[] arr = brJson.getString(key).split(",");
                    ArrayList<String> arrName = new ArrayList<String>();
                    if (biz.getGranularity() != null && biz.getGranularity() == 5) {
                        for (String code : arr) {
                            RegionVillage regionVillage = this.regionService.queryRegionVillageByCode(code);
                            arrName.add(regionVillage.getName());
                        }
                    } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                        for (String code : arr) {
                            RegionTown regionTown = this.regionService.queryRegionTownByCode(code);
                            arrName.add(regionTown.getName());
                        }
                    } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                        for (String code : arr) {
                            Region region = this.regionService.queryRegionByCode(code);
                            arrName.add(region.getName());
                        }
                    }
                    reJson.put(biz.getName(), (Object)org.apache.commons.lang3.StringUtils.join(arrName, (String)","));
                }
                regUser.setBizRegionName(reJson.toJSONString());
            }
            result.put("list", regUsers);
        }
        result.put("total", (Object)totalCount);
        return result;
    }

    public SyncUserInfo addUser(AddUserInfo addUserInfo) throws Exception {
        if (addUserInfo == null) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getUserName())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u7528\u6237\u540d");
        }
        EpaUserReso userReso = this.getMidtUserByUserName(addUserInfo.getUserName());
        if (userReso != null) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getUserRealName())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u771f\u5b9e\u59d3\u540d");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getPhoneNumber())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u624b\u673a\u53f7");
        }
        if (this.isPhoneRegistered(addUserInfo.getPhoneNumber())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u5f53\u524d\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getPassWord())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u5bc6\u7801");
        }
        String reg = "^(?![0-9]+$)(?![a-zA-Z]+$)[a-zA-Z0-9]{6,16}$";
        if (!addUserInfo.getPassWord().matches(reg)) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u5bc6\u7801\u8981\u6c42\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u5408,\u957f\u5ea66-16\u4f4d");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getOrgId())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u6240\u5c5e\u5355\u4f4d");
        }
        OrganizationReso organizationReso = this.organizationSelectRes3Service.searchOrganizationById(addUserInfo.getOrgId());
        if (organizationReso == null) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u7528\u6237\u6240\u5c5e\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getOrgRole())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u7ec4\u7ec7\u89d2\u8272");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getRegionCode())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u7528\u6237\u653f\u533a");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getCloudRoleId())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u4e91\u67e5\u8be2\u89d2\u8272");
        }
        if (StringUtils.isBlank((CharSequence)addUserInfo.getCloudArea())) {
            throw new GwValidateException("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u672a\u8bbe\u7f6e\u4e91\u67e5\u8be2\u533a\u57df");
        }
        String password = "{MD5}" + Md5Util.calFileMd5ByByte((byte[])addUserInfo.getPassWord().getBytes());
        EpaUserAddReso userAddReso = new EpaUserAddReso();
        userAddReso.setUserName(addUserInfo.getUserName());
        userAddReso.setRealName(addUserInfo.getUserRealName());
        userAddReso.setPhoneNumber(addUserInfo.getPhoneNumber());
        userAddReso.setEncryptionPassword(password);
        userAddReso.setEmail(addUserInfo.getEmail());
        EpaUserReso epaUserReso = this.epaRegisterUserRes3Service.registerEpaUser(userAddReso);
        BusUserInfoReso busUser = null;
        try {
            busUser = this.busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (busUser == null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(addUserInfo.getOrgId());
            addReso.setRegionCode(addUserInfo.getRegionCode());
            addReso.setOrgRole(addUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = this.busUserRes3SdkService.registerBusUser(addReso);
            this.changeUserRealName(addUserInfo.getUserRealName(), busUser.getMidUserId());
        } else {
            boolean update = false;
            if (StringUtils.isBlank((CharSequence)busUser.getOrgId()) || !busUser.getOrgId().equals(addUserInfo.getOrgId())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)busUser.getRegionCode()) || !busUser.getRegionCode().equals(addUserInfo.getRegionCode())) {
                update = true;
            }
            if (StringUtils.isBlank((CharSequence)busUser.getOrgRole()) || !busUser.getOrgRole().equals(addUserInfo.getOrgRole())) {
                update = true;
            }
            if (update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(addUserInfo.getOrgId());
                updateReso.setRegionCode(addUserInfo.getRegionCode());
                updateReso.setOrgRole(addUserInfo.getOrgRole());
                updateReso.setBusUserId(busUser.getBusUserId());
                busUser = this.busUserRes3SdkService.updateBusUser(updateReso);
            }
            if (StringUtils.isBlank((CharSequence)busUser.getRealName()) || !busUser.getRealName().equals(addUserInfo.getUserRealName())) {
                this.changeUserRealName(addUserInfo.getUserRealName(), busUser.getMidUserId());
            }
        }
        LandUser landUser = new LandUser();
        landUser.setName(epaUserReso.getUserName());
        landUser.setRname(addUserInfo.getUserRealName());
        landUser.setState(Integer.valueOf(0));
        landUser.setIsdel(Integer.valueOf(0));
        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        landUser = this.landUserService.saveUser(landUser);
        try {
            this.userCloudAreaRepository.delteByUserId(landUser.getId());
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setUserId(landUser.getId());
            userCloudArea.setCode(addUserInfo.getCloudArea());
            userCloudArea.setState(Integer.valueOf(1));
            userCloudArea.setCreateTime(new Date());
            this.userCloudAreaRepository.save((Object)userCloudArea);
            this.roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setUid(landUser.getId().toString());
            roleCloudQueryRel.setCid(addUserInfo.getCloudRoleId());
            this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
            if (addUserInfo.getUserTaskPermissionDto() != null) {
                addUserInfo.getUserTaskPermissionDto().setUserId(landUser.getId());
                this.tskTaskBizService.setUserTaskPermission(addUserInfo.getUserTaskPermissionDto());
            }
        }
        catch (Exception ex) {
            this.logger.error("\u65b0\u589e\u7528\u6237\u8bbe\u7f6e\u4e1a\u52a1\u4fe1\u606f\u5931\u8d25", new Object[0]);
        }
        SyncUserInfo syncUserInfo = new SyncUserInfo();
        syncUserInfo.setMidUserId(busUser.getMidUserId());
        syncUserInfo.setEpaUserId(busUser.getBusUserId());
        syncUserInfo.setUserId(landUser.getId());
        syncUserInfo.setUserName(busUser.getUserName());
        syncUserInfo.setEnable(Integer.valueOf(1));
        syncUserInfo.setCloudArea(addUserInfo.getCloudArea());
        syncUserInfo.setCloudRoleId(addUserInfo.getCloudRoleId());
        syncUserInfo.setPhone(busUser.getPhone());
        syncUserInfo.setOrgId(busUser.getOrgId());
        syncUserInfo.setOrgRole(busUser.getOrgRole());
        syncUserInfo.setRegionCode(busUser.getRegionCode());
        syncUserInfo.setRealName(busUser.getRealName());
        syncUserInfo.setPassWord(password);
        return syncUserInfo;
    }

    public boolean canViewAppZttj(String orgId) {
        try {
            SysConfig config = this.sysConfigService.findOne("appZttjViewOrg");
            if (config == null || StringUtils.isBlank((CharSequence)config.getValue())) {
                return true;
            }
            JSONArray jsonArray = JSONArray.parseArray((String)config.getValue(), (Feature[])new Feature[0]);
            if (jsonArray == null || jsonArray.isEmpty()) {
                return true;
            }
            ArrayList<String> childViews = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String org = jsonObject.getString("orgId");
                if (org.equals(orgId)) {
                    return true;
                }
                Boolean childView = jsonObject.getBoolean("childView");
                if (!childView.booleanValue()) continue;
                childViews.add(org);
            }
            if (!childViews.isEmpty()) {
                for (String org : childViews) {
                    List childs = this.oauthOrganizationService.getAllChildIds(org);
                    if (childs == null || !childs.contains(orgId)) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    public LandUser addUser(String usreName, String regionCode, String midUserId, String busUserId) {
        LandUser landUser = new LandUser();
        landUser.setMidUserId(midUserId);
        landUser.setSubjectUserId(busUserId);
        landUser.setName(usreName);
        landUser.setIsdel(Integer.valueOf(0));
        landUser.setState(Integer.valueOf(1));
        landUser = this.landUserService.saveUser(landUser);
        if (GutilStr.isNotBlank((CharSequence)regionCode)) {
            Map<String, Object> map = this.regionCodeLevel(regionCode);
            String cloudRole = map.get("cloudRole").toString();
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(landUser.getId());
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(Integer.valueOf(1));
            this.userCloudAreaDao.save((Object)userCloudArea);
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(landUser.getId().toString());
            this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        }
        return landUser;
    }

    public Boolean sendSms(String phone) {
        try {
            String registrationId = "gas-" + AuthorizationGrantType.CLIENT_CREDENTIALS.getValue() + "-gasClient";
            ClientCredentialsClientRegistration cccr = (ClientCredentialsClientRegistration)Oauth2ClientRegistration.findById((String)registrationId);
            if (cccr == null) {
                this.logger.error("sendsms:\u53d1\u9001\u767b\u5f55\u9a8c\u8bc1\u7801 \u83b7\u53d6client\u5931\u8d25\uff0c\u521d\u59cb\u5316\u4e00\u4e2a", new Object[0]);
                GacOauth2Tool.getGasClient();
                cccr = new ClientCredentialsClientRegistration(registrationId, "gasClient");
            }
            this.logger.error("sendsms:clientName:" + cccr.getClientName(), new Object[0]);
            this.logger.error("sendsms:clientId:" + cccr.getClient().getClientId(), new Object[0]);
            this.logger.error("sendsms:clientName:" + cccr.getClient().getClientName(), new Object[0]);
            this.logger.error("sendsms:clientSecret:" + cccr.getClient().getClientSecret(), new Object[0]);
            this.logger.error("sendsms:priovider:" + cccr.getClient().getProvider(), new Object[0]);
            Oauth2Provider provider = Oauth2Provider.get((String)cccr.getClient().getProvider());
            this.logger.error("sendsms:getTokenEndpointURI:" + provider.getTokenEndpointURI().toString(), new Object[0]);
            this.logger.error("sendsms:getAuthorizationEndpointURI:" + provider.getAuthorizationEndpointURI().toString(), new Object[0]);
            URI url = provider.getIssuerEndpointURIWithPath("/res3client/captcha");
            this.logger.error("sendsms:getIssuerEndpointURIWithPath:" + url.toString(), new Object[0]);
            String type = "sms";
            String phoneNumber = phone;
            String userId = null;
            String userName = null;
            HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
            httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            if (org.springframework.util.StringUtils.hasText((String)type)) {
                params.put("type", Collections.singletonList(type));
                if (org.springframework.util.StringUtils.hasText(userId)) {
                    params.put("userId", Collections.singletonList(userId));
                }
                if (org.springframework.util.StringUtils.hasText(userName)) {
                    params.put("userName", Collections.singletonList(userName));
                }
                if (org.springframework.util.StringUtils.hasText((String)phoneNumber)) {
                    params.put("phoneNumber", Collections.singletonList(phoneNumber));
                }
                String paramStr = URLUtils.serializeParameters(params);
                httpRequest.setQuery(paramStr);
                this.logger.error("sendsms:param:" + paramStr, new Object[0]);
                String principalName = cccr.getClientName();
                OAuth2AuthorizedClientService oAuth2AuthorizedClientService = Oauth2Provider.get((String)cccr.getClient().getProvider()).getAuthorizedClientService();
                OAuth2AuthorizedClient client = oAuth2AuthorizedClientService.loadAuthorizedClient(registrationId, principalName);
                if (client == null) {
                    try {
                        this.logger.error("sendsms:client redis null", new Object[0]);
                        OAuth2AccessToken accessToken = this.authentication(cccr, provider);
                        this.logger.error("sendsms:client token " + accessToken.getTokenValue(), new Object[0]);
                        client = new OAuth2AuthorizedClient(OAuth2AuthorizedClient.OAuth2AuthorizedPrincipalId.of((String)registrationId, (String)principalName), accessToken, (OAuth2RefreshToken)null);
                        oAuth2AuthorizedClientService.saveAuthorizedClient(client);
                    }
                    catch (Exception var6) {
                        this.logger.error("sendsms:client redis null,init error" + ExceptionUtil.getErrorString(var6), new Object[0]);
                    }
                }
                httpRequest.setAuthorization("Bearer " + client.getAccessToken().getTokenValue());
                this.logger.error("sendsms:token:Bearer " + client.getAccessToken().getTokenValue(), new Object[0]);
                HTTPResponse response = httpRequest.send();
                if (response.getStatusCode() == 200) {
                    this.logger.error("sendsms:200:" + response.getContent(), new Object[0]);
                    String res = response.getContent();
                    return Boolean.valueOf(res.trim());
                }
                String res = response.getContent();
                this.logger.error("sendsms:error:" + response.getContent(), new Object[0]);
                return false;
            }
            this.logger.error("sendsms:type is need", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            this.logger.error("sendsms:ex:" + ExceptionUtil.getErrorString(ex), new Object[0]);
            return false;
        }
    }

    private OAuth2AccessToken authentication(ClientCredentialsClientRegistration cccr, Oauth2Provider provider) throws Exception {
        ClientSecretBasic clientSecretBasicAuthentication = new ClientSecretBasic(new ClientID(cccr.getClient().getClientId()), new Secret(cccr.getClient().getClientSecret()));
        TokenRequest request = new TokenRequest(provider.getTokenEndpointURI(), (ClientAuthentication)clientSecretBasicAuthentication, (AuthorizationGrant)new ClientCredentialsGrant(), Scope.parse((Collection)cccr.getScope()));
        HTTPResponse httpResponse = request.toHTTPRequest().send();
        TokenResponse response = TokenResponse.parse((HTTPResponse)httpResponse);
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            if (errorResponse != null && errorResponse.getErrorObject() != null) {
                throw new RuntimeException("1ClientCredentialsGrant\u6a21\u5f0f\u8fd4\u56de\u9519\u8bef\u7ed3\u679c:" + errorResponse.toJSONObject().toJSONString());
            }
            throw new RuntimeException("2ClientCredentialsGrant\u6a21\u5f0f\u8fd4\u56de\u9519\u8bef\u7ed3\u679c:" + errorResponse.toJSONObject().toJSONString());
        }
        AccessTokenResponse successResponse = response.toSuccessResponse();
        Tokens tokens = successResponse.getTokens();
        AccessToken accessToken = tokens.getAccessToken();
        OAuth2AccessToken oAuth2AccessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, accessToken.getValue(), Instant.now(), Instant.now().plusSeconds(accessToken.getLifetime()));
        return oAuth2AccessToken;
    }

    private void setUserInfo(Long userId, String orgId, String regionCode, String orgRole, SyncUserInfo syncUserInfo) throws Exception {
        List subjectRel = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (subjectRel == null || subjectRel.isEmpty()) {
            throw new Exception("\u672a\u627e\u5230\u7528\u6237:" + userId + "\u5bf9\u5e94\u7684\u4e1a\u52a1\u7528\u6237");
        }
        String busUserId = ((TbsysUserSubjectRel)subjectRel.get(0)).getSubjectUserId();
        BusUserUpdateReso userUpdateReso = new BusUserUpdateReso();
        userUpdateReso.setBusUserId(busUserId);
        userUpdateReso.setOrgId(orgId);
        userUpdateReso.setOrgRole(orgRole);
        userUpdateReso.setRegionCode(regionCode);
        this.busUserRes3SdkService.updateBusUser(userUpdateReso);
        syncUserInfo.setUserId(userId);
        syncUserInfo.setMidUserId(((TbsysUserSubjectRel)subjectRel.get(0)).getMidUserId());
        syncUserInfo.setEpaUserId(((TbsysUserSubjectRel)subjectRel.get(0)).getSubjectUserId());
        syncUserInfo.setOrgRole(orgRole);
        syncUserInfo.setOrgId(orgId);
        syncUserInfo.setRegionCode(regionCode);
    }

    private boolean isMyFriend(Long ownerId, Long userId) throws Exception {
        List friends = this.friendsService.getMyFriends(ownerId);
        if (friends.isEmpty()) {
            return false;
        }
        for (LandUser myFriend : friends) {
            if (!myFriend.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    private void addUser(Long userId, String regionCode) {
        if (GutilStr.isNotBlank((CharSequence)regionCode)) {
            Map<String, Object> map = this.regionCodeLevel(regionCode);
            String cloudRole = map.get("cloudRole").toString();
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(userId);
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(Integer.valueOf(1));
            this.userCloudAreaDao.save((Object)userCloudArea);
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(userId.toString());
            this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        }
    }

    private void addUser(Long userId, String regionCode, String roleIds) {
        if (GutilStr.isNotBlank((CharSequence)regionCode)) {
            Map<String, Object> map = this.regionCodeLevel(regionCode);
            String cloudRole = map.get("cloudRole").toString();
            String userrole = roleIds;
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(userId);
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(Integer.valueOf(1));
            this.userCloudAreaDao.save((Object)userCloudArea);
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(userId.toString());
            this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
        }
    }

    public Map<String, Object> regionCodeLevel(String regionCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("level", 1);
        result.put("cloudRole", 1001);
        result.put("userrole", 10003);
        if (regionCode.length() <= 6) {
            if (regionCode.endsWith("0000")) {
                result.put("level", 1);
                result.put("cloudRole", "1001");
                result.put("userrole", "10003");
            } else if (regionCode.endsWith("00")) {
                result.put("level", 2);
                result.put("cloudRole", "1005");
                result.put("userrole", "10018");
            } else {
                result.put("level", 3);
                result.put("cloudRole", "1006");
                result.put("userrole", "10019");
            }
        } else if (regionCode.length() == 9) {
            result.put("level", 4);
            result.put("cloudRole", "1006");
            result.put("userrole", "10019");
        } else if (regionCode.length() == 12) {
            result.put("level", 5);
            result.put("cloudRole", "1006");
            result.put("userrole", "10019");
        }
        return result;
    }

    private void completeRegUserInfo1(LandRegUser regUser, RegionVersion defaultVersion) throws Exception {
        String roleIds = regUser.getRoleIds();
        MyRegion myRegion = new MyRegion();
        int level = 3;
        String lsSf = "";
        if (GutilStr.isNotBlank((CharSequence)regUser.getSjsf())) {
            lsSf = regUser.getSjsf();
            if (lsSf.equals("000000")) {
                lsSf = "1";
            }
            myRegion = this.getMyRegionByCode(lsSf, defaultVersion);
            if (lsSf != null && lsSf.length() == 6) {
                Region region = this.regionDao.findByCodeAndVersion(lsSf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                level = region.getLevel();
            } else if (lsSf != null && lsSf.length() == 9) {
                RegionTown regionTown = this.regionTownDao.getByCodeAndVersion(lsSf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                level = regionTown.getLevel();
            } else if (lsSf != null && lsSf.length() == 12) {
                level = 5;
            }
        }
        regUser.setRegion(myRegion);
        regUser.setRegionCode(lsSf);
        regUser.setLevel(level);
    }

    public MyRegion getMyRegionByCode(String xzqdm, RegionVersion defaultVersion) throws Exception {
        if ("1".equals(xzqdm)) {
            MyRegion myRegion = new MyRegion("\u5168\u56fd");
            myRegion.setCountry("1");
            return myRegion;
        }
        MyRegion myRegion = new MyRegion();
        Region region = null;
        RegionTown regionTown = null;
        RegionVillage regionVillage = null;
        if (xzqdm.length() == 6) {
            region = this.regionDao.findByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        } else if (xzqdm.length() == 9) {
            regionTown = this.regionTownDao.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        } else if (xzqdm.length() == 12) {
            regionVillage = this.regionVillageRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        }
        if (region == null && regionTown == null && regionVillage == null) {
            return new MyRegion();
        }
        int level = 0;
        if (region != null) {
            level = region.getLevel();
        } else if (regionTown != null) {
            level = regionTown.getLevel();
        } else if (regionVillage != null) {
            level = 5;
        }
        switch (level) {
            case 1: {
                myRegion.setProvince(region);
                myRegion.setFullName(region.getName());
                break;
            }
            case 2: {
                myRegion.setCity(region);
                Region pRegion = this.regionDao.findByCodeAndVersion(region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(pRegion);
                myRegion.setFullName(pRegion.getName() + region.getName());
                break;
            }
            case 3: {
                myRegion.setCounty(region);
                Region p1Region = this.regionDao.findByCodeAndVersion(region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(p1Region);
                Region p2Region = this.regionDao.findByCodeAndVersion(p1Region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(p2Region);
                myRegion.setFullName(p2Region.getName() + p1Region.getName() + region.getName());
                break;
            }
            case 4: {
                myRegion.setTown(regionTown);
                Region parentRegion1 = this.regionDao.findByCodeAndVersion(regionTown.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCounty(parentRegion1);
                Region parentRegion2 = this.regionDao.findByCodeAndVersion(parentRegion1.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(parentRegion2);
                Region parentRegion3 = this.regionDao.findByCodeAndVersion(parentRegion2.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(parentRegion3);
                myRegion.setFullName(parentRegion3.getName() + parentRegion2.getName() + parentRegion1.getName() + regionTown.getName());
                break;
            }
            case 5: {
                myRegion.setVillage(regionVillage);
                RegionTown regionTown1 = this.regionTownDao.getByCodeAndVersion(regionVillage.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setTown(regionTown1);
                Region parentRegion5 = this.regionDao.findByCodeAndVersion(regionTown1.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCounty(parentRegion5);
                Region parentRegion6 = this.regionDao.findByCodeAndVersion(parentRegion5.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(parentRegion6);
                Region parentRegion7 = this.regionDao.findByCodeAndVersion(parentRegion6.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(parentRegion7);
                myRegion.setFullName(parentRegion7.getName() + parentRegion6.getName() + parentRegion5.getName() + regionTown1.getName() + regionVillage.getName());
            }
        }
        return myRegion;
    }
}

