/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.other.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImportOtherDataServiceImpl
implements ImportOtherDataService {
    private final GiLoger logger = GwLoger.getLoger(this.getClass());
    private final String host = "https://jzgx.cqlandcloud.org.cn:806";
    private final String getMediaUrl = "/api/cggl/GetAchievementInPolygon";
    private final String ak = "jwgxpt";
    private final String sk = "grsCKkZsGcPD";
    private final Long days = 360L;
    private static final String MEDIA_SOURCE_PREFIX = "JA_IMPORT_";
    private static final String IMPORT_JAMEDIA_CACHE = "IMPORT_JAMEDIA_CACHE";
    private static final String JA_TOKEN = "JA_IMPORT_TOKEN";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public String getMediaSourcePrefix() {
        return MEDIA_SOURCE_PREFIX;
    }

    public void saveJAMediaData(String taskId) throws Exception {
        Boolean tag = this.redisTemplate.opsForHash().hasKey((Object)"JOB_REDIS_IMPORTDATA", (Object)taskId);
        if (tag.booleanValue()) {
            throw new Exception("\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42");
        }
        this.redisTemplate.opsForHash().put((Object)"JOB_REDIS_IMPORTDATA", (Object)taskId, (Object)new Date());
        Thread thread = new Thread(() -> {
            try {
                TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
                String tablename = table.getfTablename();
                List<Map<String, Object>> dataList = this.getData(tablename);
                dataList.forEach(data -> {
                    String f_id = (String)data.get("f_id");
                    String wkt = (String)data.get("wkt");
                    Boolean flag = this.hasMedia(f_id);
                    if (!flag.booleanValue()) {
                        try {
                            JSONObject medias = this.getMediaByJA(wkt);
                            String code = medias.getString("Code");
                            if (!"200".equals(code)) {
                                throw new Exception(code + medias.getString("Error") + medias.getString("Message"));
                            }
                            JSONArray array = medias.getJSONArray("Data");
                            if (array.size() > 0) {
                                this.logger.error("\u56fe\u6591id" + f_id, new Object[0]);
                                for (int i = 0; i < array.size(); ++i) {
                                    this.saveMedia(f_id, array.getJSONObject(i));
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.error((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                try {
                    this.logger.error((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.redisTemplate.opsForHash().delete((Object)"JOB_REDIS_IMPORTDATA", new Object[]{taskId});
                    throw throwable;
                }
                this.redisTemplate.opsForHash().delete((Object)"JOB_REDIS_IMPORTDATA", new Object[]{taskId});
            }
            this.redisTemplate.opsForHash().delete((Object)"JOB_REDIS_IMPORTDATA", new Object[]{taskId});
        });
        this.threadPoolTaskExecutor.execute((Runnable)thread);
    }

    public JSONArray getTbMediaData(String taskId, String tbid, String tableId) throws Exception {
        JSONArray result = null;
        TbtskObjectinfo table = null;
        table = StringUtils.isNotBlank((CharSequence)tableId) ? this.tskTaskBizService.getTableByTableId(tableId) : this.tskTaskBizService.findTableByTaskId(taskId);
        String tablename = table.getfTablename();
        List<Map<String, Object>> dataList = this.getData(tablename, tbid);
        Assert.notEmpty(dataList, (String)"\u672a\u67e5\u5230\u56fe\u6591\u4fe1\u606f");
        Map<String, Object> data = dataList.get(0);
        String wkt = (String)data.get("wkt");
        List attachedMedias = this.appMediaRepository.queryByGalleryidAndBizid(tbid, taskId);
        try {
            JSONObject medias = this.getMediaByJA(wkt);
            String code = medias.getString("Code");
            if (!"200".equals(code)) {
                throw new Exception(code + medias.getString("Error") + medias.getString("Message"));
            }
            HashMap cache = new HashMap();
            JSONArray temp = medias.getJSONArray("Data");
            Assert.notNull((Object)temp, (String)"\u672a\u67e5\u5230\u7ed3\u679c");
            temp.forEach(item -> {
                JSONObject json = (JSONObject)item;
                String bsm = json.getString("BSM");
                this.redisTemplate.opsForHash().putIfAbsent((Object)IMPORT_JAMEDIA_CACHE, (Object)bsm, (Object)json);
                json.put("isAttached", (Object)this.isAttached(attachedMedias, bsm));
            });
            this.redisTemplate.expire((Object)IMPORT_JAMEDIA_CACHE, 1L, TimeUnit.HOURS);
            result = temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Throwable)e);
        }
        return result;
    }

    public JSONObject attachMedia(String taskId, String tbid, String medias) {
        String[] mediaArray = medias.split(",");
        JSONObject result = new JSONObject();
        for (String mediaId : mediaArray) {
            Boolean tag = this.redisTemplate.opsForHash().hasKey((Object)IMPORT_JAMEDIA_CACHE, (Object)mediaId);
            if (!tag.booleanValue()) {
                result.put(mediaId, (Object)"\u6302\u8f7d\u5931\u8d25\u5237\u65b0\u540e\u91cd\u8bd5");
                continue;
            }
            try {
                JSONObject cache = (JSONObject)this.redisTemplate.opsForHash().get((Object)IMPORT_JAMEDIA_CACHE, (Object)mediaId);
                boolean suc = this.saveMedia(taskId, tbid, cache);
                result.put(mediaId, (Object)"\u6302\u8f7d\u6210\u529f");
                result.put("suc", (Object)suc);
            }
            catch (Exception e) {
                result.put(mediaId, (Object)"\u6302\u8f7d\u5931\u8d25");
            }
        }
        return result;
    }

    public List<String> getTempUrl(List<String> url) throws IOException {
        JSONObject json = new JSONObject();
        json.put("urls", url);
        json.put("resize", (Object)0);
        JSONArray arr = new JSONArray();
        arr.add((Object)json);
        String sevice = "https://jg.landcloud.org.cn:8553/temporarysignature/api/FileUrl/Convert";
        HttpPost post = new HttpPost(sevice);
        StringEntity entity = new StringEntity(arr.toString(), "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json");
        CloseableHttpClient httpClient = this.buildHttpClient(false);
        HttpResponse response1 = httpClient.execute((HttpUriRequest)post);
        String result = EntityUtils.toString((HttpEntity)response1.getEntity());
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (resultObj.containsKey((Object)"code") && "200".equals(resultObj.getString("code"))) {
            JSONArray data = resultObj.getJSONArray("data");
            if (data == null) {
                return null;
            }
            ArrayList<String> newUrls = new ArrayList<String>();
            for (int i = 0; i < data.size(); ++i) {
                String aa = data.getString(i);
                newUrls.add(aa);
            }
            return newUrls;
        }
        return null;
    }

    private List<Map<String, Object>> getData(String tablename) {
        String sql = "select f_id,st_astext(f_shape) as wkt from " + tablename;
        return this.jdbcTemplate.queryForList(sql);
    }

    private List<Map<String, Object>> getData(String tablename, String tbid) {
        String sql = "select f_id,st_astext(f_shape) as wkt from " + tablename + " where f_id = '" + tbid + "'";
        return this.jdbcTemplate.queryForList(sql);
    }

    private Boolean hasMedia(String f_id) {
        String sql = "select f_id from tb_app_media where f_galleryid = '" + f_id + "'";
        List list = this.jdbcTemplate.queryForList(sql);
        if (list.isEmpty()) {
            return false;
        }
        return true;
    }

    private void saveMedia(String f_id, JSONObject obj) throws ParseException {
    }

    private boolean saveMedia(String taskid, String fid, JSONObject obj) throws ParseException {
        String url = obj.getString("BigImgUrl");
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)taskid) && this.isAttached(taskid, fid, url).booleanValue()) {
            return false;
        }
        if (url.contains("?")) {
            url = StringUtils.split((String)url, (String)"?")[0];
        }
        AppMedia media = new AppMedia();
        media.setId(UUID.randomUUID().toString());
        media.setBizId(taskid);
        media.setGalleryid(fid);
        media.setType(Integer.valueOf(1));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String pssjStr = obj.getString("PSSJ").trim().replace('/', '-').substring(0, 18);
        media.setTime(String.valueOf(format.parse(obj.getString("PSSJ")).getTime()));
        media.setLon(obj.getDouble("Longitude"));
        media.setLat(obj.getDouble("Latitude"));
        media.setAzimuth(obj.getString("PSJD"));
        media.setServerpath(url);
        media.setUsername(obj.getString("PSRY"));
        media.setFromSource(MEDIA_SOURCE_PREFIX + obj.getString("BSM"));
        this.appMediaRepository.save((Object)media);
        this.logger.error("\u7167\u7247" + obj.getString("BigImgUrl"), new Object[0]);
        return true;
    }

    private JSONObject getMediaByJA(String wkt) throws IOException {
        Boolean hasToken = this.redisTemplate.hasKey((Object)JA_TOKEN);
        String token = "";
        if (hasToken.booleanValue()) {
            token = (String)this.redisTemplate.opsForValue().get((Object)JA_TOKEN);
        } else {
            try {
                token = this.getAuthorization();
                if (StringUtils.isNotBlank((CharSequence)token)) {
                    this.redisTemplate.opsForValue().set((Object)JA_TOKEN, (Object)token);
                    this.redisTemplate.expire((Object)JA_TOKEN, 1L, TimeUnit.HOURS);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("token\u83b7\u53d6\u5931\u8d25");
            }
        }
        Long time = System.currentTimeMillis();
        Long starttime = time - this.days * 1000L * 60L * 60L * 24L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String StartDate = format.format(starttime);
        String EndDate = format.format(time);
        JSONObject obj = new JSONObject();
        obj.put("BufferDistance", (Object)20);
        obj.put("QueryCountLimit", (Object)100);
        obj.put("StartDate", (Object)StartDate);
        obj.put("EndDate", (Object)EndDate);
        obj.put("WKT", (Object)wkt);
        HttpPost post = new HttpPost(this.host + this.getMediaUrl);
        StringEntity entity = new StringEntity(obj.toString(), "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity((HttpEntity)entity);
        post.setHeader("Authorization", "bearer " + token);
        post.addHeader("Content-Type", "application/json");
        CloseableHttpClient httpClient = this.buildHttpClient(false);
        HttpResponse response1 = httpClient.execute((HttpUriRequest)post);
        String result = EntityUtils.toString((HttpEntity)response1.getEntity());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        return resultObj;
    }

    private JSONObject getMediaByJA_bk(String wkt) throws IOException {
        Long time = System.currentTimeMillis();
        Long starttime = time - this.days * 1000L * 60L * 60L * 24L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String StartDate = format.format(starttime);
        String EndDate = format.format(time);
        JSONObject obj = new JSONObject();
        obj.put("BufferDistance", (Object)20);
        obj.put("QueryCountLimit", (Object)100);
        obj.put("StartDate", (Object)StartDate);
        obj.put("EndDate", (Object)EndDate);
        obj.put("WKT", (Object)wkt);
        HttpPost post = new HttpPost(this.host + this.getMediaUrl);
        StringEntity entity = new StringEntity(obj.toString(), "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity((HttpEntity)entity);
        post.setHeader("Authorization", "bearer 6TRtO11i85bE96RJeUYnRE304CtDun4M_YTaBIvqQLSFIzWHeOXkxv4uAzgNglpEPCNAHDEQb1P6hozZSG_NjIUDqDG6f0pTbZPSQuSUGKmgAVZLh3GfmlJx074KLHe0vQwgJJfdkXXDFp1-X5FRIGHfJ8UkouQMhmuWBPc3sYX7YJnkaitJZ-jYUkf7aKAO-JIxZiU0TS0GZXDKF3L1Qi5aV0h7e2L-LuHILSzPStFcXOb2KbaqKTsx5j8a4XZfeTWcCP3WaJmesaoM66yMVHPoc091t3X2l_UcbGttevhbZ7tpiFM8QCrep_W7RzbU");
        post.addHeader("Content-Type", "application/json");
        CloseableHttpClient httpClient = this.buildHttpClient(false);
        HttpResponse response1 = httpClient.execute((HttpUriRequest)post);
        String result = EntityUtils.toString((HttpEntity)response1.getEntity());
        JSONObject resultObj = JSONObject.parseObject((String)result);
        return resultObj;
    }

    private String getAuthorization() throws Exception {
        OkHttpClient client = new OkHttpClient();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        FormBody body = new FormBody.Builder().add("grant_type", "password").add("username", "jwgxpt").add("password", "grsCKkZsGcPD").build();
        Request request = new Request.Builder().url(this.host + "/token").post((RequestBody)body).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("cache-control", "no-cache").build();
        String result = "";
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                String resp = response.body().string();
                JSONObject jsonObject = JSONObject.parseObject((String)resp);
                result = jsonObject.getString("access_token");
            }
        }
        catch (Exception e) {
            throw new Exception("\u4eca\u5965\u767b\u5f55\u5931\u8d25");
        }
        return result;
    }

    private CloseableHttpClient buildHttpClient(boolean isMultiThread) {
        CloseableHttpClient client = isMultiThread ? HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build() : HttpClientBuilder.create().build();
        return client;
    }

    private Boolean isAttached(String taskid, String tbid, String bsm) {
        List list = this.appMediaRepository.queryByTaskIdGidAndFromSource(tbid, taskid, MEDIA_SOURCE_PREFIX + bsm);
        return list != null && !list.isEmpty();
    }

    private Boolean isAttached(List<AppMedia> medias, String bsm) {
        if (medias == null) {
            return false;
        }
        String source = MEDIA_SOURCE_PREFIX + bsm;
        List result = medias.stream().filter(item -> source.equals(item.getFromSource())).collect(Collectors.toList());
        return !result.isEmpty();
    }
}

