/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MCluePlotService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueJudgeMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueLandinfoMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskCluePlotinfoMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.TaskClueJudgeDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskClueJudge;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskClueLandinfo;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskCluePlotinfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MCluePlotServiceImpl
implements MCluePlotService {
    @Autowired
    JcTaskClueJudgeMapper jcTaskClueJudgeMapper;
    @Autowired
    JcTaskClueLandinfoMapper jcTaskClueLandinfoMapper;
    @Autowired
    JcTaskCluePlotinfoMapper jcTaskCluePlotinfoMapper;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DataBizService dataBizService;
    @Resource
    private JdbcTemplate jdbcTemplate;

    public void saveTaskclueJudgeInfo(Long userId, TaskClueJudgeDto taskClueJudgeDto) {
        if (taskClueJudgeDto != null) {
            JcTaskClueJudge jcTaskClueJudge = this.jcTaskClueJudgeMapper.selectByDataId(taskClueJudgeDto.getfDataid());
            if (jcTaskClueJudge == null) {
                JcTaskClueJudge bean = new JcTaskClueJudge();
                BeanUtil.copyProperties((Object)taskClueJudgeDto, (Object)bean);
                bean.setfId(UUID.randomUUID().toString());
                bean.setfUserid(Integer.valueOf(userId.intValue()));
                bean.setfCreatetime(new Date());
                this.jcTaskClueJudgeMapper.insertSelective((Object)bean);
            } else {
                BeanUtil.copyProperties((Object)taskClueJudgeDto, (Object)jcTaskClueJudge, (boolean)false);
                jcTaskClueJudge.setfUserid(Integer.valueOf(userId.intValue()));
                this.jcTaskClueJudgeMapper.updateByPrimaryKeySelective((Object)jcTaskClueJudge);
            }
            this.jcTaskClueLandinfoMapper.deleteByDataId(taskClueJudgeDto.getfDataid());
            if (taskClueJudgeDto.getLandinfo() != null && !taskClueJudgeDto.getLandinfo().isEmpty()) {
                List jcCaseLandinfos = taskClueJudgeDto.getLandinfo().toJavaList(JcTaskClueLandinfo.class);
                for (JcTaskClueLandinfo bean : jcCaseLandinfos) {
                    bean.setfId(UUID.randomUUID().toString());
                    bean.setfDataid(taskClueJudgeDto.getfDataid());
                    this.jcTaskClueLandinfoMapper.insertSelective((Object)bean);
                }
            }
        }
    }

    public void saveCluePlotInfo(Long userId, JcTaskCluePlotinfo jcTaskCluePlotinfo) {
        if (jcTaskCluePlotinfo != null) {
            String id = UUID.randomUUID().toString();
            JcTaskCluePlotinfo jcTaskCluePlotinfo1 = this.jcTaskCluePlotinfoMapper.selectByDataId(jcTaskCluePlotinfo.getfDataid());
            if (jcTaskCluePlotinfo1 != null) {
                id = jcTaskCluePlotinfo1.getfId();
                BeanUtil.copyProperties((Object)jcTaskCluePlotinfo, (Object)jcTaskCluePlotinfo1, (boolean)false);
                jcTaskCluePlotinfo1.setfId(id);
                jcTaskCluePlotinfo1.setfUserid(Integer.valueOf(userId.intValue()));
                jcTaskCluePlotinfo1.setfCreatetime(new Date());
                this.jcTaskCluePlotinfoMapper.updateByPrimaryKeySelective((Object)jcTaskCluePlotinfo1);
            } else {
                JcTaskCluePlotinfo bean = new JcTaskCluePlotinfo();
                BeanUtil.copyProperties((Object)jcTaskCluePlotinfo, (Object)bean, (boolean)false);
                bean.setfId(id);
                bean.setfUserid(Integer.valueOf(userId.intValue()));
                bean.setfCreatetime(new Date());
                this.jcTaskCluePlotinfoMapper.insertSelective((Object)bean);
            }
        }
    }

    public JcTaskClueJudge getTaskclueJudgeInfo(Long userId, String dataId) {
        JcTaskClueJudge jcTaskClueJudge = this.jcTaskClueJudgeMapper.selectByDataId(dataId);
        if (jcTaskClueJudge != null) {
            List jcTaskClueLandinfos = this.jcTaskClueLandinfoMapper.selectByDataId(dataId);
            jcTaskClueJudge.setLandinfo(jcTaskClueLandinfos);
            List appMedias = this.appMediaDao.queryByGid(dataId);
            ArrayList result = new ArrayList();
            ArrayList<AppMediaDTO> resultObject = new ArrayList<AppMediaDTO>();
            for (int i = 0; i < appMedias.size(); ++i) {
                if (((AppMedia)appMedias.get(i)).getTypetype() != 5) continue;
                AppMediaDTO newMedia = new AppMediaDTO();
                BeanUtils.copyProperties(appMedias.get(i), (Object)newMedia);
                if (newMedia.getServerpath() != null && !newMedia.getServerpath().contains("AccessKeyId")) {
                    String fiename = ((AppMedia)appMedias.get(i)).getServerpath().substring(((AppMedia)appMedias.get(i)).getServerpath().lastIndexOf("/") + 1, ((AppMedia)appMedias.get(i)).getServerpath().length());
                    newMedia.setFileName(fiename);
                    String url = this.temporarySignedUrlService.getTemporarySignedUrl("", newMedia.getServerpath(), null);
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        newMedia.setServerpath(url);
                    }
                }
                resultObject.add(newMedia);
            }
            jcTaskClueJudge.setMediaList(resultObject);
        }
        return jcTaskClueJudge;
    }

    public JcTaskCluePlotinfo getCluePlotInfo(Long userId, String dataId) {
        return this.jcTaskCluePlotinfoMapper.selectByDataId(dataId);
    }

    public Map<String, Object> findCluePlotList(Long userId, String regionCode, String existLian, String wflx, String tbbh, String xsStage, int pageIndex, int pageSize) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findByName("\u536b\u7247\u6267\u6cd5");
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u6765\u6e90\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = " select ca.f_id caseid,ca.f_inspectid inspectid,wf.f_zzqk zzqk,ca.f_type casetype,tb.f_wflx wflx,tb.f_xzqdm xzqdm,r.f_clueid clueid,r.f_sourceid sourceid,r.f_taskid taskid,r.f_tbid tbid ,tb.f_tbbh tbbh,tb.f_stage stage\nfrom jc_clue_task_rel as r \nLEFT JOIN jc_wf_info wf ON(wf.f_clueid = r.f_clueid) \nLEFT JOIN jc_case_info ca ON(ca.f_clueid = r.f_clueid) \n," + jcClueSource.getfTablename() + " tb where r.f_clueid = tb.f_id and r.f_type='2'";
        String countSql = "select count(1) from jc_clue_task_rel as r \nLEFT JOIN jc_wf_info wf ON(wf.f_clueid = r.f_clueid) \nLEFT JOIN jc_case_info ca ON(ca.f_clueid = r.f_clueid) \n," + jcClueSource.getfTablename() + " tb where r.f_clueid = tb.f_id and r.f_type='2'";
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            if (regionCode.length() <= 6 && regionCode.endsWith("00")) {
                regionCode = regionCode.replace("00", "");
            }
            sql = sql + " and tb.f_xzqdm like '" + regionCode + "%'";
            countSql = countSql + " and tb.f_xzqdm like '" + regionCode + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)existLian)) {
            sql = sql + " and ca.f_type = '" + existLian + "'";
            countSql = countSql + " and ca.f_type = '" + existLian + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)wflx)) {
            sql = sql + " and tb.f_wflx like '" + wflx + "%'";
            countSql = countSql + " and tb.f_wflx like '" + wflx + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)tbbh)) {
            sql = sql + " and tb.f_tbbh like '%" + wflx + "%'";
            countSql = countSql + " and tb.f_tbbh like '%" + wflx + "%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql = sql + " order by tb.f_createtime desc limit " + pageSize + " offset " + start;
        List maps = this.dataBizService.queryDataBySql(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class);
        result.put("datas", maps);
        result.put("totalNum", count);
        return result;
    }
}

