/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl.MJcClueSourceImpl;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueSourceMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MJcClueFieldsServiceImpl
implements MJcClueFieldsService {
    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    JcClueSourceMapper jcClueSourceMapper;
    @Autowired
    MJcClueSourceService jcClueSourceService;

    public int deleteByPrimaryKey(String fId) {
        return this.jcClueFieldsMapper.deleteByPrimaryKey((Object)fId);
    }

    public int insert(JcClueFields record) {
        return this.jcClueFieldsMapper.insert((Object)record);
    }

    public int insertSelective(JcClueFields record) {
        return this.jcClueFieldsMapper.insertSelective((Object)record);
    }

    public JcClueFields selectByPrimaryKey(String fId) {
        return (JcClueFields)this.jcClueFieldsMapper.selectByPrimaryKey((Object)fId);
    }

    public int updateByPrimaryKeySelective(JcClueFields record) {
        return this.jcClueFieldsMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(JcClueFields record) {
        return this.jcClueFieldsMapper.updateByPrimaryKey((Object)record);
    }

    public List<JcClueFields> findByTableName(String sourceId) {
        return this.jcClueFieldsMapper.findByTableName(sourceId);
    }

    public List<JcClueFields> findByTableId(String sourceId) {
        return this.jcClueFieldsMapper.findByTableId(sourceId);
    }

    public List<JcClueFields> getClueMustFieldsByTableid(String sourceId, Integer fIsMust) {
        return this.jcClueFieldsMapper.getClueMustFieldsByTableid(sourceId, fIsMust);
    }

    public List<JcClueFields> getClueUniqueFieldsByTableid(String sourceId, Integer fUnique) {
        return this.jcClueFieldsMapper.getClueUniqueFieldsByTableid(sourceId, fUnique);
    }

    public JcClueFields saveClueField(JcClueFields bean) {
        if (bean.getfTableid() != null) {
            JcClueFields oldField;
            JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)bean.getfTableid());
            if (jcClueSource != null && jcClueSource.getfTablename() != null) {
                if (!StringUtils.isEmpty((CharSequence)bean.getfId())) {
                    oldField = (JcClueFields)this.jcClueFieldsMapper.selectByPrimaryKey((Object)bean.getfId());
                    if (!oldField.getfAlias().equals(bean.getfAlias())) {
                        bean = this.changeFileName(bean);
                        this.jdbcTemplate.execute("ALTER TABLE " + jcClueSource.getfTablename() + " RENAME " + oldField.getfFieldname() + " to " + bean.getfFieldname());
                    }
                    this.jcClueFieldsMapper.updateByPrimaryKeySelective((Object)bean);
                    ArrayList<JcClueFields> fields = new ArrayList<JcClueFields>();
                    fields.add(bean);
                    StringBuilder sbSql = new StringBuilder();
                    sbSql.append(" ALTER TABLE ");
                    sbSql.append(jcClueSource.getfTablename());
                    sbSql.append("  alter  COLUMN ");
                    String sql = MJcClueSourceImpl.generateFieldSql(jcClueSource, fields);
                    sql = bean.getfFieldname() + " TYPE " + sql.replace(bean.getfFieldname(), "") + "  USING ( " + bean.getfFieldname() + "::" + sql.replace(bean.getfFieldname(), "") + ")";
                    sbSql.append(sql);
                    this.jdbcTemplate.execute(sbSql.toString());
                } else {
                    bean.setfId(UUID.randomUUID().toString());
                    bean = this.changeFileName(bean);
                    this.jcClueFieldsMapper.insertSelective((Object)bean);
                    ArrayList<JcClueFields> fields = new ArrayList<JcClueFields>();
                    fields.add(bean);
                    StringBuilder sbSql = new StringBuilder();
                    sbSql.append(" ALTER TABLE ");
                    sbSql.append(jcClueSource.getfTablename());
                    sbSql.append(" ADD COLUMN ");
                    String sql = MJcClueSourceImpl.generateFieldSql(jcClueSource, fields);
                    sbSql.append(sql);
                    this.jdbcTemplate.execute(sbSql.toString());
                }
                this.syncClueInfo(jcClueSource, bean.getfId(), 101L, "rootNode", "update");
                this.jcClueSourceService.defaultClueImportRel(jcClueSource.getfId());
            }
            if (!StringUtils.isEmpty((CharSequence)bean.getfId())) {
                oldField = (JcClueFields)this.jcClueFieldsMapper.selectByPrimaryKey((Object)bean.getfId());
                if (!oldField.getfAlias().equals(bean.getfAlias())) {
                    bean = this.changeFileName(bean);
                }
                this.jcClueFieldsMapper.updateByPrimaryKeySelective((Object)bean);
            } else {
                bean.setfId(UUID.randomUUID().toString());
                bean = this.changeFileName(bean);
                this.jcClueFieldsMapper.insertSelective((Object)bean);
            }
        }
        return bean;
    }

    public void syncClueInfo(JcClueSource jcClueSource, String fieldId, Long userId, String source, String type) {
        JSONObject params = new JSONObject();
        params.put("sourceId", (Object)jcClueSource.getfId());
        params.put("fieldId", (Object)fieldId);
        params.put("userId", (Object)userId);
        params.put("type", (Object)type);
        params.put("source", (Object)source);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(jcClueSource.getfId());
        record.setRead(Integer.valueOf(0));
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        record.setTaskName(jcClueSource.getfName());
        this.taskRecordService.save(record);
    }

    private JcClueFields changeFileName(JcClueFields field) {
        String alias = field.getfAlias();
        String pinYin = PinYinUtil.getFirstSpell((String)alias);
        if (pinYin.length() > 8) {
            pinYin = pinYin.substring(0, 8);
        }
        pinYin = "f_" + pinYin;
        Long count = this.jcClueFieldsMapper.countStartWithPinyin(field.getfTableid(), pinYin + "%");
        if (count > 0L && pinYin.length() > 7) {
            count = count + this.jcClueFieldsMapper.countStartWithPinyin(field.getfTableid(), pinYin.substring(0, pinYin.length() - 3) + "_n%");
        }
        if (count > 0L) {
            pinYin = pinYin.length() + 3 <= 10 ? pinYin + "_n" + count : pinYin.substring(0, pinYin.length() - 3) + "_n" + count;
        }
        field.setfFieldname(pinYin);
        return field;
    }

    public void saveFields(JcClueSource jcClueSource, String name, String type, String length, String flength, String notNull, String isBase, String isOutwork, String rname, String order, String isListShow, String isWebCheck, String isWebEdit, String isStatis, Integer fieldType, Boolean isSysField) {
        JcClueFields tbField = new JcClueFields();
        tbField.setfId(UUID.randomUUID().toString());
        tbField.setfAlias(rname);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(type);
        if (StringUtils.isNotBlank((CharSequence)order)) {
            tbField.setfOrder(Integer.valueOf(Integer.parseInt(order)));
        }
        if (StringUtils.isNotBlank((CharSequence)length)) {
            tbField.setfLength(Integer.valueOf(Integer.parseInt(length)));
        }
        if (StringUtils.isNotBlank((CharSequence)flength)) {
            tbField.setfPrecision(Integer.valueOf(Integer.parseInt(flength)));
        }
        if ("true".equals(notNull)) {
            tbField.setfNullable(Integer.valueOf(0));
        } else {
            tbField.setfNullable(Integer.valueOf(1));
        }
        if ("true".equals(isBase)) {
            tbField.setfIsBase(Integer.valueOf(1));
        } else {
            tbField.setfIsBase(Integer.valueOf(0));
        }
        if ("true".equals(isOutwork)) {
            tbField.setfIsOutwork(Integer.valueOf(1));
        } else {
            tbField.setfIsOutwork(Integer.valueOf(0));
        }
        if ("true".equals(isListShow)) {
            tbField.setfIsListShow(Integer.valueOf(1));
        } else {
            tbField.setfIsListShow(Integer.valueOf(0));
        }
        if ("true".equals(isWebCheck)) {
            tbField.setfIsWebCheck(Integer.valueOf(1));
        } else {
            tbField.setfIsWebCheck(Integer.valueOf(0));
        }
        if ("true".equals(isWebEdit)) {
            tbField.setfIsWebEdit(Integer.valueOf(1));
        } else {
            tbField.setfIsWebEdit(Integer.valueOf(0));
        }
        if ("true".equals(isStatis)) {
            tbField.setfIsStatis(Integer.valueOf(1));
        } else {
            tbField.setfIsStatis(Integer.valueOf(0));
        }
        tbField.setfFieldInnerOuterSys(fieldType);
        if ("int4".equals(type) && isSysField.booleanValue()) {
            tbField.setfDefaultvalue("0");
        }
        tbField.setfTablename(jcClueSource.getfTablename());
        tbField.setfTableid(jcClueSource.getfId());
        this.jcClueFieldsMapper.insertSelective((Object)tbField);
    }

    public void updateTableNameBytableId(String tableName, String tableId) {
        this.jcClueFieldsMapper.updateTableNameBytableId(tableName, tableId);
    }
}

