/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskDataLogRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.constants.UpResultErrorEnum;
import com.geoway.landteam.customtask.task.dto.TskUploadErrorLogDTO;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelData;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.pub.dto.ClueFieldsValueParamVo;
import com.geoway.landteam.landcloud.model.pub.dto.JcClueFilterVo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskImportTaskDataService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueAssignmentCondDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueAssignmentPmDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueFilterDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSplitMapDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSplitMapLayerDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSplitProgrammeDao;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldGroupViewMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueJudgeMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueNumMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueJudgeMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.CuleQueryParam;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueAssignmentCond;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueAssignmentPm;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFieldGroupView;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFilter;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRelView;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRelFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueJudge;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueNum;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSplitMap;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSplitMapLayer;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSplitProgramme;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskClueJudge;
import com.geoway.landteam.patrolclue.model.until.ShapeUtil;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRelService;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MJcClueServiceImpl
implements MJcClueService {
    private final GiLoger logger = GwLoger.getLoger(MJcClueServiceImpl.class);
    private static final String SHAPE_APPEND = "0";
    private static final String SHAPE_UPDATE = "1";
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionvillageDao;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;
    @Autowired
    RegionService regionService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;
    @Autowired
    JcClueImportRelService jcClueImportRelService;
    @Autowired
    JcClueFieldGroupViewMapper jcClueFieldGroupViewMapper;
    @Autowired
    JcClueJudgeMapper jcClueJudgeMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    JcClueNumMapper jcClueNumMapper;
    @Autowired
    JcTaskClueJudgeMapper jcTaskClueJudgeMapper;
    @Autowired
    JcClueFilterDao jcClueFilterDao;
    @Autowired
    MTaskImportTaskDataService taskImportTaskDataService;
    @Autowired
    JcClueAssignmentPmDao jcClueAssignmentPmDao;
    @Autowired
    JcClueAssignmentCondDao jcClueAssignmentCondDao;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JcClueSplitProgrammeDao jcClueSplitProgrammeDao;
    @Autowired
    JcClueSplitMapDao jcClueSplitMapDao;
    @Autowired
    JcClueSplitMapLayerDao jcClueSplitMapLayerDao;
    @Autowired
    TbtskDataLogService tbtskDataLogService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TbtskDataLogRepository tbtskDataLogRepository;

    @Transactional(rollbackFor={Exception.class})
    public void importData(MultipartFile multipartFile, JcClueSource jcClueSource, Long userid, String sjpc, String jcClueImportRels, Boolean isChange, String jcsj) throws Exception {
        List jcClueImportRelViews;
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u9519\u8bef");
        }
        File zipFile = null;
        File dir = new File(this.uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        zipFile = File.createTempFile("tmp", ".gty", dir);
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"");
        File file = new File(unzipFileDir);
        URL url = null;
        File[] content = file.listFiles();
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (!content[j].getName().endsWith(".shp")) continue;
            url = content[j].toURI().toURL();
            break;
        }
        if (url == null) {
            throw new RuntimeException("shape\u6587\u4ef6\u9519\u8bef");
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        String chasetStr = shpDataStore.getCharset().toString();
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = this.createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        SimpleFeature sf = null;
        FeatureCollection collection = featureSource.getFeatures();
        FeatureIterator itertor = collection.features();
        if (isChange.booleanValue() && !StringUtils.isEmpty((CharSequence)jcClueImportRels)) {
            JSONArray objects = JSONArray.parseArray((String)jcClueImportRels, (Feature[])new Feature[0]);
            List jcClueImportRelList = objects.toJavaList(JcClueImportRel.class);
            for (JcClueImportRel bean : jcClueImportRelList) {
                this.jcClueImportRelService.updateByPrimaryKey(bean);
            }
        }
        if ((jcClueImportRelViews = this.jcClueImportRelService.selectBySourceId(jcClueSource.getfId())).isEmpty()) {
            throw new RuntimeException("\u7f3a\u5c11\u5bfc\u5165\u914d\u7f6e");
        }
        ArrayList addDataCacheList = new ArrayList();
        int count = 0;
        Double area = 0.0;
        String id = UUID.randomUUID().toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (itertor.hasNext()) {
            System.out.println("\u672c\u6b21\u56fe\u6591\u603b\u6570\u91cf\uff1a" + collection.size() + "\uff0c\u5f53\u524d\u6b63\u5728\u5904\u7406\u7b2c" + ++count + "\u6761\u6570\u636e...");
            HashMap<String, Object> map = new HashMap<String, Object>();
            sf = (SimpleFeature)itertor.next();
            Geometry geo = (Geometry)sf.getDefaultGeometry();
            if (geo == null) continue;
            map.clear();
            Point pt = geo.getCentroid();
            int proNum = this.getColNum(pt.getX());
            HashMap<String, Object> map1 = null;
            try {
                map1 = this.getXzqdmSys((Geometry)pt, geo, proNum);
                if (map1 != null && map1.size() > 0) {
                    map.put("f_xzqdm", map1.get("xzqdmsys"));
                    map.put("f_xzqmc", map1.get("xzqmc"));
                    map.put("f_location", map1.get("location"));
                    map.put("f_area", map1.get("area"));
                    area = area + Double.valueOf(map1.get("area").toString());
                }
            }
            catch (SQLException e) {
                this.logger.error("getXzqdmSys\u9519\u8bef\uff1a" + e.getMessage(), new Object[0]);
            }
            map.put("f_shape", geo);
            map.put("f_sjpc", sjpc);
            map.put("f_status", 0);
            map.put("f_userid", userid.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000L);
            map.put("f_import_recordid", id);
            block21: for (int i = 0; i < jcClueImportRelViews.size(); ++i) {
                JcClueImportRelView t = (JcClueImportRelView)jcClueImportRelViews.get(i);
                if ("f_shape".equalsIgnoreCase(t.getfFieldname()) || "f_sjpc".equalsIgnoreCase(t.getfFieldname()) || "f_sourceid".equalsIgnoreCase(t.getfFieldname())) continue;
                String strValue = this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr);
                switch (this.conType(t.getfFieldtype())) {
                    case "varchar": {
                        map.put(t.getfFieldname(), this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr));
                        continue block21;
                    }
                    case "text": {
                        map.put(t.getfFieldname(), this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr));
                        continue block21;
                    }
                    case "decimal": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block21;
                        Double value2 = Double.valueOf(strValue);
                        map.put(t.getfFieldname(), value2);
                        continue block21;
                    }
                    case "timestamp": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block21;
                        Date date = df.parse(strValue);
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(t.getfFieldname(), value5);
                        continue block21;
                    }
                    case "int4": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block21;
                        Integer value3 = Integer.valueOf(strValue);
                        map.put(t.getfFieldname(), value3);
                        continue block21;
                    }
                    case "geometry": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block21;
                        Geometry geo1 = WKTUtil.wktToGeom((String)strValue);
                        if (geo == null) continue block21;
                        map.put(t.getfFieldname(), WKTUtil.geomToWkt((Geometry)geo1));
                        continue block21;
                    }
                }
            }
            if (map.containsKey("f_id")) {
                if (StringUtils.isBlank((CharSequence)map.get("f_id").toString())) {
                    map.put("f_id", UUID.randomUUID().toString());
                }
            } else {
                map.put("f_id", UUID.randomUUID().toString());
            }
            addDataCacheList.add(map);
            if (addDataCacheList.size() != 200) continue;
            this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        if (!addDataCacheList.isEmpty()) {
            this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        shpDataStore.dispose();
        JcClueImportRecord record = new JcClueImportRecord();
        record.setfId(id);
        record.setfCreatetime(new Date());
        record.setfName(sjpc);
        record.setfSourceid(jcClueSource.getfId());
        record.setfCount(Integer.valueOf(count));
        record.setfJcmj(new BigDecimal(area));
        record.setfJcsj(jcsj);
        this.jcClueImportRecordService.insert(record);
    }

    public void asynImportData1(MultipartFile multipartFile, JcClueSource jcClueSource, Long userId, String sjpc, String jcClueImportRels, Boolean isChange, String jcsj) throws Exception {
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u9519\u8bef");
        }
        File zipFile = null;
        File dir = new File(this.uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        zipFile = File.createTempFile("tmp", ".gty", dir);
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"");
        String fileName = UUID.randomUUID().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = sdf.format(new Date());
        String obsFilePath = "importClueData/" + dateString + "/" + zipFile.getName();
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);
        String id = UUID.randomUUID().toString();
        JSONObject params = new JSONObject();
        params.put("unzipFileDir", (Object)resultUrl);
        params.put("userId", (Object)userId);
        params.put("sjpc", (Object)sjpc);
        params.put("jcClueImportRels", (Object)jcClueImportRels);
        params.put("isChange", (Object)isChange);
        params.put("jcsj", (Object)jcsj);
        params.put("sourceId", (Object)jcClueSource.getfId());
        params.put("importId", (Object)id);
        TaskRecord record = new TaskRecord();
        record.setId(id);
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_CULEDATA_IMPORT);
        record.setData(resultUrl);
        record.setBizId(jcClueSource.getfId());
        record.setRead(Integer.valueOf(0));
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        record.setTaskName(sjpc);
        this.taskRecordService.save(record);
        JcClueImportRecord bean = new JcClueImportRecord();
        bean.setfId(id);
        bean.setfCreatetime(new Date());
        bean.setfName(sjpc);
        bean.setfSourceid(jcClueSource.getfId());
        bean.setfCount(Integer.valueOf(0));
        bean.setfJcmj(new BigDecimal(0));
        bean.setfJcsj(jcsj);
        this.jcClueImportRecordService.insert(bean);
    }

    public void deleteClueDatas(String sourceId, String recordId, String clueIds) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)clueIds)) {
            List<String> ids = Arrays.asList(clueIds.split(","));
            String id = "";
            if (ids.size() > 0) {
                for (String s : ids) {
                    id = id + "'" + s + "',";
                }
            }
            String sql = "delete from " + jcClueSource.getfTablename() + " where f_id in (" + id.substring(0, id.length() - 1) + ")";
            this.jdbcTemplate.execute(sql);
            JcClueImportRecord jcClueImportRecord = this.jcClueImportRecordService.selectByPrimaryKey(recordId);
            jcClueImportRecord.setfCount(Integer.valueOf(jcClueImportRecord.getfCount() - ids.size()));
            this.jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
        } else if (StringUtils.isNotBlank((CharSequence)recordId)) {
            String sql = "delete from " + jcClueSource.getfTablename() + " where f_import_recordid = '" + recordId + "'";
            this.jdbcTemplate.execute(sql);
            this.jcClueImportRecordService.deleteByPrimaryKey(recordId);
        }
    }

    public void handleImportData(TaskRecord record) throws Exception {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{record.getParam()})) {
            JSONObject jsonObject = JSONObject.parseObject((String)record.getParam());
            String sjpc = jsonObject.getString("sjpc");
            String jcClueImportRels = jsonObject.getString("jcClueImportRels");
            Boolean isChange = jsonObject.getBoolean("isChange");
            String jcsj = jsonObject.getString("jcsj");
            Long userId = jsonObject.getLong("userId");
            String sourceId = jsonObject.getString("sourceId");
            String importId = jsonObject.getString("importId");
            HttpURLConnection httpURLConnection = null;
            String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", jsonObject.getString("unzipFileDir"), null);
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            URLConnection con = url.openConnection();
            File zipFile = null;
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"");
            ArrayList<Map<String, Object>> dataLog = new ArrayList<Map<String, Object>>();
            JSONObject resultObject = new JSONObject();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            resultObject.put("uploadTime", (Object)simpleDateFormat.format(record.getStarttime()));
            resultObject.put("completeTime", (Object)simpleDateFormat.format(new Date()));
            resultObject.put("userId", (Object)userId);
            try {
                Map<String, Object> map = this.importData(unzipFileDir, sourceId, importId, userId, sjpc, jcClueImportRels, isChange, jcsj, dataLog);
                resultObject.put("totalNum", (Object)map.get("count").toString());
                resultObject.put("successNum", (Object)map.get("count").toString());
                resultObject.put("failNum", (Object)0);
                resultObject.put("logAddr", null);
                record.setResult(JSONObject.toJSONString((Object)resultObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                record.setEndtime(new Date());
                this.taskRecordService.save(record);
            }
            catch (Exception e) {
                resultObject.put("totalNum", (Object)0);
                resultObject.put("successNum", (Object)0);
                resultObject.put("failNum", (Object)0);
                if (dataLog.size() > 0) {
                    String logAddr = this.createLog(userId, dataLog, record);
                    resultObject.put("logAddr", (Object)logAddr);
                }
                record.setResult(JSONObject.toJSONString((Object)resultObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                record.setEndtime(new Date());
                this.taskRecordService.save(record);
                throw new GwValidateException(e.getMessage());
            }
        }
    }

    public Map<String, Object> importData(String unzipFileDir, String sourceId, String importId, Long userid, String sjpc, String jcClueImportRels, Boolean isChange, String jcsj, List<Map<String, Object>> dataLog) throws Exception {
        String rootSourceId;
        List jcClueImportRelViews;
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        File file = new File(unzipFileDir);
        URL url = null;
        File[] content = file.listFiles();
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (!content[j].getName().endsWith(".shp")) continue;
            url = content[j].toURI().toURL();
            break;
        }
        if (url == null) {
            errorMap.put("objectId", 0);
            errorMap.put("type", "error");
            errorMap.put("result", "shape\u6587\u4ef6\u9519\u8bef");
            dataLog.add(errorMap);
            throw new GwValidateException("shape\u6587\u4ef6\u9519\u8bef");
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        String chasetStr = shpDataStore.getCharset().toString();
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = this.createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        SimpleFeature sf = null;
        FeatureCollection collection = featureSource.getFeatures();
        FeatureIterator itertor = collection.features();
        if (isChange.booleanValue() && !StringUtils.isEmpty((CharSequence)jcClueImportRels)) {
            JSONArray objects = JSONArray.parseArray((String)jcClueImportRels, (Feature[])new Feature[0]);
            List jcClueImportRelList = objects.toJavaList(JcClueImportRel.class);
            for (JcClueImportRel bean : jcClueImportRelList) {
                this.jcClueImportRelService.updateByPrimaryKey(bean);
            }
        }
        if ((jcClueImportRelViews = this.jcClueImportRelService.selectBySourceId(rootSourceId = jcClueSource.getfId())).isEmpty()) {
            errorMap.put("objectId", 0);
            errorMap.put("type", "error");
            errorMap.put("result", "\u7f3a\u5c11\u5bfc\u5165\u914d\u7f6e");
            dataLog.add(errorMap);
            throw new RuntimeException("\u7f3a\u5c11\u5bfc\u5165\u914d\u7f6e");
        }
        ArrayList addDataCacheList = new ArrayList();
        int count = 0;
        Double area = 0.0;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (itertor.hasNext()) {
            ++count;
            HashMap<String, Object> map = new HashMap<String, Object>();
            sf = (SimpleFeature)itertor.next();
            Geometry geo = (Geometry)sf.getDefaultGeometry();
            if (geo == null) continue;
            map.clear();
            Point pt = geo.getCentroid();
            int proNum = this.getColNum(pt.getX());
            HashMap<String, Object> map1 = null;
            List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
            List fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            try {
                map1 = this.getXzqdmSys((Geometry)pt, geo, proNum);
                if (map1 != null && map1.size() > 0) {
                    map.put("f_xzqdm", map1.get("xzqdmsys"));
                    map.put("f_xzqmc", map1.get("xzqmc"));
                    map.put("f_location", map1.get("location"));
                    map.put("f_area", map1.get("area"));
                    area = area + Double.valueOf(map1.get("area").toString());
                    if (fields.contains("f_xzqdmcity") && StringUtils.isNotBlank((CharSequence)((String)map1.get("xzqdmsys")))) {
                        map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0, 4) + "00");
                        map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0, 6));
                        map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0, 9));
                        map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
                    }
                }
            }
            catch (SQLException e2) {
                this.logger.error("getXzqdmSys\u9519\u8bef\uff1a" + e2.getMessage(), new Object[0]);
            }
            map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
            map.put("f_sjpc", sjpc);
            map.put("f_status", Character.valueOf('0'));
            map.put("f_state", Character.valueOf('0'));
            map.put("f_stage", Character.valueOf('1'));
            map.put("f_analysis", Character.valueOf('0'));
            if (fields.contains("f_registerstatus")) {
                map.put("f_registerstatus", Character.valueOf('0'));
                map.put("f_mergestatus", Character.valueOf('0'));
            }
            map.put("f_userid", userid.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000L);
            map.put("f_import_recordid", importId);
            block23: for (int i = 0; i < jcClueImportRelViews.size(); ++i) {
                JcClueImportRelView t = (JcClueImportRelView)jcClueImportRelViews.get(i);
                if ("f_shape".equalsIgnoreCase(t.getfFieldname()) || "f_sjpc".equalsIgnoreCase(t.getfFieldname()) || "f_sourceid".equalsIgnoreCase(t.getfFieldname())) continue;
                String strValue = this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr);
                switch (this.conType(t.getfFieldtype())) {
                    case "varchar": {
                        map.put(t.getfFieldname(), this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr));
                        continue block23;
                    }
                    case "text": {
                        map.put(t.getfFieldname(), this.getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr));
                        continue block23;
                    }
                    case "decimal": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block23;
                        Double value2 = Double.valueOf(strValue);
                        map.put(t.getfFieldname(), value2);
                        continue block23;
                    }
                    case "timestamp": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block23;
                        try {
                            Date date = df.parse(strValue);
                            Timestamp value5 = new Timestamp(date.getTime());
                            map.put(t.getfFieldname(), value5);
                        }
                        catch (Exception e3) {
                            DateTimeFormatter df1 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                            LocalDateTime localDateTime = LocalDateTime.parse(strValue, df1);
                            Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                            Timestamp value5 = new Timestamp(date.getTime());
                            map.put(t.getfFieldname(), value5);
                        }
                        continue block23;
                    }
                    case "int4": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block23;
                        Integer value3 = Integer.valueOf(strValue);
                        map.put(t.getfFieldname(), value3);
                        continue block23;
                    }
                    case "geometry": {
                        if (StringUtils.isBlank((CharSequence)strValue)) continue block23;
                        Geometry geo1 = WKTUtil.wktToGeom((String)strValue);
                        if (geo == null) continue block23;
                        map.put(t.getfFieldname(), WKTUtil.geomToWkt((Geometry)geo1));
                        continue block23;
                    }
                }
            }
            if (map.containsKey("f_id")) {
                if (StringUtils.isBlank((CharSequence)map.get("f_id").toString())) {
                    map.put("f_id", UUID.randomUUID().toString());
                }
            } else {
                map.put("f_id", UUID.randomUUID().toString());
            }
            addDataCacheList.add(map);
            if (addDataCacheList.size() != 200) continue;
            this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        if (!addDataCacheList.isEmpty()) {
            this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        shpDataStore.dispose();
        JcClueImportRecord record = this.jcClueImportRecordService.selectByPrimaryKey(importId);
        record.setfCount(Integer.valueOf(count));
        record.setfJcmj(new BigDecimal(area));
        this.jcClueImportRecordService.updateByPrimaryKeySelective(record);
        resultMap.put("count", count);
        return resultMap;
    }

    public static Geometry wktToGeom(String wkt) throws org.locationtech.jts.io.ParseException {
        Geometry geometry = null;
        WKTReader reader = new WKTReader();
        geometry = reader.read(wkt);
        geometry.setSRID(4490);
        return geometry;
    }

    public void handleCuleDataAsyncImport(TaskRecord record) throws Exception {
        TbtskDataLog tbtskDataLog;
        HttpURLConnection conn;
        block11: {
            String uploadurl;
            JSONObject paramsObject;
            Long userId;
            JcClueSource jcClueSource;
            HashMap<String, TskUploadLogDTO> dataUploadLog;
            block10: {
                this.logger.info("\u7ebf\u7d22\u5bfc\u5165\u4efb\u52a1:" + record.getId() + "\u5f00\u59cb", new Object[0]);
                conn = null;
                dataUploadLog = new HashMap<String, TskUploadLogDTO>();
                jcClueSource = new JcClueSource();
                tbtskDataLog = new TbtskDataLog();
                TskUploadErrorLogDTO erros = new TskUploadErrorLogDTO();
                userId = null;
                paramsObject = JSONObject.parseObject((String)record.getParam());
                userId = paramsObject.getLongValue("userId");
                String sourceId = paramsObject.getString("sourceId");
                String tbtskDataLogId = paramsObject.getString("tbtskDataLogId");
                jcClueSource = this.jcClueSourceService.findOne(sourceId);
                tbtskDataLog = (TbtskDataLog)this.tbtskDataLogRepository.findById((Object)tbtskDataLogId).get();
                uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
                if (!paramsObject.containsKey((Object)"batch") || !paramsObject.get((Object)"batch").equals(true)) break block10;
                this.clueDataBatchImport(tbtskDataLog, record, paramsObject, uploadurl);
                this.redisTemplate.opsForHash().delete((Object)"JOB_WEB_ID", new Object[]{tbtskDataLog.getId()});
                if (conn != null) {
                    conn.disconnect();
                }
                return;
            }
            try {
                URL url = new URL(uploadurl);
                this.logger.info("\u7ebf\u7d22\u5bfc\u5165\u4efb\u52a1:" + record.getId() + "\u6570\u636eurl:" + uploadurl, new Object[0]);
                if (url == null) break block11;
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("Charset", "UTF-8");
                File zipFile = null;
                File dir = new File(this.uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = File.createTempFile("tmp", ".gty", dir);
                FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)zipFile);
                String zipName = zipFile.getAbsolutePath();
                String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
                String batchId = paramsObject.getString("batchId");
                Map<String, List<String>> tempIds = this.importTaskData(1, tbtskDataLog.getId(), record, unzipFileDir, jcClueSource, userId, paramsObject.getString("updateType"), dataUploadLog, batchId);
                HashMap<String, List> ids = new HashMap<String, List>();
                ids.computeIfAbsent("ADD", k -> new ArrayList()).addAll(tempIds.getOrDefault("ADD", new ArrayList()));
                ids.computeIfAbsent("UPDATE", k -> new ArrayList()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList()));
                this.createOrUpdateLog(tbtskDataLog, userId, dataUploadLog, jcClueSource);
                zipFile.delete();
                record.setLog(tbtskDataLog.getLogUrl());
                this.taskRecordService.save(record);
            }
            catch (Exception e) {
                try {
                    this.logger.error("\u7ebf\u7d22\u5bfc\u5165\u4efb\u52a1:" + record.getId() + "\u5f02\u5e38" + e.getMessage() + " " + ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
                    if (conn != null) {
                        conn.disconnect();
                    }
                    this.createOrUpdateLog(tbtskDataLog, userId, dataUploadLog, jcClueSource);
                    record.setLog(tbtskDataLog.getLogUrl());
                    this.taskRecordService.save(record);
                    throw new GwValidateException(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.redisTemplate.opsForHash().delete((Object)"JOB_WEB_ID", new Object[]{tbtskDataLog.getId()});
                    if (conn != null) {
                        conn.disconnect();
                    }
                    throw throwable;
                }
            }
        }
        this.redisTemplate.opsForHash().delete((Object)"JOB_WEB_ID", new Object[]{tbtskDataLog.getId()});
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clueDataBatchImport(TbtskDataLog tbtskDataLog, TaskRecord record, JSONObject paramsObject, String uploadurl) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        HttpURLConnection httpURLConnection = null;
        String sourceId = paramsObject.getString("sourceId");
        Long userId = paramsObject.getLongValue("userId");
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        ArrayList<Map<String, TskUploadLogDTO>> allDataUploadLogList = new ArrayList<Map<String, TskUploadLogDTO>>();
        ArrayList errosList = new ArrayList();
        ArrayList<String> fileNameList = new ArrayList<String>();
        try {
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            URLConnection con = url.openConnection();
            File zipFile = null;
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".zip", dir);
            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019", (String)"UTF-8");
            File file = new File(unzipFileDir);
            File[] content = file.listFiles();
            int gtyFileNum = Arrays.stream(content).filter(u -> u.getName().endsWith(".gty")).collect(Collectors.toList()).size();
            int ln = content.length;
            for (int j = 0; j < ln; ++j) {
                if (!content[j].getName().endsWith(".gty")) continue;
                this.dealSingleClueGty(gtyFileNum, tbtskDataLog.getId(), record, content[j], allDataUploadLogList);
                fileNameList.add(content[j].getName());
            }
            this.createBatchClueLog(tbtskDataLog, userId, allDataUploadLogList, jcClueSource, fileNameList);
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(3));
            this.taskRecordService.save(record);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.createBatchClueLog(tbtskDataLog, userId, allDataUploadLogList, jcClueSource, fileNameList);
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(4));
            record.setRemark(e.getMessage());
            this.taskRecordService.save(record);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.logger.info("JobRunTask-rateJobDataImportInner \u5e73\u53f0\u4efb\u52a1\u6570\u636e\u52a0\u8f7d\u6267\u884c\u7ed3\u675f" + record.getId() + "-" + record.getState() + "-" + df.format(new Date()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBatchClueLog(TbtskDataLog tbtskDataLog, Long userId, List<Map<String, TskUploadLogDTO>> dataUploadLogList, JcClueSource jcClueSource, List<String> fileNameList) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = jcClueSource.getfName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
        String fileName1 = jcClueSource.getfName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
        String localFullFileName = tempDir + "/" + fileName;
        WritableWorkbook wwb = null;
        try {
            File file = new File(localFullFileName);
            if (wwb == null || wwb.getSheets() == null || wwb.getSheets().length <= 0) {
                wwb = Workbook.createWorkbook((File)file);
            }
            int i = 0;
            for (Map<String, TskUploadLogDTO> dataUploadLog : dataUploadLogList) {
                String gtyName = fileNameList.get(i);
                Integer successCount = 0;
                Integer failCount = 0;
                Integer skipCount = 0;
                if (dataUploadLog.isEmpty()) continue;
                String name = this.landUserRepository.queryUserById(userId).getName();
                ArrayList<Object> data = new ArrayList<Object>();
                if (dataUploadLog.size() == 1 && dataUploadLog.containsKey("error")) {
                    Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataUploadLog.get("error")), Map.class);
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    map.put("error", map.get("errorInfo"));
                    map.put("updateType", map.get("uploadType"));
                    failCount = failCount + Integer.valueOf(map.get("failNum").toString());
                    data.add(map);
                } else {
                    for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                        Map map = entry.getValue().toMap();
                        map.put("uploadUser", name);
                        map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        successCount = successCount + Integer.valueOf(map.get("success").toString());
                        failCount = failCount + Integer.valueOf(map.get("fail").toString());
                        skipCount = skipCount + Integer.valueOf(map.get("skip").toString());
                        data.add(map);
                    }
                }
                String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
                String colName = TskUploadLogDTO.getExcelColName() + ",\u4e0a\u4f20\u4eba,\u4e0a\u4f20\u65f6\u95f4";
                ArrayList<ExcelData> excelDataLst = new ArrayList<ExcelData>();
                ExcelData dataHz = new ExcelData();
                dataHz.setData(data);
                dataHz.setCol(col);
                dataHz.setHeader(colName);
                dataHz.setSheetIndex(i++);
                dataHz.setSheetName(gtyName);
                excelDataLst.add(dataHz);
                try {
                    ExcelUtil.createAndWriteExcelMultipleSheets((WritableWorkbook)wwb, excelDataLst);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            wwb.write();
            wwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sendObjName = "taskManagerUploadLog/" + fileName1;
        String downloadPath = this.ossOperatorService.sendObject2Oss(sendObjName, localFullFileName);
        tbtskDataLog.setLogUrl(downloadPath);
        this.tbtskDataLogService.saveDataLog(tbtskDataLog);
    }

    public void createOrUpdateLog(TbtskDataLog tbtskDataLog, Long userId, Map<String, TskUploadLogDTO> dataUploadLog, JcClueSource jcClueSource) {
        Integer successCount = 0;
        Integer failCount = 0;
        Integer skipCount = 0;
        if (!dataUploadLog.isEmpty()) {
            String name = this.landUserRepository.queryUserById(userId).getName();
            ArrayList<Object> data = new ArrayList<Object>();
            if (dataUploadLog.size() == 1 && dataUploadLog.containsKey("error")) {
                Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error", map.get("errorInfo"));
                map.put("updateType", map.get("uploadType"));
                failCount = failCount + Integer.valueOf(map.get("failNum").toString());
                data.add(map);
            } else {
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    successCount = successCount + Integer.valueOf(map.get("success").toString());
                    failCount = failCount + Integer.valueOf(map.get("fail").toString());
                    skipCount = skipCount + Integer.valueOf(map.get("skip").toString());
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = jcClueSource.getfName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
            String fileName1 = jcClueSource.getfName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",\u4e0a\u4f20\u4eba,\u4e0a\u4f20\u65f6\u95f4";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, (String)tempDir, (String)fileName, (String)col, (String)colName, (String)"\u65e5\u5fd7\u5bfc\u51fa");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = this.ossOperatorService.sendObject2Oss(sendObjName, filePath);
            tbtskDataLog.setLogUrl(downloadPath);
            tbtskDataLog.setSuccessCount(successCount.toString());
            tbtskDataLog.setFailCount(failCount.toString());
            tbtskDataLog.setSkipCount(skipCount.toString());
            this.tbtskDataLogService.saveDataLog(tbtskDataLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealSingleClueGty(int gtyFileNum, String tskDataLogId, TaskRecord record, File item, List<Map<String, TskUploadLogDTO>> allDataUploadLogList) {
        HashMap<String, TskUploadLogDTO> dataUploadLog = new HashMap<String, TskUploadLogDTO>();
        Long userId = null;
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            userId = paramsObject.getLongValue("userId");
            String sourceId = paramsObject.getString("sourceId");
            JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File zipFile = File.createTempFile("tmp", ".gty", dir);
            FileInputStream fileInputStream = new FileInputStream(item);
            FileUtils.copyInputStreamToFile((InputStream)fileInputStream, (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
            String batchId = paramsObject.getString("batchId");
            Map<String, List<String>> tempIds = this.importTaskData(gtyFileNum, tskDataLogId, record, unzipFileDir, jcClueSource, userId, paramsObject.getString("updateType"), dataUploadLog, batchId);
            HashMap<String, List> ids = new HashMap<String, List>();
            ids.computeIfAbsent("ADD", k -> new ArrayList()).addAll(tempIds.getOrDefault("ADD", new ArrayList()));
            ids.computeIfAbsent("UPDATE", k -> new ArrayList()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList()));
            allDataUploadLogList.add(dataUploadLog);
            zipFile.delete();
        }
        catch (Exception e) {
            this.logger.error("\u7ebf\u7d22\u5bfc\u5165\u4efb\u52a1:" + record.getId() + "\u5f02\u5e38" + e.getMessage() + " " + ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
            allDataUploadLogList.add(dataUploadLog);
        }
    }

    public Map<String, List<String>> importTaskData(int gtyFileNum, String tskDataLogId, TaskRecord taskRecord, String unzipFileDir, JcClueSource jcClueSource, Long userId, String updateType, Map<String, TskUploadLogDTO> dataUploadLog, String batchId) throws Exception {
        JSONObject jsonParam = JSONObject.parseObject((String)taskRecord.getParam());
        URL url = null;
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (!content[j].getName().endsWith(".shp")) continue;
            url = content[j].toURI().toURL();
            break;
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        String chasetStr = shpDataStore.getCharset().toString();
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = this.createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        SimpleFeature sf = null;
        FeatureCollection collection = featureSource.getFeatures();
        List attributeDescriptors = ((SimpleFeatureType)collection.getSchema()).getAttributeDescriptors();
        List mustFields = this.jcClueFieldsService.getClueMustFieldsByTableid(jcClueSource.getfId(), Integer.valueOf(1));
        if (!mustFields.isEmpty()) {
            List fieldNames = attributeDescriptors.stream().map(a -> a.getLocalName()).collect(Collectors.toList());
            for (JcClueFields mustField : mustFields) {
                if (fieldNames.contains(mustField.getfFieldname())) continue;
                TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
                tskUploadLogDTO.setUploadType(SHAPE_APPEND.equals(updateType) ? "\u8ffd\u52a0" : "\u8986\u76d6");
                tskUploadLogDTO.setErrorInfo("\u5fc5\u6709\u5b57\u6bb5" + mustField.getfAlias() + "\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u6570\u636e\u3002");
                dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
                throw new RuntimeException("\u5fc5\u6709\u5b57\u6bb5" + mustField.getfAlias() + "\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u6570\u636e\u3002");
            }
        }
        if (collection.size() > 20000) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("\u52a0\u8f7d\u7ebf\u7d22\u6570\u91cf\u4e00\u6b21\u4e0d\u80fd\u8d85\u8fc720000");
            tskUploadLogDTO.setUploadType(SHAPE_APPEND.equals(updateType) ? "\u8ffd\u52a0" : "\u8986\u76d6");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("\u52a0\u8f7d\u7ebf\u7d22\u6570\u91cf\u4e00\u6b21\u4e0d\u80fd\u8d85\u8fc720000");
        }
        FeatureIterator itertor = collection.features();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<Map<String, Object>> addDataCacheList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateDataCacheList = new ArrayList<Map<String, Object>>();
        List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
        List uniqueFields = this.jcClueFieldsService.getClueUniqueFieldsByTableid(jcClueSource.getfId(), Integer.valueOf(1));
        if (uniqueFields.isEmpty()) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("\u552f\u4e00\u503c\u5b57\u6bb5\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u4efb\u52a1\u914d\u7f6e\u3002");
            tskUploadLogDTO.setUploadType(SHAPE_APPEND.equals(updateType) ? "\u8ffd\u52a0" : "\u8986\u76d6");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("\u552f\u4e00\u503c\u5b57\u6bb5\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u4efb\u52a1\u914d\u7f6e\u3002");
        }
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        int s = 0;
        int importTbSize = collection.size();
        while (itertor.hasNext()) {
            String importProgress = new BigDecimal((double)(++s) * 100.0 / (double)importTbSize / (double)gtyFileNum).setScale(2, 4).toString() + "%";
            this.redisTemplate.opsForHash().put((Object)"JOB_WEB_ID", (Object)tskDataLogId, (Object)importProgress);
            sf = (SimpleFeature)itertor.next();
            Map<String, Object> result = this.saveData(jcClueSource, sf, chasetStr, userId.toString(), updateType, addDataCacheList, updateDataCacheList, allFields, uniqueFields, null, batchId, defaultVersion);
            UpResultEnum r = (UpResultEnum)result.get("type");
            String xzqdm = (String)result.get("xzqdm") == null || "".equals((String)result.get("xzqdm")) ? "\u653f\u533a\u4ee3\u7801" : (String)result.get("xzqdm");
            TskUploadLogDTO tskUploadLogDTO = dataUploadLog.computeIfAbsent(xzqdm, k -> new TskUploadLogDTO(xzqdm, updateType));
            tskUploadLogDTO.addTotal(Long.valueOf(1L));
            switch (r) {
                case ADD: {
                    tskUploadLogDTO.addSuccessNum(Long.valueOf(1L));
                    map.computeIfAbsent("ADD", k -> new ArrayList()).add((String)result.get("f_id"));
                    break;
                }
                case UPDATE: {
                    tskUploadLogDTO.addSuccessNum(Long.valueOf(1L));
                    map.computeIfAbsent("UPDATE", k -> new ArrayList()).add((String)result.get("f_id"));
                    break;
                }
                case SKIP: {
                    tskUploadLogDTO.addSkipNum(Long.valueOf(1L));
                    break;
                }
                case ERROR: {
                    Map errorEnumLongMap = tskUploadLogDTO.getErrorEnumLongMap();
                    UpResultErrorEnum e = (UpResultErrorEnum)result.getOrDefault("error", UpResultErrorEnum.OTHER);
                    errorEnumLongMap.merge(e, 1L, (oldValue, newValue) -> oldValue + newValue);
                    tskUploadLogDTO.addFailNum(Long.valueOf(1L)).appendErrorInfo((String)result.getOrDefault("errorInfo", ""));
                    break;
                }
            }
            if (addDataCacheList.size() == 200) {
                this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
                addDataCacheList.clear();
                this.logger.info("\u6570\u91cf----------------" + s, new Object[0]);
            }
            if (s % 200 != 0) continue;
            jsonParam.put("curCount", (Object)s);
            taskRecord.setParam(jsonParam.toJSONString());
            this.taskRecordService.save(taskRecord);
        }
        jsonParam.put("curCount", (Object)s);
        taskRecord.setParam(jsonParam.toJSONString());
        this.taskRecordService.save(taskRecord);
        this.logger.info("\u6570\u636e\u52a0\u8f7d\u6700\u540e\u4e00\u6b65-------------" + s, new Object[0]);
        if (!addDataCacheList.isEmpty()) {
            this.dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        if (StringUtils.isNotBlank((CharSequence)batchId)) {
            JcClueImportRecord record = this.jcClueImportRecordService.selectByPrimaryKey(batchId);
            String sql = "select count(1) count,sum(f_area) area  from " + jcClueSource.getfTablename() + " where f_import_recordid  ='" + batchId + "';";
            List list = this.jdbcTemplate.queryForList(sql);
            if (!list.isEmpty() && list.size() > 0) {
                String count = ((Map)list.get(0)).get("count").toString();
                String area = ((Map)list.get(0)).get("area").toString();
                record.setfJcmj(new BigDecimal(Double.valueOf(area)));
                record.setfCount(Integer.valueOf(Integer.parseInt(count)));
                this.jcClueImportRecordService.updateByPrimaryKeySelective(record);
            }
        }
        return map;
    }

    private Map<String, Object> saveData(JcClueSource jcClueSource, SimpleFeature sf, String chasetStr, String userId, String updateType, List<Map<String, Object>> addDataList, List<Map<String, Object>> updateDataList, List<JcClueFields> allFields, List<JcClueFields> uniqueFields, Set<String> areaCodes, String batchId, RegionVersion defaultVersion) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<String> fieldDefault = new ArrayList<String>();
        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Integer outWork = -1;
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (JcClueFields field : allFields) {
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType((String)fieldType);
            alias = field.getfAlias();
            outWork = field.getfIsWebCheck();
            if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName) || "f_shape".equals(fieldName)) continue;
            if (field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue())) {
                fieldDefault.add(fieldName);
            }
            map.put(fieldName, field.getfDefaultvalue());
            Boolean dataType = false;
            if ("f_shape".equalsIgnoreCase(fieldName)) {
                if (fieldType.equalsIgnoreCase("geometry")) {
                    Geometry geo = (Geometry)sf.getDefaultGeometry();
                    if (geo.getGeometryType().equals("Polygon") || geo.getGeometryType().equals("MultiPolygon")) {
                        dataType = true;
                    }
                } else {
                    dataType = false;
                }
                if (!dataType.booleanValue()) {
                    String xzqdm = (String)map.get("f_xzqdm");
                    result.put("xzqdm", xzqdm);
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.DATA_TYPE_ERROR);
                    result.put("errorInfo", "\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d");
                    return result;
                }
            }
            boolean isOut = (field.getfFieldInnerOuterSys() & 2) == 2;
            this.addDatatoMap(map, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field.getfNullable(), field.getfOrder(), field.getfDefaultvalue());
            if (!SHAPE_UPDATE.equals(updateType) || (field.getfFieldInnerOuterSys() & 1) != 1) continue;
            updateMap.put(fieldName, field.getfDefaultvalue());
            this.addDatatoMap(updateMap, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field.getfNullable(), field.getfOrder(), field.getfDefaultvalue());
        }
        List fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_sjpc", batchId);
        map.put("f_status", Character.valueOf('0'));
        map.put("f_state", Character.valueOf('0'));
        map.put("f_stage", Character.valueOf('1'));
        map.put("f_analysis", Character.valueOf('0'));
        if (fields.contains("f_registerstatus")) {
            map.put("f_registerstatus", Character.valueOf('0'));
            map.put("f_mergestatus", Character.valueOf('0'));
        }
        map.put("f_userid", userId);
        map.put("f_sourceid", jcClueSource.getfId());
        map.put("f_createtime", System.currentTimeMillis() / 1000L);
        map.put("f_import_recordid", batchId);
        List sysFields = allFields.stream().filter(t -> "f_xzqdm".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
        if (sysFields != null && sysFields.size() > 0) {
            Geometry geo = (Geometry)sf.getDefaultGeometry();
            Point pt = geo.getCentroid();
            int proNum = this.getColNum(pt.getX());
            HashMap<String, Object> map1 = this.getXzqdmSys((Geometry)pt, geo, proNum);
            map.put("f_xzqdm", map1.get("xzqdmsys"));
            map.put("f_xzqmc", map1.get("xzqmc"));
            map.put("f_location", map1.get("location"));
            map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
            map.put("f_area", map1.get("area"));
            updateMap.put("f_xzqdm", map1.get("xzqdmsys"));
            updateMap.put("f_xzqmc", map1.get("xzqmc"));
            updateMap.put("f_location", map1.get("location"));
            updateMap.put("f_area", map1.get("area"));
            updateMap.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
            if (fields.contains("f_xzqdmcity") && StringUtils.isNotBlank((CharSequence)((String)map1.get("xzqdmsys")))) {
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0, 4) + "00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0, 6));
                map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0, 9));
                map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
                updateMap.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0, 4) + "00");
                updateMap.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0, 6));
                updateMap.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0, 9));
                updateMap.put("f_xzqdmvillage", map1.get("xzqdmsys"));
            }
        }
        if (map.containsKey("f_xzqdm") && StringUtils.isNotBlank((CharSequence)((String)map.get("f_xzqdm")))) {
            String name;
            String xzqdm = (String)map.get("f_xzqdm");
            if (xzqdm.endsWith("000") || xzqdm.endsWith("000000")) {
                xzqdm = xzqdm.replaceAll("000", "");
            }
            result.put("xzqdm", xzqdm);
            boolean xzqdmisExist = true;
            if (xzqdm.length() <= 6) {
                Region region = this.regionDao.findByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (region == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 9) {
                String name2 = this.regionTownRepository.getNameByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (name2 == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 12 && (name = this.regionvillageDao.getNameByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018")) == null) {
                xzqdmisExist = false;
            }
            if (!xzqdmisExist) {
                result.put("xzqdm", xzqdm);
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.XZQDM_ERROR);
                StringBuilder stringBuilder1 = new StringBuilder();
                for (JcClueFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias()).append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            List maps = new ArrayList();
            if (uniqueFields != null && !uniqueFields.isEmpty()) {
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("select f_id from " + jcClueSource.getfTablename() + " where 1=1 and f_import_recordid = '" + batchId + "' ");
                ArrayList<Object> values = new ArrayList<Object>(uniqueFields.size());
                for (JcClueFields tbtskFields : uniqueFields) {
                    stringBuilder.append(" and ");
                    stringBuilder.append(tbtskFields.getfFieldname());
                    stringBuilder.append(" = ?");
                    values.add(map.get(tbtskFields.getfFieldname()));
                }
                maps = this.jdbcTemplate.query(stringBuilder.toString(), values.toArray(new Object[0]), (RowMapper)new RowMapper<Map>(){

                    public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                        HashMap<String, String> ha = new HashMap<String, String>();
                        rs.getString("f_id");
                        ha.put("f_id", rs.getString("f_id"));
                        return ha;
                    }
                });
            }
            if (!maps.isEmpty() && SHAPE_APPEND.equals(updateType)) {
                result.put("type", UpResultEnum.SKIP);
                StringBuilder stringBuilder1 = new StringBuilder();
                for (JcClueFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias()).append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            String name3 = this.regionService.getNameAndVersion(xzqdm, defaultVersion.getVersion());
            if (StringUtils.isNotBlank((CharSequence)name3)) {
                map.put("f_xzqmc", name3);
                if (updateMap.containsKey("f_xzqmc")) {
                    updateMap.put("f_xzqmc", name3);
                }
                if (updateMap.containsKey("f_createtime")) {
                    updateMap.put("f_createtime", System.currentTimeMillis() + "");
                }
                if (updateMap.containsKey("f_userid")) {
                    updateMap.put("f_userid", userId);
                }
            }
            if (maps.isEmpty()) {
                result.put("f_id", map.get("f_id"));
                result.put("type", UpResultEnum.ADD);
                this.resolveFieldDefault(map, fieldDefault);
                addDataList.add(map);
            } else if (maps.size() > 0 && SHAPE_UPDATE.equals(updateType)) {
                String fid = (String)((Map)maps.get(0)).get("f_id");
                result.put("f_id", fid);
                result.put("type", UpResultEnum.UPDATE);
                this.resolveFieldDefault(updateMap, fieldDefault);
                updateMap.remove("f_id");
                try {
                    this.dataBizService.updateData(jcClueSource.getfTablename(), updateMap, " f_id = '" + fid + "'");
                }
                catch (Exception e2) {
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.OTHER);
                    result.put("errorInfo", e2.getMessage());
                    this.logger.error(e2.getMessage(), new Object[]{e2});
                }
            }
            return result;
        }
        result.put("type", UpResultEnum.ERROR);
        result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
        return result;
    }

    void addDatatoMap(Map map, SimpleFeature sf, String fieldType, String fieldName, String rname, String chasetStr, Integer nullable, Integer order, String defaultValue) throws Exception {
        DecimalFormat format = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar": {
                String value1 = this.getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value1 == null || "null".equalsIgnoreCase(value1) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : defaultValue);
                    break;
                }
                map.put(fieldName, value1);
                break;
            }
            case "decimal": {
                if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName)) break;
                String tmp1 = this.getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp1 == null || this.isMessyCode(tmp1) || "".equals(tmp1)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : Double.valueOf(defaultValue));
                    break;
                }
                Double value2 = Double.valueOf(tmp1);
                map.put(fieldName, value2);
                break;
            }
            case "int4": {
                String tmp2 = this.getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp2 == null || this.isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : Integer.valueOf(defaultValue));
                    break;
                }
                Integer value3 = Integer.valueOf(tmp2);
                map.put(fieldName, value3);
                break;
            }
            case "timestamp": {
                String tmp3 = this.getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp3 == null || this.isMessyCode(tmp3) || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, null);
                    break;
                }
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = df.parse(tmp3);
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                catch (ParseException e) {
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    LocalDateTime localDateTime = LocalDateTime.parse(tmp3, df);
                    Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                break;
            }
            case "text": {
                String value2 = this.getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value2 == null || "null".equalsIgnoreCase(value2) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : defaultValue);
                    break;
                }
                map.put(fieldName, value2);
                break;
            }
            case "geometry": {
                Geometry geo = (Geometry)sf.getDefaultGeometry();
                if (!"f_shape".equalsIgnoreCase(fieldName) || geo == null) break;
                map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
                if (geo.getGeometryType().equals("Point")) {
                    Point geo1 = (Point)sf.getDefaultGeometry();
                    if (geo1 != null) {
                        map.put("f_lat", format.format(geo1.getY()));
                        map.put("f_lon", format.format(geo1.getX()));
                        break;
                    }
                    map.put("f_lat", "0.0");
                    map.put("f_lon", "0.0");
                    break;
                }
                Point point = geo.getCentroid();
                if (point != null) {
                    map.put("f_lat", format.format(point.getY()));
                    map.put("f_lon", format.format(point.getX()));
                    break;
                }
                map.put("f_lat", "0.0");
                map.put("f_lon", "0.0");
                break;
            }
        }
    }

    public void resolveFieldDefault(HashMap<String, Object> map, List<String> fieldDefaults) {
        if (fieldDefaults.size() > 0) {
            for (String fieldDefault : fieldDefaults) {
                try {
                    if (!map.containsKey(fieldDefault) || map.get(fieldDefault) == null) continue;
                    if (!map.get(fieldDefault).toString().contains("fields")) {
                        if (!"{\"value\":null}".equalsIgnoreCase(map.get(fieldDefault).toString())) continue;
                        map.put(fieldDefault, null);
                        continue;
                    }
                    JSONObject jsonObject = JSONObject.parseObject((String)map.get(fieldDefault).toString());
                    if ("".equalsIgnoreCase(jsonObject.getString("fields")) || jsonObject.getString("fields") == null) {
                        map.put(fieldDefault, jsonObject.getString("value"));
                        continue;
                    }
                    if ("".equalsIgnoreCase(jsonObject.getString("fields"))) continue;
                    String[] fieldArray = jsonObject.getString("fields").split(",");
                    map.put(fieldDefault, this.jexlConverData(map, fieldArray, jsonObject.getString("value")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    map.put(fieldDefault, null);
                }
            }
        }
    }

    public Object jexlConverData(HashMap<String, Object> map, String[] fieldArray, String jexlExp) {
        JexlBuilder jexlB = new JexlBuilder();
        JexlEngine jexl = jexlB.create();
        JexlExpression e = jexl.createExpression(jexlExp);
        MapContext jc = new MapContext();
        for (String field : fieldArray) {
            jc.set(field, map.get(field));
        }
        Object obj = e.evaluate((JexlContext)jc);
        return obj;
    }

    public void importClueByTaskData(Long userId, String taskId, String tbId) throws Exception {
        Integer type = 1;
        TskTaskBiz taskBiz = this.tskTaskBizService.findOne(taskId);
        if (taskBiz == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        String tableNameByBizId = this.tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank((CharSequence)tableNameByBizId)) {
            throw new RuntimeException("\u4efb\u52a1\u8868\u4e0d\u5b58\u5728");
        }
        JcClueSource jcClueSource = null;
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        List rels = this.jcClueSourceService.findTaskMapperSchemes(Long.valueOf(101L), taskId, "2");
        if (rels.isEmpty()) {
            errorMap.put("objectId", 0);
            errorMap.put("type", "error");
            errorMap.put("result", "\u7f3a\u5c11\u5bfc\u5165\u914d\u7f6e");
            throw new RuntimeException("\u7f3a\u5c11\u5bfc\u5165\u914d\u7f6e");
        }
        jcClueSource = this.jcClueSourceService.findOne(((JcClueImportTaskRel)rels.get(0)).getfSourceid());
        List clueImportRecords = this.jcClueImportRecordService.selectBySourceId(jcClueSource.getfId());
        JcClueImportRecord jcClueImportRecord = null;
        if (!clueImportRecords.isEmpty()) {
            jcClueImportRecord = (JcClueImportRecord)clueImportRecords.get(0);
        }
        HashMap map = new HashMap();
        List fieldsList = this.tskTaskBizService.findTbtskFieldsByTaskId(taskId);
        ArrayList<String> fields = new ArrayList<String>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map datamap = this.dataBizService.selectFieldByID(tableNameByBizId, fields, "f_id", "'" + tbId + "'");
        if (datamap != null) {
            String clueId = UUID.randomUUID().toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\", \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
            stringBuffer.append(" VALUES ( uuid_generate_v1(),'" + jcClueSource.getfId() + "'," + "'" + jcClueImportRecord == null ? "" : jcClueImportRecord.getfId() + "','" + clueId + "','" + taskId + "','" + tbId + "',now(),null,'2')");
            this.jdbcTemplate.execute(stringBuffer.toString());
            if (!((JcClueImportTaskRel)rels.get(0)).getTaskRelFields().isEmpty()) {
                for (JcClueImportTaskRelFields fields1 : ((JcClueImportTaskRel)rels.get(0)).getTaskRelFields()) {
                    map.put(fields1.getfTarFieldname(), datamap.get(fields1.getfOriFieldname()));
                }
            }
            Double area = 0.0;
            if (datamap.get("f_tbmj") != null && StringUtils.isNotBlank((CharSequence)datamap.get("f_tbmj").toString())) {
                area = Double.parseDouble(datamap.get("f_tbmj").toString());
            }
            List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
            List cluefields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            map.put("f_id", clueId);
            map.put("f_xzqdm", datamap.get("f_xzqdmsys"));
            map.put("f_xzqmc", datamap.get("f_xzqmc"));
            map.put("f_location", datamap.get("f_xzqmc"));
            map.put("f_area", datamap.get("f_tbmj"));
            if (datamap.get("f_shape") != null && StringUtils.isNotBlank((CharSequence)datamap.get("f_shape").toString())) {
                map.put("f_shape", "SRID=4490;" + datamap.get("f_shape").toString());
            }
            map.put("f_sjpc", jcClueImportRecord == null ? "" : jcClueImportRecord.getfName());
            map.put("f_status", Character.valueOf('0'));
            map.put("f_state", Character.valueOf('0'));
            map.put("f_stage", Character.valueOf('1'));
            map.put("f_analysis", Character.valueOf('0'));
            if (cluefields.contains("f_registerstatus")) {
                map.put("f_registerstatus", Character.valueOf('0'));
                map.put("f_mergestatus", Character.valueOf('0'));
            }
            map.put("f_userid", userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000L);
            map.put("f_import_recordid", jcClueImportRecord == null ? "" : jcClueImportRecord.getfId());
            this.dataBizService.insertData(jcClueSource.getfTablename(), map, "f_shape");
            if (jcClueImportRecord != null) {
                jcClueImportRecord.setfCount(Integer.valueOf(jcClueImportRecord.getfCount() + 1));
                jcClueImportRecord.setfJcmj(new BigDecimal(jcClueImportRecord.getfJcmj().doubleValue() + Double.valueOf(area)));
                this.jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
            }
        }
    }

    public void syncClueByTaskData(Long userId, String taskId, String tbId, String sourceId, String importRel) throws Exception {
        TskTaskBiz taskBiz = this.tskTaskBizService.findOne(taskId);
        if (taskBiz == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        String tableNameByBizId = this.tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank((CharSequence)tableNameByBizId)) {
            throw new RuntimeException("\u4efb\u52a1\u8868\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)importRel)) {
            throw new RuntimeException("\u7f3a\u5931\u5b57\u6bb5\u914d\u7f6e\u6620\u5c04\u6570\u636e");
        }
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
        List cluefields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        List clueImportRecords = this.jcClueImportRecordService.selectBySourceId(jcClueSource.getfId());
        JcClueImportRecord jcClueImportRecord = null;
        if (!clueImportRecords.isEmpty()) {
            jcClueImportRecord = (JcClueImportRecord)clueImportRecords.get(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List fieldsList = this.tskTaskBizService.findTbtskFieldsByTaskId(taskId);
        ArrayList<String> fields = new ArrayList<String>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map datamap = this.dataBizService.selectFieldByID(tableNameByBizId, fields, "f_id", "'" + tbId + "'");
        if (datamap != null) {
            String clueId = UUID.randomUUID().toString();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\", \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
            stringBuffer.append(" VALUES ( uuid_generate_v1(),'" + jcClueSource.getfId() + "'," + "'" + jcClueImportRecord != null ? jcClueImportRecord.getfId() : null + "','" + clueId + "','" + taskId + "','" + datamap.get("f_id").toString() + "',now(),null,'2')");
            this.jdbcTemplate.execute(stringBuffer.toString());
            Double area = 0.0;
            if (datamap.get("f_tbmj") != null && StringUtils.isNotBlank((CharSequence)datamap.get("f_tbmj").toString())) {
                area = Double.parseDouble(datamap.get("f_tbmj").toString());
            }
            map.put("f_id", clueId);
            map.put("f_xzqdm", datamap.get("f_xzqdmsys"));
            map.put("f_xzqmc", datamap.get("f_xzqmc"));
            map.put("f_location", datamap.get("f_xzqmc"));
            map.put("f_area", datamap.get("f_tbmj"));
            if (datamap.get("f_shape") != null && StringUtils.isNotBlank((CharSequence)datamap.get("f_shape").toString())) {
                map.put("f_shape", "SRID=4490;" + datamap.get("f_shape").toString());
            }
            map.put("f_sjpc", jcClueImportRecord != null ? jcClueImportRecord.getfName() : null);
            map.put("f_status", Character.valueOf('0'));
            map.put("f_state", Character.valueOf('0'));
            map.put("f_stage", Character.valueOf('1'));
            map.put("f_analysis", Character.valueOf('0'));
            if (cluefields.contains("f_registerstatus")) {
                map.put("f_registerstatus", Character.valueOf('0'));
                map.put("f_mergestatus", Character.valueOf('0'));
            }
            map.put("f_userid", userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000L);
            map.put("f_import_recordid", jcClueImportRecord != null ? jcClueImportRecord.getfId() : null);
            JSONArray jsonArray = JSONObject.parseArray((String)importRel, (Feature[])new Feature[0]);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String oriField = object.getString("oriField");
                String tarField = object.getString("tarField");
                map.put(oriField, datamap.get(tarField));
            }
            this.dataBizService.insertData(jcClueSource.getfTablename(), map, "f_shape");
            if (jcClueImportRecord != null) {
                jcClueImportRecord.setfCount(Integer.valueOf(jcClueImportRecord.getfCount() + 1));
                jcClueImportRecord.setfJcmj(new BigDecimal(jcClueImportRecord.getfJcmj().doubleValue() + Double.valueOf(area)));
                this.jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
            }
        }
    }

    public void addJudgeInfo(String dataId, HashMap<String, Object> map) {
        JcClueJudge jcClueJudge = this.jcClueJudgeMapper.selectByDataId(dataId);
        if (jcClueJudge != null) {
            map.put("f_pdlx", jcClueJudge.getfPdlx());
            map.put("f_jyclfs", jcClueJudge.getfJyclfs());
            map.put("f_bljy", jcClueJudge.getfBljy());
            map.put("f_pdbz", jcClueJudge.getfPdbz());
            map.put("f_pdr", jcClueJudge.getfPdr());
            if (jcClueJudge.getfPdsj() != null) {
                String f_pdsj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jcClueJudge.getfPdsj());
                map.put("f_pdsj", f_pdsj);
            }
            map.put("f_djdw", jcClueJudge.getfDjdw());
            map.put("f_djr", jcClueJudge.getfDjr());
            map.put("f_djrq", jcClueJudge.getfDjrq());
        }
    }

    public void addWPZFJudgeInfo(String dataId, HashMap<String, Object> map) {
        JcTaskClueJudge jcTaskClueJudge = this.jcTaskClueJudgeMapper.selectByDataId(dataId);
        if (jcTaskClueJudge != null) {
            map.put("f_pdlx", jcTaskClueJudge.getfPdlx());
            map.put("f_gsbm", jcTaskClueJudge.getfGsbm());
            map.put("f_sjyt", jcTaskClueJudge.getfSjyt());
            map.put("f_jtqx", jcTaskClueJudge.getfJyqx());
            map.put("f_pdyjsm", jcTaskClueJudge.getfPdjysm());
            map.put("f_wflx", jcTaskClueJudge.getfWflx());
            map.put("f_sfxzlzgd", jcTaskClueJudge.getfSfxzlzgdjf());
            map.put("f_sfwhzj", jcTaskClueJudge.getfSfwhzj());
            map.put("f_qzgdmj", jcTaskClueJudge.getfSfgdmj());
            map.put("f_wfnydmj", jcTaskClueJudge.getfWfnydmj());
            map.put("f_qzjbntmj", jcTaskClueJudge.getfQzjbntmj());
            map.put("f_wfkdzdlm", jcTaskClueJudge.getfWfktzdlmj());
            map.put("f_wfwlydmj", jcTaskClueJudge.getfWfwlydmj());
            map.put("f_wfjsydmj", jcTaskClueJudge.getfWfjsydmj());
        }
    }

    public String createLog(Long userId, List<Map<String, Object>> dataLog, TaskRecord record) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = record.getTaskName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
        String col = "objectId,type,result";
        String colName = "objectId,\u7ed3\u679c\u7c7b\u578b,\u7ed3\u679c";
        String filePath = null;
        try {
            filePath = ExcelUtil.CreateExcel(dataLog, (String)tempDir, (String)fileName, (String)col, (String)colName, (String)"\u65e5\u5fd7\u5bfc\u51fa");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sendObjName = "clueDataUploadLog/" + fileName;
        String downloadPath = this.defaultOssOperatorService.sendObject2Oss(sendObjName, filePath);
        return downloadPath;
    }

    public int getColNumOut(Double xLine) {
        return this.getColNum(xLine);
    }

    public String saveClueInfo(String sourceId, String clueInfo, MultipartFile shape, String slzb, Long userId) throws Exception {
        String id = "";
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (jcClueSource != null) {
            String wkt;
            HashMap<String, Object> map = new HashMap<String, Object>();
            JSONObject jsonObject = JSONObject.parseObject((String)clueInfo);
            List<Object> fields = new ArrayList();
            List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
            fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            if (jsonObject.keySet().size() > 0) {
                Set keys = jsonObject.keySet();
                for (String s : keys) {
                    String fieldType = this.getFieldType(s, allFields);
                    Object obj = jsonObject.get((Object)s);
                    if (obj == null || StringUtils.isBlank((CharSequence)obj.toString()) || "null".equals(obj.toString())) continue;
                    if ("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)) {
                        String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj);
                        map.put(s, "'" + datetime + "'");
                        continue;
                    }
                    map.put(s, obj);
                }
            }
            Geometry geometry = null;
            if (shape != null) {
                geometry = ShapeUtil.shapeFile2Geometry((MultipartFile)shape, (String)this.uploadDir);
                wkt = geometry.toText();
                map.put("f_shape", "SRID=4490;" + wkt);
            } else if (StringUtils.isNotBlank((CharSequence)slzb)) {
                geometry = WKTUtil.wktToGeom((String)slzb);
                wkt = geometry.toText();
                map.put("f_shape", "SRID=4490;" + wkt);
            }
            Point pt = geometry.getCentroid();
            int proNum = this.getColNum(pt.getX());
            HashMap<String, Object> map1 = this.getXzqdmSys((Geometry)pt, geometry, proNum);
            map.put("f_xzqdm", map1.get("xzqdmsys"));
            map.put("f_xzqmc", map1.get("xzqmc"));
            if (fields.contains("f_xzqdmcity") && StringUtils.isNotBlank((CharSequence)((String)map1.get("xzqdmsys")))) {
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0, 4) + "00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0, 6));
                map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0, 9));
                map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
            }
            map.put("f_location", map1.get("location"));
            map.put("f_area", map1.get("area"));
            map.put("f_id", UUID.randomUUID().toString());
            map.put("f_status", Character.valueOf('0'));
            map.put("f_state", Character.valueOf('0'));
            map.put("f_stage", Character.valueOf('1'));
            map.put("f_analysis", Character.valueOf('0'));
            if (fields.contains("f_registerstatus")) {
                map.put("f_registerstatus", Character.valueOf('0'));
                map.put("f_mergestatus", Character.valueOf('0'));
            }
            map.put("f_userid", userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000L);
            this.dataBizService.insertData(jcClueSource.getfTablename(), map, "f_shape");
            id = map.get("f_id").toString();
        }
        return id;
    }

    public void updateXsInfo(String sourceId, String clueInfo, String clueId) {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (jcClueSource != null) {
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            JSONObject jsonObject = JSONObject.parseObject((String)clueInfo);
            if (jsonObject.keySet().size() > 0) {
                List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
                Set keys = jsonObject.keySet();
                for (String s : keys) {
                    String fieldType = this.getFieldType(s, allFields);
                    Object obj = jsonObject.get((Object)s);
                    if (obj == null || StringUtils.isBlank((CharSequence)obj.toString()) || "null".equals(obj.toString())) continue;
                    if ("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)) {
                        String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj);
                        updateMap.put(s, "'" + datetime + "'");
                        continue;
                    }
                    updateMap.put(s, obj);
                }
            }
            if (MapUtil.isNotEmpty(updateMap)) {
                int n = this.dataBizService.updateDataById(jcClueSource.getfTablename(), clueId, updateMap);
            }
        }
    }

    public void batchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List allFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
        StringBuilder sb = new StringBuilder();
        if (this.validParam(allFields, clueFieldsValueParamVo)) {
            block6: for (ClueFieldsValueParamVo.FieldValueParam fieldValueParam : clueFieldsValueParamVo.getFieldValueParams()) {
                Optional<JcClueFields> op = allFields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase(fieldValueParam.getFieldName())).findAny();
                JcClueFields jcClueField = op.get();
                String fFieldtype = jcClueField.getfFieldtype();
                String where = "1 = 1 ";
                if (StringUtils.isNotBlank((CharSequence)clueFieldsValueParamVo.getImportRecordId()) && !clueFieldsValueParamVo.getImportRecordId().equals(clueFieldsValueParamVo.getSourceId())) {
                    where = where + " and f_import_recordid = '" + clueFieldsValueParamVo.getImportRecordId() + "' ";
                }
                if (StringUtils.isNotBlank((CharSequence)fieldValueParam.getFilter())) {
                    where = where + " and " + fieldValueParam.getFilter();
                }
                Integer type = fieldValueParam.getSetType();
                switch (type) {
                    case 0: {
                        sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " ='" + fieldValueParam.getValue() + "' where " + where + ";");
                        continue block6;
                    }
                    case 1: {
                        if ((SHAPE_UPDATE.equals(fFieldtype) || "2".equals(fFieldtype)) && !StringUtils.isNotBlank((CharSequence)jcClueField.getfCodetableid())) {
                            sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " =   case  when  " + fieldValueParam.getFieldName() + " is null then '" + fieldValueParam.getValue() + "'        else '" + fieldValueParam.getValue() + "' || " + fieldValueParam.getFieldName() + " end  where " + where + ";");
                            continue block6;
                        }
                        throw new Exception("\u5b57\u6bb5\uff1a" + fieldValueParam.getFieldName() + "\u5f85\u8d4b\u503c\u7c7b\u578b\u9519\u8bef,\u53ea\u80fd\u5b57\u7b26\u4e32\u7c7b\u578b\u6570\u636e\u8fdb\u884c\u8ffd\u52a0");
                    }
                    case 2: {
                        if ((SHAPE_UPDATE.equals(fFieldtype) || "2".equals(fFieldtype)) && !StringUtils.isNotBlank((CharSequence)jcClueField.getfCodetableid())) {
                            sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " =   case  when  " + fieldValueParam.getFieldName() + " is null then '" + fieldValueParam.getValue() + "'        else " + fieldValueParam.getFieldName() + "||'" + fieldValueParam.getValue() + "' end  where " + where + ";");
                            continue block6;
                        }
                        throw new Exception("\u5b57\u6bb5\uff1a" + fieldValueParam.getFieldName() + "\u5f85\u8d4b\u503c\u7c7b\u578b\u9519\u8bef,\u53ea\u80fd\u5b57\u7b26\u4e32\u7c7b\u578b\u6570\u636e\u8fdb\u884c\u8ffd\u52a0");
                    }
                    case 3: {
                        sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " = null  where " + where + ";");
                        continue block6;
                    }
                }
                throw new Exception("\u5b57\u6bb5\uff1a" + fieldValueParam.getFieldName() + "\u5f85\u8d4b\u503c\u7c7b\u578b\u9519\u8bef");
            }
            this.dataBizService.excuteSql(sb.toString());
        }
    }

    public void addBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List jcClueAssignmentPms = this.jcClueAssignmentPmDao.selectBySourceIdAndName(clueFieldsValueParamVo.getSourceId(), clueFieldsValueParamVo.getProgrammeName());
        if (jcClueAssignmentPms.size() > 0) {
            throw new RuntimeException("\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        JcClueAssignmentPm jcClueAssignmentPm = new JcClueAssignmentPm();
        jcClueAssignmentPm.setId(UUID.randomUUID().toString());
        jcClueAssignmentPm.setProgrammeName(clueFieldsValueParamVo.getProgrammeName());
        jcClueAssignmentPm.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jcClueAssignmentPm.setSourceId(clueFieldsValueParamVo.getSourceId());
        this.jcClueAssignmentPmDao.gwAccessSelective((GiEntitySaveable)jcClueAssignmentPm);
        for (ClueFieldsValueParamVo.FieldValueParam fieldValueParam : clueFieldsValueParamVo.getFieldValueParams()) {
            JcClueAssignmentCond jcClueAssignmentCond = new JcClueAssignmentCond();
            BeanUtils.copyProperties((Object)fieldValueParam, (Object)jcClueAssignmentCond);
            jcClueAssignmentCond.setSourceId(clueFieldsValueParamVo.getSourceId());
            jcClueAssignmentCond.setProgrammeId(jcClueAssignmentPm.getId());
            jcClueAssignmentCond.setId(UUID.randomUUID().toString());
            jcClueAssignmentCond.setFieldValue(fieldValueParam.getValue());
            this.jcClueAssignmentCondDao.gwAccessSelective((GiEntitySaveable)jcClueAssignmentCond);
        }
    }

    public void updateBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        JcClueAssignmentPm jcClueAssignmentPm = (JcClueAssignmentPm)this.jcClueAssignmentPmDao.gwSearchByPK((Serializable)((Object)clueFieldsValueParamVo.getId()));
        if (jcClueAssignmentPm == null) {
            throw new RuntimeException("\u65b9\u6848\u4e0d\u5b58\u5728\u4e0d\u5b58\u5728");
        }
        if (!jcClueAssignmentPm.getProgrammeName().equals(clueFieldsValueParamVo.getProgrammeName())) {
            List jcClueAssignmentPms = this.jcClueAssignmentPmDao.selectBySourceIdAndName(clueFieldsValueParamVo.getSourceId(), clueFieldsValueParamVo.getProgrammeName());
            if (jcClueAssignmentPms.size() > 0) {
                throw new RuntimeException("\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            }
            jcClueAssignmentPm.setProgrammeName(clueFieldsValueParamVo.getProgrammeName());
        }
        this.jcClueAssignmentPmDao.gwUpdateByPK((GiEntityAlterable)jcClueAssignmentPm);
        this.jcClueAssignmentCondDao.delByProgrammeId(jcClueAssignmentPm.getId());
        for (ClueFieldsValueParamVo.FieldValueParam fieldValueParam : clueFieldsValueParamVo.getFieldValueParams()) {
            JcClueAssignmentCond jcClueAssignmentCond = new JcClueAssignmentCond();
            BeanUtils.copyProperties((Object)fieldValueParam, (Object)jcClueAssignmentCond);
            jcClueAssignmentCond.setSourceId(clueFieldsValueParamVo.getSourceId());
            jcClueAssignmentCond.setProgrammeId(jcClueAssignmentPm.getId());
            jcClueAssignmentCond.setId(UUID.randomUUID().toString());
            jcClueAssignmentCond.setFieldValue(fieldValueParam.getValue());
            this.jcClueAssignmentCondDao.gwAccessSelective((GiEntitySaveable)jcClueAssignmentCond);
        }
    }

    public List<JcClueAssignmentPm> findBatchUpdateXsInfoByCondition(String sourceId) throws Exception {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List jcClueAssignmentPms = this.jcClueAssignmentPmDao.selectBySourceId(sourceId);
        for (JcClueAssignmentPm jcClueAssignmentPm : jcClueAssignmentPms) {
            jcClueAssignmentPm.setJcClueAssignmentConds(this.jcClueAssignmentCondDao.selectByProgrammeId(jcClueAssignmentPm.getId()));
        }
        return jcClueAssignmentPms;
    }

    public JcClueAssignmentPm findBatchUpdateXsInfoByProgrammeId(String programmeId) throws Exception {
        JcClueAssignmentPm jcClueAssignmentPm = (JcClueAssignmentPm)this.jcClueAssignmentPmDao.gwSearchByPK((Serializable)((Object)programmeId));
        jcClueAssignmentPm.setJcClueAssignmentConds(this.jcClueAssignmentCondDao.selectByProgrammeId(jcClueAssignmentPm.getId()));
        return jcClueAssignmentPm;
    }

    public void delBatchUpdateXsInfoByCondition(String programmeId) throws Exception {
        JcClueAssignmentPm jcClueAssignmentPm = (JcClueAssignmentPm)this.jcClueAssignmentPmDao.gwSearchByPK((Serializable)((Object)programmeId));
        if (jcClueAssignmentPm == null) {
            throw new RuntimeException("\u65b9\u6848\u4e0d\u5b58\u5728\u4e0d\u5b58\u5728");
        }
        this.jcClueAssignmentCondDao.delByProgrammeId(jcClueAssignmentPm.getId());
        this.jcClueAssignmentPmDao.gwDeleteByPK((Serializable)((Object)programmeId));
    }

    public JcClueFilter addClueFilter(Long userId, JcClueFilterVo jcClueFilterVo) {
        List jcClueFilters = this.jcClueFilterDao.selectBySourceIdAndFilterName(jcClueFilterVo.getSourceId(), jcClueFilterVo.getFilterName());
        if (jcClueFilters.size() > 0) {
            throw new GwValidateException("\u7ebf\u7d22\u8fc7\u6ee4\u6761\u4ef6\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        JcClueFilter jcClueFilter = new JcClueFilter();
        BeanUtils.copyProperties((Object)jcClueFilterVo, (Object)jcClueFilter);
        jcClueFilter.setId(UUID.randomUUID().toString());
        jcClueFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jcClueFilter.setUserId(Integer.valueOf(Math.toIntExact(userId)));
        this.jcClueFilterDao.gwAccessSelective((GiEntitySaveable)jcClueFilter);
        return jcClueFilter;
    }

    public JcClueFilter updateClueFilter(Long userId, JcClueFilterVo jcClueFilterVo) {
        JcClueFilter jcClueFilter = (JcClueFilter)this.jcClueFilterDao.gwSearchByPK((Serializable)((Object)jcClueFilterVo.getId()));
        if (jcClueFilter == null) {
            throw new GwValidateException("\u7ebf\u7d22\u8fc7\u6ee4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636eid");
        }
        if (!jcClueFilter.getFilterName().equals(jcClueFilterVo.getFilterName())) {
            List jcClueFilters = this.jcClueFilterDao.selectBySourceIdAndFilterName(jcClueFilterVo.getSourceId(), jcClueFilterVo.getFilterName());
            if (jcClueFilters.size() > 0) {
                throw new GwValidateException("\u7ebf\u7d22\u8fc7\u6ee4\u6761\u4ef6\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            }
            jcClueFilter.setFilterName(jcClueFilterVo.getFilterName());
        }
        jcClueFilter.setFilterValue(jcClueFilterVo.getFilterValue());
        jcClueFilter.setEnumCode(jcClueFilterVo.getEnumCode());
        this.jcClueFilterDao.gwUpdateByPKSelective((GiEntityAlterable)jcClueFilter);
        return jcClueFilter;
    }

    public void delClueFilterById(String id) {
        JcClueFilter jcClueFilter = (JcClueFilter)this.jcClueFilterDao.gwSearchByPK((Serializable)((Object)id));
        if (jcClueFilter == null) {
            throw new GwValidateException("\u7ebf\u7d22\u8fc7\u6ee4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636eid");
        }
        this.jcClueFilterDao.gwDeleteByPK((Serializable)((Object)id));
    }

    public List<JcClueFilter> findClueFilters(String sourceId) {
        return this.jcClueFilterDao.selectBySourceId(sourceId);
    }

    public boolean validParam(List<JcClueFields> allFields, ClueFieldsValueParamVo param) throws Exception {
        for (ClueFieldsValueParamVo.FieldValueParam fieldValueParam : param.getFieldValueParams()) {
            Optional<JcClueFields> op = allFields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase(fieldValueParam.getFieldName())).findAny();
            if (!op.isPresent()) {
                throw new Exception("\u5b57\u6bb5\uff1a" + fieldValueParam.getFieldName() + "\u4e0d\u5b58\u5728");
            }
            JcClueFields jcClueFields = op.get();
            String fieldType = jcClueFields.getfFieldtype();
            if (fieldValueParam.getSetType() == 3 || !StringUtils.isBlank((CharSequence)fieldValueParam.getValue())) continue;
            throw new Exception("\u5b57\u6bb5\uff1a" + fieldValueParam.getFieldName() + "\u5f85\u8d4b\u503c\u5185\u5bb9\u4e3a\u7a7a");
        }
        return true;
    }

    public String getFieldType(String fieldName, List<JcClueFields> tbtskFields) {
        String fieldType = "";
        for (JcClueFields field : tbtskFields) {
            if (!fieldName.equalsIgnoreCase(field.getfFieldname())) continue;
            fieldType = field.getfFieldtype();
        }
        return fieldType;
    }

    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }

    public String conType(String fieldType) {
        HashMap<String, String> FIELD_TYPE_DIC = new HashMap<String, String>();
        FIELD_TYPE_DIC.put(SHAPE_UPDATE, "text");
        FIELD_TYPE_DIC.put("2", "varchar");
        FIELD_TYPE_DIC.put("3", "decimal");
        FIELD_TYPE_DIC.put("4", "timestamp");
        FIELD_TYPE_DIC.put("5", "timestamp");
        FIELD_TYPE_DIC.put("6", "varchar");
        FIELD_TYPE_DIC.put("7", "decimal");
        FIELD_TYPE_DIC.put("8", "int4");
        FIELD_TYPE_DIC.put("9", "geometry");
        FIELD_TYPE_DIC.put("10", "text");
        return FIELD_TYPE_DIC.getOrDefault(fieldType, "varchar");
    }

    public List<JcClueFields> getJcFieldsByTablename(String tablename) {
        List jcClueFieldsList = this.jcClueFieldsService.findByTableName(tablename);
        return jcClueFieldsList;
    }

    private CoordinateReferenceSystem createCRSByPrjFile(String filePath) {
        String prjFilePath = filePath.replace(".shp", ".prj");
        String wkt = this.txt2String(new File(prjFilePath));
        String wkt2 = wkt.replaceAll("[',']+", ",").replaceAll(",]", "]");
        CoordinateReferenceSystem sCRS = null;
        try {
            sCRS = CRS.parseWKT((String)wkt2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        return sCRS;
    }

    private String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private String getStrValue(Object obj, String chasetStr) {
        String val = "";
        try {
            if (obj != null && !"".equals(obj)) {
                String objStr = obj.toString();
                if ((obj = new String(objStr.getBytes(chasetStr), StandardCharsets.UTF_8)) != null && this.isMessyCode(obj.toString())) {
                    obj = new String(objStr.getBytes(chasetStr), "GBK");
                }
                val = String.valueOf(obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\ufffd') continue;
            return true;
        }
        return false;
    }

    private HashMap<String, Object> getXzqdmSys(Geometry geo, String version) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("xzqdmsys", "");
        map.put("xzqmc", "");
        map.put("location", "");
        String location = "";
        String xzqdmsys = "";
        try {
            RegionVillage regionVillage = new RegionVillage();
            RegionTown regionTown = new RegionTown();
            RegionDetail region = new RegionDetail();
            String wkt = WKTUtil.geomToWkt((Geometry)geo);
            if (version != null) {
                regionVillage = this.regionService.queryRegionVillageByCoor(geo, version);
                regionTown = this.regionService.queryRegionTownCotain(geo, version);
                region = this.regionService.queryRegionByGeomByVersion(wkt, 4490, 3, version);
            } else {
                regionVillage = this.regionService.queryRegionVillageByCoor(geo);
                regionTown = this.regionService.queryRegionTownCotain(geo);
                region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
            }
            if (regionVillage != null) {
                xzqdmsys = regionVillage.getCode();
                map.put("xzqdmsys", xzqdmsys);
                map.put("xzqmc", regionVillage.getName());
            } else if (regionTown != null) {
                xzqdmsys = regionTown.getCode() + "000";
                map.put("xzqdmsys", xzqdmsys);
                map.put("xzqmc", regionTown.getName());
            } else {
                xzqdmsys = region.getCode() + "000000";
                map.put("xzqdmsys", xzqdmsys);
                map.put("xzqmc", regionTown.getName());
            }
            if (region != null) {
                location = location + region.getName();
            }
            if (regionTown != null) {
                location = location + regionTown.getName();
            }
            if (regionVillage != null) {
                location = location + regionVillage.getName();
            }
            map.put("location", location);
        }
        catch (org.locationtech.jts.io.ParseException e) {
            e.printStackTrace();
        }
        return map;
    }

    private HashMap<String, Object> getXzqdmSys(Geometry pt, Geometry geo, int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String wkt = WKTUtil.geomToWkt((Geometry)pt);
            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\nunion\n(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\nunion\n(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";
            List maps = this.jdbcTemplate.queryForList(sql);
            Map region = null;
            Map regionTown = null;
            Map regionVillage = null;
            for (int i = 0; i < maps.size(); ++i) {
                Object xzqdm = ((Map)maps.get(i)).get("xzqdm");
                if (xzqdm == null) continue;
                if (xzqdm.toString().length() == 12) {
                    regionVillage = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() == 9) {
                    regionTown = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() != 6) continue;
                region = (Map)maps.get(i);
            }
            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage != null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                String string = xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown != null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region != null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }
            String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt((Geometry)geo) + "',4490)," + proNum + "))/666.6666667 as area";
            Map areaMap = this.jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(area));
            map.put("area", bigDecimal);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return map;
    }

    public Pair<Long, List<Map>> queryCulelist(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = this.parseQueryParameter(parameter);
        String tableName = (String)queryParamPair.getLeft();
        String where = (String)queryParamPair.getRight();
        if (StringUtils.isNotBlank((CharSequence)parameter.getConditionFilter())) {
            where = where + " and " + parameter.getConditionFilter();
        }
        String order = " order by " + parameter.getSortParam();
        List jcFields = this.jcClueFieldsService.findByTableId(parameter.getSourceId());
        List fieldList = jcFields.stream().filter(r -> !r.getfFieldname().equals("f_shape_g")).map(t -> t.getfFieldname()).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)tableName) && !tableName.contains("null")) {
            Integer count = this.dataBizService.getCount(tableName, where);
            List list = this.dataBizService.queryPageData(tableName, fieldList, parameter.getRows().intValue(), parameter.getPage().intValue(), where + order);
            return Pair.of((Object)count, (Object)list);
        }
        return Pair.of((Object)0L, new ArrayList());
    }

    public Pair<Long, List<Map>> queryCulelistNotPage(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = this.parseQueryParameter(parameter);
        String tableName = (String)queryParamPair.getLeft();
        String where = (String)queryParamPair.getRight();
        if (StringUtils.isNotBlank((CharSequence)parameter.getConditionFilter())) {
            where = where + " and " + parameter.getConditionFilter();
        }
        String order = " order by " + parameter.getSortParam();
        List jcFields = this.jcClueFieldsService.findByTableId(parameter.getSourceId());
        List fieldList = jcFields.stream().filter(r -> !r.getfFieldname().equals("f_shape_g")).map(t -> t.getfFieldname()).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)tableName) && !tableName.contains("null")) {
            Integer count = this.dataBizService.getCount(tableName, where);
            List list = this.dataBizMapper.queryNotPageData(tableName, fieldList, where + order);
            return Pair.of((Object)count, (Object)list);
        }
        return Pair.of((Object)0L, new ArrayList());
    }

    public void importClueToTaskByCondition(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = this.parseQueryParameter(parameter);
        String where = (String)queryParamPair.getRight();
        if (StringUtils.isNotBlank((CharSequence)parameter.getConditionFilter())) {
            where = where + " and " + parameter.getConditionFilter();
        }
        String tablename = parameter.getTableName();
        where = where + " and  not exists (select null from jc_clue_task_rel r where r.f_clueid= tb.f_id and r.f_type='1'  and r.f_taskid = '" + parameter.getTaskId() + "')";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\", \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
        stringBuffer.append(" select uuid_generate_v1(),'" + parameter.getSourceId() + "','" + parameter.getRecordId() + "',tb.f_id,'" + parameter.getTaskId() + "', uuid_generate_v1(),now(),null,'1' from " + tablename + " tb  where " + where);
        this.dataBizMapper.excuteSql(stringBuffer.toString());
        JSONObject params = new JSONObject();
        params.put("sourceId", (Object)parameter.getSourceId());
        params.put("recordId", (Object)parameter.getRecordId());
        params.put("importRel", (Object)parameter.getImportRel());
        params.put("taskId", (Object)parameter.getTaskId());
        params.put("userId", (Object)parameter.getUserId());
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTaskName("\u7ebf\u7d22\u6570\u636e\u5bfc\u5165\u5230\u6838\u67e5\u4efb\u52a1");
        record.setTasktype(JobConstants.JOB_TYPE_CULETASK_IMPORT);
        record.setStarttime(new Date());
        record.setBizId(parameter.getSourceId());
        record.setRead(Integer.valueOf(0));
        record.setState(Integer.valueOf(1));
        record.setUserid(parameter.getUserId());
        this.taskRecordService.save(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClueNum(String xzqdm, String type) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String dateString = sf.format(new Date());
        ReentrantLock lock = new ReentrantLock();
        if (xzqdm.length() < 6) {
            throw new RuntimeException("\u653f\u533a\u4ee3\u7801\u6709\u8bef");
        }
        xzqdm = xzqdm.substring(0, 6);
        int count = 0;
        try {
            boolean b = lock.tryLock();
            if (b) {
                JcClueNum clueNum = this.jcClueNumMapper.getClueNum(xzqdm, type, dateString);
                if (clueNum == null) {
                    clueNum = new JcClueNum();
                    clueNum.setfXzqdm(xzqdm);
                    clueNum.setfDate(dateString);
                    clueNum.setfType(type);
                    clueNum.setfNum(Integer.valueOf(0));
                    this.jcClueNumMapper.insert((Object)clueNum);
                } else {
                    count = clueNum.getfNum() + 1;
                    clueNum.setfNum(Integer.valueOf(count));
                    this.jcClueNumMapper.update(clueNum);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return this.getXSBH(xzqdm, type, dateString, count);
    }

    public HashMap<String, Object> getXzqdmSysOut(Geometry pt, Geometry geo, int proNum) throws SQLException {
        return this.getXzqdmSys(pt, geo, proNum);
    }

    public String getXSBH(String xzqdm, String type, String dateString, int count) {
        String c = String.format("%04d", count);
        return xzqdm + dateString + type + c;
    }

    public void clueJudgeSubmit(Long userId, JcClueJudge jcClueJudge) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYY-MM-DD");
        String fid = "";
        if (jcClueJudge != null && jcClueJudge.getfDataid() != null) {
            JcClueJudge jcClueJudge1 = this.jcClueJudgeMapper.selectByDataId(jcClueJudge.getfDataid());
            if (jcClueJudge1 != null) {
                fid = jcClueJudge1.getfId();
                BeanUtil.copyProperties((Object)jcClueJudge, (Object)jcClueJudge1, (boolean)false);
                jcClueJudge1.setfId(fid);
                jcClueJudge1.setfUserid(Integer.valueOf(userId.intValue()));
                jcClueJudge1.setfCreatetime(new Date());
                if (StringUtils.isNotBlank((CharSequence)jcClueJudge.getPdsj())) {
                    jcClueJudge1.setfPdsj(simpleDateFormat.parse(jcClueJudge.getPdsj()));
                }
                if (StringUtils.isNotBlank((CharSequence)jcClueJudge.getDjrq())) {
                    jcClueJudge1.setfDjrq(simpleDateFormat.parse(jcClueJudge.getDjrq()));
                }
                this.jcClueJudgeMapper.updateByPrimaryKeySelective((Object)jcClueJudge1);
            } else {
                JcClueJudge bean = new JcClueJudge();
                BeanUtil.copyProperties((Object)jcClueJudge, (Object)bean, (boolean)false);
                bean.setfId(UUID.randomUUID().toString());
                bean.setfUserid(Integer.valueOf(userId.intValue()));
                bean.setfCreatetime(new Date());
                if (StringUtils.isNotBlank((CharSequence)jcClueJudge.getPdsj())) {
                    bean.setfPdsj(simpleDateFormat.parse(jcClueJudge.getPdsj()));
                }
                if (StringUtils.isNotBlank((CharSequence)jcClueJudge.getDjrq())) {
                    bean.setfDjrq(simpleDateFormat.parse(jcClueJudge.getDjrq()));
                }
                this.jcClueJudgeMapper.insertSelective((Object)bean);
            }
        }
    }

    public JcClueJudge findClueJudgeInfo(Long userId, String dataId) {
        JcClueJudge jcClueJudge = this.jcClueJudgeMapper.selectByDataId(dataId);
        List appMedias = this.appMediaDao.queryByGid(dataId);
        ArrayList result = new ArrayList();
        ArrayList<AppMediaDTO> resultObject = new ArrayList<AppMediaDTO>();
        for (int i = 0; i < appMedias.size(); ++i) {
            if (((AppMedia)appMedias.get(i)).getTypetype() != 2) continue;
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtils.copyProperties(appMedias.get(i), (Object)newMedia);
            if (newMedia.getServerpath() != null && !newMedia.getServerpath().contains("AccessKeyId")) {
                String fiename = ((AppMedia)appMedias.get(i)).getServerpath().substring(((AppMedia)appMedias.get(i)).getServerpath().lastIndexOf("/") + 1, ((AppMedia)appMedias.get(i)).getServerpath().length());
                newMedia.setFileName(fiename);
                String url = this.temporarySignedUrlService.getTemporarySignedUrl("", newMedia.getServerpath(), null);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    newMedia.setServerpath(url);
                }
            }
            resultObject.add(newMedia);
        }
        jcClueJudge.setMediaList(resultObject);
        return jcClueJudge;
    }

    public Pair<String, String> parseQueryParameter(CuleQueryParam param) {
        String tempFilter = "";
        String rejectJoinFilter = "";
        StringBuilder sbFilter = new StringBuilder(" 1=1 ");
        String tableAlias = "tb";
        if (StringUtils.isNotBlank((CharSequence)param.getRegionCode())) {
            List allFields = this.jcClueFieldsService.findByTableId(param.getSourceId());
            List fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            sbFilter.append(" and  ");
            if (param.getRegionCode().length() <= 6) {
                if (param.getRegionCode().endsWith("0000")) {
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode().substring(0, 2) + "%' ");
                } else if (param.getRegionCode().endsWith("00")) {
                    sbFilter.append(tableAlias);
                    if (fields.contains("f_xzqdmcity")) {
                        sbFilter.append(".f_xzqdmcity = '" + param.getRegionCode() + "' ");
                    } else {
                        sbFilter.append(".f_xzqdm like '" + param.getRegionCode().substring(0, 4) + "%' ");
                    }
                } else {
                    sbFilter.append(tableAlias);
                    if (fields.contains("f_xzqdmcounty")) {
                        sbFilter.append(".f_xzqdmcounty = '" + param.getRegionCode() + "' ");
                    } else {
                        sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                    }
                }
            } else if (param.getRegionCode().length() == 9) {
                sbFilter.append(tableAlias);
                if (fields.contains("f_xzqdmtown")) {
                    sbFilter.append(".f_xzqdmtown = '" + param.getRegionCode() + "' ");
                } else {
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                }
            } else if (param.getRegionCode().length() == 12) {
                sbFilter.append(tableAlias);
                if (fields.contains("f_xzqdmvillage")) {
                    sbFilter.append(".f_xzqdmvillage = '" + param.getRegionCode() + "' ");
                } else {
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRecordId()) && !param.getSourceId().equals(param.getRecordId())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            sbFilter.append(".f_import_recordid =  '" + param.getRecordId() + "' ");
        }
        if (param.getRegisterStatus() != null) {
            if (param.getRegisterStatus() == 0) {
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '" + param.getRegisterStatus() + "'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status  is null ) ");
            } else {
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_registerstatus =  '" + param.getRegisterStatus() + "' ");
            }
        }
        if (param.getMergeStatus() != null) {
            if (param.getMergeStatus() == 0) {
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus =  '" + param.getMergeStatus() + "'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus  is null ) ");
            } else {
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus =  '" + param.getMergeStatus() + "' ");
            }
        }
        if (param.getHandlyStatus() != null) {
            if (param.getHandlyStatus() == 0) {
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '" + param.getHandlyStatus() + "'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status  is null ) ");
            } else {
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '" + param.getHandlyStatus() + "' ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getFxymCode())) {
            List jcClueFilters = this.jcClueFilterDao.selectBySourceIdAndEnumCode(param.getSourceId(), param.getFxymCode());
            if (jcClueFilters.size() > 0) {
                sbFilter.append(" and (");
                for (JcClueFilter jcClueFilter : jcClueFilters) {
                    sbFilter.append("(").append(jcClueFilter.getFilterValue()).append(") or ");
                }
                sbFilter.delete(sbFilter.length() - 4, sbFilter.length());
                sbFilter.append(" ) ");
            } else {
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_id is null  ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getKeyWord()) && StringUtils.isNotBlank((CharSequence)(tempFilter = this.parseSearchParam(param.getKeyWord(), param.getTableName(), tableAlias)))) {
            sbFilter.append(tempFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCustomFilter()) && StringUtils.isNotBlank((CharSequence)(tempFilter = this.parseFilterParam(param.getCustomFilter(), param.getSourceId(), tableAlias)))) {
            sbFilter.append(tempFilter);
        }
        String tableName = " " + param.getTableName() + " as " + tableAlias + " ";
        return Pair.of((Object)(tableName + rejectJoinFilter), (Object)sbFilter.toString());
    }

    public String parseSearchParam(String keyWord, String tablename, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            List searchList = this.jcClueFieldGroupViewMapper.clueGroupByTableName("web", tablename, "102").stream().map(r -> "(" + tableAlias + "." + r.getfFieldname() + " LIKE '%" + keyWord + "%')").collect(Collectors.toList());
            String searchStr = String.join((CharSequence)" OR ", searchList);
            where = where + " AND (" + searchStr + ") ";
        }
        return where;
    }

    public String parseFilterParam(String filterParam, String tablename, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty((CharSequence)filterParam)) {
            JSONArray filterArray = JSONArray.parseArray((String)filterParam, (Feature[])new Feature[0]);
            List filterField = this.jcClueFieldGroupViewMapper.clueGroupByTableId("web", tablename, "101");
            for (int i = 0; i < filterArray.size(); ++i) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if ("".equals(val)) continue;
                Optional<JcClueFieldGroupView> optional = filterField.stream().filter(r -> r.getfId().equals(field)).findFirst();
                if (optional.isPresent()) {
                    JcClueFieldGroupView one = optional.get();
                    block7 : switch (one.getfFieldtype()) {
                        case "1": 
                        case "2": {
                            switch (ref) {
                                case "LK": {
                                    String[] tem = val.split(",");
                                    if (tem.length > 1) {
                                        filterStr = filterStr + "( ";
                                        for (String s : tem) {
                                            filterStr = filterStr + tableAlias + "." + one.getfFieldname() + " LIKE '%" + s + "%'  or ";
                                        }
                                        filterStr = filterStr.substring(0, filterStr.length() - 3) + ") ";
                                        break block7;
                                    }
                                    filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";
                                    break block7;
                                }
                                case "EQ": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                    break block7;
                                }
                                case "IN": {
                                    ArrayList<String> inValues = new ArrayList<String>();
                                    for (String s : val.split(",")) {
                                        inValues.add("'" + s + "'");
                                    }
                                    filterStr = tableAlias + "." + one.getfFieldname() + " IN (" + StringUtils.join(inValues, (String)",") + ") ";
                                    break block7;
                                }
                            }
                            break;
                        }
                        case "3": 
                        case "4": 
                        case "5": {
                            switch (ref) {
                                case "GT": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " > " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "EQ": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " = " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "LT": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " < " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "LE": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " <= " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "GE": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " >= " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "NE": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " != " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                            }
                            break;
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)filterStr)) continue;
                where = where + " AND " + filterStr;
            }
        }
        return where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportExcel(List<Map<String, Object>> maps, String templateFile, String type) {
        if (maps == null) {
            return null;
        }
        XSSFWorkbook wb = null;
        FileInputStream fileInputStream = null;
        byte[] barray = null;
        ByteArrayOutputStream bos = null;
        try {
            File srcFile = new File(templateFile);
            fileInputStream = new FileInputStream(srcFile);
            wb = new XSSFWorkbook((InputStream)fileInputStream);
            if (type.equals("tbjxlxfx")) {
                this.tbjxlxfxSheet(wb, maps);
            } else if (type.equals("gdwtbdjfx")) {
                this.gdwtbdjfxSheet(wb, maps);
            } else if (type.equals("xftbmx")) {
                this.xftbmxSheet(wb, maps);
            } else if (type.equals("zhjcjgxsb")) {
                this.zhjcjgxsbSheet(wb, maps);
            } else if (type.equals("shfpqd")) {
                this.shfpqdSheet(wb, maps);
            }
            bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            barray = bos.toByteArray();
            this.logger.info("excel\u5b8c\u6210\uff01\uff01\uff01\uff01\uff01", new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return barray;
    }

    public List<Map<String, Object>> statisticsTbjclxfx(String sourceId, String recordId) {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        String where = " where f_sourceid='" + sourceId + "'";
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            where = where + " and f_import_recordid = '" + recordId + "'";
        }
        String sql = " select '\u5168\u5e02' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n  SUM ( case when f_jcgl = '\u5efa\u6784\u7b51\u7269' then 1   else 0 end ) as jgzwCount,\n\tSUM( case when f_jcgl = '\u5efa\u6784\u7b51\u7269' then f_area else 0 end ) as jgzwArea,\n\tSUM( case when f_jcgl = '\u63a8\u5806\u571f' then 1 else 0 end ) as tdtCount,\n\tSUM( case when f_jcgl = '\u63a8\u5806\u571f' then f_area else 0 end ) as tdtArea,\n\tSUM ( case when f_jcgl = '\u7ebf\u72b6\u5730\u7269' then 1 else 0 end ) as xzdwCount,\n\tSUM( case when f_jcgl = '\u7ebf\u72b6\u5730\u7269' then f_area else 0 end ) as xzdwArea,\n\tSUM ( case when f_jcgl = '\u56ed\u6797\u5730' then 1 else 0 end ) as yldCount,\n\tSUM( case when f_jcgl = '\u56ed\u6797\u5730' then f_area else 0 end ) as yldArea,\n\tSUM ( case when f_jcgl = '\u5751\u5858' then 1 else 0 end ) as ktCount,\n\tSUM( case when f_jcgl = '\u5751\u5858' then f_area else 0 end ) as ktArea,\n\tSUM ( case when f_jcgl = '\u5efa\u7b51\u62c6\u9664\u53ca\u539f\u5740\u53d8\u5316' then 1 else 0 end ) as jzccCount,\n\tSUM ( case when f_jcgl = '\u5efa\u7b51\u62c6\u9664\u53ca\u539f\u5740\u53d8\u5316' then f_area else 0 end ) as jzccArea,\n\tSUM ( case when f_jcgl = '\u65b0\u589e\u8015\u5730' then 1 else 0 end ) as xzgdCount,\n\tSUM ( case when f_jcgl = '\u65b0\u589e\u8015\u5730' then f_area else 0 end ) as xzgdArea\n\tfrom " + jcClueSource.getfTablename() + where + "\nunion all\t\nselect\n\tcase when f_rwfp is null then '\u653f\u533a\u6570\u636e\u4e3a\u7a7a' else f_rwfp end  as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n\tSUM ( case when f_jcgl = '\u5efa\u6784\u7b51\u7269' then 1 else 0 end ) as jgzwCount,\n\tSUM( case when f_jcgl = '\u5efa\u6784\u7b51\u7269' then f_area else 0 end ) as jgzwArea,\n\tSUM( case when f_jcgl = '\u63a8\u5806\u571f' then 1 else 0 end ) as tdtCount,\n\tSUM( case when f_jcgl = '\u63a8\u5806\u571f' then f_area else 0 end ) as tdtArea,\n\tSUM ( case when f_jcgl = '\u7ebf\u72b6\u5730\u7269' then 1 else 0 end ) as xzdwCount,\n\tSUM( case when f_jcgl = '\u7ebf\u72b6\u5730\u7269' then f_area else 0 end ) as xzdwArea,\n\tSUM ( case when f_jcgl = '\u56ed\u6797\u5730' then 1 else 0 end ) as yldCount,\n\tSUM( case when f_jcgl = '\u56ed\u6797\u5730' then f_area else 0 end ) as yldArea,\n\tSUM ( case when f_jcgl = '\u5751\u5858' then 1 else 0 end ) as ktCount,\n\tSUM( case when f_jcgl = '\u5751\u5858' then f_area else 0 end ) as ktArea,\n\tSUM ( case when f_jcgl = '\u5efa\u7b51\u62c6\u9664\u53ca\u539f\u5740\u53d8\u5316' then 1 else 0 end ) as jzccCount,\n\tSUM ( case when f_jcgl = '\u5efa\u7b51\u62c6\u9664\u53ca\u539f\u5740\u53d8\u5316' then f_area\telse 0 end ) as jzccArea,\n\tSUM ( case when f_jcgl = '\u65b0\u589e\u8015\u5730' then 1 else 0 end ) as xzgdCount,\n\tSUM ( case when f_jcgl = '\u65b0\u589e\u8015\u5730' then f_area else 0 end ) as xzgdArea\nfrom\n\t" + jcClueSource.getfTablename() + where + "\n group by f_rwfp;";
        List dataList = this.jdbcTemplate.queryForList(sql);
        return dataList;
    }

    public List<Map<String, Object>> statisticsGdwtbdjfx(String sourceId, String recordId) {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        String where = " where f_sourceid='" + sourceId + "' and f_jcrw ='\u5e38\u89c4\u76d1\u6d4b' ";
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            where = where + " and f_import_recordid = '" + recordId + "'";
        }
        String sql = " select\n\tcase when f_rwfp is null then '\u653f\u533a\u6570\u636e\u4e3a\u7a7a' else f_rwfp end  as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n\tSUM ( case when f_cbsxyy in( '\u624b\u7eed\u8986\u76d6\u7c7b','\u4e34\u65f6\u7528\u5730','\u8bbe\u65bd\u519c\u7528\u5730') then 1 else 0 end ) as ysxlCount,\n\tSUM( case when f_cbsxyy in( '\u624b\u7eed\u8986\u76d6\u7c7b','\u4e34\u65f6\u7528\u5730','\u8bbe\u65bd\u519c\u7528\u5730')  then f_area else 0 end ) as ysxlArea,\n\tSUM( case when f_cbsxyy = '\u5df2\u7eb3\u5165\u53d8\u66f4\u6784\u5efa\u7b51\u7269' then 1 else 0 end ) as ynrbgjzwCount,\n\tSUM( case when f_cbsxyy = '\u5df2\u7eb3\u5165\u53d8\u66f4\u6784\u5efa\u7b51\u7269' then f_area else 0 end ) as ynrbgjzwArea,\n\tSUM ( case when f_cbsxyy = '\u7eb3\u5165\u536b\u7247\u6267\u6cd5' then 1 else 0 end ) as nrwpzfCount,\n\tSUM( case when f_cbsxyy = '\u7eb3\u5165\u536b\u7247\u6267\u6cd5' then f_area else 0 end ) as nrwpzfArea,\n\tSUM ( case when f_cbsxyy is null and f_nxftb='\u4eba\u5de5\u5224\u5b9a' then 1 else 0 end ) as xzdwCount,\n\tSUM( case when f_cbsxyy is null and f_nxftb='\u4eba\u5de5\u5224\u5b9a' then f_area else 0 end ) as xzdwArea,\n\tSUM ( case when f_cbsxyy = '\u5efa\u7b51\u62c6\u9664' then 1 else 0 end ) as jzccCount,\n\tSUM( case when f_cbsxyy = '\u5efa\u7b51\u62c6\u9664' then f_area else 0 end ) as jzccArea,\n\tSUM ( case when f_cbsxyy = '\u9762\u79ef\u4e0d\u8db3' then 1 else 0 end ) as mjbzCount,\n\tSUM ( case when f_cbsxyy = '\u9762\u79ef\u4e0d\u8db3' then f_area else 0 end ) as mjbzArea\nfrom\n\t" + jcClueSource.getfTablename() + where + "\ngroup by f_rwfp\nunion all \nselect\n\t'\u603b\u8ba1' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n\tSUM ( case when f_cbsxyy in( '\u624b\u7eed\u8986\u76d6\u7c7b','\u4e34\u65f6\u7528\u5730','\u8bbe\u65bd\u519c\u7528\u5730') then 1 else 0 end ) as ysxlCount,\n\tSUM( case when f_cbsxyy in( '\u624b\u7eed\u8986\u76d6\u7c7b','\u4e34\u65f6\u7528\u5730','\u8bbe\u65bd\u519c\u7528\u5730')  then f_area else 0 end ) as ysxlArea,\n\tSUM( case when f_cbsxyy = '\u5df2\u7eb3\u5165\u53d8\u66f4\u6784\u5efa\u7b51\u7269' then 1 else 0 end ) as ynrbgjzwCount,\n\tSUM( case when f_cbsxyy = '\u5df2\u7eb3\u5165\u53d8\u66f4\u6784\u5efa\u7b51\u7269' then f_area else 0 end ) as ynrbgjzwArea,\n\tSUM ( case when f_cbsxyy = '\u7eb3\u5165\u536b\u7247\u6267\u6cd5' then 1 else 0 end ) as nrwpzfCount,\n\tSUM( case when f_cbsxyy = '\u7eb3\u5165\u536b\u7247\u6267\u6cd5' then f_area else 0 end ) as nrwpzfArea,\n\tSUM ( case when f_cbsxyy is null and f_nxftb='\u4eba\u5de5\u5224\u5b9a' then 1 else 0 end ) as xzdwCount,\n\tSUM( case when f_cbsxyy is null and f_nxftb='\u4eba\u5de5\u5224\u5b9a' then f_area else 0 end ) as xzdwArea,\n\tSUM ( case when f_cbsxyy = '\u5efa\u7b51\u62c6\u9664' then 1 else 0 end ) as jzccCount,\n\tSUM( case when f_cbsxyy = '\u5efa\u7b51\u62c6\u9664' then f_area else 0 end ) as jzccArea,\n\tSUM ( case when f_cbsxyy = '\u9762\u79ef\u4e0d\u8db3' then 1 else 0 end ) as mjbzCount,\n\tSUM ( case when f_cbsxyy = '\u9762\u79ef\u4e0d\u8db3' then f_area else 0 end ) as mjbzArea\nfrom\n\t" + jcClueSource.getfTablename() + where + ";";
        List dataList = this.jdbcTemplate.queryForList(sql);
        return dataList;
    }

    public List<Map<String, Object>> statisticsXftbmx(String sourceId, String recordId) {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        String where = " where f_sourceid='" + sourceId + "'";
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            where = where + " and f_import_recordid = '" + recordId + "'";
        }
        String sql = " select f_rwfp as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea from \n\t" + jcClueSource.getfTablename() + where + " and f_jcrw='\u5e38\u89c4\u76d1\u6d4b' and f_nxftb='\u4e0b\u53d1'\ngroup by f_rwfp  \nunion all \nselect '\u603b\u8ba1' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea from \n\t" + jcClueSource.getfTablename() + where + " and f_jcrw='\u5e38\u89c4\u76d1\u6d4b' and f_nxftb='\u4e0b\u53d1';;";
        List dataList = this.jdbcTemplate.queryForList(sql);
        return dataList;
    }

    public void addClueSplitProgramme(JcClueSplitProgramme jcClueSplitProgramme) {
        List jcClueSplitProgrammeList = this.jcClueSplitProgrammeDao.selectBySourceIdAndProgrammeName(jcClueSplitProgramme.getSourceId(), jcClueSplitProgramme.getProgrammeName());
        if (jcClueSplitProgrammeList.size() > 0) {
            throw new GwValidateException("\u5206\u5c4f\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        jcClueSplitProgramme.setId(UUID.randomUUID().toString());
        jcClueSplitProgramme.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.jcClueSplitProgrammeDao.gwAccessSelective((GiEntitySaveable)jcClueSplitProgramme);
        if (jcClueSplitProgramme.getJcClueSplitMaps().size() > 0) {
            int i = 0;
            for (JcClueSplitMap jcClueSplitMap : jcClueSplitProgramme.getJcClueSplitMaps()) {
                jcClueSplitMap.setId(UUID.randomUUID().toString());
                jcClueSplitMap.setProgrammeId(jcClueSplitProgramme.getId());
                jcClueSplitMap.setOrderValue(Integer.valueOf(++i));
                this.jcClueSplitMapDao.gwAccessSelective((GiEntitySaveable)jcClueSplitMap);
                if (jcClueSplitMap.getJcClueSplitMapLayers().size() <= 0) continue;
                for (JcClueSplitMapLayer jcClueSplitMapLayer : jcClueSplitMap.getJcClueSplitMapLayers()) {
                    jcClueSplitMapLayer.setId(UUID.randomUUID().toString());
                    jcClueSplitMapLayer.setMapId(jcClueSplitMap.getId());
                    this.jcClueSplitMapLayerDao.gwAccessSelective((GiEntitySaveable)jcClueSplitMapLayer);
                }
            }
        }
    }

    public void updateClueSplitProgramme(JcClueSplitProgramme jcClueSplitProgramme) {
        JcClueSplitProgramme jcClueSplitProgramme1 = (JcClueSplitProgramme)this.jcClueSplitProgrammeDao.gwSearchByPK((Serializable)((Object)jcClueSplitProgramme.getId()));
        if (jcClueSplitProgramme1 == null) {
            throw new GwValidateException("\u7ebf\u7d22\u5206\u5c4f\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (!jcClueSplitProgramme1.getProgrammeName().equals(jcClueSplitProgramme.getProgrammeName())) {
            List jcClueSplitProgrammeList = this.jcClueSplitProgrammeDao.selectBySourceIdAndProgrammeName(jcClueSplitProgramme.getSourceId(), jcClueSplitProgramme.getProgrammeName());
            if (jcClueSplitProgrammeList.size() > 0) {
                throw new GwValidateException("\u5206\u5c4f\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            jcClueSplitProgramme1.setProgrammeName(jcClueSplitProgramme.getProgrammeName());
        }
        jcClueSplitProgramme1.setFilter(jcClueSplitProgramme.getFilter());
        jcClueSplitProgramme1.setMapNum(jcClueSplitProgramme.getMapNum());
        jcClueSplitProgramme1.setProgrammeDesc(jcClueSplitProgramme.getProgrammeDesc());
        jcClueSplitProgramme1.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.jcClueSplitProgrammeDao.gwUpdateByPKSelective((GiEntityAlterable)jcClueSplitProgramme);
        List jcClueSplitMaps = this.jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
        for (JcClueSplitMap jcClueSplitMap : jcClueSplitMaps) {
            this.jcClueSplitMapLayerDao.delByMapId(jcClueSplitMap.getId());
        }
        this.jcClueSplitMapDao.delByProgrammeId(jcClueSplitProgramme.getId());
        if (jcClueSplitProgramme.getJcClueSplitMaps().size() > 0) {
            int i = 0;
            for (JcClueSplitMap jcClueSplitMap : jcClueSplitProgramme.getJcClueSplitMaps()) {
                jcClueSplitMap.setId(UUID.randomUUID().toString());
                jcClueSplitMap.setProgrammeId(jcClueSplitProgramme.getId());
                jcClueSplitMap.setOrderValue(Integer.valueOf(++i));
                this.jcClueSplitMapDao.gwAccessSelective((GiEntitySaveable)jcClueSplitMap);
                if (jcClueSplitMap.getJcClueSplitMapLayers().size() <= 0) continue;
                for (JcClueSplitMapLayer jcClueSplitMapLayer : jcClueSplitMap.getJcClueSplitMapLayers()) {
                    jcClueSplitMapLayer.setId(UUID.randomUUID().toString());
                    jcClueSplitMapLayer.setMapId(jcClueSplitMap.getId());
                    this.jcClueSplitMapLayerDao.gwAccessSelective((GiEntitySaveable)jcClueSplitMapLayer);
                }
            }
        }
    }

    public void delClueSplitProgramme(String programmeId) {
        JcClueSplitProgramme jcClueSplitProgramme = (JcClueSplitProgramme)this.jcClueSplitProgrammeDao.gwSearchByPK((Serializable)((Object)programmeId));
        if (jcClueSplitProgramme == null) {
            throw new GwValidateException("\u5206\u5c4f\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        List jcClueSplitMaps = this.jcClueSplitMapDao.selectByProgrammeId(programmeId);
        for (JcClueSplitMap jcClueSplitMap : jcClueSplitMaps) {
            this.jcClueSplitMapLayerDao.delByMapId(jcClueSplitMap.getId());
        }
        this.jcClueSplitMapDao.delByProgrammeId(programmeId);
        this.jcClueSplitProgrammeDao.gwDeleteByPK((Serializable)((Object)programmeId));
    }

    public List<JcClueSplitProgramme> findClueSplitProgrammes(String sourceId, String programmeName) {
        List jcClueSplitProgrammes = this.jcClueSplitProgrammeDao.selectBySourceIdAndLikeProgrammeName(sourceId, programmeName);
        for (JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes) {
            List jcClueSplitMaps = this.jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
            jcClueSplitProgramme.setJcClueSplitMaps(jcClueSplitMaps);
            for (JcClueSplitMap jcClueSplitMap : jcClueSplitMaps) {
                List jcClueSplitMapLayers = this.jcClueSplitMapLayerDao.selectByMapId(jcClueSplitMap.getId());
                jcClueSplitMap.setJcClueSplitMapLayers(jcClueSplitMapLayers);
            }
        }
        return jcClueSplitProgrammes;
    }

    public List<JcClueSplitProgramme> findClueSplitProgrammeByClueId(String sourceId, String clueId) {
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        ArrayList<JcClueSplitProgramme> resultList = new ArrayList<JcClueSplitProgramme>();
        List<JcClueSplitProgramme> jcClueSplitProgrammes = this.findClueSplitProgrammes(sourceId, null);
        for (JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes) {
            if (!StringUtils.isNotBlank((CharSequence)jcClueSplitProgramme.getFilter())) continue;
            String filter = jcClueSplitProgramme.getFilter();
            String sql = " select count(1) from " + jcClueSource.getfTablename() + " where " + filter + " and f_id = '" + clueId + "';";
            try {
                Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
                if (count <= 0) continue;
                resultList.add(jcClueSplitProgramme);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), new Object[0]);
            }
        }
        return resultList;
    }

    public List<JcClueSplitProgramme> findClueSplitProgrammeByTbId(String taskId, String tbId) {
        String tableName = this.tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank((CharSequence)tableName)) {
            throw new RuntimeException("\u4efb\u52a1\u56fe\u73ed\u8868\u4e0d\u5b58\u5728");
        }
        ArrayList<JcClueSplitProgramme> resultList = new ArrayList<JcClueSplitProgramme>();
        List<JcClueSplitProgramme> jcClueSplitProgrammes = this.findClueSplitProgrammes(taskId, null);
        for (JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes) {
            if (!StringUtils.isNotBlank((CharSequence)jcClueSplitProgramme.getFilter())) continue;
            String filter = jcClueSplitProgramme.getFilter();
            String sql = " select count(1) from " + tableName + " where " + filter + " and f_id = '" + tbId + "';";
            try {
                Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
                if (count <= 0) continue;
                resultList.add(jcClueSplitProgramme);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), new Object[0]);
            }
        }
        return resultList;
    }

    public JcClueSplitProgramme findClueSplitProgrammeDetails(String programmeId) {
        JcClueSplitProgramme jcClueSplitProgramme = (JcClueSplitProgramme)this.jcClueSplitProgrammeDao.gwSearchByPK((Serializable)((Object)programmeId));
        if (jcClueSplitProgramme == null) {
            throw new GwValidateException("\u5206\u5c4f\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        List jcClueSplitMaps = this.jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
        jcClueSplitProgramme.setJcClueSplitMaps(jcClueSplitMaps);
        for (JcClueSplitMap jcClueSplitMap : jcClueSplitMaps) {
            List jcClueSplitMapLayers = this.jcClueSplitMapLayerDao.selectByMapId(jcClueSplitMap.getId());
            jcClueSplitMap.setJcClueSplitMapLayers(jcClueSplitMapLayers);
        }
        return jcClueSplitProgramme;
    }

    private void tbjxlxfxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); ++j) {
                XSSFRow row = workSheet.createRow(j + 3);
                XSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                cell0.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString() : null);
                cell1.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString() : null);
                cell2.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(maps.get(j).get("jgzwCount") != null ? maps.get(j).get("jgzwCount").toString() : null);
                cell3.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(maps.get(j).get("jgzwArea") != null ? maps.get(j).get("jgzwArea").toString() : null);
                cell4.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(maps.get(j).get("tdtCount") != null ? maps.get(j).get("tdtCount").toString() : null);
                cell5.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(maps.get(j).get("tdtArea") != null ? maps.get(j).get("tdtArea").toString() : null);
                cell6.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(maps.get(j).get("xzdwCount") != null ? maps.get(j).get("xzdwCount").toString() : null);
                cell7.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(maps.get(j).get("xzdwArea") != null ? maps.get(j).get("xzdwArea").toString() : null);
                cell8.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(maps.get(j).get("yldCount") != null ? maps.get(j).get("yldCount").toString() : null);
                cell9.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(maps.get(j).get("yldArea") != null ? maps.get(j).get("yldArea").toString() : null);
                cell10.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(maps.get(j).get("ktCount") != null ? maps.get(j).get("ktCount").toString() : null);
                cell11.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(maps.get(j).get("ktArea") != null ? maps.get(j).get("ktArea").toString() : null);
                cell12.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(maps.get(j).get("jzccCount") != null ? maps.get(j).get("jzccCount").toString() : null);
                cell13.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell14 = row.createCell(14);
                cell14.setCellValue(maps.get(j).get("jzccArea") != null ? maps.get(j).get("jzccArea").toString() : null);
                cell14.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell15 = row.createCell(15);
                cell15.setCellValue(maps.get(j).get("xzgdCount") != null ? maps.get(j).get("xzgdCount").toString() : null);
                cell15.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell116 = row.createCell(16);
                cell116.setCellValue(maps.get(j).get("xzgdArea") != null ? maps.get(j).get("xzgdArea").toString() : null);
                cell116.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private void gdwtbdjfxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); ++j) {
                XSSFRow row = workSheet.createRow(j + 5);
                XSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                cell0.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString() : null);
                cell1.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString() : null);
                cell2.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(maps.get(j).get("ysxlCount") != null ? maps.get(j).get("ysxlCount").toString() : null);
                cell3.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(maps.get(j).get("ysxlArea") != null ? maps.get(j).get("ysxlArea").toString() : null);
                cell4.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(maps.get(j).get("ynrbgjzwCount") != null ? maps.get(j).get("ynrbgjzwCount").toString() : null);
                cell5.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(maps.get(j).get("ynrbgjzwArea") != null ? maps.get(j).get("ynrbgjzwArea").toString() : null);
                cell6.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(maps.get(j).get("nrwpzfCount") != null ? maps.get(j).get("nrwpzfCount").toString() : null);
                cell7.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(maps.get(j).get("nrwpzfArea") != null ? maps.get(j).get("nrwpzfArea").toString() : null);
                cell8.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(maps.get(j).get("xzdwCount") != null ? maps.get(j).get("xzdwCount").toString() : null);
                cell9.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(maps.get(j).get("xzdwArea") != null ? maps.get(j).get("xzdwArea").toString() : null);
                cell10.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(maps.get(j).get("jzccCount") != null ? maps.get(j).get("jzccCount").toString() : null);
                cell11.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(maps.get(j).get("jzccArea") != null ? maps.get(j).get("jzccArea").toString() : null);
                cell12.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(maps.get(j).get("mjbzCount") != null ? maps.get(j).get("mjbzCount").toString() : null);
                cell13.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell14 = row.createCell(14);
                cell14.setCellValue(maps.get(j).get("mjbzArea") != null ? maps.get(j).get("mjbzArea").toString() : null);
                cell14.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private void xftbmxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); ++j) {
                XSSFRow row = workSheet.createRow(j + 4);
                XSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                cell0.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString() : null);
                cell1.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString() : null);
                cell2.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell3 = row.createCell(3);
                cell3.setCellValue("");
                cell3.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell4 = row.createCell(4);
                cell4.setCellValue("");
                cell4.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString() : null);
                cell5.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString() : null);
                cell6.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private void zhjcjgxsbSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); ++j) {
                XSSFRow row = workSheet.createRow(j + 3);
                XSSFCell cell = row.createCell(0);
                cell.setCellValue((double)(j + 1));
                cell.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell0 = row.createCell(1);
                cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                cell0.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell1 = row.createCell(2);
                cell1.setCellValue(maps.get(j).get("\u5c0f\u8ba1") != null ? maps.get(j).get("\u5c0f\u8ba1").toString() : null);
                cell1.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell2 = row.createCell(3);
                cell2.setCellValue(maps.get(j).get("\u56fd\u5bb6\u7ebf\u7d22") != null ? maps.get(j).get("\u56fd\u5bb6\u7ebf\u7d22").toString() : null);
                cell2.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell3 = row.createCell(4);
                cell3.setCellValue(maps.get(j).get("\u5e02\u7ea7\u7ebf\u7d22") != null ? maps.get(j).get("\u5e02\u7ea7\u7ebf\u7d22").toString() : null);
                cell3.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell4 = row.createCell(5);
                cell4.setCellValue(maps.get(j).get("\u533a\u53bf\u7ebf\u7d22") != null ? maps.get(j).get("\u533a\u53bf\u7ebf\u7d22").toString() : null);
                cell4.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell5 = row.createCell(6);
                cell5.setCellValue(maps.get(j).get("\u7efc\u5408\u76d1\u6d4b") != null ? maps.get(j).get("\u7efc\u5408\u76d1\u6d4b").toString() : null);
                cell5.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell6 = row.createCell(7);
                cell6.setCellValue((double)(Integer.valueOf(maps.get(j).get("\u5c0f\u8ba1").toString()) - Integer.valueOf(maps.get(j).get("\u7efc\u5408\u76d1\u6d4b").toString())));
                cell6.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell7 = row.createCell(8);
                double dividend = Double.valueOf(maps.get(j).get("\u7efc\u5408\u76d1\u6d4b").toString());
                double divisor = Double.valueOf(maps.get(j).get("\u5c0f\u8ba1").toString());
                double result = dividend / divisor;
                DecimalFormat decimalFormat = new DecimalFormat("0.00%");
                cell7.setCellValue(divisor > 0.0 ? decimalFormat.format(result) : "0.00%");
                cell7.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private void shfpqdSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); ++j) {
                XSSFRow row = workSheet.createRow(j + 1);
                XSSFCell cell = row.createCell(0);
                cell.setCellValue((double)(j + 1));
                cell.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell0 = row.createCell(1);
                cell0.setCellValue(maps.get(j).get("f_id") != null ? maps.get(j).get("f_id").toString() : null);
                cell0.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell1 = row.createCell(2);
                cell1.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                cell1.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell2 = row.createCell(3);
                cell2.setCellValue(maps.get(j).get("f_tbbh") != null ? maps.get(j).get("f_tbbh").toString() : null);
                cell2.setCellStyle((CellStyle)cellStyle);
                XSSFCell cell3 = row.createCell(4);
                cell3.setCellValue("");
                cell3.setCellStyle((CellStyle)cellStyle);
            }
        }
    }
}

