/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.FieldDisPlay;
import com.geoway.landteam.customtask.task.dto.FieldGroup;
import com.geoway.landteam.customtask.task.dto.TaskCategoryDTO;
import com.geoway.landteam.customtask.task.dto.TaskDefineDTO;
import com.geoway.landteam.customtask.task.dto.TaskFieldDefineDTO;
import com.geoway.landteam.customtask.task.dto.TaskFieldMappingDTO;
import com.geoway.landteam.customtask.task.dto.TaskMetaDTO;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.JaxbXmlUtil;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskImportTaskDataService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueGroupMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueImportRelMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueImportTaskRelFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueImportTaskRelMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueSourceMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueTemplateMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.CuleGroupDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.JcClueImportTaskRelDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueGroup;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRelFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTemplate;
import com.geoway.landteam.patrolclue.model.until.ThirdInterfaceUtil;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service
public class MJcClueSourceImpl
implements MJcClueSourceService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueSourceMapper jcClueSourceMapper;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;
    @Autowired
    JcClueGroupMapper jcClueGroupMapper;
    @Autowired
    JcClueImportTaskRelMapper jcClueImportTaskRelMapper;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JcClueImportRelMapper jcClueImportRelMapper;
    @Autowired
    JcClueImportTaskRelFieldsMapper jcClueImportTaskRelFieldsMapper;
    @Autowired
    JcClueTemplateMapper jcClueTemplateMapper;
    @Autowired
    DataBizMapper dataBizMapper;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    RegionService regionService;
    @Autowired
    JcClueFieldsService jcClueFieldsService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    MTaskImportTaskDataService taskImportTaskDataService;
    @Value(value="${intelligent.analysis.url:}")
    protected String analysisUrl;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    AppMediaService appMediaService;

    public List<JcClueSource> getClueList(Integer state, String sourceName, String appsId) {
        return this.jcClueSourceMapper.getAllList(state, sourceName, appsId);
    }

    public JcClueSource findOne(String id) {
        return (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)id);
    }

    public JcClueSource findByName(String name) {
        return this.jcClueSourceMapper.findByName(name);
    }

    public JcClueSource findByNameAndAppsId(String name, String appsId) {
        return this.jcClueSourceMapper.findByNameAndAppsId(name, appsId);
    }

    public JcClueSource findByRemark(String remark) {
        return this.jcClueSourceMapper.findByRemark(remark);
    }

    public List<JcClueSource> findByNameAndSourceId(String sourceId, String name) {
        return this.jcClueSourceMapper.findByNameAndSourceId(sourceId, name);
    }

    public JcClueSource createClueSource(Long userId, String sourceName, String sourceDesc, String parentId, Integer fLevel, String isNeedTemple, String importtype, String importfiletype, String showtype, String templeId, String appsId, Integer clueClass) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JcClueSource bean = new JcClueSource();
        String id = UUID.randomUUID().toString();
        bean.setfName(sourceName);
        bean.setfUserid(BigDecimal.valueOf(userId));
        bean.setfId(id);
        bean.setfCreatetime(format.format(new Date()));
        bean.setfState(Integer.valueOf(isNeedTemple.equals("1") ? 0 : 1));
        bean.setfIsneedtemple(isNeedTemple);
        bean.setfParentid(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parentId) ? parentId : "-1");
        bean.setfLevel(fLevel);
        bean.setfRemark(sourceDesc);
        bean.setfShowtype(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)showtype) ? Short.valueOf(Short.parseShort(showtype)) : null);
        bean.setfTempleid(templeId);
        bean.setfImporttype(importtype);
        bean.setfImportfiletype(importfiletype);
        bean.setfAppsId(appsId);
        bean.setfClueclass(clueClass);
        this.jcClueSourceMapper.insertSelective((Object)bean);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)templeId)) {
            this.jcClueFieldsMapper.insertFieldByTemple(id, templeId);
        }
        return bean;
    }

    public void clueSourceRecordMove(String clueId, String orderVal, String orderType, String appsId) {
        if ("1".equals(orderType)) {
            List preRecord = this.jcClueSourceMapper.findPreRecord(Integer.valueOf(Integer.parseInt(orderVal)), appsId);
            this.jcClueSourceMapper.updateMaxOrderVal(((JcClueSource)preRecord.get(0)).getfId(), ((JcClueSource)preRecord.get(1)).getfOrder());
            this.jcClueSourceMapper.updateMaxOrderVal(((JcClueSource)preRecord.get(1)).getfId(), ((JcClueSource)preRecord.get(0)).getfOrder());
        } else if ("2".equals(orderType)) {
            List nextRecord = this.jcClueSourceMapper.findNextRecord(Integer.valueOf(Integer.parseInt(orderVal)), appsId);
            this.jcClueSourceMapper.updateMaxOrderVal(((JcClueSource)nextRecord.get(0)).getfId(), ((JcClueSource)nextRecord.get(1)).getfOrder());
            this.jcClueSourceMapper.updateMaxOrderVal(((JcClueSource)nextRecord.get(1)).getfId(), ((JcClueSource)nextRecord.get(0)).getfOrder());
        } else if ("3".equals(orderType)) {
            int maxOrderVal = this.jcClueSourceMapper.findMaxOrderVal();
            this.jcClueSourceMapper.updateOrderVal(Integer.valueOf(maxOrderVal), Integer.valueOf(Integer.parseInt(orderVal)));
            this.jcClueSourceMapper.updateMaxOrderVal(clueId, Integer.valueOf(maxOrderVal));
        }
    }

    public JcClueSource addClueResouceGroup(JcClueSource bean) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        bean.setfLevel(Integer.valueOf(bean.getfLevel() + 1));
        bean.setfId(UUID.randomUUID().toString());
        bean.setfCreatetime(format.format(new Date()));
        bean.setfState(Integer.valueOf(1));
        this.jcClueSourceMapper.insertSelective((Object)bean);
        this.syncClueInfo(bean, bean.getfUserid().longValue(), "groupNode", "insert");
        return bean;
    }

    public JcClueSource updatNameById(JcClueSource bean, String templeId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)templeId) && !bean.getfTempleid().equals(templeId)) {
            this.jcClueFieldsMapper.deleteByTableId(bean.getfId());
            this.jcClueFieldsMapper.insertFieldByTemple(bean.getfId(), templeId);
            this.jcClueGroupMapper.deleteBytableId(bean.getfId(), "web");
        }
        bean.setfTempleid(templeId);
        this.jcClueSourceMapper.updateByPrimaryKeySelective((Object)bean);
        return bean;
    }

    public int deleteByPrimaryKey(String id) {
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)id);
        if (jcClueSource.getfTablename() != null) {
            this.syncClueInfo(id, "delete");
        }
        int result = this.jcClueSourceMapper.deleteByPrimaryKey((Object)id);
        return result;
    }

    public void syncClueInfo(String sourceId, String type) {
        JSONObject params = new JSONObject();
        params.put("sourceId", (Object)sourceId);
        params.put("type", (Object)type);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(sourceId);
        record.setRead(Integer.valueOf(0));
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        this.taskRecordService.save(record);
    }

    public List<JcClueSource> getClueAllGroup(Integer state, String sourceName, String appsId) {
        List allList = this.jcClueSourceMapper.getAllList(state, sourceName, appsId);
        for (JcClueSource jcClueSource : allList) {
            List tbtskTaskClasses = this.jcClueSourceMapper.queryByParentId(jcClueSource.getfId(), null);
            tbtskTaskClasses.forEach(this::completeChildren);
            jcClueSource.setChildren(tbtskTaskClasses);
        }
        return allList;
    }

    public JcClueSource clueTrees(String sourceId) {
        JcClueSource bean = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        List tbtskTaskClasses = this.jcClueSourceMapper.queryByParentId(sourceId, null);
        tbtskTaskClasses.forEach(this::completeChildren);
        bean.setChildren(tbtskTaskClasses);
        return bean;
    }

    public List<JcClueSource> getCuleBysourceids(List<String> sourceIdList) {
        return this.jcClueSourceMapper.getCuleBysourceids(sourceIdList);
    }

    private void completeChildren(JcClueSource jcClueSource) {
        List jcClueSources = this.jcClueSourceMapper.queryByParentId(jcClueSource.getfId(), null);
        if (jcClueSources == null) {
            return;
        }
        jcClueSources.forEach(this::completeChildren);
        if (jcClueSources.size() > 0) {
            jcClueSource.setChildren(jcClueSources);
        } else {
            jcClueSource.setChildren(null);
        }
    }

    private void completeClueChildren(JcClueSource jcClueSource, List<String> tableNames) {
        List jcClueSources = this.jcClueSourceMapper.queryByParentId(jcClueSource.getfId(), null);
        if (jcClueSources != null && jcClueSources.size() > 0) {
            for (JcClueSource bean : jcClueSources) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bean.getfTablename())) {
                    tableNames.add(bean.getfTablename());
                }
                this.completeClueChildren(bean, tableNames);
            }
        }
    }

    public JcClueSource rootJcClueSource(String sourceId) {
        JcClueSource bean = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        if (!"-1".equals(bean.getfParentid())) {
            JcClueSource jcClueSource = this.recursive(bean);
            return jcClueSource;
        }
        return bean;
    }

    private JcClueSource recursive(JcClueSource jcClueSource) {
        JcClueSource bean = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)jcClueSource.getfParentid());
        if (!"-1".equals(bean.getfParentid())) {
            JcClueSource clueSource = this.recursive(bean);
            return clueSource;
        }
        return bean;
    }

    public JcClueSource finishCuleSource(JcClueSource jcClueSource, Long userId) {
        if (jcClueSource.getfTablename() == null) {
            String sourceName = PinYinUtil.getFirstSpell((String)jcClueSource.getfName());
            String tableName = MJcClueSourceImpl.generateTableName(sourceName);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfAppsId())) {
                String sql = " select f_schema from bus_apps_schema where f_apps_id = '" + jcClueSource.getfAppsId() + "'";
                String txtStr = (String)this.jdbcTemplate.queryForObject(sql, String.class);
                tableName = txtStr + "." + tableName;
            }
            jcClueSource.setfTablename(tableName);
            this.jcClueFieldsService.updateTableNameBytableId(tableName, jcClueSource.getfId());
            this.createTable(jcClueSource);
            jcClueSource.setfState(Integer.valueOf(1));
            this.jcClueSourceMapper.updateByPrimaryKey((Object)jcClueSource);
            this.defaultClueImportRel(jcClueSource.getfId());
            this.syncClueInfo(jcClueSource, userId, "rootNode", "insert");
        } else {
            this.defaultClueImportRel(jcClueSource.getfId());
        }
        return jcClueSource;
    }

    public void syncClueInfo(JcClueSource jcClueSource, Long userId, String source, String type) {
        JSONObject params = new JSONObject();
        params.put("sourceId", (Object)jcClueSource.getfId());
        params.put("userId", (Object)userId);
        params.put("type", (Object)type);
        params.put("source", (Object)source);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(jcClueSource.getfId());
        record.setRead(Integer.valueOf(0));
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        record.setTaskName(jcClueSource.getfName());
        this.taskRecordService.save(record);
    }

    public JSONArray getClueStatistical(String appsId) {
        JSONArray jsonArray = new JSONArray();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        for (JcClueSource jcClueSource : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceName", (Object)jcClueSource.getfName());
            jsonObject.put("sourceId", (Object)jcClueSource.getfId());
            jsonObject.put("untreatedNum", (Object)0);
            jsonObject.put("handleNum", (Object)0);
            jsonObject.put("totalNum", (Object)0);
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String sql = "select f_status,count(1) from " + s + " group by f_status";
                    List maps = this.jdbcTemplate.queryForList(sql);
                    for (Map map : maps) {
                        if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                            jsonObject.put("untreatedNum", (Object)(jsonObject.getInteger("untreatedNum") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        jsonObject.put("handleNum", (Object)(jsonObject.getInteger("handleNum") + Integer.valueOf(map.get("count").toString())));
                    }
                }
            }
            jsonObject.put("totalNum", (Object)(Integer.valueOf(jsonObject.get((Object)"handleNum").toString()) + Integer.valueOf(jsonObject.get((Object)"untreatedNum").toString())));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getClueStatisticalByDate(String appsId, String startTime, String endTime) {
        JSONArray jsonArray = new JSONArray();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        for (JcClueSource jcClueSource : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceName", (Object)jcClueSource.getfName());
            jsonObject.put("sourceId", (Object)jcClueSource.getfId());
            jsonObject.put("totalNum", (Object)0);
            jsonObject.put("totalArea", (Object)0);
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String sql = "select count(1) ,sum(f_area)  from " + s;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
                        sql = sql + " where f_createtime between '" + MJcClueSourceImpl.converTime(startTime) + "' and '" + MJcClueSourceImpl.converTime(endTime) + "'";
                    }
                    List maps = this.jdbcTemplate.queryForList(sql);
                    for (Map map : maps) {
                        if (map.get("count") == null || map.get("sum") == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("sum").toString())) continue;
                        jsonObject.put("totalNum", (Object)(jsonObject.getInteger("totalNum") + Integer.valueOf(map.get("count").toString())));
                        BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                        bd = bd.setScale(2, RoundingMode.HALF_UP);
                        jsonObject.put("totalArea", (Object)(jsonObject.getDoubleValue("totalArea") + bd.doubleValue()));
                    }
                }
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getClueStatisticalByClassAndDate(String appsId, String startTime, String endTime) {
        JSONArray jsonArray = new JSONArray();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceName", (Object)"\u56fd\u5bb6\u7ebf\u7d22");
        jsonObject.put("totalNum", (Object)0);
        jsonObject.put("totalArea", (Object)0);
        jsonArray.add((Object)jsonObject);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("sourceName", (Object)"\u5e02\u7ea7\u7ebf\u7d22");
        jsonObject1.put("totalNum", (Object)0);
        jsonObject1.put("totalArea", (Object)0);
        jsonArray.add((Object)jsonObject1);
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("sourceName", (Object)"\u533a\u53bf\u7ebf\u7d22");
        jsonObject2.put("totalNum", (Object)0);
        jsonObject2.put("totalArea", (Object)0);
        jsonArray.add((Object)jsonObject2);
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("sourceName", (Object)"\u7efc\u5408\u76d1\u6d4b");
        jsonObject3.put("totalNum", (Object)0);
        jsonObject3.put("totalArea", (Object)0);
        jsonArray.add((Object)jsonObject3);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String sql = "select count(1) ,sum(f_area)  from " + s;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
                    sql = sql + " where f_createtime between '" + MJcClueSourceImpl.converTime(startTime) + "' and '" + MJcClueSourceImpl.converTime(endTime) + "'";
                }
                List maps = this.jdbcTemplate.queryForList(sql);
                for (Map map : maps) {
                    BigDecimal bd;
                    if (map.get("count") == null || map.get("sum") == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("sum").toString())) continue;
                    if (jcClueSource.getfClueclass() == 1) {
                        jsonObject.put("totalNum", (Object)(jsonObject.getInteger("totalNum") + Integer.valueOf(map.get("count").toString())));
                        bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                        bd = bd.setScale(2, RoundingMode.HALF_UP);
                        jsonObject.put("totalArea", (Object)(jsonObject.getDoubleValue("totalArea") + bd.doubleValue()));
                        continue;
                    }
                    if (jcClueSource.getfClueclass() == 3) {
                        jsonObject1.put("totalNum", (Object)(jsonObject1.getInteger("totalNum") + Integer.valueOf(map.get("count").toString())));
                        bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                        bd = bd.setScale(2, RoundingMode.HALF_UP);
                        jsonObject1.put("totalArea", (Object)(jsonObject1.getDoubleValue("totalArea") + bd.doubleValue()));
                        continue;
                    }
                    if (jcClueSource.getfClueclass() == 4) {
                        jsonObject2.put("totalNum", (Object)(jsonObject2.getInteger("totalNum") + Integer.valueOf(map.get("count").toString())));
                        bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                        bd = bd.setScale(2, RoundingMode.HALF_UP);
                        jsonObject2.put("totalArea", (Object)(jsonObject2.getDoubleValue("totalArea") + bd.doubleValue()));
                        continue;
                    }
                    if (!jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) continue;
                    jsonObject3.put("totalNum", (Object)(jsonObject3.getInteger("totalNum") + Integer.valueOf(map.get("count").toString())));
                    bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                    bd = bd.setScale(2, RoundingMode.HALF_UP);
                    jsonObject3.put("totalArea", (Object)(jsonObject3.getDoubleValue("totalArea") + bd.doubleValue()));
                }
            }
        }
        return jsonArray;
    }

    public Map<String, List<Map<String, Object>>> getClueStatisticalXzqByDate(String appsId, String startTime, String endTime) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> resultMap1 = new ArrayList<Map<String, Object>>();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String string : tableNames) {
                String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + string + "  ";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
                    Bsql = Bsql + " where f_createtime between '" + MJcClueSourceImpl.converTime(startTime) + "' and '" + MJcClueSourceImpl.converTime(endTime) + "'";
                }
                String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List maps = this.jdbcTemplate.queryForList(sql);
                if (jcClueSource.getfClueclass() == 1 || jcClueSource.getfClueclass() == 3 || jcClueSource.getfClueclass() == 4) {
                    resultMap.addAll(maps);
                    continue;
                }
                if (!jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) continue;
                resultMap1.addAll(maps);
            }
        }
        List<Map<String, Object>> mapList = MJcClueSourceImpl.removeRepeatMapByKey(resultMap, "f_xzqdm");
        List ysxslist = mapList.stream().sorted((e1, e2) -> -Double.compare(Double.parseDouble(e1.get("count").toString()), Double.parseDouble(e2.get("count").toString()))).collect(Collectors.toList());
        List<Map<String, Object>> mapList1 = MJcClueSourceImpl.removeRepeatMapByKey(resultMap1, "f_xzqdm");
        ArrayList<Map<String, Object>> zhjgxslist = new ArrayList<Map<String, Object>>();
        block2: for (Map map : ysxslist) {
            for (Map<String, Object> map1 : mapList1) {
                if (!map.get("f_xzqdm").toString().equals(map1.get("f_xzqdm").toString())) continue;
                zhjgxslist.add(map1);
                continue block2;
            }
        }
        HashMap<String, List<Map<String, Object>>> hashMap = new HashMap<String, List<Map<String, Object>>>();
        hashMap.put("\u539f\u59cb\u7ebf\u7d22", ysxslist);
        hashMap.put("\u7efc\u5408\u76d1\u6d4b\u7ebf\u7d22", zhjgxslist);
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> getClueDistStatisticalByDate(String appsId, String startTime, String endTime) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        int i = 1;
        for (JcClueSource jcClueSource : list) {
            ArrayList<Map<String, Object>> resultMap1 = new ArrayList<Map<String, Object>>();
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    void var15_25;
                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + s + "  ";
                    String string = " ";
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
                        String string2 = " where f_createtime between '" + MJcClueSourceImpl.converTime(startTime) + "' and '" + MJcClueSourceImpl.converTime(endTime) + "'";
                    }
                    String sql = Asql + Bsql + (String)var15_25 + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)  union all\nselect '500000' as f_xzqdm,'\u91cd\u5e86\u5e02' as f_xzqmc,count(1) as count from " + s + (String)var15_25;
                    List maps = this.jdbcTemplate.queryForList(sql);
                    resultMap1.addAll(maps);
                }
            }
            List<Map<String, Object>> mapList = MJcClueSourceImpl.removeRepeatMapByKey(resultMap1, "f_xzqdm");
            for (Map<String, Object> map : mapList) {
                if (jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) {
                    map.put("\u7efc\u5408\u76d1\u6d4b", map.get("count"));
                    map.put("\u5c0f\u8ba1", 0);
                } else if (jcClueSource.getfName().contains("\u5e38\u89c4\u76d1\u6d4b")) {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u5e38\u89c4\u76d1\u6d4b", map.get("count"));
                } else if (jcClueSource.getfName().contains("\u536b\u7247\u6267\u6cd5")) {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u536b\u7247\u6267\u6cd5", map.get("count"));
                } else {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u5176\u4ed6\u7ebf\u7d22", map.get("count"));
                }
                if (i > 1) {
                    for (Map map2 : resultMap) {
                        if (!map.get("f_xzqdm").toString().contains(map2.get("f_xzqdm").toString())) continue;
                        if (jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) {
                            if (map2.containsKey("\u7efc\u5408\u76d1\u6d4b")) {
                                map2.put("\u7efc\u5408\u76d1\u6d4b", Integer.valueOf(map2.get("\u7efc\u5408\u76d1\u6d4b").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u7efc\u5408\u76d1\u6d4b", map.get("count"));
                            continue;
                        }
                        if (jcClueSource.getfName().contains("\u5e38\u89c4\u76d1\u6d4b")) {
                            map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                            if (map2.containsKey("\u5e38\u89c4\u76d1\u6d4b")) {
                                map2.put("\u5e38\u89c4\u76d1\u6d4b", Integer.valueOf(map2.get("\u5e38\u89c4\u76d1\u6d4b").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u5e38\u89c4\u76d1\u6d4b", map.get("count"));
                            continue;
                        }
                        if (jcClueSource.getfName().contains("\u536b\u7247\u6267\u6cd5")) {
                            map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                            if (map2.containsKey("\u536b\u7247\u6267\u6cd5")) {
                                map2.put("\u536b\u7247\u6267\u6cd5", Integer.valueOf(map2.get("\u536b\u7247\u6267\u6cd5").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u536b\u7247\u6267\u6cd5", map.get("count"));
                            continue;
                        }
                        map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                        if (map2.containsKey("\u5176\u4ed6\u7ebf\u7d22")) {
                            map2.put("\u5176\u4ed6\u7ebf\u7d22", Integer.valueOf(map2.get("\u5176\u4ed6\u7ebf\u7d22").toString()) + Integer.valueOf(map.get("count").toString()));
                            continue;
                        }
                        map2.put("\u5176\u4ed6\u7ebf\u7d22", map.get("count"));
                    }
                    continue;
                }
                resultMap.add(map);
            }
            ++i;
        }
        for (Map map : resultMap) {
            double dividend = Double.valueOf(map.getOrDefault("\u7efc\u5408\u76d1\u6d4b", "0").toString());
            double divisor = Double.valueOf(map.get("\u5c0f\u8ba1").toString());
            double result = dividend / divisor;
            DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            map.put("\u51cf\u5c11\u4e0b\u53d1\u7ebf\u7d22", Integer.valueOf(map.get("\u5c0f\u8ba1").toString()) - Integer.valueOf(map.getOrDefault("\u7efc\u5408\u76d1\u6d4b", "0").toString()));
            map.put("\u4e0b\u53d1\u7ebf\u7d22\u51cf\u5c11\u7387", divisor > 0.0 ? decimalFormat.format(result) : "0.00%");
        }
        List<Map<String, Object>> list1 = resultMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("\u5c0f\u8ba1"), (Integer)e2.get("\u5c0f\u8ba1"))).collect(Collectors.toList());
        return list1;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> getClueDistStatisticalByClassAndDate(String appsId, String startTime, String endTime) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        int i = 1;
        for (JcClueSource jcClueSource : list) {
            ArrayList<Map<String, Object>> resultMap1 = new ArrayList<Map<String, Object>>();
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    void var15_25;
                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + s + "  ";
                    String string = " ";
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
                        String string2 = " where f_createtime between '" + MJcClueSourceImpl.converTime(startTime) + "' and '" + MJcClueSourceImpl.converTime(endTime) + "'";
                    }
                    String sql = Asql + Bsql + (String)var15_25 + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)  union all\nselect '500000' as f_xzqdm,'\u91cd\u5e86\u5e02' as f_xzqmc,count(1) as count from " + s + (String)var15_25;
                    List maps = this.jdbcTemplate.queryForList(sql);
                    resultMap1.addAll(maps);
                }
            }
            List<Map<String, Object>> mapList = MJcClueSourceImpl.removeRepeatMapByKey(resultMap1, "f_xzqdm");
            for (Map<String, Object> map : mapList) {
                map.put("\u533a\u53bf\u7ebf\u7d22", 0);
                map.put("\u56fd\u5bb6\u7ebf\u7d22", 0);
                map.put("\u5e02\u7ea7\u7ebf\u7d22", 0);
                map.put("\u5c0f\u8ba1", 0);
                if (jcClueSource.getfClueclass() == 1) {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u56fd\u5bb6\u7ebf\u7d22", map.get("count"));
                } else if (jcClueSource.getfClueclass() == 3) {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u5e02\u7ea7\u7ebf\u7d22", map.get("count"));
                } else if (jcClueSource.getfClueclass() == 4) {
                    map.put("\u5c0f\u8ba1", map.get("count"));
                    map.put("\u533a\u53bf\u7ebf\u7d22", map.get("count"));
                } else if (jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) {
                    map.put("\u7efc\u5408\u76d1\u6d4b", map.get("count"));
                    map.put("\u5c0f\u8ba1", 0);
                }
                if (i > 1) {
                    for (Map map2 : resultMap) {
                        if (!map.get("f_xzqdm").toString().contains(map2.get("f_xzqdm").toString())) continue;
                        if (jcClueSource.getfClueclass() == 1) {
                            map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                            if (map2.containsKey("\u56fd\u5bb6\u7ebf\u7d22")) {
                                map2.put("\u56fd\u5bb6\u7ebf\u7d22", Integer.valueOf(map2.get("\u56fd\u5bb6\u7ebf\u7d22").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u56fd\u5bb6\u7ebf\u7d22", map.get("count"));
                            continue;
                        }
                        if (jcClueSource.getfClueclass() == 3) {
                            map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                            if (map2.containsKey("\u5e02\u7ea7\u7ebf\u7d22")) {
                                map2.put("\u5e02\u7ea7\u7ebf\u7d22", Integer.valueOf(map2.get("\u5e02\u7ea7\u7ebf\u7d22").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u5e02\u7ea7\u7ebf\u7d22", map.get("count"));
                            continue;
                        }
                        if (jcClueSource.getfClueclass() == 4) {
                            map2.put("\u5c0f\u8ba1", Integer.valueOf(map2.get("\u5c0f\u8ba1").toString()) + Integer.valueOf(map.get("\u5c0f\u8ba1").toString()));
                            if (map2.containsKey("\u533a\u53bf\u7ebf\u7d22")) {
                                map2.put("\u533a\u53bf\u7ebf\u7d22", Integer.valueOf(map2.get("\u533a\u53bf\u7ebf\u7d22").toString()) + Integer.valueOf(map.get("count").toString()));
                                continue;
                            }
                            map2.put("\u533a\u53bf\u7ebf\u7d22", map.get("count"));
                            continue;
                        }
                        if (!jcClueSource.getfName().contains("\u7efc\u5408\u76d1\u6d4b")) continue;
                        if (map2.containsKey("\u7efc\u5408\u76d1\u6d4b")) {
                            map2.put("\u7efc\u5408\u76d1\u6d4b", Integer.valueOf(map2.get("\u7efc\u5408\u76d1\u6d4b").toString()) + Integer.valueOf(map.get("count").toString()));
                            continue;
                        }
                        map2.put("\u7efc\u5408\u76d1\u6d4b", map.get("count"));
                    }
                    continue;
                }
                resultMap.add(map);
            }
            ++i;
        }
        for (Map map : resultMap) {
            double dividend = Double.valueOf(map.getOrDefault("\u7efc\u5408\u76d1\u6d4b", "0").toString());
            double divisor = Double.valueOf(map.get("\u5c0f\u8ba1").toString());
            double result = dividend / divisor;
            DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            map.put("\u51cf\u5c11\u4e0b\u53d1\u7ebf\u7d22", Integer.valueOf(map.get("\u5c0f\u8ba1").toString()) - Integer.valueOf(map.getOrDefault("\u7efc\u5408\u76d1\u6d4b", "0").toString()));
            map.put("\u4e0b\u53d1\u7ebf\u7d22\u51cf\u5c11\u7387", divisor > 0.0 ? decimalFormat.format(result) : "0.00%");
        }
        List<Map<String, Object>> list1 = resultMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("\u5c0f\u8ba1"), (Integer)e2.get("\u5c0f\u8ba1"))).collect(Collectors.toList());
        return list1;
    }

    public static List<Map<String, Object>> removeRepeatMapByKey(List<Map<String, Object>> list, String mapKey) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        HashMap<String, Map<String, Object>> msp = new HashMap<String, Map<String, Object>>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Map<String, Object> map = list.get(i);
            String id = (String)map.get(mapKey);
            map.remove(mapKey);
            if (msp.containsKey(id)) {
                map.put("count", Long.parseLong(((Map)msp.get(id)).get("count").toString()) + Long.parseLong(map.get("count").toString()));
            }
            msp.put(id, map);
        }
        Set mspKey = msp.keySet();
        for (String key : mspKey) {
            Map newMap = (Map)msp.get(key);
            newMap.put(mapKey, key);
            listMap.add(newMap);
        }
        return listMap;
    }

    public JSONArray getAllClueStatistical(String appsId) {
        JSONArray jsonArray = new JSONArray();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject allObject = new JSONObject();
        Integer alllHandleNum = 0;
        Integer allUntreatedNum = 0;
        JSONObject yearObject = new JSONObject();
        Integer yearHandleNum = 0;
        Integer yearUntreatedNum = 0;
        JSONObject seasonObject = new JSONObject();
        Integer seasonHandleNum = 0;
        Integer seasonUntreatedNum = 0;
        JSONObject monthObject = new JSONObject();
        Integer monthHandleNum = 0;
        Integer monthUntreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for (JcClueSource jcClueSource : list) {
            if (jcClueSource.getfTablename() == null) continue;
            String sql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " group by f_status";
            List maps = this.jdbcTemplate.queryForList(sql);
            for (Map map : maps) {
                if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                    allUntreatedNum = allUntreatedNum + Integer.valueOf(map.get("count").toString());
                    continue;
                }
                alllHandleNum = alllHandleNum + Integer.valueOf(map.get("count").toString());
            }
            int year = cal.get(1);
            String start = year + "-01-01 00:00:00";
            String end = year + "-12-31 23:59:59";
            String yearsql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " where f_createtime between '" + MJcClueSourceImpl.converTime(start) + "' and '" + MJcClueSourceImpl.converTime(end) + "' group by f_status";
            List map1s = this.jdbcTemplate.queryForList(yearsql);
            for (Map map1 : map1s) {
                if (map1.get("f_status") != null && map1.get("f_status").toString().equals("0")) {
                    yearUntreatedNum = yearUntreatedNum + Integer.valueOf(map1.get("count").toString());
                    continue;
                }
                yearHandleNum = yearHandleNum + Integer.valueOf(map1.get("count").toString());
            }
            String seasonStart = MJcClueSourceImpl.getCurrentQuarterStartTime();
            String seasonEnd = MJcClueSourceImpl.getCurrentQuarterEndTime();
            String seasonsql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " where f_createtime between '" + MJcClueSourceImpl.converTime(seasonStart) + "' and '" + MJcClueSourceImpl.converTime(seasonEnd) + "' group by f_status";
            List map3s = this.jdbcTemplate.queryForList(seasonsql);
            for (Map map3 : map3s) {
                if (map3.get("f_status") != null && map3.get("f_status").toString().equals("0")) {
                    seasonUntreatedNum = seasonUntreatedNum + Integer.valueOf(map3.get("count").toString());
                    continue;
                }
                seasonHandleNum = seasonHandleNum + Integer.valueOf(map3.get("count").toString());
            }
            String monthStart = MJcClueSourceImpl.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
            String monthEnd = MJcClueSourceImpl.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
            String monthsql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " where f_createtime between '" + MJcClueSourceImpl.converTime(monthStart) + "' and '" + MJcClueSourceImpl.converTime(monthEnd) + "' group by f_status";
            List map2s = this.jdbcTemplate.queryForList(monthsql);
            for (Map map2 : map2s) {
                if (map2.get("f_status") != null && map2.get("f_status").toString().equals("0")) {
                    monthUntreatedNum = monthUntreatedNum + Integer.valueOf(map2.get("count").toString());
                    continue;
                }
                monthHandleNum = monthHandleNum + Integer.valueOf(map2.get("count").toString());
            }
        }
        allObject.put("alllHandleNum", (Object)alllHandleNum);
        allObject.put("allUntreatedNum", (Object)allUntreatedNum);
        allObject.put("allTotalNum", (Object)(alllHandleNum + allUntreatedNum));
        allObject.put("name", (Object)"\u603b\u8ba1");
        yearObject.put("yearHandleNum", (Object)yearHandleNum);
        yearObject.put("yearUntreatedNum", (Object)yearUntreatedNum);
        yearObject.put("yearTotalNum", (Object)(yearUntreatedNum + yearHandleNum));
        yearObject.put("name", (Object)"\u672c\u5e74\u5ea6");
        seasonObject.put("seasonHandleNum", (Object)seasonHandleNum);
        seasonObject.put("seasonUntreatedNum", (Object)seasonUntreatedNum);
        seasonObject.put("seasonTotalNum", (Object)(seasonHandleNum + seasonUntreatedNum));
        seasonObject.put("name", (Object)"\u672c\u5b63\u5ea6");
        monthObject.put("monthHandleNum", (Object)monthHandleNum);
        monthObject.put("monthUntreatedNum", (Object)monthUntreatedNum);
        monthObject.put("monthTotalNum", (Object)(monthUntreatedNum + monthHandleNum));
        monthObject.put("name", (Object)"\u672c\u6708\u4efd");
        jsonArray.add((Object)allObject);
        jsonArray.add((Object)yearObject);
        jsonArray.add((Object)seasonObject);
        jsonArray.add((Object)monthObject);
        return jsonArray;
    }

    public JSONObject getClueStatisticalByMonth(String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String monthStart = MJcClueSourceImpl.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
                String monthEnd = MJcClueSourceImpl.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
                String monthsql = "select f_status,count(1) from " + s + " where f_createtime between '" + MJcClueSourceImpl.converTime(monthStart) + "' and '" + MJcClueSourceImpl.converTime(monthEnd) + "' group by f_status";
                List map2s = this.jdbcTemplate.queryForList(monthsql);
                for (Map map1 : map2s) {
                    if (map1.get("f_status") != null && map1.get("f_status").toString().equals("0")) {
                        untreatedNum = untreatedNum + Integer.valueOf(map1.get("count").toString());
                        continue;
                    }
                    handleNum = handleNum + Integer.valueOf(map1.get("count").toString());
                }
            }
        }
        object.put("handleNum", (Object)handleNum);
        object.put("untreatedNum", (Object)untreatedNum);
        object.put("totalNum", (Object)(handleNum + untreatedNum));
        object.put("name", (Object)"\u603b\u8ba1");
        return object;
    }

    public JSONObject getClueStatisticalBySeason(String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String seasonStart = MJcClueSourceImpl.getCurrentQuarterStartTime();
                String seasonEnd = MJcClueSourceImpl.getCurrentQuarterEndTime();
                String seasonsql = "select f_status,count(1) from " + s + " where f_createtime between '" + MJcClueSourceImpl.converTime(seasonStart) + "' and '" + MJcClueSourceImpl.converTime(seasonEnd) + "' group by f_status";
                List map1s = this.jdbcTemplate.queryForList(seasonsql);
                for (Map map1 : map1s) {
                    if (map1.get("f_status") != null && map1.get("f_status").toString().equals("0")) {
                        untreatedNum = untreatedNum + Integer.valueOf(map1.get("count").toString());
                        continue;
                    }
                    handleNum = handleNum + Integer.valueOf(map1.get("count").toString());
                }
            }
        }
        object.put("handleNum", (Object)handleNum);
        object.put("untreatedNum", (Object)untreatedNum);
        object.put("totalNum", (Object)(handleNum + untreatedNum));
        object.put("name", (Object)"\u603b\u8ba1");
        return object;
    }

    public JSONObject getClueStatisticalByYear(String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                int year = cal.get(1);
                String start = year + "-01-01 00:00:00";
                String end = year + "-12-31 23:59:59";
                String yearsql = "select f_status,count(1) from " + s + " where f_createtime between '" + MJcClueSourceImpl.converTime(start) + "' and '" + MJcClueSourceImpl.converTime(end) + "' group by f_status";
                List map1s = this.jdbcTemplate.queryForList(yearsql);
                for (Map map1 : map1s) {
                    if (map1.get("f_status") != null && map1.get("f_status").toString().equals("0")) {
                        untreatedNum = untreatedNum + Integer.valueOf(map1.get("count").toString());
                        continue;
                    }
                    handleNum = handleNum + Integer.valueOf(map1.get("count").toString());
                }
            }
        }
        object.put("handleNum", (Object)handleNum);
        object.put("untreatedNum", (Object)untreatedNum);
        object.put("totalNum", (Object)(handleNum + untreatedNum));
        object.put("name", (Object)"\u603b\u8ba1");
        return object;
    }

    public JSONObject getClueStatisticalByAll(String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject allObject = new JSONObject();
        Integer alllHandleNum = 0;
        Integer allUntreatedNum = 0;
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String sql = "select f_status,count(1) from " + s + " group by f_status";
                List maps = this.jdbcTemplate.queryForList(sql);
                for (Map map : maps) {
                    if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                        allUntreatedNum = allUntreatedNum + Integer.valueOf(map.get("count").toString());
                        continue;
                    }
                    alllHandleNum = alllHandleNum + Integer.valueOf(map.get("count").toString());
                }
            }
        }
        allObject.put("handleNum", (Object)alllHandleNum);
        allObject.put("untreatedNum", (Object)allUntreatedNum);
        allObject.put("totalNum", (Object)(alllHandleNum + allUntreatedNum));
        allObject.put("name", (Object)"\u603b\u8ba1");
        return allObject;
    }

    public Map<String, Object> getClueStatisticalByXzqdm(String xzqdm, String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (JcClueSource jcClueSource : list) {
            if (jcClueSource.getfTablename() == null) continue;
            String sql = "select substring(f_xzqdm,0,5) xzqdm,count(1) count from " + jcClueSource.getfTablename() + " where f_xzqdm like '" + xzqdm.replace("00", "") + "%' group  by  substring(f_xzqdm,0,5) order by count desc";
            List maps = this.jdbcTemplate.queryForList(sql);
            for (Map map : maps) {
                String xzqdmsys = map.get("xzqdm").toString().length() < 6 ? map.get("xzqdm").toString() + "00" : map.get("xzqdm").toString();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xzqdmsys) || xzqdmsys.length() > 12) continue;
                if (resultMap.containsKey(xzqdmsys)) {
                    JSONObject object = (JSONObject)resultMap.get(xzqdmsys);
                    object.put("count", (Object)(Integer.valueOf(object.get((Object)"count").toString()) + Integer.valueOf(map.get("count").toString())));
                    continue;
                }
                JSONObject newObject = new JSONObject();
                newObject.put("xzqdm", (Object)xzqdmsys);
                newObject.put("count", (Object)Integer.valueOf(map.get("count").toString()));
                newObject.put("xzqmc", (Object)this.regionService.getName(xzqdmsys));
                resultMap.put(xzqdmsys, newObject);
            }
        }
        return resultMap;
    }

    public void importCuleTaskData(TaskRecord bean) throws Exception {
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{bean.getParam()})) {
            JSONObject jsonObject = JSONObject.parseObject((String)bean.getParam());
            JSONArray jsonArray = JSONObject.parseArray((String)jsonObject.getString("importRel"), (Feature[])new Feature[0]);
            String sourceId = jsonObject.getString("sourceId");
            String recordId = jsonObject.getString("recordId");
            String taskId = jsonObject.getString("taskId");
            String userId = jsonObject.getString("userId");
            JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
            if (jcClueSource == null) {
                throw new RuntimeException("\u7ebf\u7d22\u8868\u4e0d\u5b58\u5728");
            }
            TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tableByTableId = this.tskTaskBizService.getTableByTableId(tskTaskBiz.getTableId());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tableByTableId.getfTablename())) {
                throw new RuntimeException("\u4efb\u52a1\u8868\u4e0d\u5b58\u5728");
            }
            String tableNameByBizId = tableByTableId.getfTablename();
            List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            List fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            String tablename = jcClueSource.getfTablename();
            String where = "";
            String where1 = "";
            String where2 = "";
            ArrayList<String> w = new ArrayList<String>();
            ArrayList<String> w1 = new ArrayList<String>();
            ArrayList<String> w2 = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceId)) {
                w.add("r1.f_sourceid='" + sourceId + "'");
                w1.add("f_sourceid='" + sourceId + "'");
                w2.add("f_sourceid='" + sourceId + "'");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recordId)) {
                w.add("r1.f_importid = '" + recordId + "'");
                w1.add("f_import_recordid = '" + recordId + "'");
                w2.add("f_importid='" + recordId + "'");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taskId)) {
                w.add("r1.f_taskid = '" + taskId + "' ");
                w2.add("f_taskid='" + taskId + "'");
            }
            w.add("not exists(select null from " + tableNameByBizId + " tb where tb.f_id = r1.f_tbid and r1.f_type='1')");
            w1.add("f_id in (select r1.f_clueid from jc_clue_task_rel r1," + tablename + " r2 where r1.f_clueid =r2.f_id and r1.f_type='1')");
            where = org.apache.commons.lang3.StringUtils.join(w, (String)" and ");
            where1 = org.apache.commons.lang3.StringUtils.join(w1, (String)" and ");
            where2 = org.apache.commons.lang3.StringUtils.join(w2, (String)" and ");
            ArrayList<String> fieldOriList = new ArrayList<String>();
            ArrayList<String> fieldTarList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String oriField = object.getString("oriField");
                String tarField = object.getString("tarField");
                fieldOriList.add(oriField);
                fieldTarList.add(tarField);
            }
            fieldTarList.add("f_id");
            fieldTarList.add("f_shape");
            fieldTarList.add("f_status");
            fieldTarList.add("f_lon");
            fieldTarList.add("f_lat");
            fieldTarList.add("f_xzqdmsys");
            fieldTarList.add("f_xzqmc1");
            fieldTarList.add("f_createtime");
            fieldTarList.add("f_userid");
            if (fields.contains("f_xzqdmcity")) {
                fieldTarList.add("f_xzqdmcity");
                fieldTarList.add("f_xzqdmcounty");
                fieldTarList.add("f_xzqdmtown");
                fieldTarList.add("f_xzqdm");
                fieldTarList.add("f_xzqmc");
                fieldTarList.add("f_tbmj");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into  " + tableNameByBizId + "(" + org.apache.commons.lang3.StringUtils.join(fieldTarList, (String)",") + ")");
            stringBuffer.append(" select ");
            if (!fieldOriList.isEmpty()) {
                for (String s : fieldOriList) {
                    stringBuffer.append(" r2." + s + ",");
                }
            }
            stringBuffer.append("r1.f_tbid");
            stringBuffer.append(",r2.f_shape");
            stringBuffer.append(",1");
            stringBuffer.append(",st_x(st_centroid(r2.f_shape))");
            stringBuffer.append(",st_y(st_centroid(r2.f_shape))");
            stringBuffer.append(",r2.f_xzqdmvillage");
            stringBuffer.append(",r2.f_xzqmc");
            stringBuffer.append("," + System.currentTimeMillis() + "");
            stringBuffer.append("," + userId + "");
            if (fields.contains("f_xzqdmcity")) {
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,5)||'00'");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,7)");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,10)");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,7)");
                stringBuffer.append(",r2.f_xzqmc");
                stringBuffer.append(",r2.f_area");
            }
            stringBuffer.append(" from jc_clue_task_rel r1, " + tablename + " r2  where r2.f_id = r1.f_clueid and " + where);
            this.dataBizMapper.excuteSql(stringBuffer.toString());
            if (tableNameByBizId.contains(".")) {
                String[] split = tableNameByBizId.split("\\.");
                this.jdbcTemplate.execute("select UpdateGeometrySRID('','" + split[0] + "','" + split[1] + "', 'f_shape', 4490)");
            } else {
                this.jdbcTemplate.execute("select UpdateGeometrySRID('" + tableNameByBizId + "', 'f_shape', 4490)");
            }
            ArrayList<String> tbids = new ArrayList<String>();
            HashMap<String, String> mapIDS = new HashMap<String, String>();
            String sql = String.format("select f_tbid,f_clueid from jc_clue_task_rel where f_clueid in (select f_clueid from %s where %s)", jcClueSource.getfTablename(), where2);
            List mapTbids = this.jdbcTemplate.queryForList(sql);
            for (Map map : mapTbids) {
                String tbid = map.get("f_tbid").toString();
                String clueId = map.get("f_clueid").toString();
                mapIDS.put(clueId, tbid);
                tbids.add(tbid);
            }
            List clues = mapIDS.keySet().stream().collect(Collectors.toList());
            List medias = this.appMediaService.queryByGalleryids(clues);
            if (medias != null && !medias.isEmpty()) {
                ArrayList<AppMedia> mediaInsert = new ArrayList<AppMedia>();
                for (AppMedia media : medias) {
                    AppMedia insert = new AppMedia();
                    BeanUtil.copyProperties((Object)media, (Object)insert);
                    insert.setId(UUID.randomUUID().toString());
                    insert.setGalleryid((String)mapIDS.get(media.getGalleryid()));
                    mediaInsert.add(insert);
                }
                this.appMediaService.save(mediaInsert);
            }
            sql = " update " + tablename + "  set  f_status = 1 ,f_stage = '2',f_state =\nCASE\n WHEN  f_state = 1 THEN 1 WHEN  f_state = 2 THEN 3 WHEN  f_state = 3 THEN 3else  1 end where " + where1;
            this.dataBizMapper.excuteSql(sql);
            if (tskTaskBiz.getMode() != null && tskTaskBiz.getMode().equals(2) && tbids.size() > 0) {
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", (Object)tbids.size());
                additionJson.put("addOrUpdate", (Object)"ADD");
                additionJson.put("taskMode", (Object)tskTaskBiz.getMode());
                additionJson.put("curMode", (Object)"receive");
                String tempId = UUID.randomUUID().toString();
                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(tempId);
                parameter.setTaskId(tskTaskBiz.getId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                parameter.setMode(tskTaskBiz.getMode().toString());
                ArrayList<TaskRecordTemp> tempList = new ArrayList<TaskRecordTemp>();
                for (int i = 0; i < tbids.size(); ++i) {
                    TaskRecordTemp temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(tempId);
                    temp.setDataid((String)tbids.get(i));
                    tempList.add(temp);
                }
                this.taskRecordService.saveTaskRecordTemp(tempList);
                TaskRecord record2 = new TaskRecord();
                record2.setId(tempId);
                record2.setParam(JSONObject.toJSONString((Object)parameter));
                record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record2.setStarttime(new Date());
                record2.setState(Integer.valueOf(1));
                record2.setUserid(Long.valueOf(Long.parseLong(userId)));
                this.taskRecordService.save(record2);
            }
        } else {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    public void syncCuleInfo(TaskRecord bean) throws Exception {
        String accessUrl;
        JSONObject resultObject;
        JSONObject param;
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{bean.getParam()})) {
            JSONObject jsonObject = JSONObject.parseObject((String)bean.getParam());
            String sourceId = jsonObject.getString("sourceId");
            String type = jsonObject.getString("type");
            JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
            if (!type.equals("delete") && jcClueSource == null) {
                throw new RuntimeException("\u7ebf\u7d22\u8868\u4e0d\u5b58\u5728");
            }
            param = new JSONObject();
            resultObject = new JSONObject();
            accessUrl = "";
            switch (type) {
                case "insert": {
                    JSONObject layer = new JSONObject();
                    layer.put("rid", (Object)jcClueSource.getfId());
                    layer.put("type", (Object)0);
                    layer.put("layername", (Object)jcClueSource.getfName());
                    layer.put("pid", (Object)jcClueSource.getfParentid());
                    layer.put("tablename", (Object)jcClueSource.getfTablename());
                    layer.put("orderindex", (Object)jcClueSource.getfOrder());
                    layer.put("state", (Object)jcClueSource.getfState());
                    param.put("layer", (Object)layer);
                    String source = jsonObject.getString("source");
                    if (source.equals("rootNode")) {
                        param.put("fields", (Object)this.converFields(jcClueSource, null));
                    }
                    accessUrl = this.analysisUrl + "/api/layer/addLayerAndFields";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails((JSONObject)param, (String)accessUrl);
                    break;
                }
                case "update": {
                    String fieldId = jsonObject.getString("fieldId");
                    param.put("fields", (Object)this.converFields(jcClueSource, fieldId));
                    accessUrl = this.analysisUrl + "/api/layer/addFields";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails((JSONObject)param, (String)accessUrl);
                    break;
                }
                case "delete": {
                    param.put("rid", (Object)sourceId);
                    param.put("type", (Object)0);
                    accessUrl = this.analysisUrl + "/api/layer/deleteLayer";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails((JSONObject)param, (String)accessUrl);
                    break;
                }
                default: {
                    throw new GwValidateException("\u7c7b\u578btype\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        } else {
            throw new GwValidateException("\u53c2\u6570\u4e3a\u7a7a");
        }
        bean.setState(Integer.valueOf(3));
        bean.setData(accessUrl);
        bean.setResult(JSONObject.toJSONString((Object)resultObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        bean.setRemark(JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        bean.setEndtime(new Date());
        this.taskRecordService.save(bean);
    }

    public JSONArray converFields(JcClueSource jcClueSource, String fieldId) {
        List fields = new ArrayList<JcClueFields>();
        if (fieldId == null) {
            String rootSourceId = jcClueSource.getfId();
            fields = this.jcClueFieldsService.findByTableId(rootSourceId);
        } else {
            fields.add(this.jcClueFieldsService.selectByPrimaryKey(fieldId));
        }
        JSONArray jsonArray = new JSONArray();
        for (JcClueFields field : fields) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("resultshow", (Object)0);
            jsonObject.put("code", (Object)field.getfFieldname());
            jsonObject.put("orderindex", (Object)field.getfOrder());
            jsonObject.put("conditionshow", (Object)0);
            jsonObject.put("tableshow", (Object)0);
            Integer fieldtype = Integer.valueOf(field.getfFieldtype());
            if (fieldtype == 1) {
                fieldtype = 4;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfCodetableid())) {
                    fieldtype = 1;
                }
            } else if (fieldtype == 1) {
                fieldtype = 3;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfCodetableid())) {
                    fieldtype = 1;
                }
            } else {
                fieldtype = fieldtype == 3 || fieldtype == 7 ? Integer.valueOf(2) : (fieldtype == 4 || fieldtype == 5 ? Integer.valueOf(5) : Integer.valueOf(4));
            }
            jsonObject.put("fieldtype", (Object)fieldtype);
            jsonObject.put("enumkey", (Object)field.getfCodetableid());
            jsonObject.put("unit", (Object)field.getUnit());
            jsonObject.put("layerid", (Object)jcClueSource.getfId());
            jsonObject.put("name", (Object)field.getfAlias());
            jsonObject.put("id", (Object)field.getfId());
            jsonObject.put("oid", (Object)field.getfId());
            jsonObject.put("webconfig", (Object)0);
            Integer basetype = null;
            if ("f_id".equals(field.getfFieldname())) {
                basetype = 0;
            } else if ("f_xzqmc".equals(field.getfFieldname())) {
                basetype = 2;
            } else if ("f_xzqdm".equals(field.getfFieldname())) {
                basetype = 1;
            } else if ("f_area".equals(field.getfFieldname())) {
                basetype = 3;
            } else if ("f_shape".equals(field.getfFieldname())) {
                basetype = 4;
            }
            jsonObject.put("basetype", (Object)basetype);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public void defaultClueImportRel(String sourceId) {
        List fields = this.jcClueFieldsService.findByTableId(sourceId).stream().filter(r -> r.getfFieldInnerOuterSys() == 1).collect(Collectors.toList());
        this.jcClueImportRelMapper.deleteBySourceId(sourceId);
        for (JcClueFields field : fields) {
            JcClueImportRel bean = new JcClueImportRel();
            bean.setfId(UUID.randomUUID().toString());
            bean.setfFieldname(field.getfFieldname());
            bean.setfFieldnameImport(field.getfFieldname());
            bean.setfSourceid(sourceId);
            bean.setfRemark("\u9ed8\u8ba4");
            this.jcClueImportRelMapper.insertSelective((Object)bean);
        }
    }

    public String exportClueDefine(Long userId, String sourceId) throws JAXBException {
        TaskDefineDTO taskDefineDTO = new TaskDefineDTO();
        ArrayList<TaskMetaDTO> taskMetaDTOList = new ArrayList<TaskMetaDTO>();
        ArrayList<TaskCategoryDTO> taskCategoryDTOList = new ArrayList<TaskCategoryDTO>();
        TaskCategoryDTO categoryDTO = new TaskCategoryDTO();
        categoryDTO.setId("1");
        categoryDTO.setPid("1");
        categoryDTO.setName("\u7ebf\u7d22\u914d\u7f6e");
        taskCategoryDTOList.add(categoryDTO);
        ArrayList<JcClueSource> clueList = new ArrayList<JcClueSource>();
        if (sourceId != null) {
            JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
            clueList.add(jcClueSource);
        }
        for (JcClueSource clue : clueList) {
            TaskMetaDTO metaDTO = new TaskMetaDTO();
            metaDTO.setId(clue.getfId());
            metaDTO.setName(clue.getfName());
            metaDTO.setGranularity(Integer.valueOf(1));
            metaDTO.setCategoryId("0000");
            ArrayList<TaskFieldMappingDTO> fieldMappingDTOList = new ArrayList<TaskFieldMappingDTO>();
            List fields = this.jcClueFieldsService.findByTableId(sourceId);
            for (JcClueFields field : fields) {
                if (field.getfFieldInnerOuterSys() != 1 && field.getfFieldInnerOuterSys() != 3 && field.getfFieldInnerOuterSys() != 5) continue;
                TaskFieldMappingDTO fieldMappingDTO = new TaskFieldMappingDTO();
                TaskFieldDefineDTO fieldDefineDTO = new TaskFieldDefineDTO();
                fieldDefineDTO.setId(field.getfId());
                fieldDefineDTO.setAlias(field.getfAlias());
                fieldDefineDTO.setName(field.getfFieldname());
                if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)field.getfFieldtype())) {
                    fieldDefineDTO.setType(TskTaskBizDBUtil.getDBType((String)field.getfFieldtype()));
                } else {
                    fieldDefineDTO.setType(field.getfFieldtype());
                }
                if (field.getfLength() != null) {
                    fieldDefineDTO.setLength(field.getfLength().toString());
                } else {
                    fieldDefineDTO.setLength("-1");
                }
                if (field.getfPrecision() != null) {
                    fieldDefineDTO.setAccuracy(field.getfPrecision().toString());
                } else {
                    fieldDefineDTO.setAccuracy("0");
                }
                if (field.getfNullable() == 0) {
                    fieldDefineDTO.setIsRequired("true");
                } else {
                    fieldDefineDTO.setIsRequired("false");
                }
                fieldDefineDTO.setIsBase("true");
                fieldDefineDTO.setIsOutwork("false");
                if (field.getfUnique() != null) {
                    if (field.getfUnique() == 0) {
                        fieldDefineDTO.setUnique("false");
                    } else {
                        fieldDefineDTO.setUnique("true");
                    }
                }
                fieldMappingDTO.setFieldDefineDTO(fieldDefineDTO);
                fieldMappingDTOList.add(fieldMappingDTO);
            }
            metaDTO.setFieldMappingDTOList(fieldMappingDTOList);
            taskMetaDTOList.add(metaDTO);
        }
        taskDefineDTO.setTaskMetaDTOList(taskMetaDTOList);
        taskDefineDTO.setCategoryDTOList(taskCategoryDTOList);
        return JaxbXmlUtil.convertToXML((Object)taskDefineDTO, (String)"gb2312");
    }

    public List<TaskRecord> importClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName, String batchDesc, String updateType) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        if (jcClueSource.getfState() < 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jcClueSource.getfTablename())) {
            throw new RuntimeException("\u7ebf\u7d22\u521b\u5efa\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u52a0\u8f7d\u6570\u636e");
        }
        ArrayList<TaskRecord> taskRecords = new ArrayList<TaskRecord>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            String id = UUID.randomUUID().toString();
            while (iter.hasNext()) {
                MultipartFile shapeFile = multiRequest.getFile((String)iter.next());
                if (shapeFile == null) continue;
                File zipFile = null;
                File dir = new File(this.uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = File.createTempFile("tmp", ".gty", dir);
                FileUtils.copyInputStreamToFile((InputStream)shapeFile.getInputStream(), (File)zipFile);
                String zipName = zipFile.getAbsolutePath();
                String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
                this.checkData(unzipFileDir, ".shp");
                String fileName = UUID.randomUUID().toString() + ".gty";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String dateString = sdf.format(new Date());
                String obsFilePath = "importClueData/" + dateString + "/" + fileName;
                String resultUrl = this.defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);
                this.taskImportTaskDataService.createImportLog(jcClueSource, tbtskDataLog, userId);
                JSONObject params = new JSONObject();
                params.put("unzipFileDir", (Object)resultUrl);
                params.put("userId", (Object)userId);
                params.put("sourceId", (Object)sourceId);
                params.put("updateType", (Object)(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)updateType) ? "0" : updateType));
                params.put("batchId", (Object)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchId) ? batchId : (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchName) ? id : "")));
                params.put("tbtskDataLogId", (Object)tbtskDataLog.getId());
                TaskRecord record = new TaskRecord();
                record.setId(UUID.randomUUID().toString());
                record.setParam(JSONObject.toJSONString((Object)params));
                record.setTasktype(JobConstants.JOB_TYPE_CULE_IMPORT);
                record.setData(sourceId);
                record.setStarttime(new Date());
                record.setState(Integer.valueOf(1));
                record.setUserid(userId);
                this.taskRecordService.save(record);
                taskRecords.add(record);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchName)) {
                JcClueImportRecord bean = new JcClueImportRecord();
                bean.setfId(id);
                bean.setfCreatetime(new Date());
                bean.setfName(batchName);
                bean.setfRemark(batchDesc);
                bean.setfSourceid(jcClueSource.getfId());
                bean.setfCount(Integer.valueOf(0));
                bean.setfJcmj(new BigDecimal(0));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                bean.setfJcsj(df.format(new Date()));
                this.jcClueImportRecordService.insert(bean);
            }
        }
        return taskRecords;
    }

    public List<TaskRecord> importBatchClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName, String batchDesc, String updateType) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        if (jcClueSource.getfState() < 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jcClueSource.getfTablename())) {
            throw new RuntimeException("\u7ebf\u7d22\u521b\u5efa\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u52a0\u8f7d\u6570\u636e");
        }
        ArrayList<TaskRecord> taskRecords = new ArrayList<TaskRecord>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            List files = multiRequest.getFiles("file");
            String time = System.currentTimeMillis() + "";
            String targetZipDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey()) + File.separator + time;
            for (MultipartFile file : files) {
                File dir = new File(targetZipDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File zipFile = new File(dir + File.separator + file.getOriginalFilename());
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)zipFile);
            }
            String targetZipFile = Zip4jUtils.zip((String)targetZipDir, (String)"gtdcy2019");
            String id = UUID.randomUUID().toString();
            this.asynImportBatchDataClue(targetZipFile, jcClueSource, id, batchId, batchName, userId, updateType);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchName)) {
                JcClueImportRecord bean = new JcClueImportRecord();
                bean.setfId(id);
                bean.setfCreatetime(new Date());
                bean.setfName(batchName);
                bean.setfRemark(batchDesc);
                bean.setfSourceid(jcClueSource.getfId());
                bean.setfCount(Integer.valueOf(0));
                bean.setfJcmj(new BigDecimal(0));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                bean.setfJcsj(df.format(new Date()));
                this.jcClueImportRecordService.insert(bean);
            }
        }
        return taskRecords;
    }

    private void asynImportBatchDataClue(String zipFile, JcClueSource jcClueSource, String id, String batchId, String batchName, Long userId, String updateType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        String dateString = sdf.format(new Date());
        String obsFileName = zipFile.substring(zipFile.lastIndexOf(File.separator) + 1);
        String obsFilePath = "importTaskData/" + dateString + "/" + obsFileName;
        String resultUrl = this.defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);
        this.taskImportTaskDataService.createImportLog(jcClueSource, tbtskDataLog, userId);
        JSONObject params = new JSONObject();
        params.put("unzipFileDir", (Object)resultUrl);
        params.put("userId", (Object)userId);
        params.put("sourceId", (Object)jcClueSource.getfId());
        params.put("updateType", (Object)(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)updateType) ? "0" : updateType));
        params.put("batchId", (Object)(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchId) ? batchId : (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)batchName) ? id : "")));
        params.put("batch", (Object)true);
        params.put("tbtskDataLogId", (Object)tbtskDataLog.getId());
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_IMPORT);
        record.setData(jcClueSource.getfId());
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
    }

    private DataDownloadRecord buildDataDownloadRecordForGeometryDownload(String sourceId, String recordId, String tbIds, long userId, DownloadTypeEnum downloadTypeEnum, Integer downloadType) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sourceId) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recordId) || userId < -1L) {
            return null;
        }
        DataDownloadRecord dataDownloadRecord = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo2(recordId, tbIds, userId, downloadTypeEnum);
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        if (jcClueSource == null) {
            throw new GwValidateException("\u7ebf\u7d22\u8868\u4e0d\u5b58\u5728");
        }
        int count = 0;
        String whereClause = "";
        String tableName = "";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbIds)) {
            whereClause = whereClause + " d.f_id in ( '" + tbIds.replace(",", "','") + "' ) ";
        }
        tableName = jcClueSource.getfTablename() + " d ";
        count = this.dataBizService.getCount(tableName, whereClause);
        dataDownloadRecord.setTbCount(Integer.valueOf(count));
        JcClueImportRecord jcClueImportRecord = this.jcClueImportRecordService.selectByPrimaryKey(recordId);
        dataDownloadRecord.setName(jcClueImportRecord.getfName());
        return dataDownloadRecord;
    }

    public DataDownloadRecord downloadGeometry(String sourceId, String recordId, String tbIds, Long userId, String geoType, Boolean isBatch, DownloadTypeEnum downloadTypeEnum, Integer downloadType) {
        GutilAssert.state((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceId), (String)"sourceId can not be null or empty.");
        GutilAssert.state((userId > -1L ? 1 : 0) != 0, (String)"userId can not be negative number.");
        GutilAssert.state((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)geoType), (String)"geoType can not be null or empty.");
        DataDownloadRecord record = this.buildDataDownloadRecordForGeometryDownload(sourceId, recordId, tbIds, userId, downloadTypeEnum, downloadType);
        record = this.dataDownloadRecordService.save(record);
        record.setBatchOpr(isBatch.booleanValue());
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)record)).toString(), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recordId) ? recordId : "");
        attachParameter.setTbIds(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setOrgIdOrGroupId("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType("dailytask");
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence)record.getId()) ? record.getId() : "");
        attachParameter.setDownloadType(downloadType);
        attachParameter.setType(downloadTypeEnum.getCode());
        attachParameter.setDataType(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{geoType}) ? geoType : "");
        String parameterString = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public void checkData(String unzipFileDir, String fileEnd) throws Exception {
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        File file1 = null;
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (!content[j].getName().endsWith(fileEnd)) continue;
            file1 = content[j];
            break;
        }
        if (file1 == null) {
            if (".db".equals(fileEnd)) {
                throw new RuntimeException("\u6570\u636e\u52a0\u8f7d\u5931\u8d25\uff1a\u7f3a\u5c11\u5f71\u50cf\u622a\u56fe\u6570\u636e");
            }
            throw new RuntimeException("\u6570\u636e\u52a0\u8f7d\u5931\u8d25\uff1a\u7f3a\u5c11\u56fe\u5f62\u6570\u636e");
        }
    }

    public void saveFieldGroup(CuleGroupDto culeGroupDto, Long userId) throws Exception {
        List fieldInDetailMain;
        List fieldInSearch;
        List fieldInFilter;
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)culeGroupDto.getSourceId());
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        this.jcClueGroupMapper.deleteBytableId(culeGroupDto.getSourceId(), "web");
        List fieldInList = culeGroupDto.getFieldInList().stream().distinct().collect(Collectors.toList());
        if (fieldInList.size() > 0) {
            IntStream.range(0, fieldInList.size()).forEach(i -> {
                JcClueFields field = this.jcClueFieldsService.selectByPrimaryKey((String)fieldInList.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("100");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(Integer.valueOf(i));
                this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
            });
        }
        if ((fieldInFilter = culeGroupDto.getFieldInFilter().stream().distinct().collect(Collectors.toList())).size() > 0) {
            IntStream.range(0, fieldInFilter.size()).forEach(i -> {
                JcClueFields field = this.jcClueFieldsService.selectByPrimaryKey((String)fieldInFilter.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("101");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(Integer.valueOf(i));
                this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
            });
        }
        if ((fieldInSearch = culeGroupDto.getFieldInSearch().stream().distinct().collect(Collectors.toList())).size() > 0) {
            IntStream.range(0, fieldInSearch.size()).forEach(i -> {
                JcClueFields field = this.jcClueFieldsService.selectByPrimaryKey((String)fieldInSearch.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("102");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(Integer.valueOf(i));
                this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
            });
        }
        if ((fieldInDetailMain = culeGroupDto.getFieldInDetailMain().stream().distinct().collect(Collectors.toList())).size() > 0) {
            IntStream.range(0, fieldInDetailMain.size()).forEach(i -> {
                JcClueFields field = this.jcClueFieldsService.selectByPrimaryKey((String)fieldInDetailMain.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("103");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(Integer.valueOf(i));
                this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
            });
        }
        for (int j = 0; j < culeGroupDto.getFieldGroup().size(); ++j) {
            Object object = culeGroupDto.getFieldGroup().get(j);
            FieldGroup group = (FieldGroup)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)JSONObject.toJSONString(object)), FieldGroup.class);
            List fields = group.getFields();
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                FieldDisPlay fieldDisPlay = (FieldDisPlay)fields.get(i2);
                JcClueFields field = (JcClueFields)this.jcClueFieldsMapper.selectByPrimaryKey((Object)fieldDisPlay.getFieldId());
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(Integer.valueOf(i2));
                jcClueGroup.setfGrouporder(Integer.valueOf(j));
                jcClueGroup.setfGroupcode("202");
                jcClueGroup.setfSubgroupname(group.getTitle());
                jcClueGroup.setfControltype(fieldDisPlay.getDisplayType());
                jcClueGroup.setfTip(fieldDisPlay.getTips());
                jcClueGroup.setfCode(fieldDisPlay.getEditAble());
                jcClueGroup.setfNotNull(fieldDisPlay.getNotNull());
                jcClueGroup.setfConnection(fieldDisPlay.getConnection());
                jcClueGroup.setfVisible(fieldDisPlay.getVisible());
                jcClueGroup.setfItemGroupName(fieldDisPlay.getItemGroupName());
                jcClueGroup.setfRegexp(fieldDisPlay.getRuleReg());
                String regEx = "/[#\\\\$%\\\\^&\\\\*\u3010\u3011@!\uff01\uffe5?|\u2018\uff1b\uff1a\u201d\u201c\\'<>+=:]+/g";
                if ((field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2")) && (field.getfCodetableid() == null || field.getfCodetableid().equals(""))) {
                    jcClueGroup.setfRegexp(regEx);
                }
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    jcClueGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                    jcClueGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
            }
        }
    }

    public void saveClueKeyLimitData(Long userId, String sourceId, String keyLimitData, String areaRepeatMinValue, String areaRepeatPrecent) throws Exception {
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        if (jcClueSource == null) {
            throw new RuntimeException("\u7ebf\u7d22\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        JSONArray keyData = JSON.parseArray((String)keyLimitData, (Feature[])new Feature[0]);
        if (keyData.isEmpty()) {
            throw new RuntimeException("\u5b57\u6bb5\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        List fields = this.jcClueFieldsMapper.findByTableId(sourceId);
        HashMap<String, JSONObject> keyMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < keyData.size(); ++i) {
            JSONObject jsonObject = keyData.getJSONObject(i);
            String fieldId = jsonObject.getString("id");
            keyMap.put(fieldId, jsonObject);
        }
        for (JcClueFields field : fields) {
            String fid = field.getfId();
            if (!keyMap.containsKey(fid)) continue;
            JSONObject data = (JSONObject)keyMap.get(fid);
            Boolean have = data.getBoolean("have");
            Boolean check = data.getBoolean("check");
            Boolean only = data.getBoolean("only");
            field.setfNullable(Integer.valueOf(check != false ? 0 : 1));
            field.setfUnique(Integer.valueOf(only != false ? 1 : 0));
            field.setfIsMust(Integer.valueOf(have != false ? 1 : 0));
            this.jcClueFieldsMapper.updateByPrimaryKeySelective((Object)field);
        }
        this.finishCuleSource(jcClueSource, userId);
    }

    public void createClueMapperScheme(Long userId, JcClueImportTaskRelDto jcClueImportTaskRelDto) throws Exception {
        Integer count;
        if (jcClueImportTaskRelDto.getfType() != null && jcClueImportTaskRelDto.getfType().equals("1") && (count = Integer.valueOf(this.jcClueImportTaskRelMapper.selectCheckName(jcClueImportTaskRelDto.getfSourceid(), jcClueImportTaskRelDto.getfTaskid(), jcClueImportTaskRelDto.getfName()))) > 0) {
            throw new RuntimeException("\u6620\u5c04\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        if (jcClueImportTaskRelDto.getfType() != null && jcClueImportTaskRelDto.getfType().equals("2")) {
            List list = this.jcClueImportTaskRelMapper.findTaskMapperSchemes(jcClueImportTaskRelDto.getfTaskid(), "2");
            for (JcClueImportTaskRel bean : list) {
                this.jcClueImportTaskRelMapper.gwDeleteByPK((Serializable)((Object)bean.getfId()));
                this.jcClueImportTaskRelFieldsMapper.deleteByRelId(bean.getfId());
            }
        }
        String id = UUID.randomUUID().toString();
        JcClueImportTaskRel jcClueImportTaskRel = new JcClueImportTaskRel();
        BeanUtil.copyProperties((Object)jcClueImportTaskRelDto, (Object)jcClueImportTaskRel, (boolean)false);
        jcClueImportTaskRel.setfId(id);
        jcClueImportTaskRel.setfCreatetime(new Date());
        jcClueImportTaskRel.setfUserid(userId);
        jcClueImportTaskRel.setfType(jcClueImportTaskRelDto.getfType() == null ? "1" : "2");
        this.jcClueImportTaskRelMapper.insertSelective((Object)jcClueImportTaskRel);
        if (jcClueImportTaskRelDto.getFields() != null) {
            List fieldsList = jcClueImportTaskRelDto.getFields().toJavaList(JcClueImportTaskRelFields.class);
            for (JcClueImportTaskRelFields bean : fieldsList) {
                bean.setfId(UUID.randomUUID().toString());
                bean.setfRelid(id);
                this.jcClueImportTaskRelFieldsMapper.insertSelective((Object)bean);
            }
        }
    }

    public List<JcClueImportTaskRel> findClueMapperSchemes(Long userId, String sourceId, String taskId, String type) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taskId) || "null".equals(taskId)) {
            return this.jcClueImportTaskRelMapper.findClueMapperSchemesByClue(sourceId, type);
        }
        return this.jcClueImportTaskRelMapper.findClueMapperSchemes(sourceId, taskId, type);
    }

    public List<JcClueImportTaskRel> findTaskMapperSchemes(Long userId, String taskId, String type) {
        List rels = this.jcClueImportTaskRelMapper.findTaskMapperSchemes(taskId, type);
        for (JcClueImportTaskRel rel : rels) {
            rel.setTaskRelFields(this.jcClueImportTaskRelFieldsMapper.selectByRelId(rel.getfId()));
        }
        return rels;
    }

    public List<JcClueImportTaskRelFields> findClueImportTaskRelFields(Long userId, String relId) {
        return this.jcClueImportTaskRelFieldsMapper.selectByRelId(relId);
    }

    public List<JcClueSource> getClueList(Long userId, String appsId) {
        List list = this.jcClueSourceMapper.queryByParentId("-1", appsId);
        if (!list.isEmpty()) {
            for (JcClueSource bean : list) {
                bean.setChildren(this.getChildren(bean.getfId()));
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bean.getfTempleid())) continue;
                JcClueTemplate jcClueTemplate = (JcClueTemplate)this.jcClueTemplateMapper.gwSearchByPK((Serializable)((Object)bean.getfTempleid()));
                bean.setTempleName(jcClueTemplate != null ? jcClueTemplate.getfName() : null);
            }
        }
        return list;
    }

    public List<JcClueSource> getClueListByTempleId(String templeId) {
        List list = this.jcClueSourceMapper.getClueListByTempleId(templeId);
        return list;
    }

    @Transactional
    public Boolean makeViewRelClueAndTask(String sourceId, String recordId, String taskId, Long userId) {
        JcClueSource jcClueSource = (JcClueSource)this.jcClueSourceMapper.selectByPrimaryKey((Object)sourceId);
        if (jcClueSource == null) {
            return false;
        }
        String viewsqlTemplate = "";
        SysConfig clueViewConfig = this.sysConfigService.findOne("clueViewSqlTemplate");
        if (clueViewConfig != null) {
            viewsqlTemplate = clueViewConfig.getValue();
        }
        String viewName = "business_apps_cgjc.v_jc_clue_cgjcxs_" + UUID.randomUUID().toString().replace("-", "");
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableByTableId = this.tskTaskBizService.getTableByTableId(tskTaskBiz.getTableId());
        JcClueSource jcClueSourceNew = new JcClueSource();
        BeanUtil.copyProperties((Object)jcClueSource, (Object)jcClueSourceNew, (boolean)false);
        jcClueSourceNew.setfId(UUID.randomUUID().toString());
        jcClueSourceNew.setfTablename(viewName);
        jcClueSourceNew.setfName("\u4f2a\u7ebf\u7d22_" + tskTaskBiz.getName());
        jcClueSourceNew.setfState(Integer.valueOf(3));
        jcClueSourceNew.setfRemark("");
        this.jcClueSourceMapper.insertSelective((Object)jcClueSourceNew);
        ArrayList<JcClueFields> jcClueFieldsListNew = new ArrayList<JcClueFields>();
        List byTableId = this.jcClueFieldsService.findByTableId(sourceId);
        for (Object jcClueFields : byTableId) {
            JcClueFields jcClueFieldsNew = new JcClueFields();
            BeanUtil.copyProperties((Object)jcClueFields, (Object)jcClueFieldsNew, (boolean)false);
            jcClueFieldsNew.setfId(UUID.randomUUID().toString());
            jcClueFieldsNew.setfTableid(jcClueSourceNew.getfId());
            jcClueFieldsListNew.add(jcClueFieldsNew);
            this.jcClueFieldsService.insert(jcClueFieldsNew);
        }
        List detailGroup = this.jcClueGroupMapper.clueGroupByTableId("", sourceId, "");
        for (JcClueGroup jcClueGroup : detailGroup) {
            JcClueGroup jcClueGroupNew = new JcClueGroup();
            BeanUtil.copyProperties((Object)jcClueGroup, (Object)jcClueGroupNew, (boolean)false);
            jcClueGroupNew.setfId(UUID.randomUUID().toString());
            Optional<JcClueFields> op = jcClueFieldsListNew.stream().filter(r -> r.getfFieldname().equals(jcClueGroupNew.getfFieldname())).findFirst();
            if (!op.isPresent()) continue;
            jcClueGroupNew.setfFieldid(op.get().getfId());
            this.jcClueGroupMapper.insertSelective((Object)jcClueGroupNew);
        }
        JcClueImportRecord jcClueImportRecord = this.jcClueImportRecordService.selectByPrimaryKey(recordId);
        jcClueImportRecord.setfJcqy(jcClueSourceNew.getfId());
        this.jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
        String viewsql = viewsqlTemplate.replaceAll("\\{viewName\\}", viewName).replaceAll("\\{taskname\\}", tableByTableId != null ? tableByTableId.getfTablename() : "").replaceAll("\\{recordid\\}", recordId);
        this.jdbcTemplate.execute(viewsql);
        return true;
    }

    private List<JcClueSource> getChildren(String id) {
        List list = this.jcClueSourceMapper.queryByParentId(id, null);
        if (!list.isEmpty()) {
            for (JcClueSource bean : list) {
                bean.setChildren(this.getChildren(bean.getfId()));
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bean.getfTempleid())) continue;
                JcClueTemplate jcClueTemplate = (JcClueTemplate)this.jcClueTemplateMapper.selectByPrimaryKey((Object)bean.getfTempleid());
                bean.setTempleName(jcClueTemplate != null ? jcClueTemplate.getfName() : null);
            }
        }
        return list;
    }

    public void defaultClueGroup(String sourceId, String tableName) {
        List fields = this.jcClueFieldsService.findByTableId(sourceId).stream().filter(r -> r.getfFieldInnerOuterSys() == 1).collect(Collectors.toList());
        for (JcClueFields field : fields) {
            JcClueGroup jcClueGroup = new JcClueGroup();
            jcClueGroup.setfId(UUID.randomUUID().toString());
            jcClueGroup.setfSyscode("web");
            jcClueGroup.setfGroupcode("100");
            jcClueGroup.setfTablename(sourceId);
            jcClueGroup.setfFieldname(field.getfFieldname());
            jcClueGroup.setfFieldid(field.getfId());
            jcClueGroup.setfAlias(field.getfAlias());
            if ("1".equalsIgnoreCase(field.getRuleReg())) {
                jcClueGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
            } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                jcClueGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
            }
            this.jcClueGroupMapper.insertSelective((Object)jcClueGroup);
        }
    }

    public void defaultField(JcClueSource jcClueSource) {
        this.jcClueFieldsService.saveFields(jcClueSource, "f_id", "2", "100", null, "true", "false", "false", "\u4e3b\u952e(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_status", "8", "10", null, "true", "false", "false", "\u72b6\u6001(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_registerstatus", "8", "10", null, "true", "false", "false", "\u5957\u5408\u72b6\u6001(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_mergestatus", "8", "10", null, "true", "false", "false", "\u878d\u5408\u72b6\u6001(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_state", "8", "10", null, "true", "false", "false", "\u7ebf\u7d22\u6709\u6548\u6027(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_analysis", "8", "10", null, "true", "false", "false", "\u667a\u80fd\u5206\u6790\u72b6\u6001(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_stage", "2", "16", null, "true", "false", "false", "\u5904\u7406\u9636\u6bb5(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_shape", "9", null, null, "true", "false", "false", "shape(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_createtime", "8", "20", null, "true", "false", "false", "\u521b\u5efa\u65f6\u95f4(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_userid", "2", "100", null, "true", "false", "false", "\u64cd\u4f5c\u4eba(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_sourceid", "2", "100", null, "true", "false", "false", "\u7ebf\u7d22\u6765\u6e90ID(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_import_recordid", "2", "100", null, "true", "false", "false", "\u6279\u6b21\u8bb0\u5f55id(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_sjpc", "2", "100", null, "true", "false", "false", "\u6279\u6b21\u540d\u79f0(\u7cfb\u7edf)", null, "false", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqmc", "2", "100", null, "false", "true", "false", "\u884c\u653f\u533a\u540d\u79f0(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqdm", "2", "20", null, "true", "true", "false", "\u884c\u653f\u533a\u4ee3\u7801(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmcity", "2", "20", null, "true", "true", "false", "\u884c\u653f\u533a\u4ee3\u7801\u5e02(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmcounty", "2", "20", null, "true", "true", "false", "\u884c\u653f\u533a\u4ee3\u7801\u53bf(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmtown", "2", "20", null, "true", "true", "false", "\u884c\u653f\u533a\u4ee3\u7801\u9547(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmvillage", "2", "20", null, "true", "true", "false", "\u884c\u653f\u533a\u4ee3\u7801\u6751(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_location", "2", "200", null, "false", "true", "false", "\u5750\u843d\u4f4d\u7f6e(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
        this.jcClueFieldsService.saveFields(jcClueSource, "f_area", "7", "20", "4", "false", "true", "false", "\u9762\u79ef(\u7cfb\u7edf)", null, "true", "false", "false", "false", Integer.valueOf(4), Boolean.valueOf(true));
    }

    public static String generateTableName(String sourceName) {
        StringBuffer name = new StringBuffer("jc_clue_" + sourceName);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String sxff = sdf.format(new Date());
        name.append("_").append(sxff);
        return name.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public void createTable(JcClueSource jcClueSource) {
        GutilAssert.hasLength((String)jcClueSource.getfTablename(), (String)"\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        StringBuilder creatTableSql = new StringBuilder("CREATE TABLE ");
        List fields = this.jcClueFieldsMapper.findByTableId(jcClueSource.getfId());
        creatTableSql.append(jcClueSource.getfTablename()).append(" (");
        creatTableSql.append(MJcClueSourceImpl.generateFieldSql(jcClueSource, fields));
        this.jdbcTemplate.execute(creatTableSql.toString());
        if (jcClueSource.getfTablename().contains(".")) {
            String table = jcClueSource.getfTablename();
            String[] split1 = jcClueSource.getfTablename().split("\\.");
            this.jdbcTemplate.execute("select UpdateGeometrySRID('','" + split1[0] + "','" + split1[1] + "', 'f_shape', 4490)");
        } else {
            this.jdbcTemplate.execute("select UpdateGeometrySRID('" + jcClueSource.getfTablename() + "', 'f_shape', 4490)");
        }
    }

    public static String generateFieldSql(JcClueSource jcClueSource, List<JcClueFields> list) {
        StringBuilder fieldSql = new StringBuilder();
        for (JcClueFields f : list) {
            fieldSql.append(f.getfFieldname()).append(" ");
            String fieldType = f.getfFieldtype();
            HashMap<String, String> FIELD_TYPE_DIC = new HashMap<String, String>();
            FIELD_TYPE_DIC.put("1", "text");
            FIELD_TYPE_DIC.put("2", "varchar");
            FIELD_TYPE_DIC.put("3", "decimal");
            FIELD_TYPE_DIC.put("4", "timestamp");
            FIELD_TYPE_DIC.put("5", "timestamp");
            FIELD_TYPE_DIC.put("6", "varchar");
            FIELD_TYPE_DIC.put("7", "decimal");
            FIELD_TYPE_DIC.put("8", "int4");
            FIELD_TYPE_DIC.put("9", "geometry");
            FIELD_TYPE_DIC.put("10", "text");
            String dbType = FIELD_TYPE_DIC.getOrDefault(fieldType, "varchar");
            if (f.getfLength() == null) {
                fieldSql.append(dbType);
            } else if ("decimal".equals(dbType)) {
                fieldSql.append(dbType).append("(").append(f.getfLength()).append(",").append(f.getfPrecision()).append(")");
            } else if ("varchar".equals(dbType)) {
                fieldSql.append(dbType).append("(").append(f.getfLength()).append(")");
            } else {
                fieldSql.append(dbType);
            }
            fieldSql.append(" ");
            if ("0".equals(f.getfNullable())) {
                fieldSql.append("NOT NULL ");
            }
            fieldSql.append(",");
        }
        if (list.size() <= 1) {
            return fieldSql.substring(0, fieldSql.length() - 1);
        }
        fieldSql.append("primary key(f_id));");
        return fieldSql.toString();
    }

    public static String getFisrtDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static String getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Object now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c.set(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(c.getTime()) + " 00:00:00";
        return time;
    }

    public static String getCurrentQuarterEndTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Object now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 31);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 31);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(c.getTime()) + "  23:59:59";
        return time;
    }

    public static Long converTime(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }
}

