/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueTemplateService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueTemplateMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTemplate;
import com.gw.base.data.GwValidateException;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MJcClueTemplateServiceImpl
implements MJcClueTemplateService {
    @Autowired
    JcClueTemplateMapper jcClueTemplateMapper;
    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;
    @Autowired
    TbtskObjectinfoRepository objectDao;
    @Autowired
    TbtskFieldsRepository fieldsDao;
    @Autowired
    MJcClueSourceService jcClueSourceService;

    public List<JcClueTemplate> getTemplateList() {
        List list = this.jcClueTemplateMapper.getTemplateList();
        return list;
    }

    public void saveClueTemplate(JcClueTemplate jcClueTemplate) {
        this.jcClueTemplateMapper.insert((Object)jcClueTemplate);
        JcClueSource jcClueSource = new JcClueSource();
        jcClueSource.setfId(jcClueTemplate.getfId());
        this.jcClueSourceService.defaultField(jcClueSource);
    }

    public boolean deleteClueTemplate(String fId) throws Exception {
        List sourceList = this.jcClueSourceService.getClueListByTempleId(fId);
        if (!sourceList.isEmpty()) {
            throw new GwValidateException("\u7ebf\u7d22\u6a21\u677f\u5df2\u914d\u7f6e\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.jcClueFieldsMapper.deleteByTableId(fId);
        int i = this.jcClueTemplateMapper.deleteByPrimaryKey((Object)fId);
        return i > 0;
    }

    public JcClueTemplate getClueTemplate(String fId) {
        return (JcClueTemplate)this.jcClueTemplateMapper.selectByPrimaryKey((Object)fId);
    }

    public boolean updateClueTemplate(JcClueTemplate jcClueTemplate) {
        int i = this.jcClueTemplateMapper.updateByPrimaryKeySelective((Object)jcClueTemplate);
        return i > 0;
    }

    public Pair<Integer, List<JcClueTemplate>> getTemplateList(String templateName, String templateStatus, String appsId, int pageNum, int pageSize) {
        int start = (pageNum - 1) * pageSize;
        List list = this.jcClueTemplateMapper.searchTemplateList(templateName, templateStatus, appsId, start, pageSize);
        int count = this.jcClueTemplateMapper.searchCountTemplateList(templateName, templateStatus, appsId);
        Pair pair = Pair.of((Object)count, (Object)list);
        return pair;
    }

    void addDefaultFieldsToTable(TbtskObjectinfo table) {
        this.addField(table, "f_id", "\u4e3b\u952e", "2", 100, null, 0, 4);
        this.addField(table, "f_status", "\u72b6\u6001", "8", null, null, 1, 4);
        this.addField(table, "f_ismycreate", "\u662f\u5426\u81ea\u5df1\u521b\u5efa", "8", null, null, 1, 4);
        this.addField(table, "f_requestid", "\u4e91\u67e5\u8be2id", "2", 100, null, 1, 4);
        this.addField(table, "f_ismy", "\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528\uff09", "8", null, null, 1, 4);
        this.addField(table, "f_xzqdmsys", "\u884c\u653f\u533a\u4ee3\u7801-\u7cfb\u7edf\u7528", "2", 20, null, 0, 4);
        this.addField(table, "f_submit_userid", "\u63d0\u4ea4\u4eba\u5458", "2", 32, null, 1, 4);
        this.addField(table, "f_reject_count", "\u6253\u56de\u6b21\u6570", "8", null, null, 1, 4);
        this.addField(table, "f_review_stage", "\u5ba1\u6838\u9636\u6bb5", "8", null, null, 1, 4);
        this.addField(table, "f_reject_status", "\u6253\u56de\u72b6\u6001", "8", null, null, 1, 4);
        this.addField(table, "f_shape", "shape", "9", null, null, 0, 5);
        this.addField(table, "f_shape1", "shape1", "9", null, null, 0, 5);
        this.addField(table, "f_lat", "\u4e2d\u5fc3\u70b9Y\u5750\u6807", "3", 12, 6, 0, 5);
        this.addField(table, "f_lon", "\u4e2d\u5fc3\u70b9X\u5750\u6807", "3", 12, 6, 0, 5);
        this.addField(table, "f_shape_b", "\u767e\u5ea6shape", "9", null, null, 1, 5);
        this.addField(table, "f_lat_b", "\u767e\u5ea6\u4e2d\u5fc3\u70b9Y\u5750\u6807", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_b", "\u767e\u5ea6\u4e2d\u5fc3\u70b9X\u5750\u6807", "3", 12, 6, 1, 5);
        this.addField(table, "f_shape_g", "\u8c37\u6b4cshape", "9", null, null, 1, 5);
        this.addField(table, "f_tbmc", "\u56fe\u6591\u540d\u79f0", "2", 100, null, 1, 1);
        this.addField(table, "f_tbbh", "\u56fe\u6591\u7f16\u53f7", "2", 100, null, 1, 1);
        this.addField(table, "f_xzqdm", "\u884c\u653f\u533a\u4ee3\u7801", "2", 20, null, 0, 1);
        this.addField(table, "f_tbmj", "\u56fe\u6591\u9762\u79ef(\u4ea9)", "3", 12, 2, 1, 1);
        this.addField(table, "f_lat_g", "\u8c37\u6b4c\u4e2d\u5fc3\u70b9Y\u5750\u6807", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_g", "\u8c37\u6b4c\u4e2d\u5fc3\u70b9X\u5750\u6807", "3", 12, 6, 1, 5);
        this.addField(table, "f_xzqmc1", "\u884c\u653f\u533a\u540d\u79f0", "2", 100, null, 1, 5);
        this.addField(table, "f_xzqmc", "\u884c\u653f\u533a\u540d\u79f0", "2", 100, null, 0, 1);
        this.addField(table, "f_userid", "\u64cd\u4f5c\u4eba", "2", 100, null, 1, 5);
        this.addField(table, "f_typical", "\u5178\u578b\u95ee\u9898", "2", 100, null, 1, 5);
        this.addField(table, "f_createtime", "\u521b\u5efa\u65f6\u95f4", "2", 100, null, 1, 5);
        this.addField(table, "f_updatetime", "\u66f4\u65b0\u65f6\u95f4", "2", 100, null, 1, 5);
        this.addField(table, "f_committime", "\u63d0\u4ea4\u65f6\u95f4", "2", 100, null, 1, 6);
        this.addField(table, "f_approvetime", "\u5ba1\u6838\u65f6\u95f4", "2", 100, null, 1, 6);
        this.addField(table, "f_upload_userid", "\u6267\u884c\u4eba\u5458", "2", 100, null, 1, 6);
    }

    private void addField(TbtskObjectinfo tableInfo, String name, String alias, String fieldType, Integer length, Integer pricies, Integer nullAble, Integer code) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(alias);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(fieldType);
        tbField.setfLength(length);
        tbField.setfPrecision(pricies);
        tbField.setfNullable(nullAble);
        tbField.setfFieldInnerOuterSys(Integer.valueOf(1));
        tbField.setfTableid(tableInfo.getfId());
        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfFieldInnerOuterSys(code);
        this.fieldsDao.save((Object)tbField);
    }
}

