/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TbtskSuperUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolConfigService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserTaskMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolConfig;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.util.GutilStr;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MPartrolConfigServiceImpl
implements MPartrolConfigService {
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    TbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    RegionService regionService;
    @Autowired
    PatrolUserMapper patrolUserMapper;
    @Autowired
    PatrolUserTaskMapper patrolUserTaskMapper;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Transactional(rollbackFor={Exception.class})
    public PatrolConfig savePatrolInfoConfig(PatrolConfig patrolConfig) {
        Boolean newRow = false;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)patrolConfig.getfId())) {
            patrolConfig.setfId(UUID.randomUUID().toString());
            patrolConfig.setfState(Integer.valueOf(0));
            this.patrolConfigMapper.gwAccessSelective((GiEntitySaveable)patrolConfig);
            newRow = true;
        } else {
            boolean existTableName;
            String tableName;
            PatrolConfig patrolConfig1 = (PatrolConfig)this.patrolConfigMapper.gwSearchByPK((Serializable)((Object)patrolConfig.getfId()));
            if (patrolConfig1.getfState() > 0 && GutilStr.isNotBlank((CharSequence)(tableName = this.tskTaskBizService.getTableNameByBizId(patrolConfig1.getfTaskId()))) && (existTableName = this.dataBizService.isExistTableName(tableName)) && this.dataBizService.getCount(tableName, " 1=1 ") > 0) {
                throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u914d\u7f6e");
            }
            this.patrolConfigMapper.gwUpdateByPKSelective((GiEntityAlterable)patrolConfig);
        }
        TskTaskBiz tskTaskBiz = new TskTaskBiz();
        if (newRow.booleanValue()) {
            tskTaskBiz.setType("2");
            tskTaskBiz.setFinish(Integer.valueOf(0));
            tskTaskBiz.setCreateTime(new Date());
            tskTaskBiz.setIsPublic(Integer.valueOf(0));
            tskTaskBiz.setTotal(Integer.valueOf(0));
            tskTaskBiz.setAssignCount(Integer.valueOf(0));
            tskTaskBiz.setStatus("1");
            tskTaskBiz.setScope("\u667a\u80fd\u7ba1\u7406");
        } else {
            tskTaskBiz = this.tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        }
        tskTaskBiz.setSource(patrolConfig.getfName());
        tskTaskBiz.setName(patrolConfig.getfName());
        tskTaskBiz.setDesc(patrolConfig.getfName());
        tskTaskBiz.setUserId(patrolConfig.getfUserId().toString());
        tskTaskBiz.setIsApprove(patrolConfig.getfIsApprove());
        tskTaskBiz.setGranularity(Integer.valueOf(3));
        tskTaskBiz.setMode(Integer.valueOf(1));
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        tskTaskBiz.setVersion(defaultVersion != null ? defaultVersion.getVersion() : "2018");
        tskTaskBiz.setClassId(Long.valueOf(Long.parseLong(patrolConfig.getfPatrolBusiness())));
        if (tskTaskBiz.getTableId() != null) {
            TbtskObjectinfo one = this.tbtskObjectinfoRepository.findById((Object)tskTaskBiz.getTableId()).orElse(null);
            one.setfSpatialtype(patrolConfig.getfSpatialtype());
            one.setfIsspatial(Integer.valueOf(1));
            this.tbtskObjectinfoRepository.save((Object)one);
        } else {
            TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
            tbtskObjectinfo.setfTablealias(tskTaskBiz.getName());
            tbtskObjectinfo.setfIsspatial(Integer.valueOf(1));
            tbtskObjectinfo.setfSpatialtype(patrolConfig.getfSpatialtype());
            tbtskObjectinfo.setfState("1");
            tbtskObjectinfo.setfVersion("1");
            tbtskObjectinfo.setfTableversion(Integer.valueOf(0));
            this.tbtskObjectinfoRepository.save((Object)tbtskObjectinfo);
            tskTaskBiz.setTableId(tbtskObjectinfo.getfId());
        }
        tskTaskBiz = this.tskTaskBizService.save(tskTaskBiz, patrolConfig.getfRegionCode(), 2);
        if (newRow.booleanValue()) {
            patrolConfig.setfTaskId(tskTaskBiz.getId());
            this.saveManager(patrolConfig.getfUserId(), patrolConfig.getfTaskId());
            this.patrolConfigMapper.gwUpdateByPK((GiEntityAlterable)patrolConfig);
        }
        return patrolConfig;
    }

    public void updatePatrolState(Integer state, String patrolId, String taskId) {
        PatrolConfig patrolConfig = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)patrolId)) {
            patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)patrolId);
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taskId)) {
            patrolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(patrolId);
        }
        if (patrolConfig != null) {
            boolean existTableName;
            String tableName;
            if (patrolConfig.getfState() == 0) {
                throw new GwValidateException("\u5de1\u67e5\u4efb\u52a1\u8fd8\u6ca1\u6709\u914d\u7f6e\u5b8c\u6210\uff0c\u4e0d\u80fd\u53d8\u66f4\u72b6\u6001\uff01");
            }
            if (patrolConfig.getfState() > 0 && state == 4 && GutilStr.isNotBlank((CharSequence)(tableName = this.tskTaskBizService.getTableNameByBizId(patrolConfig.getfTaskId()))) && (existTableName = this.dataBizService.isExistTableName(tableName)) && this.dataBizService.getCount(tableName, " 1=1 ") > 0) {
                throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5de1\u67e5\u4e1a\u52a1");
            }
        }
        this.patrolConfigMapper.updatePatrolState(state, patrolId, taskId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delPatrolCofig(String classId) {
        PatrolConfig patrolConfig = this.patrolConfigMapper.findPartolConfigByClassId(classId);
        if (patrolConfig != null) {
            if (patrolConfig.getfState() > 0) {
                boolean existTableName;
                String tableName = this.tskTaskBizService.getTableNameByBizId(patrolConfig.getfTaskId());
                if (GutilStr.isNotBlank((CharSequence)tableName) && (existTableName = this.dataBizService.isExistTableName(tableName)) && this.dataBizService.getCount(tableName, " 1=1 ") > 0) {
                    throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5de1\u67e5\u4e1a\u52a1");
                }
                this.tbtskTaskClassRepository.deleteById(Long.valueOf(Long.parseLong(classId)));
                this.patrolConfigMapper.deleteByPrimaryKey((Object)patrolConfig.getfId());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)patrolConfig.getfTaskId())) {
                    this.tskTaskBizService.delByTaskId(patrolConfig.getfTaskId());
                }
                this.patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(), null);
                this.patrolUserTaskMapper.deleteByPatrolId(patrolConfig.getfId());
            } else {
                this.tbtskTaskClassRepository.deleteById(Long.valueOf(Long.parseLong(classId)));
                this.patrolConfigMapper.deleteByPrimaryKey((Object)patrolConfig.getfId());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)patrolConfig.getfTaskId())) {
                    this.tskTaskBizService.delByTaskId(patrolConfig.getfTaskId());
                }
                this.patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(), null);
                this.patrolUserTaskMapper.deleteByPatrolId(patrolConfig.getfId());
            }
        } else {
            this.tbtskTaskClassRepository.deleteById(Long.valueOf(Long.parseLong(classId)));
        }
    }

    public Map<String, Object> findPartolConfigList(String className, Integer state, int page, int rows) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int start = (page - 1) * rows;
        List list = this.patrolConfigMapper.findPartolConfigList(state, className, start, rows);
        int count = this.patrolConfigMapper.findPartolConfigListCount(state, className);
        if (!list.isEmpty()) {
            for (PatrolConfig patrolConfig : list) {
                List tskTaskBizs;
                String url;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)patrolConfig.getfRegionCode())) {
                    patrolConfig.setRegionName(this.regionService.getName(patrolConfig.getfRegionCode()));
                }
                if (patrolConfig.getClassImgurl() != null && !patrolConfig.getClassImgurl().contains("AccessKeyId")) {
                    url = this.temporarySignedUrlService.getTemporarySignedUrl("", patrolConfig.getClassImgurl(), null);
                    patrolConfig.setClassImgurl(url);
                }
                if (patrolConfig.getClassAppicon() != null && !patrolConfig.getClassAppicon().contains("AccessKeyId")) {
                    url = this.temporarySignedUrlService.getTemporarySignedUrl("", patrolConfig.getClassAppicon(), null);
                    patrolConfig.setClassAppicon(url);
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)patrolConfig.getfPatrolBusiness()) || (tskTaskBizs = this.tskTaskBizService.getTskTaskBizByClassId(Long.valueOf(Long.parseLong(patrolConfig.getfPatrolBusiness())))).isEmpty()) continue;
                this.bizSetParamByClass(tskTaskBizs, null, null);
                patrolConfig.setTaskBizs(tskTaskBizs.get(0));
            }
        }
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    public void bizSetParamByClass(List<TskTaskBiz> bizs, String userRegion, Long userId) {
        for (TskTaskBiz biz : bizs) {
            String name;
            List tskTaskBizArea = this.tskTaskBizService.getTskTaskBizAreaByBizId(biz.getId());
            if (!tskTaskBizArea.isEmpty()) {
                List collect = tskTaskBizArea.stream().map(a -> a.getArea()).collect(Collectors.toList());
                biz.setTaskArea(StringUtils.join(collect, (CharSequence)","));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)biz.getDataUrl())) {
                name = biz.getDataUrl().substring(biz.getDataUrl().lastIndexOf("/") + 1);
                biz.setDataFileName(name);
                if (biz.getDataUrl() != null) {
                    biz.setDataUrl(this.temporarySignedUrlService.getTemporarySignedUrl("", biz.getDataUrl(), null));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)biz.getWorkflowUrl())) {
                name = biz.getWorkflowUrl().substring(biz.getWorkflowUrl().lastIndexOf("/") + 1);
                biz.setWorkflowFileName(name);
                if (!biz.getWorkflowUrl().contains("AccessKeyId")) {
                    biz.setWorkflowUrl(this.temporarySignedUrlService.getTemporarySignedUrl("", biz.getWorkflowUrl(), null));
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)biz.getUserUrl())) continue;
            name = biz.getUserUrl().substring(biz.getUserUrl().lastIndexOf("/") + 1);
            biz.setUserFileName(name);
            if (biz.getUserUrl().contains("AccessKeyId")) continue;
            biz.setUserUrl(this.temporarySignedUrlService.getTemporarySignedUrl("", biz.getUserUrl(), null));
        }
    }

    public void saveManager(Long userId, String taskId) {
        UserBiz2 ub = new UserBiz2();
        ub.setUserId(userId);
        ub.setBizId(taskId);
        ub.setRole(Integer.valueOf(0));
        this.userBiz2Repository.save((Object)ub);
        UserBiz2 userBiz2 = new UserBiz2();
        userBiz2.setUserId(userId);
        userBiz2.setBizId(taskId);
        userBiz2.setRole(Integer.valueOf(1));
        this.userBiz2Repository.save((Object)userBiz2);
        UserBiz2 userBiz3 = new UserBiz2();
        userBiz3.setUserId(userId);
        userBiz3.setBizId(taskId);
        userBiz3.setRole(Integer.valueOf(5));
        this.userBiz2Repository.save((Object)userBiz3);
        List regions = this.landUser2AreaRepository.queryAreas(userId);
        if (!regions.isEmpty()) {
            this.tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), (String)regions.get(0), null);
            this.tbtskSuperUserAuditAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), (String)regions.get(0), null);
        }
    }
}

