/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.repository.task.TbsysSignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskAuditAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskGroupRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TbtskSuperUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.task.entity.TbsysSignRecord;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolConfigService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolTaskService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolApproveRecordMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserTaskMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolApproveRecord;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolConfig;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolUser;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolUserTask;
import com.geoway.landteam.patrolclue.model.until.DateUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntitySaveable;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MPartrolTaskServiceImpl
implements MPartrolTaskService {
    @Autowired
    TbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MPartrolConfigService mPartrolConfigService;
    @Resource
    TskRightAreaRepository rightAreaRepository;
    @Autowired
    MTbtskFieldsService fieldsService;
    @Autowired
    PatrolUserTaskMapper patrolUserTaskMapper;
    @Autowired
    PatrolApproveRecordMapper patrolApproveRecordMapper;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    LandUser2AreaRepository userAreaDao;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    UserAreaRepository userAreaRepository;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskAuditAssignRecordRepository tbtskAuditAssignRecordRepository;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    RegionService regionService;
    @Autowired
    PatrolUserMapper patrolUserMapper;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Resource
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    TbsysSignRecordRepository tbsysSignRecordRepository;

    public Map<String, Object> findPartolTaskList(String patrolId, Long userId, String name, String usernName, int page, int rows) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int start = (page - 1) * rows;
        List list = this.patrolUserTaskMapper.findListLimit(patrolId, userId, name, usernName, start, rows);
        int count = this.patrolUserTaskMapper.findListLimitCount(patrolId, userId, name, usernName);
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    public List<PatrolUserTask> findPartolTaskList(String patrolId, Long userId, String patrolTime) {
        List list = this.patrolUserTaskMapper.findPartolTaskList(patrolId, userId, patrolTime);
        PatrolConfig patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)patrolId);
        String tableName = null;
        String tableNameGzqk = null;
        String tableNameWt = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for (TbtskObjectinfo tbtskObjectinfo : objectbyTaskId) {
            if (StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("\u5de5\u4f5c\u60c5\u51b5")) {
                tableNameGzqk = tbtskObjectinfo.getfTablename();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("\u95ee\u9898\u6570\u636e")) {
                tableNameWt = tbtskObjectinfo.getfTablename();
                continue;
            }
            tableName = tbtskObjectinfo.getfTablename();
        }
        for (PatrolUserTask patrolUserTask : list) {
            patrolUserTask.setSignCount(Integer.valueOf(this.tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, patrolUserTask.getfId())));
            Integer gzqkcount = this.dataBizService.getCount(tableNameGzqk, " f_xcrwid = '" + patrolUserTask.getfId() + "'");
            patrolUserTask.setWorkReportCount(gzqkcount);
            String sql = "select count(distinct f_dataid) from tbtsk_assign_record tar where f_status  ='1' and f_taskid  = '" + patrolConfig.getfTaskId() + "' and  f_assignto = '" + userId + "' and  f_createtime  <= '" + sdf.format(patrolUserTask.getfEndTime()) + "' and exists (select tb.f_id from " + tableName + " tb where tb.f_id = tar.f_dataid) ";
            Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
            patrolUserTask.setXsCount(count);
        }
        return list;
    }

    public Map<String, Object> findPartolGzqk(String patrolId, String xcrwId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PatrolConfig patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)patrolId);
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        List objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for (TbtskObjectinfo tbtskObjectinfo : objectbyTaskId) {
            if (!StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfRemark()) || !tbtskObjectinfo.getfRemark().equals("\u5de5\u4f5c\u60c5\u51b5")) continue;
            List<TbtskFields> fieldsList = this.tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
            List detailMainGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode("app", tbtskObjectinfo.getfId(), "202");
            ArrayList<String> fields = new ArrayList<String>();
            for (TbtskFields f : fieldsList) {
                fields.add(f.getfFieldname());
            }
            Map currObj = this.dataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fields, "f_xcrwid", "'" + xcrwId + "'");
            result.put("gzqkFields", fieldsList);
            result.put("gzqkDetailGroup", detailMainGroup);
            result.put("gzqkInfo", currObj);
        }
        return result;
    }

    public List<TbsysSignRecord> findPartolSign(Long userId, String patrolId, String xcrwId) {
        return this.tbsysSignRecordRepository.getByUserIdAndXsrwId(userId, xcrwId);
    }

    public Map<String, Object> findPartolWtdata(String patrolId, String xcrwId, String tbId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PatrolConfig patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)patrolId);
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        List objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for (TbtskObjectinfo tbtskObjectinfo : objectbyTaskId) {
            if (!StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfRemark()) || !tbtskObjectinfo.getfRemark().equals("\u95ee\u9898\u6570\u636e")) continue;
            List<TbtskFields> fieldsList = this.tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
            List detailMainGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode("app", tbtskObjectinfo.getfId(), "202");
            ArrayList<String> fields = new ArrayList<String>();
            for (TbtskFields f : fieldsList) {
                fields.add(f.getfFieldname());
            }
            String where = "f_xcrwid = '" + xcrwId + "'";
            if (StringUtils.isNotBlank((CharSequence)tbId)) {
                where = where + " and f_tbid = '" + tbId + "'";
            }
            List<Map> currObj = this.dataBizService.queryAllData(tbtskObjectinfo.getfTablename(), fields, where);
            result.put("wtFields", fieldsList);
            result.put("wtDetailMainGroup", detailMainGroup);
            result.put("wtInfo", currObj);
        }
        return result;
    }

    public Map<String, Object> findPartolTaskTb(Long userId, String patrolId, String xcrwId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PatrolConfig patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)patrolId);
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        PatrolUserTask patrolUserTask = (PatrolUserTask)this.patrolUserTaskMapper.selectByPrimaryKey((Object)xcrwId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<TbtskFields> fieldsList = this.tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
        List detailMainGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode("app", tbtskObjectinfo.getfId(), "100");
        ArrayList<String> fields = new ArrayList<String>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        String where = " 1= 1 ";
        if (StringUtils.isNotBlank((CharSequence)xcrwId)) {
            String sql = "select tar.f_dataid from tbtsk_assign_record tar where f_id = tar.f_dataid and tar.f_status='1' and tar.f_taskid  = '" + patrolConfig.getfTaskId() + "' and  tar.f_assignto = '" + userId + "' and tar.f_createtime between '" + sdf.format(patrolUserTask.getfStartTime()) + "' and '" + sdf.format(patrolUserTask.getfEndTime()) + "' ";
            where = where + " and exists (" + sql + ")";
        }
        List<Map> currObj = this.dataBizService.queryAllData(tbtskObjectinfo.getfTablename(), fields, where);
        result.put("tbFields", fieldsList);
        result.put("tbDetailMainGroup", detailMainGroup);
        result.put("tbInfo", currObj);
        return result;
    }

    public List<PatrolUserTask> findPartolTaskListByTbid(String bizId, String tbId) {
        PatrolConfig partolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(bizId);
        List assigntos = this.tskAssignRecordRepository.findAssigntoByTaskIdAndTbId(bizId, tbId);
        List userIds = assigntos.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List list = this.patrolUserTaskMapper.findPatrolUserTaskByUserIds(partolConfig.getfId(), userIds);
        return list;
    }

    public Map<String, Object> findPatrolUserList(String taskId, String phone, String usernName, int role, int page, int rows) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int start = (page - 1) * rows;
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        PatrolConfig patrolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(taskId);
        List patrolUserList = this.patrolUserMapper.findPatrolUserList(patrolConfig.getfId(), phone, usernName, role, start, rows);
        for (PatrolUser patrolUser : patrolUserList) {
            patrolUser.setUserRoleAreas(this.tskTaskBizService.getUserRoleAreas(taskId, patrolUser.getfUserId(), 3, null));
            LandUser2Area landUser2Area = this.userAreaDao.queryOneByUserId(patrolUser.getfUserId());
            patrolUser.setRegionCode(landUser2Area.getRegionCode());
            String regionName = this.regionRepository.getNameByCodeAndVersion(landUser2Area.getRegionCode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
            patrolUser.setRegionName(regionName);
        }
        int count = this.patrolUserMapper.findPatrolUserListCount(patrolConfig.getfId(), phone, usernName);
        result.put("data", patrolUserList);
        result.put("totalCount", count);
        return result;
    }

    public List<PatrolUser> findPatrolUserRole(String patrolId, Long userId) {
        List patrolUsers = this.patrolUserMapper.findPatrolUserRoleByPatrolId(patrolId, userId);
        return patrolUsers;
    }

    public void addPatrolRole(String taskId, Long userId, Integer role, String regions, String version) {
        PatrolConfig patrolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(taskId);
        if (patrolConfig != null) {
            List byUserIdAndRoleAndId = this.patrolUserMapper.findByUserIdAndRoleAndId(patrolConfig.getfId(), userId, null);
            if (byUserIdAndRoleAndId.size() <= 0 || ((PatrolUser)byUserIdAndRoleAndId.get(0)).getfRole() == role) {
                JSONArray keyData = JSON.parseArray((String)patrolConfig.getfPatrolFreq(), (Feature[])new Feature[0]);
                for (int i = 0; i < keyData.size(); ++i) {
                    JSONObject jsonObject = keyData.getJSONObject(i);
                    Integer patrolRole = jsonObject.getInteger("role");
                    Integer frequency = jsonObject.getInteger("frequency");
                    if (byUserIdAndRoleAndId.size() > 0 || role != patrolRole) continue;
                    PatrolUser patrolUser = new PatrolUser();
                    patrolUser.setfId(UUID.randomUUID().toString());
                    patrolUser.setfUserId(userId);
                    patrolUser.setfRole(role);
                    patrolUser.setfPatrolId(patrolConfig.getfId());
                    patrolUser.setfPatrolFreq(frequency.toString());
                    this.patrolUserMapper.gwAccessSelective((GiEntitySaveable)patrolUser);
                    this.addPatrolUserTask(patrolConfig, frequency, userId);
                }
                this.tskTaskBizService.saveUserBiz(userId, taskId, 3);
                this.tskTaskBizService.changeRightArea(taskId, userId.toString(), regions);
                this.tskTaskBizService.saveUserBiz(userId, taskId, 1);
                this.tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions, version);
                this.tskTaskBizService.saveUserBiz(userId, taskId, 2);
                this.tbtskUserAuditAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions, version);
            } else {
                throw new GwValidateException("\u7528\u6237\u3010" + userId + "\u3011\u5df2\u914d\u7f6e\u5de1\u67e5\u5458\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            }
        }
    }

    public void updatePatrolRole(String id, String taskId, String regions, String version) {
        PatrolUser patrolUser = (PatrolUser)this.patrolUserMapper.gwSearchByPK((Serializable)((Object)id));
        this.tskTaskBizService.changeRightArea(taskId, patrolUser.getfUserId().toString(), regions);
        this.tbtskUserManageAreaService.deleteByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString());
        this.tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString(), regions, version);
        this.tbtskUserAuditAreaService.deleteByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString());
        this.tbtskUserAuditAreaService.updateByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString(), regions, version);
    }

    @Transactional
    public void cancelPatrolRole(String taskId, List<Long> userIdList) {
        PatrolConfig patrolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(taskId);
        if (patrolConfig != null) {
            for (Long userId : userIdList) {
                this.patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(), userId);
                this.patrolUserTaskMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(), userId);
                this.userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, Integer.valueOf(1));
                this.tbtskUserManageAreaService.deleteByTaskIdAndUserId(taskId, userId.toString());
                this.userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, Integer.valueOf(2));
                this.tbtskUserAuditAreaService.deleteByTaskIdAndUserId(taskId, userId.toString());
                this.userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, Integer.valueOf(3));
                this.rightAreaRepository.deleteByTaskIdAndUserId(taskId, userId.toString());
            }
        }
    }

    public PatrolConfig findPartolTaskByClassId(Long classId) {
        PatrolConfig patrolConfig = null;
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(classId);
        List<TskTaskBiz> tskTaskBizs = this.tskTaskBizService.getTskTaskBizByClassId(classId);
        if (tskTaskBizs != null && tskTaskBizs.size() > 0) {
            patrolConfig = this.patrolConfigMapper.findPartolConfigByTaskId(tskTaskBizs.get(0).getId());
            this.mPartrolConfigService.bizSetParamByClass(tskTaskBizs, null, null);
            patrolConfig.setTaskBizs((Object)tskTaskBizs.get(0));
            patrolConfig.setClassDesc(tbtskTaskClass.getDesc());
        }
        return patrolConfig;
    }

    public int userClockIn(Long userId, String lon, String lat, String patrolId, String xcrwId) throws Exception {
        int signCount = 1;
        String wkt = "POINT(" + lon + " " + lat + ")";
        Geometry geometry = WKTUtil.wktToGeom((String)wkt);
        String code = "";
        String codeName = "";
        RegionVillage regionVillage = this.regionService.queryRegionVillageByCoor(geometry);
        if (regionVillage != null) {
            code = regionVillage.getCode();
            codeName = regionVillage.getName();
        } else {
            RegionTown regionTown = this.regionService.queryRegionTownCotain(geometry);
            if (regionTown != null) {
                code = regionTown.getCode();
                codeName = regionTown.getName();
            } else {
                RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                if (region != null) {
                    code = region.getCode();
                    codeName = region.getName();
                }
            }
        }
        TbsysSignRecord bean = new TbsysSignRecord();
        bean.setUserId(userId);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bean.setRegionCode(code);
        bean.setAddr(codeName);
        bean.setLat(Double.valueOf(Double.parseDouble(lat)));
        bean.setLon(Double.valueOf(Double.parseDouble(lon)));
        bean.setPlanId(patrolId);
        bean.setXsrwId(xcrwId);
        this.tbsysSignRecordRepository.save((Object)bean);
        signCount = this.tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, xcrwId);
        return signCount;
    }

    public void submitPartolGzqk(Long userId, JSONObject param) {
        String sql;
        Integer count;
        String f_patrolid = param.getString("f_patrolid");
        String f_xcrwid = param.getString("f_xcrwid");
        PatrolConfig patrolConfig = (PatrolConfig)this.patrolConfigMapper.selectByPrimaryKey((Object)f_patrolid);
        String tableNameGzqk = null;
        List objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for (TbtskObjectinfo tbtskObjectinfo : objectbyTaskId) {
            if (!StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfRemark()) || !tbtskObjectinfo.getfRemark().equals("\u5de5\u4f5c\u60c5\u51b5")) continue;
            tableNameGzqk = tbtskObjectinfo.getfTablename();
            break;
        }
        if ((count = (Integer)this.jdbcTemplate.queryForObject(sql = "select count(1) from " + tableNameGzqk + " where  f_patrolid ='" + f_patrolid + "' and f_xcrwid ='" + f_xcrwid + "'", Integer.class)) > 0) {
            throw new GwValidateException("\u5de1\u67e5\u4efb\u52a1\u5df2\u6709\u5de5\u4f5c\u60c5\u51b5\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        Map<String, Object> map = MPartrolTaskServiceImpl.convertJsonToMap(param);
        map.put("f_id", UUID.randomUUID().toString());
        this.dataBizService.insertData(tableNameGzqk, map, null);
    }

    public List<PatrolApproveRecord> findPartolApproveRecord(String taskId, String tbId, String xcrwId) {
        return this.patrolApproveRecordMapper.findPartolApproveRecord(taskId, tbId, xcrwId);
    }

    public Map<String, Object> checkApprovePermission(String taskId, String tbId, String xcrwId, Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("hasPermission", true);
        List byTaskIdAndAssigntoAndDataIdAndStatus = this.tbtskAuditAssignRecordRepository.findByTaskIdAndAssigntoAndDataIdAndStatus(taskId, userId.toString(), tbId, "0");
        if (byTaskIdAndAssigntoAndDataIdAndStatus.size() <= 0) {
            resultMap.put("hasPermission", false);
            return resultMap;
        }
        List partolApproveRecord = this.patrolApproveRecordMapper.findPartolApproveRecord(taskId, tbId, xcrwId);
        if (partolApproveRecord.size() > 0) {
            resultMap.put("hasPermission", false);
            return resultMap;
        }
        return resultMap;
    }

    public PatrolApproveRecord savePatrolApproveRecord(PatrolApproveRecord patrolApproveRecord) {
        if (StringUtils.isNotBlank((CharSequence)patrolApproveRecord.getfId())) {
            this.patrolApproveRecordMapper.updateByPrimaryKeySelective((Object)patrolApproveRecord);
        } else {
            patrolApproveRecord.setfId(UUID.randomUUID().toString());
            this.patrolApproveRecordMapper.gwAccessSelective((GiEntitySaveable)patrolApproveRecord);
        }
        return patrolApproveRecord;
    }

    public void batchApproveXcTaskData(JSONObject data, Long userId) throws Exception {
        String taskId = data.getString("taskId");
        String fOption = data.getString("fOption");
        String fStatus = data.getString("fStatus");
        String fDescription = data.getString("fDescription");
        String fRemark = data.getString("fRemark");
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findOne(taskId);
        if (null == tskTaskBiz) {
            throw new Exception("\u4e0b\u53d1\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo || tbtskObjectinfo != null && StringUtils.isBlank((CharSequence)tbtskObjectinfo.getfTablename())) {
            throw new Exception("\u4e0b\u53d1\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (data.containsKey((Object)"taskids")) {
            JSONArray tbIds = data.getJSONArray("taskids");
            for (int i = 0; i < tbIds.size(); ++i) {
                String xcrwId;
                JSONObject jsonObject = tbIds.getJSONObject(i);
                String tbId = jsonObject.getString("tbId");
                List partolApproveRecord = this.patrolApproveRecordMapper.findPartolApproveRecord(taskId, tbId, xcrwId = jsonObject.getString("xcrwId"));
                if (partolApproveRecord.size() > 0) continue;
                PatrolApproveRecord patrolApproveRecord = new PatrolApproveRecord();
                patrolApproveRecord.setfId(UUID.randomUUID().toString());
                patrolApproveRecord.setfTaskId(taskId);
                patrolApproveRecord.setfTbId(tbId);
                patrolApproveRecord.setfXcrwId(xcrwId);
                patrolApproveRecord.setfApproveUserId(userId);
                patrolApproveRecord.setfApproveUser(userId.toString());
                patrolApproveRecord.setfOption(Integer.valueOf(fOption));
                patrolApproveRecord.setfStatus(Integer.valueOf(fStatus));
                patrolApproveRecord.setfRemark(fRemark);
                patrolApproveRecord.setfDescription(fDescription);
                patrolApproveRecord.setfApproveTime(new Timestamp(System.currentTimeMillis()));
                this.patrolApproveRecordMapper.gwAccessSelective((GiEntitySaveable)patrolApproveRecord);
            }
        } else if (data.containsKey((Object)"taskQueryParameter")) {
            TaskQueryParameter taskQueryParameter = (TaskQueryParameter)JSONObject.parseObject((String)data.getString("taskQueryParameter"), TaskQueryParameter.class);
            taskQueryParameter.setUserId(userId);
            taskQueryParameter.setTaskId(taskId);
            Pair<String, String> queryParamPair = this.tskTaskBizService.parseQueryParameter(taskQueryParameter);
            String tableName = "with assign as (select f_dataid ,f_assignto from tbtsk_assign_record tar  where f_taskid ='" + taskId + "' group by f_dataid ,f_assignto)\nselect\n\ttb.f_id as tbid,tput.f_id as xcrwid\nfrom\n\ttbtsk_task_znglrw_20240109160703834 tb\ninner join assign tar on (tar.f_dataid = tb.f_id)\nleft join tb_patrol_user_task tput on (cast (tput.f_userid as varchar)  = tar.f_assignto)\nwhere exists (select * from tbtsk_audit_assign_record audit where audit.f_dataid = tb.f_id and audit.f_assignto='" + userId + "')\nand not exists (select * from tb_patrol_approve_record approve where approve.f_tbid  = tb.f_id and approve.f_xcrwid = tput.f_id)\n ";
            String where = "and " + (String)queryParamPair.getRight();
            ArrayList<String> finalFliedNameList = new ArrayList<String>();
            finalFliedNameList.add("tb.f_id as tbid");
            finalFliedNameList.add("tput.f_id as xcrwid");
            Integer count = (Integer)this.jdbcTemplate.queryForObject(tableName + where, Integer.class);
            if (count > 0) {
                String insetSql = " INSERT INTO public.tb_patrol_approve_record (f_id, f_taskid, f_tbid, f_xcrwid, f_option, f_approve_user,      f_approve_time, f_status, f_description, f_approve_userid, f_remark) select uuid_generate_v4(),'" + taskId + "',aa.tbid, aa.xcrwid,'" + fOption + "','" + userId + "',now(),'" + fStatus + "','" + fDescription + "','" + userId + "','" + fRemark + "' from (" + tableName + where + ") as aa";
                this.jdbcTemplate.execute(insetSql);
            }
        }
    }

    public Pair<Long, List<Map>> queryXcTaskDataForList(TaskQueryParameter param) throws Exception {
        Pair<String, String> queryParamPair = this.tskTaskBizService.parseQueryParameter(param);
        String tableName = "with assign as (select f_dataid ,f_assignto from tbtsk_assign_record tar  where f_taskid ='" + param.getTaskId() + "' group by f_dataid ,f_assignto)\nselect\n AAA from\n\tBBB tb\ninner join assign tar on (tar.f_dataid = tb.f_id)\nleft join tb_patrol_user_task tput on (cast (tput.f_userid as varchar)  = tar.f_assignto)\nwhere exists (select * from tbtsk_audit_assign_record audit where audit.f_dataid = tb.f_id and audit.f_assignto='" + param.getUserId() + "')\nand not exists (select * from tb_patrol_approve_record approve where approve.f_tbid  = tb.f_id and approve.f_xcrwid = tput.f_id)\n ";
        String where = " and  " + (String)queryParamPair.getRight();
        TskTaskBiz taskBiz = this.tskTaskBizService.findOne(param.getTaskId());
        if (null == taskBiz) {
            throw new Exception("\u4e0b\u53d1\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectByTableId(taskBiz.getTableId());
        List<String> fieldNameList = this.fieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web", tableInfo.getfId(), "100");
        this.tskTaskBizService.fillRequiredFieldNames(fieldNameList, tableInfo);
        fieldNameList = fieldNameList.stream().map("tb."::concat).collect(Collectors.toList());
        fieldNameList.add("tput.f_name");
        fieldNameList.add("tput.f_starttime");
        fieldNameList.add("tput.f_endtime");
        fieldNameList.add("tput.f_state");
        fieldNameList.add("tput.f_id as f_xcrwid");
        fieldNameList.add("tput.f_userid as f_assignto");
        fieldNameList.add("(select record.f_assignto as f_distributionto from tbtsk_audit_assign_record record where tb.f_id = record.f_dataid limit 1 )");
        Integer count = (Integer)this.jdbcTemplate.queryForObject(tableName.replace("BBB", tableInfo.getfTablename()).replace("AAA", "count(1)") + where, Integer.class);
        String order = " order by " + param.getSortParam();
        where = where + order;
        if (param.getPage() != null && param.getRows() != null) {
            where = where + " limit " + param.getRows() + " offset " + (param.getPage() - 1) * param.getRows();
        }
        List originalList = this.jdbcTemplate.queryForList(tableName.replace("BBB", tableInfo.getfTablename()).replace("AAA", StringUtils.join((Object[])fieldNameList.toArray(), (String)",")) + where);
        List<Map> dataList = this.tskTaskBizService.updateAssignInfo(MPartrolTaskServiceImpl.convertToListOfMaps(originalList), param.getTaskId());
        return Pair.of((Object)count, dataList);
    }

    private static List<Map> convertToListOfMaps(List<Map<String, Object>> list) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (Map<String, Object> map : list) {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!newMap.containsKey(key)) {
                    newMap.put(key, value);
                    continue;
                }
                throw new IllegalArgumentException("Duplicate keys are not allowed.");
            }
            resultList.add(newMap);
        }
        return resultList;
    }

    public void addPatrolUserTask(PatrolConfig patrolConfig, Integer frequency, Long userId) {
        if (patrolConfig.getfStartTime() != null && patrolConfig.getfEndTime() != null) {
            Timestamp startDate = patrolConfig.getfStartTime();
            Timestamp endDate = patrolConfig.getfEndTime();
            int count = 0;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            ArrayList<PatrolUserTask> patrolUserTasks = new ArrayList<PatrolUserTask>();
            String name = "\u7b2c%s\u6b21\u5de1\u67e5\uff08" + patrolConfig.getfName() + "\uff09";
            SimpleDateFormat sf = null;
            String tempName = "";
            Date tempStart = null;
            Date tempEnd = null;
            Date now = new Date();
            if (frequency == 1) {
                count = DateUtils.getDayCount((Date)endDate, (Date)startDate);
            } else if (frequency == 2) {
                count = DateUtils.getWeekCount((Date)endDate, (Date)startDate);
            } else if (frequency == 3) {
                count = DateUtils.getMonthCount((Date)endDate, (Date)startDate);
            } else if (frequency == 4) {
                count = DateUtils.getSeasonCount((Date)endDate, (Date)startDate);
            } else if (frequency == 5) {
                count = DateUtils.getHalfYearCount((Date)endDate, (Date)startDate);
            } else if (frequency == 6) {
                count = DateUtils.getYearCount((Date)endDate, (Date)startDate);
            }
            if (count > 366) {
                throw new RuntimeException("\u4efb\u52a1\u6570\u91cf\u8fc7\u591a");
            }
            for (int i = 0; i < count; ++i) {
                tempName = String.format(name, i + 1);
                if (frequency == 1) {
                    sf = new SimpleDateFormat("yyyy-MM-dd");
                    tempStart = calendar.getTime();
                    tempEnd = DateUtils.getEndOfDay((Date)calendar.getTime());
                } else if (frequency == 2) {
                    tempStart = DateUtils.getStartOfWeek((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfWeek((Date)calendar.getTime());
                    calendar.set(3, calendar.get(3) + 1);
                } else if (frequency == 3) {
                    calendar.setTime(DateUtils.getStartOfMonth((Date)calendar.getTime()));
                    sf = new SimpleDateFormat("yyyy-MM");
                    tempStart = DateUtils.getStartOfMonth((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfMonth((Date)calendar.getTime());
                } else if (frequency == 4) {
                    tempStart = DateUtils.getSeasonStartDate((Date)calendar.getTime());
                    tempEnd = DateUtils.getSeasonEndDate((Date)calendar.getTime());
                } else if (frequency == 5) {
                    tempStart = DateUtils.getHalfYearStartTime((Date)calendar.getTime());
                    tempEnd = DateUtils.getHalfYearEndTime((Date)calendar.getTime());
                } else if (frequency == 6) {
                    tempStart = DateUtils.getStartOfYear((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfYear((Date)calendar.getTime());
                }
                PatrolUserTask patrolUserTask = new PatrolUserTask();
                patrolUserTask.setfCreateTime(new Timestamp(now.getTime()));
                patrolUserTask.setfName(tempName);
                patrolUserTask.setfId(UUID.randomUUID().toString());
                patrolUserTask.setfStartTime(new Timestamp(tempStart.getTime()));
                patrolUserTask.setfEndTime(new Timestamp(tempEnd.getTime()));
                patrolUserTask.setfPatrolId(patrolConfig.getfId());
                patrolUserTask.setfUserId(userId);
                this.updateState(patrolUserTask, tempStart, tempEnd, now);
                patrolUserTasks.add(patrolUserTask);
                calendar.setTime(tempEnd);
                calendar.set(13, calendar.get(13) + 1);
            }
            this.patrolUserTaskMapper.insertList(patrolUserTasks);
        }
    }

    public boolean updateState(PatrolUserTask patrolUserTask, Date start, Date end, Date now) {
        boolean result = false;
        if (end.before(now)) {
            if (patrolUserTask.getfState() != null) {
                result = !patrolUserTask.getfState().equals(2);
            }
            patrolUserTask.setfState(Integer.valueOf(2));
        } else if (end.after(now) && start.before(now)) {
            if (patrolUserTask.getfState() != null) {
                result = !patrolUserTask.getfState().equals(1);
            }
            patrolUserTask.setfState(Integer.valueOf(1));
        } else if (start.after(now)) {
            if (patrolUserTask.getfState() != null) {
                result = !patrolUserTask.getfState().equals(0);
            }
            patrolUserTask.setfState(Integer.valueOf(0));
        }
        return result;
    }

    private static Map<String, Object> convertJsonToMap(JSONObject jsonObj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : jsonObj.keySet()) {
            Object value;
            if (key.equalsIgnoreCase("null")) continue;
            try {
                value = jsonObj.get((Object)key);
            }
            catch (Exception e) {
                continue;
            }
            resultMap.put(key, value);
        }
        return resultMap;
    }
}

