/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TbtskUserAuditArea;
import com.geoway.landteam.customtask.task.entity.TbtskUserTaskClass;
import com.geoway.landteam.customtask.task.entity.TskRightArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPatrolPlanService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.networkTransmission.inner.InnerProgramTransmitService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanContentMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeKeyAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeOutServiceMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeServiceMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanTaskMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolProgramMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.dto.PatrolPlanInfo;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanArea;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanContent;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScope;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeKeyArea;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeOutService;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeService;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanTask;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolProgram;
import com.geoway.landteam.patrolclue.model.until.DateUtils;
import com.geoway.landteam.patrolclue.servface.patrollibrary.PatrolPlanAreaService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MPatrolPlanServiceImpl
implements MPatrolPlanService {
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaMapper;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    InnerProgramTransmitService innerProgramTransmitService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    PatrolPlanAreaService patrolPlanAreaService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    PatrolPlanScopeKeyAreaMapper patrolPlanScopeKeyAreaMapper;
    @Autowired
    PatrolPlanScopeOutServiceMapper patrolPlanScopeOutServiceMapper;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    UserBiz2Repository biz2Repository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Resource
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    private RegionService regionService;
    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;

    @Transactional(rollbackFor={Exception.class})
    public void create(Long userId, PatrolPlanInfo patrolPlanInfo) throws Exception {
        String name = patrolPlanInfo.getfName();
        List list = this.patrolPlanMapper.selectByPlanName(name);
        if (!list.isEmpty()) {
            throw new RuntimeException("\u5df2\u5b58\u5728\u540c\u540d\u8ba1\u5212\uff0c\u8bf7\u4fee\u6539");
        }
        String planId = UUID.randomUUID().toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        PatrolPlan patrolPlan = new PatrolPlan();
        patrolPlan.setfId(planId);
        patrolPlan.setfName(patrolPlanInfo.getfName());
        patrolPlan.setfRelprogram(patrolPlanInfo.getfRelprogram());
        patrolPlan.setfRate(patrolPlanInfo.getfRate());
        patrolPlan.setfStarttime(df.parse(patrolPlanInfo.getfStarttime()));
        patrolPlan.setfEndtime(df.parse(patrolPlanInfo.getfEndtime()));
        patrolPlan.setfRegioncode(patrolPlanInfo.getfRegioncode());
        patrolPlan.setfCreatetime(new Date());
        patrolPlan.setfPatrolbusiness(patrolPlanInfo.getfPatrolbusiness());
        patrolPlan.setfState(Integer.valueOf(0));
        this.patrolPlanMapper.insert((Object)patrolPlan);
        ArrayList<PatrolPlanArea> patrolPlanAreas = new ArrayList<PatrolPlanArea>();
        if (patrolPlanInfo.getDutyArea() != null && !patrolPlanInfo.getDutyArea().isEmpty()) {
            for (int i = 0; i < patrolPlanInfo.getDutyArea().size(); ++i) {
                String[] regionCodes;
                JSONObject object = patrolPlanInfo.getDutyArea().getJSONObject(i);
                Long uId = object.getLong("userId");
                String role = object.getString("role");
                for (String regionCode : regionCodes = object.getString("regionCode").split(",")) {
                    PatrolPlanArea area = new PatrolPlanArea();
                    area.setfId(UUID.randomUUID().toString());
                    area.setfArea(regionCode);
                    area.setfRole(role);
                    area.setfCreatetime(new Date());
                    area.setfUserid(uId);
                    area.setfPlanid(planId);
                    patrolPlanAreas.add(area);
                }
                List<TskTaskBiz> taskBizs = this.tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(patrolPlanInfo.getfPatrolbusiness()));
                for (TskTaskBiz t : taskBizs) {
                    List userBiz2s = this.biz2Repository.findByUserIdAndBizIdAndRole(uId, t.getId(), Integer.valueOf(Integer.parseInt(role)));
                    if (userBiz2s.size() != 0) continue;
                    UserBiz2 userBiz2 = new UserBiz2();
                    userBiz2.setId(UUID.randomUUID().toString());
                    userBiz2.setUserId(uId);
                    userBiz2.setBizId(t.getId());
                    userBiz2.setRole(Integer.valueOf(Integer.parseInt(role)));
                    this.biz2Repository.save((Object)userBiz2);
                    for (String regionCode : regionCodes) {
                        if (role.equals("3")) {
                            List tskRightAreas = this.tskRightAreaRepository.findByTaskIdAndUserIdAndXzqdm(t.getId(), uId.toString(), regionCode);
                            if (tskRightAreas.size() != 0) continue;
                            TskRightArea tskRightArea = new TskRightArea();
                            tskRightArea.setId(UUID.randomUUID().toString());
                            tskRightArea.setTaskId(t.getId());
                            tskRightArea.setXzqdm(regionCode);
                            tskRightArea.setUserId(uId.toString());
                            this.tskRightAreaRepository.save((Object)tskRightArea);
                            continue;
                        }
                        if (!role.equals("2")) continue;
                        TbtskUserAuditArea tbtskUserAuditArea = new TbtskUserAuditArea();
                        tbtskUserAuditArea.setTaskId(t.getId());
                        tbtskUserAuditArea.setRegionCode(regionCode);
                        tbtskUserAuditArea.setUserId(uId.toString());
                        tbtskUserAuditArea.setLevel(Short.valueOf(this.regionService.getRegionLevel(regionCode, null).shortValue()));
                        this.tbtskUserAuditAreaService.insertSelective(tbtskUserAuditArea);
                    }
                }
                List tbtskUserTaskClasses = this.tbtskUserTaskClassRepository.queryByUserIdAndClassId(uId, Long.valueOf(patrolPlanInfo.getfPatrolbusiness()));
                if (tbtskUserTaskClasses.size() != 0) continue;
                TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
                tbtskUserTaskClass.setUserId(uId);
                tbtskUserTaskClass.setCreateDate(new Date());
                tbtskUserTaskClass.setClassId(Long.valueOf(patrolPlanInfo.getfPatrolbusiness()));
                this.tbtskUserTaskClassRepository.save((Object)tbtskUserTaskClass);
            }
            if (!patrolPlanAreas.isEmpty()) {
                this.patrolPlanAreaMapper.insertByList(patrolPlanAreas);
            }
        }
        this.savePlanContent(patrolPlanInfo, planId, userId);
        JSONArray scoptArray = patrolPlanInfo.getfScope();
        ArrayList<PatrolPlanScope> scopes = new ArrayList<PatrolPlanScope>();
        ArrayList<PatrolPlanScopeService> scopeServices = new ArrayList<PatrolPlanScopeService>();
        ArrayList<PatrolPlanScopeKeyArea> scopeKeyAreas = new ArrayList<PatrolPlanScopeKeyArea>();
        ArrayList<PatrolPlanScopeOutService> scopeOutServices = new ArrayList<PatrolPlanScopeOutService>();
        this.completePlanScopeList(scoptArray, planId, userId, scopes, scopeServices, scopeKeyAreas, scopeOutServices);
        if (!scopes.isEmpty()) {
            this.patrolPlanScopeMapper.insertList(scopes);
        }
        if (!scopeServices.isEmpty()) {
            this.patrolPlanScopeServiceMapper.insertList(scopeServices);
        }
        if (!scopeKeyAreas.isEmpty()) {
            this.patrolPlanScopeKeyAreaMapper.insertList(scopeKeyAreas);
        }
        if (!scopeOutServices.isEmpty()) {
            this.patrolPlanScopeOutServiceMapper.insertList(scopeOutServices);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group", (Object)"patrol");
        jsonObject.put("type", (Object)"insert");
        jsonObject.put("operUserId", (Object)userId);
        jsonObject.put("patrolPlan", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)patrolPlan, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        jsonObject.put("patrolPlanArea", patrolPlanAreas);
        jsonObject.put("PatrolPlanScope", scopes);
        jsonObject.put("PatrolPlanContent", (Object)this.patrolPlanContentMapper.getListByPlanId(patrolPlan.getfId()));
        jsonObject.put("PatrolPlanScopeService", scopeServices);
        jsonObject.put("PatrolProgram", (Object)this.patrolProgramMapper.gwSearchByPK((Serializable)((Object)patrolPlan.getfRelprogram())));
        jsonObject.put("PatrolPlanScopeKeyArea", scopeKeyAreas);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(Long userId, PatrolPlanInfo patrolPlanInfo) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String id = patrolPlanInfo.getfId();
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)id);
        if (patrolPlan.getfState().equals(1) || patrolPlan.getfState().equals(2)) {
            throw new RuntimeException("\u5df2\u4e0b\u53d1\u8ba1\u5212\u4fe1\u606f\u4e0d\u53ef\u4fee\u6539");
        }
        if (!patrolPlanInfo.getfName().equals(patrolPlan.getfName())) {
            List list = this.patrolPlanMapper.selectByPlanName(patrolPlanInfo.getfName());
            if (!list.isEmpty()) {
                throw new RuntimeException("\u8ba1\u5212\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
            }
            patrolPlan.setfName(patrolPlanInfo.getfName());
        }
        patrolPlan.setfRelprogram(patrolPlanInfo.getfRelprogram());
        patrolPlan.setfRate(patrolPlanInfo.getfRate());
        patrolPlan.setfStarttime(df.parse(patrolPlanInfo.getfStarttime()));
        patrolPlan.setfEndtime(df.parse(patrolPlanInfo.getfEndtime()));
        patrolPlan.setfRegioncode(patrolPlanInfo.getfRegioncode());
        this.patrolPlanMapper.updateByPrimaryKey((Object)patrolPlan);
        this.patrolPlanAreaService.changeUserRoleByPlanId(id, patrolPlanInfo.getDutyArea());
        JSONArray scopeArray = patrolPlanInfo.getfScope();
        List scopeIds = this.patrolPlanScopeServiceMapper.findByPlanId(patrolPlan.getfId()).stream().map(r -> r.getfScopeid()).collect(Collectors.toList());
        if (!scopeIds.isEmpty()) {
            this.patrolPlanScopeMapper.deleteByIds(scopeIds);
        }
        this.patrolPlanScopeServiceMapper.deleteByPlanId(patrolPlan.getfId());
        this.patrolPlanScopeKeyAreaMapper.deleteByPlanId(patrolPlan.getfId());
        this.patrolPlanScopeOutServiceMapper.deleteByPlanid(patrolPlan.getfId());
        ArrayList<PatrolPlanScope> scopes = new ArrayList<PatrolPlanScope>();
        ArrayList<PatrolPlanScopeService> scopeServices = new ArrayList<PatrolPlanScopeService>();
        ArrayList<PatrolPlanScopeKeyArea> scopeKeyAreas = new ArrayList<PatrolPlanScopeKeyArea>();
        ArrayList<PatrolPlanScopeOutService> scopeOutServices = new ArrayList<PatrolPlanScopeOutService>();
        this.completePlanScopeList(scopeArray, patrolPlan.getfId(), userId, scopes, scopeServices, scopeKeyAreas, scopeOutServices);
        if (!scopes.isEmpty()) {
            this.patrolPlanScopeMapper.insertList(scopes);
        }
        if (!scopeServices.isEmpty()) {
            this.patrolPlanScopeServiceMapper.insertList(scopeServices);
        }
        if (!scopeKeyAreas.isEmpty()) {
            this.patrolPlanScopeKeyAreaMapper.insertList(scopeKeyAreas);
        }
        if (!scopeOutServices.isEmpty()) {
            this.patrolPlanScopeOutServiceMapper.insertList(scopeOutServices);
        }
        this.patrolPlanContentMapper.deleteByPlanId(patrolPlan.getfId());
        this.savePlanContent(patrolPlanInfo, patrolPlanInfo.getfId(), userId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group", (Object)"patrol");
        jsonObject.put("type", (Object)"update");
        jsonObject.put("operUserId", (Object)userId);
        jsonObject.put("patrolPlan", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)patrolPlan, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        List patrolPlanAreas = this.patrolPlanAreaMapper.queryByPlanId(patrolPlan.getfId());
        jsonObject.put("patrolPlanArea", (Object)patrolPlanAreas);
        jsonObject.put("PatrolProgram", (Object)this.patrolProgramMapper.gwSearchByPK((Serializable)((Object)patrolPlan.getfRelprogram())));
        jsonObject.put("PatrolPlanContent", (Object)this.patrolPlanContentMapper.getListByPlanId(patrolPlan.getfId()));
        List patrolPlanScopeServices = this.patrolPlanScopeServiceMapper.findByPlanId(patrolPlan.getfId());
        if (!patrolPlanScopeServices.isEmpty()) {
            List ids = patrolPlanScopeServices.stream().map(p -> p.getfScopeid()).collect(Collectors.toList());
            List patrolPlanScopes = this.patrolPlanScopeMapper.selectByIds(ids);
            jsonObject.put("PatrolPlanScope", (Object)patrolPlanScopes);
            jsonObject.put("PatrolPlanScopeService", (Object)patrolPlanScopeServices);
        }
        if (!scopeKeyAreas.isEmpty()) {
            jsonObject.put("PatrolPlanScopeKeyArea", scopeKeyAreas);
        }
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public Map<String, Object> getList(String name, String programName, String programId, String patrolBusiness, String regionCode, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> list = new ArrayList();
        Long count = 0L;
        String sql = "SELECT A.*,\n\tb.f_name pname,b.f_patrol_business \nFROM\n\ttb_patrol_plan\n\tA LEFT JOIN tb_patrol_program b ON b.f_id = A.f_rel_program where 1=1 ";
        String countSql = "SELECT count(1)FROM\n\ttb_patrol_plan\n\tA LEFT JOIN tb_patrol_program b ON b.f_id = A.f_rel_program where 1=1 ";
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sql = sql + " and a.f_name like '%" + name + "%'";
            countSql = countSql + " and a.f_name like '%" + name + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            if (regionCode.endsWith("00")) {
                regionCode = regionCode.replace("00", "");
            }
            sql = sql + " and a.f_regioncode like '" + regionCode + "%'";
            countSql = countSql + " and a.f_regioncode like '" + regionCode + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)programId)) {
            sql = sql + " and a.f_rel_program = '" + programId + "'";
            countSql = countSql + " and a.f_rel_program = '" + programId + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)programName)) {
            sql = sql + " and b.f_name like '%" + programName + "%'";
            countSql = countSql + " and b.f_name like '%" + programName + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)patrolBusiness)) {
            sql = sql + " and a.f_patrol_business like '%" + patrolBusiness + "%'";
            countSql = countSql + " and a.f_patrol_business like '%" + patrolBusiness + "%'";
        }
        sql = sql + " order by a.f_createtime desc limit " + rows + " offset " + (page - 1) * rows;
        List list1 = this.jdbcTemplate.queryForList(sql);
        list = this.changeMapToJavaObj(list1, "");
        count = (Long)this.jdbcTemplate.queryForObject(countSql, Long.class);
        map.put("list", list);
        map.put("count", count);
        return map;
    }

    public List<PatrolPlan> findPlanList(Long userId) {
        List list = this.patrolPlanMapper.findPlanList(userId);
        if (!list.isEmpty()) {
            return list.stream().filter(MPatrolPlanServiceImpl.distinctByKey(PatrolPlan::getfId)).collect(Collectors.toList());
        }
        return list;
    }

    public List<PatrolPlanTask> findPlanTaskList(Long userId, String planId) {
        List list = this.patrolPlanTaskMapper.findPlanTaskList(planId);
        if (!list.isEmpty()) {
            return list.stream().filter(MPatrolPlanServiceImpl.distinctByKey(PatrolPlanTask::getfId)).collect(Collectors.toList());
        }
        return list;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public PatrolPlan getPatrolPlanInfo(String id) {
        PatrolProgram patrolProgram;
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)id);
        if (patrolPlan == null) {
            throw new RuntimeException("\u8ba1\u5212id\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)patrolPlan.getfRelprogram()) && (patrolProgram = (PatrolProgram)this.patrolProgramMapper.gwSearchByPK((Serializable)((Object)patrolPlan.getfRelprogram()))) != null) {
            patrolPlan.setProgramName(patrolProgram.getfName());
        }
        return patrolPlan;
    }

    public List<PatrolPlan> changeMapToJavaObj(List<Map<String, Object>> maps, String except) {
        ArrayList<PatrolPlan> list = new ArrayList<PatrolPlan>();
        for (Map<String, Object> stringObjectMap : maps) {
            PatrolPlan patrolPlan = new PatrolPlan();
            patrolPlan.setfId(stringObjectMap.get("f_id").toString());
            patrolPlan.setfRegioncode(stringObjectMap.get("f_regioncode") != null ? stringObjectMap.get("f_regioncode").toString() : null);
            patrolPlan.setfStarttime(stringObjectMap.get("f_starttime") != null ? (Date)stringObjectMap.get("f_starttime") : null);
            patrolPlan.setfEndtime(stringObjectMap.get("f_endtime") != null ? (Date)stringObjectMap.get("f_endtime") : null);
            patrolPlan.setfRate(stringObjectMap.get("f_rate") != null ? stringObjectMap.get("f_rate").toString() : null);
            patrolPlan.setfRelprogram(stringObjectMap.get("f_rel_program") != null ? stringObjectMap.get("f_rel_program").toString() : null);
            patrolPlan.setfName(stringObjectMap.get("f_name") != null ? stringObjectMap.get("f_name").toString() : null);
            patrolPlan.setfState(stringObjectMap.get("f_state") != null ? Integer.valueOf(stringObjectMap.get("f_state").toString()) : null);
            patrolPlan.setfCreatetime(stringObjectMap.get("f_createtime") != null ? (Date)stringObjectMap.get("f_createtime") : null);
            if (except != null && !except.contains("pname")) {
                patrolPlan.setProgramName(stringObjectMap.get("pname") != null ? stringObjectMap.get("pname").toString() : null);
            }
            if (stringObjectMap.containsKey("f_patrol_business") && stringObjectMap.get("f_patrol_business") != null) {
                TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(Long.valueOf(Long.parseLong(stringObjectMap.get("f_patrol_business").toString())));
                patrolPlan.setBusinessName(tbtskTaskClass.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)patrolPlan.getfRegioncode())) {
                patrolPlan.setfRegionname(this.regionService.getName(patrolPlan.getfRegioncode()));
            }
            list.add(patrolPlan);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)id);
        if (patrolPlan == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8ba1\u5212");
        }
        if (!patrolPlan.getfState().equals(0)) {
            throw new RuntimeException("\u975e\u62df\u4ef6\u72b6\u6001\u4efb\u52a1\u4e0d\u53ef\u5220\u9664");
        }
        this.patrolPlanAreaMapper.deleteByPlanId(id);
        this.patrolPlanContentMapper.deleteByPlanId(id);
        this.patrolPlanMapper.deleteByPrimaryKey((Object)id);
        List sourceids = this.patrolPlanScopeServiceMapper.findByPlanId(id).stream().map(r -> r.getfScopeid()).collect(Collectors.toList());
        if (!sourceids.isEmpty()) {
            this.patrolPlanScopeMapper.deleteByIds(sourceids);
        }
        this.patrolPlanScopeServiceMapper.deleteByPlanId(id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group", (Object)"patrol");
        jsonObject.put("type", (Object)"delete");
        jsonObject.put("operUserId", (Object)"101");
        jsonObject.put("planId", (Object)id);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void assignPlan(String id) {
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)id);
        if (patrolPlan == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8ba1\u5212");
        }
        if (patrolPlan.getfState().equals(1)) {
            throw new RuntimeException("\u4e0d\u53ef\u91cd\u590d\u4e0b\u53d1");
        }
        patrolPlan.setfState(Integer.valueOf(1));
        this.patrolPlanMapper.updateByPrimaryKey((Object)patrolPlan);
        if (patrolPlan.getfStarttime() != null && patrolPlan.getfEndtime() != null) {
            Date startDate = patrolPlan.getfStarttime();
            Date endDate = patrolPlan.getfEndtime();
            int count = 0;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            ArrayList<PatrolPlanTask> patrolPlanTasks = new ArrayList<PatrolPlanTask>();
            String name = "\u7b2c%s\u6b21\u5de1\u67e5\uff08" + patrolPlan.getfName() + "\uff09";
            SimpleDateFormat sf = null;
            String tempName = "";
            Date tempStart = null;
            Date tempEnd = null;
            Date now = new Date();
            if (patrolPlan.getfRate().equals("1")) {
                count = DateUtils.getDayCount((Date)endDate, (Date)startDate);
            } else if (patrolPlan.getfRate().equals("2")) {
                count = DateUtils.getWeekCount((Date)endDate, (Date)startDate);
            } else if (patrolPlan.getfRate().equals("3")) {
                count = DateUtils.getMonthCount((Date)endDate, (Date)startDate);
            } else if (patrolPlan.getfRate().equals("4")) {
                count = DateUtils.getYearCount((Date)endDate, (Date)startDate);
            }
            if (count > 366) {
                throw new RuntimeException("\u4efb\u52a1\u6570\u91cf\u8fc7\u591a");
            }
            for (int i = 0; i < count; ++i) {
                tempName = String.format(name, i + 1);
                if (patrolPlan.getfRate().equals("1")) {
                    sf = new SimpleDateFormat("yyyy-MM-dd");
                    tempStart = calendar.getTime();
                    tempEnd = DateUtils.getEndOfDay((Date)calendar.getTime());
                } else if (patrolPlan.getfRate().equals("2")) {
                    tempStart = DateUtils.getStartOfWeek((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfWeek((Date)calendar.getTime());
                    calendar.set(3, calendar.get(3) + 1);
                } else if (patrolPlan.getfRate().equals("3")) {
                    calendar.setTime(DateUtils.getStartOfMonth((Date)calendar.getTime()));
                    sf = new SimpleDateFormat("yyyy-MM");
                    tempStart = DateUtils.getStartOfMonth((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfMonth((Date)calendar.getTime());
                } else if (patrolPlan.getfRate().equals("4")) {
                    tempStart = DateUtils.getStartOfYear((Date)calendar.getTime());
                    tempEnd = DateUtils.getEndOfYear((Date)calendar.getTime());
                }
                PatrolPlanTask patrolPlanTask = new PatrolPlanTask();
                patrolPlanTask.setfCreatetime(now);
                patrolPlanTask.setfName(tempName);
                patrolPlanTask.setfId(UUID.randomUUID().toString());
                patrolPlanTask.setfStarttime(tempStart);
                patrolPlanTask.setfEndtime(tempEnd);
                patrolPlanTask.setfPlanid(id);
                this.updateState(patrolPlanTask, tempStart, tempEnd, now);
                patrolPlanTasks.add(patrolPlanTask);
                calendar.setTime(tempEnd);
                calendar.set(13, calendar.get(13) + 1);
                calendar.setTime(calendar.getTime());
            }
            if (!patrolPlanTasks.isEmpty()) {
                this.patrolPlanTaskMapper.insertList(patrolPlanTasks);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("group", (Object)"patrol");
                jsonObject.put("type", (Object)"insert");
                jsonObject.put("operUserId", (Object)"101");
                jsonObject.put("patrolPlan", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)patrolPlan, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
                jsonObject.put("patrolPlanTask", patrolPlanTasks);
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        this.innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        } else {
            throw new RuntimeException("\u65f6\u95f4\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
    }

    public boolean updateState(PatrolPlanTask patrolPlanTask, Date start, Date end, Date now) {
        boolean result = false;
        if (end.before(now)) {
            if (patrolPlanTask.getfState() != null) {
                result = !patrolPlanTask.getfState().equals(2);
            }
            patrolPlanTask.setfState(Integer.valueOf(2));
        } else if (end.after(now) && start.before(now)) {
            if (patrolPlanTask.getfState() != null) {
                result = !patrolPlanTask.getfState().equals(1);
            }
            patrolPlanTask.setfState(Integer.valueOf(1));
        } else if (start.after(now)) {
            if (patrolPlanTask.getfState() != null) {
                result = !patrolPlanTask.getfState().equals(0);
            }
            patrolPlanTask.setfState(Integer.valueOf(0));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void revoke(String id) {
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)id);
        if (patrolPlan == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8ba1\u5212");
        }
        if (patrolPlan.getfState().equals(0)) {
            throw new RuntimeException("\u672a\u4e0b\u53d1\u65e0\u9700\u64a4\u56de");
        }
        if (patrolPlan.getfState().equals(2)) {
            throw new RuntimeException("\u5df2\u7ed3\u675f\u65e0\u6cd5\u64a4\u56de");
        }
        PatrolProgram patrolProgram = (PatrolProgram)this.patrolProgramMapper.gwSearchByPK((Serializable)((Object)patrolPlan.getfRelprogram()));
        if (patrolProgram != null && StringUtils.isNotBlank((CharSequence)patrolProgram.getfPatrolBusiness())) {
            List<TskTaskBiz> tskTaskBizs = this.tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(patrolProgram.getfPatrolBusiness()));
            for (TskTaskBiz bean : tskTaskBizs) {
                TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.findById((Object)bean.getTableId()).orElse(null);
                String sql = "select count(1) from " + tableInfo.getfTablename() + " where f_jhid = '" + id + "'";
                Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
                if (count <= 0L) continue;
                throw new RuntimeException("\u5df2\u6709\u7ebf\u7d22\u65e0\u6cd5\u64a4\u56de");
            }
        }
        this.patrolPlanTaskMapper.deleteByPlanId(id);
        patrolPlan.setfState(Integer.valueOf(0));
        this.patrolPlanMapper.updateByPrimaryKey((Object)patrolPlan);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group", (Object)"patrol");
        jsonObject.put("type", (Object)"revoke");
        jsonObject.put("operUserId", (Object)"101");
        jsonObject.put("patrolPlan", (Object)patrolPlan);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void completePlanScopeList(JSONArray scoptArray, String planId, Long userId, List<PatrolPlanScope> scopes, List<PatrolPlanScopeService> scopeServices, List<PatrolPlanScopeKeyArea> scopeKeyAreas, List<PatrolPlanScopeOutService> scopeOutServices) throws ParseException {
        if (scoptArray != null && !scoptArray.isEmpty()) {
            for (int i = 0; i < scoptArray.size(); ++i) {
                JSONObject object1;
                JSONObject object = scoptArray.getJSONObject(i);
                if (object.get((Object)"fScope") == null || object.get((Object)"fDesc") == null) continue;
                PatrolPlanScope patrolPlanScope = new PatrolPlanScope();
                String scopeId = UUID.randomUUID().toString();
                patrolPlanScope.setfId(scopeId);
                patrolPlanScope.setfCreatetime(new Date());
                patrolPlanScope.setfScope(object.getString("fScope"));
                patrolPlanScope.setfDesc(object.getString("fDesc"));
                patrolPlanScope.setfUserid(userId);
                scopes.add(patrolPlanScope);
                if (object.get((Object)"fServiceIds") == null) {
                    object.put("fServiceIds", (Object)"");
                }
                String[] serviceIds = object.getString("fServiceIds").split(",");
                for (int j = 0; j < serviceIds.length; ++j) {
                    String id = serviceIds[j];
                    PatrolPlanScopeService patrolPlanScopeService = new PatrolPlanScopeService();
                    patrolPlanScopeService.setfId(UUID.randomUUID().toString());
                    patrolPlanScopeService.setfPlanid(planId);
                    patrolPlanScopeService.setfScopeid(scopeId);
                    patrolPlanScopeService.setfUserid(userId);
                    patrolPlanScopeService.setfServiceid(id);
                    scopeServices.add(patrolPlanScopeService);
                }
                if (object.get((Object)"fOutService") != null) {
                    JSONArray array = object.getJSONArray("fOutService");
                    for (int j = 0; j < array.size(); ++j) {
                        object1 = array.getJSONObject(j);
                        if (object1.get((Object)"name") == null || object1.get((Object)"url") == null) continue;
                        String name = object1.getString("name");
                        String url = object1.getString("url");
                        PatrolPlanScopeOutService patrolPlanScopeOutService = new PatrolPlanScopeOutService();
                        patrolPlanScopeOutService.setfId(UUID.randomUUID().toString());
                        patrolPlanScopeOutService.setfName(name);
                        patrolPlanScopeOutService.setfPlanid(planId);
                        patrolPlanScopeOutService.setfScopeid(scopeId);
                        patrolPlanScopeOutService.setfUrl(url);
                        scopeOutServices.add(patrolPlanScopeOutService);
                    }
                }
                if (object.get((Object)"keyArea") == null) continue;
                JSONArray array = object.getJSONArray("keyArea");
                for (int j = 0; j < array.size(); ++j) {
                    object1 = array.getJSONObject(j);
                    String wkt = object1.getString("wkt");
                    String area = object1.getString("area");
                    if (!StringUtils.isNotBlank((CharSequence)wkt)) continue;
                    Geometry geometry = WKTUtil.wktToGeom((String)wkt);
                    List regionVillages = this.regionVillageRepository.queryContains1(wkt);
                    PatrolPlanScopeKeyArea patrolPlanScopeKeyArea = new PatrolPlanScopeKeyArea();
                    patrolPlanScopeKeyArea.setfArea(area);
                    patrolPlanScopeKeyArea.setfId(UUID.randomUUID().toString());
                    patrolPlanScopeKeyArea.setfScopeid(scopeId);
                    patrolPlanScopeKeyArea.setfDkbh("ZD" + String.format("%04d", j));
                    patrolPlanScopeKeyArea.setfShape((Object)wkt);
                    patrolPlanScopeKeyArea.setfPlanid(planId);
                    if (!regionVillages.isEmpty()) {
                        patrolPlanScopeKeyArea.setfXzqdm(((RegionVillage)regionVillages.get(0)).getCode());
                        patrolPlanScopeKeyArea.setfXzqmc(((RegionVillage)regionVillages.get(0)).getName());
                    }
                    scopeKeyAreas.add(patrolPlanScopeKeyArea);
                }
            }
        }
    }

    private void savePlanContent(PatrolPlanInfo patrolPlanInfo, String planId, Long userId) {
        ArrayList<PatrolPlanContent> patrolPlanContents = new ArrayList<PatrolPlanContent>();
        JSONArray contentArray = patrolPlanInfo.getfContent();
        if (contentArray != null && !contentArray.isEmpty()) {
            for (int i = 0; i < contentArray.size(); ++i) {
                JSONObject object = contentArray.getJSONObject(i);
                String content = object.getString("fContent");
                String desc = object.getString("fDesc");
                PatrolPlanContent one = new PatrolPlanContent();
                one.setfId(UUID.randomUUID().toString());
                one.setfPlanid(planId);
                one.setfCreatetime(new Date());
                one.setfDesc(desc);
                one.setfContent(content);
                one.setfUserid(userId);
                patrolPlanContents.add(one);
            }
        }
        if (!patrolPlanContents.isEmpty()) {
            this.patrolPlanContentMapper.insertList(patrolPlanContents);
        }
    }
}

