/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.patrolclue.pub.impl;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.geoway.landteam.patrolclue.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.patrolclue.service.pub.impl.DataDownloadFieldService;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadService;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadServiceImpl;
import com.geoway.landteam.patrolclue.service.util.UuidUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MDownloadGeometryDailyClueBaseService
extends JcClueDownloadService {
    private final GiLoger logger = GwLoger.getLoger(JcClueDownloadServiceImpl.class);
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueSourceService jcClueSourceService;
    @Autowired
    JcClueFieldsService jcClueFieldsService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DataBizMapper dataBizMapper;
    private static final String TASK_CODE_DAILY_CLUE = "\u7ebf\u7d22\u6279\u6b21";
    protected String uploadDir = "d:/data/upload";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";

    List<Map> getSourceData(JcClueSource jcClueSource, List<String> queryFieldNames) {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (StringUtils.isNotBlank((CharSequence)this.downloadParameter.getTbIds())) {
            whereClause = whereClause + "d.f_id in ( '" + this.downloadParameter.getTbIds().replace(",", "','") + "' )";
        }
        tableName = jcClueSource.getfTablename() + " d ";
        return this.queryAllData(tableName, queryFieldNames, whereClause);
    }

    public List<Map> queryAllData(String tableName, List<String> fieldNameList, String where) {
        List list = this.dataBizMapper.queryAllData(tableName, fieldNameList, where);
        return list;
    }

    private void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull((Object)taskId, (String)"taskId can not be null");
        GutilAssert.notNull((Object)taskCode, (String)"taskCode can not be null");
        GutilAssert.notNull((Object)taskName, (String)"taskName can not be null");
        GutilAssert.notNull((Object)this.downloadRecord, (String)"downloadRecord can not be null");
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum, new Object[0]);
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 downloadRecord:" + this.downloadRecord.toString(), new Object[0]);
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        this.resultUrl = "";
    }

    public void doDownloadClue() throws Exception {
        this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
        JcClueImportRecord jcClueImportRecord = null;
        JcClueSource jcClueSource = null;
        List sourceFields = null;
        ArrayList<JcClueFields> exportFields = new ArrayList();
        ArrayList<String> queryFieldNames = new ArrayList<String>();
        try {
            boolean b = this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord);
            if (b) {
                return;
            }
            this.logger.info(this.getDescription() + " \u5f00\u59cb\u67e5\u8be2\u4efb\u52a1f_shape\u5b57\u6bb5\u6570\u636e", new Object[0]);
            jcClueImportRecord = this.jcClueImportRecordService.selectByPrimaryKey(this.downloadParameter.getTaskId());
            if (jcClueImportRecord != null && StringUtils.isNotBlank((CharSequence)jcClueImportRecord.getfSourceid())) {
                jcClueSource = this.jcClueSourceService.findOne(jcClueImportRecord.getfSourceid());
            }
            if (jcClueSource != null && StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                sourceFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (JcClueFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname()) || "f_shape_b".equalsIgnoreCase(field.getfFieldname()) || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) continue;
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (!this.isQueryGeoFields()) continue;
                        queryFieldNames.add("d." + field.getfFieldname());
                        continue;
                    }
                    queryFieldNames.add("d." + field.getfFieldname());
                }
                exportFields = DataDownloadFieldService.getExportFields((List)sourceFields);
            }
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = this.getSourceData(jcClueSource, queryFieldNames);
            if (sourceData != null) {
                safeFileName = sourceData.size() == 1 ? (sourceData.get(0).get("f_tbmc") != null && StringUtils.isNotBlank((CharSequence)sourceData.get(0).get("f_tbmc").toString()) ? jcClueImportRecord.getfName() + "(" + sourceData.get(0).get("f_tbmc").toString() + UuidUtil.get16UUID() + "\uff09" : jcClueImportRecord.getfName() + "(" + UuidUtil.get16UUID() + "\uff09") : jcClueImportRecord.getfName() + "(" + sourceData.size() + "\u4e2a)" + UuidUtil.get16UUID();
                String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                this.initParameter(jcClueImportRecord.getfId(), TASK_CODE_DAILY_CLUE, jcClueImportRecord.getfName(), "");
                this.downloadRecord.setName(jcClueImportRecord.getfName() + "(\u4e0b\u8f7d" + this.getDataType() + ")");
                this.exportAction(sourceData, tempFolderPath, exportFields);
                this.afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    List<String> getPropertyKeys(List<JcClueFields> exportFields) {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
            }
        }
        return propertyKeys;
    }

    Map<String, Object> getPropertyMap(Map map, List<JcClueFields> exportFields) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (map == null) {
            return resultMap;
        }
        String userName = "";
        String createtime = "";
        resultMap.put("taskId", this.taskId);
        resultMap.put("taskCode", this.taskCode);
        resultMap.put("taskName", this.taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");
        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                String translatedValue;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getfFieldtype()) || "taskId".equalsIgnoreCase(field.getfFieldname()) || "taskCode".equalsIgnoreCase(field.getfFieldname()) || "taskName".equalsIgnoreCase(field.getfFieldname()) || "f_shape".equalsIgnoreCase(field.getfFieldname())) continue;
                columnNmae = "f_" + field.getfFieldname();
                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (!map.containsKey("f_userid") || map.get("f_userid") == null) continue;
                    userName = this.userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    continue;
                }
                if ("f_createtime".equalsIgnoreCase(columnNmae) || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                        createtime = format.format(ts);
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                    }
                    catch (Exception e) {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                    }
                    continue;
                }
                if ("f_lon".equalsIgnoreCase(columnNmae) || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u6709");
                            continue;
                        }
                        if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u65e0");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u5f71\u50cf\u65e0\u623f";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "6": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "7": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "8": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e00\u81f4";
                                break;
                            }
                            case "9": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e0d\u4e00\u81f4";
                                break;
                            }
                            case "10": {
                                translatedValue = "\u672a\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62";
                                break;
                            }
                            case "11": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u519c\u6751\u5b85\u57fa\u5730";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u516c\u5171\u8bbe\u65bd\u519c\u7528\u5730";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u533b\u536b\u6148\u5584\u7528\u5730";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u79d1\u6559\u7528\u5730";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u4e2a\u4eba";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5355\u4f4d";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u662f");
                            continue;
                        }
                        if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u5426");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrqm".equalsIgnoreCase(columnNmae) || "f_dcrqm".equalsIgnoreCase(columnNmae) || "f_sign".equalsIgnoreCase(columnNmae) || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    continue;
                }
                resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
            }
        }
        return resultMap;
    }

    String getExportFileName(List<Map> sourceData, String folderPath) {
        if (sourceData == null || sourceData.size() == 0 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)folderPath)) {
            return "";
        }
        FileUtil.creatDirectoryIfNotExist((String)folderPath);
        String fileName = "";
        if (sourceData.size() == 1) {
            Map map = sourceData.get(0);
            if (map != null) {
                if (map.containsKey("f_tbmc") && map.get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbmc").toString())) {
                    fileName = map.get("f_tbmc").toString();
                } else if (map.containsKey("f_tbbh") && map.get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbbh").toString())) {
                    fileName = map.get("f_tbbh").toString();
                } else if (map.containsKey("f_id") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_id").toString())) {
                    fileName = map.get("f_id").toString();
                }
            }
        } else {
            fileName = sourceData.size() + "\u4e2a";
        }
        String targetFileName = folderPath + File.separator + this.taskName + "(" + fileName + ")" + this.getFileExtension();
        File file = new File(targetFileName);
        if (!file.exists()) {
            // empty if block
        }
        return targetFileName;
    }

    protected String getObsFolderPath() {
        return "dailyTask/download/" + this.getDataType();
    }

    abstract void exportAction(List<Map> var1, String var2, List<JcClueFields> var3) throws Exception;

    String getName(Map map) {
        if (map == null) {
            return "";
        }
        String result = "";
        if (map.containsKey("f_tbmc") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbmc").toString())) {
            result = map.get("f_tbmc").toString();
        } else if (map.containsKey("f_tbbh") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbbh").toString())) {
            result = map.get("f_tbbh").toString();
        } else if (map.containsKey("f_id") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_id").toString())) {
            result = map.get("f_id").toString();
        }
        return result;
    }

    abstract boolean isQueryGeoFields();
}

