/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.SQLInjectionUtil;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.entity.TbBusinessStatistics;
import com.geoway.landteam.landcloud.model.statistics.entity.TbZhddZdzbtj;
import com.geoway.landteam.landcloud.model.zhdd.dto.QuotaDataDto;
import com.geoway.landteam.landcloud.repository.pub.TbBusinessStatisticsRepository;
import com.geoway.landteam.landcloud.repository.pub.TbZhddZdzbtjRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskTaskClassService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueSourceMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BusinessStatisticsService {
    private final GiLoger logger = GwLoger.getLoger(BusinessStatisticsService.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    JcClueSourceMapper jcClueSourceMapper;
    @Autowired
    TbBusinessStatisticsRepository tbBusinessStatisticsRepository;
    @Autowired
    MTbtskTaskClassService mTbtskTaskClassService;
    @Autowired
    TbZhddZdzbtjRepository tbZhddZdzbtjRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TskTaskBizService tskTaskBizService;

    public List<Map<String, Object>> statisticsOverviewByRegion() {
        String sql = "select f_xzqdm,f_xzqmc,f_centerx,f_centery from tb_region where f_pcode = '130000'";
        List listRegions = this.jdbcTemplate.queryForList(sql);
        HashMap<String, Map> maps = new HashMap<String, Map>();
        if (listRegions != null && !listRegions.isEmpty()) {
            for (Map temp : listRegions) {
                HashMap<String, QuotaDataDto> totalMap = new HashMap<String, QuotaDataDto>();
                QuotaDataDto quotaDataDto = new QuotaDataDto();
                quotaDataDto.setCode("73");
                quotaDataDto.setName("\u571f\u5730\u536b\u7247\u6267\u6cd5");
                quotaDataDto.setCount(new BigDecimal(0));
                totalMap.put("73", quotaDataDto);
                QuotaDataDto quotaDataDto1 = new QuotaDataDto();
                quotaDataDto1.setCode("75");
                quotaDataDto1.setName("\u8015\u5730\u5360\u8865\u5e73\u8861");
                quotaDataDto1.setCount(new BigDecimal(0));
                totalMap.put("75", quotaDataDto1);
                QuotaDataDto quotaDataDto2 = new QuotaDataDto();
                quotaDataDto2.setCode("76");
                quotaDataDto2.setName("\u519c\u6751\u65b0\u5efa\u4f4f\u623f\u8c03\u67e5");
                quotaDataDto2.setCount(new BigDecimal(0));
                totalMap.put("76", quotaDataDto2);
                temp.put("data", totalMap);
                maps.put(temp.get("f_xzqdm").toString(), temp);
            }
            String sql2 = "WITH RECURSIVE class_hierarchy AS (\n    SELECT c.f_id, c.f_parentid, c.f_id AS root_id\n    FROM tbtsk_task_class c\n    WHERE c.f_id IN (73,75,76) \n    UNION ALL\n    SELECT c.f_id, c.f_parentid, ch.root_id\n    FROM tbtsk_task_class c\n    INNER JOIN class_hierarchy ch ON ch.f_id = c.f_parentid\n)\nSELECT \n    ch.root_id AS f_id,\n    b.city,\n    tcn.f_name,\n    SUM(b.f_tbcount) AS total_count\nFROM class_hierarchy ch\nLEFT JOIN \n(select left(s.f_xzqdm,4)||'00' as city,s.f_tbcount, CAST(s.f_classid AS INTEGER) as id from tbtsk_task_statis s) b ON b.id = ch.f_id \nLEFT JOIN tbtsk_task_class tcn ON ch.root_id = tcn.f_id\nGROUP BY b.city,ch.root_id, tcn.f_name\nORDER BY total_count desc";
            List listCount = this.jdbcTemplate.queryForList(sql2);
            if (listCount != null && !listCount.isEmpty()) {
                for (Map temp : listCount) {
                    String cityCode = String.valueOf(temp.get("city"));
                    if (!maps.containsKey(cityCode)) continue;
                    Map regionData = (Map)maps.get(cityCode);
                    String classId = String.valueOf(temp.get("f_id"));
                    Map data = (Map)regionData.get("data");
                    if (!data.containsKey(classId)) continue;
                    QuotaDataDto quotaDataDto = (QuotaDataDto)data.get(classId);
                    BigDecimal count = (BigDecimal)temp.get("total_count");
                    quotaDataDto.setCount(count);
                }
            }
        }
        return listRegions;
    }

    public JSONObject getClueStatisticalByDay(String appsId) {
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, appsId);
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for (JcClueSource jcClueSource : list) {
            if (jcClueSource.getfTablename() == null) continue;
            String startOfDay = BusinessStatisticsService.getStartOfDay(null);
            String endOfDay = BusinessStatisticsService.getEndOfDay(null);
            String monthsql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " where f_createtime between '" + BusinessStatisticsService.converTime(startOfDay) + "' and '" + BusinessStatisticsService.converTime(endOfDay) + "' group by f_status";
            List map2s = this.jdbcTemplate.queryForList(monthsql);
            for (Map map1 : map2s) {
                if (map1.get("f_status") != null && map1.get("f_status").toString().equals("0")) {
                    untreatedNum = untreatedNum + Integer.valueOf(map1.get("count").toString());
                    continue;
                }
                handleNum = handleNum + Integer.valueOf(map1.get("count").toString());
            }
        }
        object.put("handleNum", (Object)handleNum);
        object.put("untreatedNum", (Object)untreatedNum);
        object.put("totalNum", (Object)(handleNum + untreatedNum));
        object.put("name", (Object)"\u603b\u8ba1");
        return object;
    }

    public Map<String, Object> getTaskAllCount(Long userId, String appsId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("taskAllCount", 0);
        String sql = "select count(1) from tbtsk_task_class ttc inner join tbtsk_task_biz ttb on (ttc.f_id = ttb.f_classid) where \n ttb.f_isdel is null and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW') ";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            sql = sql + " and ttc.f_appkey ='" + appsId + "'";
        }
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        resultMap.put("taskAllCount", count);
        return resultMap;
    }

    public Map<String, Object> getTaskCountByDay(Long userId, String appsId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int taskTBAllCount = 0;
        int taskTBCountDay = 0;
        String sql = "select\n ttc.f_id ,ttc.f_name ,ttb.f_id ,to2.f_tablename \nfrom\n tbtsk_task_class ttc\ninner join tbtsk_task_biz ttb on (ttc.f_id = ttb.f_classid)\ninner join tbtsk_objectinfo to2   on (to2.f_id = ttb.f_tableid)\nwhere\n ttb.f_isdel is null\n and (ttc.f_appkey is not null and ttc.f_appkey != 'XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            sql = sql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(sql);
        String startOfDay = BusinessStatisticsService.getStartOfDay(null);
        String endOfDay = BusinessStatisticsService.getEndOfDay(null);
        for (Map map1 : taskClassmap) {
            if (map1.get("f_tablename") == null) continue;
            String f_tablename = map1.get("f_tablename").toString();
            String allcount = " select count(1) from " + f_tablename;
            String daycount = "select count(1) from " + f_tablename + " where f_createtime between '" + BusinessStatisticsService.converTime(startOfDay) + "' and '" + BusinessStatisticsService.converTime(endOfDay) + "'";
            taskTBAllCount += ((Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class)).intValue();
            taskTBCountDay += ((Integer)this.jdbcTemplate.queryForObject(daycount, Integer.class)).intValue();
        }
        resultMap.put("taskTBAllCount", taskTBAllCount);
        resultMap.put("taskTBCountDay", taskTBCountDay);
        return resultMap;
    }

    public List<Map<String, Object>> getTaskTBCountByClass(Long userId, String appsId) {
        ArrayList resultMap = new ArrayList();
        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            taskClassSql = taskClassSql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(taskClassSql);
        for (Map map1 : taskClassmap) {
            if (map1.get("f_id") == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String classId = map1.get("f_id").toString();
            String className = map1.get("f_name").toString();
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(classId));
            int taskTBCount = 0;
            map.put("classId", classId);
            map.put("className", className);
            map.put("taskTBCount", taskTBCount);
            this.mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId), classIds);
            String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
            List taskMap = this.jdbcTemplate.queryForList(taskSql);
            for (Map map2 : taskMap) {
                String f_tablename;
                if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
                String allcount = " select count(1) from " + f_tablename;
                taskTBCount += ((Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class)).intValue();
            }
            map.put("taskTBCount", taskTBCount);
            resultMap.add(map);
        }
        List<Map<String, Object>> list = resultMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("taskTBCount"), (Integer)e2.get("taskTBCount"))).collect(Collectors.toList());
        return list;
    }

    public Map<String, Object> getUserCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int userAllCount = 0;
        int userCurrenWeekCount = 0;
        String userSql = " select count(1) from tbsys_user tu";
        Integer userCount = (Integer)this.jdbcTemplate.queryForObject(userSql, Integer.class);
        userAllCount = userCount;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String sql = "select count(1) from tbsys_user tu where f_create_date  between  '" + startOfWeek + "' and '" + endOfWeek + "'";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        userCurrenWeekCount = count;
        resultMap.put("userAllCount", userAllCount);
        resultMap.put("userCurrenWeekCount", userCurrenWeekCount);
        return resultMap;
    }

    public List<Map<String, Object>> getUserorganizationCountByCurrenWeek() {
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String userorganizationSql = " select f_type,count(1) from uis_organization uo , uis_userorganization uu, tbsys_user tu where uo.f_id  = uu.f_organizationid  and uu.f_userid  = tu.f_userid  group by f_type";
        List maps = this.jdbcTemplate.queryForList(userorganizationSql);
        for (Map map : maps) {
            String f_type;
            map.put("userOrganizationWeekCount", 0);
            if (map.get("f_type") == null || !StringUtils.isNotBlank((CharSequence)(f_type = map.get("f_type").toString()))) continue;
            String weekCount = " select count(1) from uis_organization uo , uis_userorganization uu, tbsys_user tu where uo.f_id  = uu.f_organizationid  and uu.f_userid  = tu.f_userid and uo.f_type='" + f_type + "' and tu.f_create_date  between  '" + startOfWeek + "' and '" + endOfWeek + "' ";
            Integer count = (Integer)this.jdbcTemplate.queryForObject(weekCount, Integer.class);
            map.put("userOrganizationWeekCount", count);
        }
        return maps;
    }

    public Map<String, Object> getUserTaskClass() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String XCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where f_appkey  ='XCYW' and f_parentid  ='-1'";
        List taskClassmap = this.jdbcTemplate.queryForList(XCYWSql);
        resultMap.put("XCYWTaskClassmap", this.handlyMap(taskClassmap));
        String HCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where  f_parentid  ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        List taskClassmap1 = this.jdbcTemplate.queryForList(HCYWSql);
        resultMap.put("HCYWTaskClassmap", this.handlyMap(taskClassmap1));
        return resultMap;
    }

    public List<Map<String, Object>> handlyMap(List<Map<String, Object>> taskClassmap) {
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        for (Map<String, Object> map1 : taskClassmap) {
            if (map1.get("f_id") == null) continue;
            String classId = map1.get("f_id").toString();
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(classId));
            this.mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId), classIds);
            String userClassCountsql = " select count(1) from tbtsk_user_task_class tutc  where f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
            String currenUserClassCountsql = " select count(1) from tbtsk_user_task_class tutc  where tutc.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ") and  tutc.f_createdate  between  '" + startOfWeek + "' and '" + endOfWeek + "' ";
            Integer userClassCount = (Integer)this.jdbcTemplate.queryForObject(userClassCountsql, Integer.class);
            Integer weekUserClassCount = (Integer)this.jdbcTemplate.queryForObject(currenUserClassCountsql, Integer.class);
            map1.put("userClassCount", userClassCount);
            map1.put("weekUserClassCount", weekUserClassCount);
        }
        List<Map<String, Object>> list = taskClassmap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("userClassCount"), (Integer)e2.get("userClassCount"))).collect(Collectors.toList());
        return list;
    }

    public List<Map<String, Object>> handlyTaskClassMap(List<Map<String, Object>> taskClassmap) {
        Calendar cal = Calendar.getInstance();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        for (Map<String, Object> map1 : taskClassmap) {
            if (map1.get("f_id") == null) continue;
            String classId = map1.get("f_id").toString();
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(classId));
            this.mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId), classIds);
            String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
            List taskMap = this.jdbcTemplate.queryForList(taskSql);
            map1.put("taskCount", taskMap.size());
            String taskWeekSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ") and ttb.f_createtime  between '" + monthstart + "' and '" + monthend + "' ";
            List taskWeekMap = this.jdbcTemplate.queryForList(taskWeekSql);
            map1.put("taskMonthCount", taskWeekMap.size());
            int taskTBAllCount = 0;
            int taskTBMonthCount = 0;
            int taskMedTpNum = 0;
            int taskMedSpNum = 0;
            for (Map map2 : taskMap) {
                String medCount;
                List medCountmap;
                if (map2.get("f_tablename") == null) continue;
                String f_tablename = map2.get("f_tablename").toString();
                String f_id = map2.get("f_id").toString();
                if (StringUtils.isNotBlank((CharSequence)f_tablename)) {
                    String allcount = " select count(1) from " + f_tablename;
                    String weekCount = " select count(1) from " + f_tablename + " where f_createtime  between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "'";
                    taskTBAllCount += ((Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class)).intValue();
                    taskTBMonthCount += ((Integer)this.jdbcTemplate.queryForObject(weekCount, Integer.class)).intValue();
                }
                if ((medCountmap = this.jdbcTemplate.queryForList(medCount = " select f_type,count(1) from tb_app_media tam  where f_bizid  ='" + f_id + "' group by f_type having f_type in (1,2); ")).size() <= 0) continue;
                for (Map medmap : medCountmap) {
                    if (medmap.get("f_type") != null && medmap.get("f_type").toString().equals("1")) {
                        taskMedTpNum += Integer.valueOf(medmap.get("count").toString()).intValue();
                        continue;
                    }
                    taskMedSpNum += Integer.valueOf(medmap.get("count").toString()).intValue();
                }
            }
            map1.put("taskTBAllCount", taskTBAllCount);
            map1.put("taskTBWeekCount", taskTBMonthCount);
            map1.put("taskMedTpNum", taskMedTpNum);
            map1.put("taskMedSpNum", taskMedSpNum);
        }
        List<Map<String, Object>> list = taskClassmap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("taskCount"), (Integer)e2.get("taskCount"))).collect(Collectors.toList());
        return list;
    }

    public Map<String, Object> getClueCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer clueAllCount = 0;
        Integer clueWeekCount = 0;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countsql = "select count(1) from " + s;
                String weekCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(startOfWeek) + "' and '" + BusinessStatisticsService.converTime(endOfWeek) + "'";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
                Integer weekCount = (Integer)this.jdbcTemplate.queryForObject(weekCountsql, Integer.class);
                clueAllCount = clueAllCount + count;
                clueWeekCount = clueWeekCount + weekCount;
            }
        }
        resultMap.put("clueAllCount", clueAllCount);
        resultMap.put("clueWeekCount", clueWeekCount);
        return resultMap;
    }

    public Map<String, Object> getClueCountByDate() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countsql = "select count(1) from " + s;
                String yearCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
                String quarterCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(quarterStartTime) + "' and '" + BusinessStatisticsService.converTime(quarterEndTime) + "'";
                String monthCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "'";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
                Integer yearCount = (Integer)this.jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                Integer quarterCount = (Integer)this.jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                Integer monthCount = (Integer)this.jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                clueAllCount = clueAllCount + count;
                clueYearCount = clueYearCount + yearCount;
                clueQuarterCount = clueQuarterCount + quarterCount;
                clueMonthCount = clueMonthCount + monthCount;
            }
        }
        resultMap.put("clueAllCount", clueAllCount);
        resultMap.put("clueYearCount", clueYearCount);
        resultMap.put("clueQuarterCount", clueQuarterCount);
        resultMap.put("clueMonthCount", clueMonthCount);
        return resultMap;
    }

    public Map<String, Object> getAllClueCountAndMj() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countAndMjsql = "select count(1), sum(f_area) from " + s;
                List maps = this.jdbcTemplate.queryForList(countAndMjsql);
                int count = 0;
                double sum = 0.0;
                if (maps != null && maps.size() > 0) {
                    Map map = (Map)maps.get(0);
                    count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                    sum = map.get("sum") == null ? 0.0 : Double.parseDouble(map.get("sum").toString());
                }
                clueAllCount = clueAllCount + count;
                clueAllMj += sum;
            }
        }
        resultMap.put("count", clueAllCount);
        resultMap.put("mj", new BigDecimal(clueAllMj).setScale(2, 4));
        return resultMap;
    }

    public Map<String, Object> getClueMergestatusCountByDate() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countsql = "select count(1) from " + s + " where f_mergestatus ='1'";
                String yearCountsql = "select count(1) from " + s + " where f_mergestatus ='1' and f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
                String quarterCountsql = "select count(1) from " + s + " where f_mergestatus ='1' and f_createtime between '" + BusinessStatisticsService.converTime(quarterStartTime) + "' and '" + BusinessStatisticsService.converTime(quarterEndTime) + "'";
                String monthCountsql = "select count(1) from " + s + " where f_mergestatus ='1' and f_createtime between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "'";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
                Integer yearCount = (Integer)this.jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                Integer quarterCount = (Integer)this.jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                Integer monthCount = (Integer)this.jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                clueAllCount = clueAllCount + count;
                clueYearCount = clueYearCount + yearCount;
                clueQuarterCount = clueQuarterCount + quarterCount;
                clueMonthCount = clueMonthCount + monthCount;
            }
        }
        resultMap.put("clueAllCount", clueAllCount);
        resultMap.put("clueYearCount", clueYearCount);
        resultMap.put("clueQuarterCount", clueQuarterCount);
        resultMap.put("clueMonthCount", clueMonthCount);
        return resultMap;
    }

    public Map<String, Object> getClueMergestatusCountAndMj() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                try {
                    String countAndMjsql = "select count(1), sum(f_area) from " + s + " where f_mergestatus ='1'";
                    List maps = this.jdbcTemplate.queryForList(countAndMjsql);
                    int count = 0;
                    double sum = 0.0;
                    if (maps != null && maps.size() > 0) {
                        Map map = (Map)maps.get(0);
                        count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                        sum = map.get("sum") == null ? 0.0 : Double.parseDouble(map.get("sum").toString());
                    }
                    clueAllCount = clueAllCount + count;
                    clueAllMj += sum;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        resultMap.put("count", clueAllCount);
        resultMap.put("mj", clueAllMj);
        return resultMap;
    }

    public Map<String, Object> getTSYYClueCountByDate(String sourceId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List list = this.jcClueSourceMapper.getCuleBysourceids(sourceIds);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countsql = "select count(1) from " + s;
                String yearCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
                String quarterCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(quarterStartTime) + "' and '" + BusinessStatisticsService.converTime(quarterEndTime) + "'";
                String monthCountsql = "select count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "'";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
                Integer yearCount = (Integer)this.jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                Integer quarterCount = (Integer)this.jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                Integer monthCount = (Integer)this.jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                clueAllCount = clueAllCount + count;
                clueYearCount = clueYearCount + yearCount;
                clueQuarterCount = clueQuarterCount + quarterCount;
                clueMonthCount = clueMonthCount + monthCount;
            }
        }
        resultMap.put("clueAllCount", clueAllCount);
        resultMap.put("clueYearCount", clueYearCount);
        resultMap.put("clueQuarterCount", clueQuarterCount);
        resultMap.put("clueMonthCount", clueMonthCount);
        return resultMap;
    }

    public Map<String, Object> getTSYYClueCountAndMj(String sourceId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List list = this.jcClueSourceMapper.getCuleBysourceids(sourceIds);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String countAndMjsql = "select count(1), sum(f_area) from " + s;
                List maps = this.jdbcTemplate.queryForList(countAndMjsql);
                int count = 0;
                double sum = 0.0;
                if (maps != null && maps.size() > 0) {
                    Map map = (Map)maps.get(0);
                    count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                    sum = map.get("sum") == null ? 0.0 : Double.parseDouble(map.get("sum").toString());
                }
                clueAllCount = clueAllCount + count;
                clueAllMj += sum;
            }
        }
        resultMap.put("count", clueAllCount);
        resultMap.put("mj", clueAllMj);
        return resultMap;
    }

    public Map<String, Object> getClueTypeByDate() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        resultMap.put("clueAllCount", list.size());
        resultMap.put("clueYearCount", list.size());
        resultMap.put("clueQuarterCount", list.size());
        resultMap.put("clueMonthCount", list.size());
        return resultMap;
    }

    public Map<String, Object> getClueXzqdmCountByDate() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> allResultMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> yearResultMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> quarterResultMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> monthResultMap = new ArrayList<Map<String, Object>>();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_level =2)";
                String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,4)||'00' as xzqdm,count(1) from " + s + "  ";
                String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List Allmaps = this.jdbcTemplate.queryForList(sql);
                allResultMap.addAll(Allmaps);
                String yearSql = Asql + Bsql + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List yearmaps = this.jdbcTemplate.queryForList(yearSql);
                yearResultMap.addAll(yearmaps);
                String quarterSql = Asql + Bsql + " where f_createtime between '" + BusinessStatisticsService.converTime(quarterStartTime) + "' and '" + BusinessStatisticsService.converTime(quarterEndTime) + "' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List quartermaps = this.jdbcTemplate.queryForList(quarterSql);
                quarterResultMap.addAll(quartermaps);
                String monthSql = Asql + Bsql + " where f_createtime between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List monthmaps = this.jdbcTemplate.queryForList(monthSql);
                monthResultMap.addAll(monthmaps);
            }
        }
        List<Map<String, Object>> allMap = BusinessStatisticsService.removeRepeatMapByKey(allResultMap, "f_xzqdm");
        List<Map<String, Object>> yearMap = BusinessStatisticsService.removeRepeatMapByKey(yearResultMap, "f_xzqdm");
        List<Map<String, Object>> quarterMap = BusinessStatisticsService.removeRepeatMapByKey(quarterResultMap, "f_xzqdm");
        List<Map<String, Object>> monthMap = BusinessStatisticsService.removeRepeatMapByKey(monthResultMap, "f_xzqdm");
        resultMap.put("allMap", allMap);
        resultMap.put("yearMap", yearMap);
        resultMap.put("quarterMap", quarterMap);
        resultMap.put("monthMap", monthMap);
        return resultMap;
    }

    public Map<String, Object> getClueStatusCountByDate() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String quarterStartTime = BusinessStatisticsService.getCurrentQuarterStartTime();
        String quarterEndTime = BusinessStatisticsService.getCurrentQuarterEndTime();
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        JSONArray allArray = new JSONArray();
        JSONArray yearArray = new JSONArray();
        JSONArray quarterArray = new JSONArray();
        JSONArray monthArray = new JSONArray();
        for (JcClueSource jcClueSource : list) {
            JSONObject allObject = new JSONObject();
            allObject.put("sourceName", (Object)jcClueSource.getfName());
            allObject.put("sourceId", (Object)jcClueSource.getfId());
            allObject.put("untreatedNum", (Object)0);
            allObject.put("handleNum", (Object)0);
            allObject.put("totalNum", (Object)0);
            JSONObject yearObject = new JSONObject();
            yearObject.put("sourceName", (Object)jcClueSource.getfName());
            yearObject.put("sourceId", (Object)jcClueSource.getfId());
            yearObject.put("untreatedNum", (Object)0);
            yearObject.put("handleNum", (Object)0);
            yearObject.put("totalNum", (Object)0);
            JSONObject quarterObject = new JSONObject();
            quarterObject.put("sourceName", (Object)jcClueSource.getfName());
            quarterObject.put("sourceId", (Object)jcClueSource.getfId());
            quarterObject.put("untreatedNum", (Object)0);
            quarterObject.put("handleNum", (Object)0);
            quarterObject.put("totalNum", (Object)0);
            JSONObject monthObject = new JSONObject();
            monthObject.put("sourceName", (Object)jcClueSource.getfName());
            monthObject.put("sourceId", (Object)jcClueSource.getfId());
            monthObject.put("untreatedNum", (Object)0);
            monthObject.put("handleNum", (Object)0);
            monthObject.put("totalNum", (Object)0);
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String sql = "select f_status,count(1) from " + s + " group by f_status";
                    List Allmaps = this.jdbcTemplate.queryForList(sql);
                    for (Map map : Allmaps) {
                        if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                            allObject.put("untreatedNum", (Object)(allObject.getInteger("untreatedNum") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        allObject.put("handleNum", (Object)(allObject.getInteger("handleNum") + Integer.valueOf(map.get("count").toString())));
                    }
                    String yearSql = "select f_status,count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'  group by f_status ";
                    List yearmaps = this.jdbcTemplate.queryForList(yearSql);
                    for (Map map : yearmaps) {
                        if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                            yearObject.put("untreatedNum", (Object)(yearObject.getInteger("untreatedNum") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        yearObject.put("handleNum", (Object)(yearObject.getInteger("handleNum") + Integer.valueOf(map.get("count").toString())));
                    }
                    String quarterSql = "select f_status,count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(quarterStartTime) + "' and '" + BusinessStatisticsService.converTime(quarterEndTime) + "'  group by f_status ";
                    List quartermaps = this.jdbcTemplate.queryForList(quarterSql);
                    for (Map map : quartermaps) {
                        if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                            quarterObject.put("untreatedNum", (Object)(quarterObject.getInteger("untreatedNum") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        quarterObject.put("handleNum", (Object)(quarterObject.getInteger("handleNum") + Integer.valueOf(map.get("count").toString())));
                    }
                    String monthSql = "select f_status,count(1) from " + s + " where f_createtime between '" + BusinessStatisticsService.converTime(monthstart) + "' and '" + BusinessStatisticsService.converTime(monthend) + "'  group by f_status ";
                    List monthmaps = this.jdbcTemplate.queryForList(monthSql);
                    for (Map map : monthmaps) {
                        if (map.get("f_status") != null && map.get("f_status").toString().equals("0")) {
                            monthObject.put("untreatedNum", (Object)(monthObject.getInteger("untreatedNum") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        monthObject.put("handleNum", (Object)(monthObject.getInteger("handleNum") + Integer.valueOf(map.get("count").toString())));
                    }
                }
            }
            allObject.put("totalNum", (Object)(Integer.valueOf(allObject.get((Object)"handleNum").toString()) + Integer.valueOf(allObject.get((Object)"untreatedNum").toString())));
            allArray.add((Object)allObject);
            yearObject.put("totalNum", (Object)(Integer.valueOf(yearObject.get((Object)"handleNum").toString()) + Integer.valueOf(yearObject.get((Object)"untreatedNum").toString())));
            yearArray.add((Object)yearObject);
            quarterObject.put("totalNum", (Object)(Integer.valueOf(quarterObject.get((Object)"handleNum").toString()) + Integer.valueOf(quarterObject.get((Object)"untreatedNum").toString())));
            quarterArray.add((Object)quarterObject);
            monthObject.put("totalNum", (Object)(Integer.valueOf(monthObject.get((Object)"handleNum").toString()) + Integer.valueOf(monthObject.get((Object)"untreatedNum").toString())));
            monthArray.add((Object)monthObject);
        }
        resultMap.put("allMap", allArray);
        resultMap.put("yearMap", yearArray);
        resultMap.put("quarterMap", quarterArray);
        resultMap.put("monthMap", monthArray);
        return resultMap;
    }

    public Map<String, Object> getTaskCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskAllCount = 0;
        Integer taskWeekCount = 0;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String taskSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null";
        String taskWeekSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null and f_createtime  between  '" + startOfWeek + "' and '" + endOfWeek + "' ";
        taskAllCount = (Integer)this.jdbcTemplate.queryForObject(taskSql, Integer.class);
        taskWeekCount = (Integer)this.jdbcTemplate.queryForObject(taskWeekSql, Integer.class);
        resultMap.put("taskAllCount", taskAllCount);
        resultMap.put("taskWeekCount", taskWeekCount);
        return resultMap;
    }

    public Map<String, Object> getTaskTBCountByBranch(String branch) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskTBAllCount = 0;
        Integer taskTBFinishCount = 0;
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        if (StringUtils.isNotBlank((CharSequence)branch) && branch.equals("XCYW")) {
            taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2,tbtsk_task_class ttc  where ttb.f_tableid  = to2.f_id and ttc.f_id = ttb.f_classid  and ( ttc.f_appkey ='XCYW' ) and ttb.f_isdel  is null and to2.f_tablename is not null;";
        } else if (StringUtils.isNotBlank((CharSequence)branch) && branch.equals("HCYW")) {
            taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2,tbtsk_task_class ttc  where ttb.f_tableid  = to2.f_id and ttc.f_id = ttb.f_classid  and ( ttc.f_appkey !='XCYW' or ttc.f_appkey is null) and ttb.f_isdel  is null and to2.f_tablename is not null";
        }
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String allcount = " select count(1) from " + f_tablename;
            String finishCount = " select count(1) from " + f_tablename + " where f_review_stage ='101' ";
            taskTBAllCount = taskTBAllCount + (Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class);
            taskTBFinishCount = taskTBFinishCount + (Integer)this.jdbcTemplate.queryForObject(finishCount, Integer.class);
        }
        resultMap.put("taskTBAllCount", taskTBAllCount);
        resultMap.put("taskTBFinishCount", taskTBFinishCount);
        return resultMap;
    }

    public Map<String, Object> getTaskTBCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskTBAllCount = 0;
        Integer taskTBWeekCount = 0;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String allcount = " select count(1) from " + f_tablename;
            String weekCount = " select count(1) from " + f_tablename + " where f_createtime  between '" + BusinessStatisticsService.converTime(startOfWeek) + "' and '" + BusinessStatisticsService.converTime(endOfWeek) + "'";
            taskTBAllCount = taskTBAllCount + (Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class);
            taskTBWeekCount = taskTBWeekCount + (Integer)this.jdbcTemplate.queryForObject(weekCount, Integer.class);
        }
        resultMap.put("taskTBAllCount", taskTBAllCount);
        resultMap.put("taskTBWeekCount", taskTBWeekCount);
        return resultMap;
    }

    public Map<String, Object> getTaskMediaCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskMediaAllCount = 0;
        Integer taskMediaWeekCount = 0;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String taskSql = "select count(1) from tb_app_media ";
        String taskWeekSql = "select count(1) from tb_app_media  where f_time  between '" + BusinessStatisticsService.converTime(startOfWeek) + "' and '" + BusinessStatisticsService.converTime(endOfWeek) + "'";
        taskMediaAllCount = (Integer)this.jdbcTemplate.queryForObject(taskSql, Integer.class);
        taskMediaWeekCount = (Integer)this.jdbcTemplate.queryForObject(taskWeekSql, Integer.class);
        resultMap.put("taskMediaAllCount", taskMediaAllCount);
        resultMap.put("taskMediaWeekCount", taskMediaWeekCount);
        return resultMap;
    }

    public Map<String, Object> getDroneLiveCount() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer droneLiveCount = 0;
        Integer droneDevicCount = 0;
        String sql = "select count(1) from tb_drone_live_channel";
        droneLiveCount = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        Date timeFilter = DateUtils.addSeconds((Date)new Date(), (int)-300);
        SimpleDateFormat pattern = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String droneDevicsql = "select count(distinct (f_sn)) from  tb_drone_devicetrack where f_updatetime  >='" + pattern.format(timeFilter) + "'";
        droneDevicCount = (Integer)this.jdbcTemplate.queryForObject(droneDevicsql, Integer.class);
        resultMap.put("droneLiveCount", droneLiveCount);
        resultMap.put("droneDevicCount", droneDevicCount);
        return resultMap;
    }

    public Map<String, Object> getDroneMediaCount() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer droneMediaAllCount = 0;
        String taskSql = "select count(1) from tb_app_media tam  where f_device_source  ='1'";
        droneMediaAllCount = (Integer)this.jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("droneMediaAllCount", droneMediaAllCount);
        resultMap.put("droneAllArea", 10346.56);
        return resultMap;
    }

    public Map<String, Object> getTaskRelevanceDataCount() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskMediaAllCount = 0;
        Integer taskAllCount = 0;
        Integer taskTBAllCount = 0;
        Integer taskUserCount = 0;
        String taskUserSql = "select  count(distinct(f_userid)) from tbsys_user_biz2 ";
        taskUserCount = (Integer)this.jdbcTemplate.queryForObject(taskUserSql, Integer.class);
        resultMap.put("taskUserCount", taskUserCount);
        String taskmedisSql = "select count(1) from tb_app_media ";
        taskMediaAllCount = (Integer)this.jdbcTemplate.queryForObject(taskmedisSql, Integer.class);
        resultMap.put("taskMediaAllCount", taskMediaAllCount);
        String taskSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null";
        taskAllCount = (Integer)this.jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("taskAllCount", taskAllCount);
        String taskTbSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        List taskMap = this.jdbcTemplate.queryForList(taskTbSql);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String allcount = " select count(1) from " + f_tablename;
            taskTBAllCount = taskTBAllCount + (Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class);
        }
        resultMap.put("taskTBAllCount", taskTBAllCount);
        return resultMap;
    }

    public Map<String, Object> getTaskDataCountByUser(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer taskMediaAllCount = 0;
        Integer taskTBAllCount = 0;
        Integer taskUserCount = 0;
        String taskUserSql = "select count(distinct f_bizid) from tbsys_user_biz2 tub  where f_userid ='" + userId + "' ";
        taskUserCount = (Integer)this.jdbcTemplate.queryForObject(taskUserSql, Integer.class);
        resultMap.put("taskUserCount", taskUserCount);
        String taskmedisSql = "select  count(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='" + userId + "' ";
        taskMediaAllCount = (Integer)this.jdbcTemplate.queryForObject(taskmedisSql, Integer.class);
        resultMap.put("taskMediaAllCount", taskMediaAllCount);
        String taskSql = "select  count(distinct f_dataid) from tbtsk_assign_record tar  where f_assignto ='" + userId + "'";
        taskTBAllCount = (Integer)this.jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("taskTBCount", taskTBAllCount);
        HashMap<String, List> medDetailsMap = new HashMap<String, List>();
        String daySql = "select \n          to_char(to_timestamp(TO_NUMBER(SUBSTR(tam.f_time, 0,11), '9999999999')),'yyyy-MM-dd') fTime,COUNT(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='" + userId + "' group by fTime  order by  fTime";
        List daylist = this.jdbcTemplate.queryForList(daySql);
        medDetailsMap.put("daylist", daylist);
        String monthSql = "select \n          to_char(to_timestamp(TO_NUMBER(SUBSTR(tam.f_time, 0,11), '9999999999')),'yyyy-MM') fTime,COUNT(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='" + userId + "' group by fTime  order by  fTime";
        List monthlist = this.jdbcTemplate.queryForList(monthSql);
        medDetailsMap.put("monthlist", monthlist);
        resultMap.put("medDetailsMap", medDetailsMap);
        return resultMap;
    }

    public Map<String, Object> getCloudQueryCountByCurrenWeek() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer cloudQueryAllCount = 0;
        Integer cloudQueryWeekCount = 0;
        String startOfWeek = BusinessStatisticsService.getCurrentWeekStartStartTime();
        String endOfWeek = BusinessStatisticsService.getCurrentWeekStartEndTime();
        String cloudQuerySql = "select count(1) from tb_cloud_query ";
        String cloudQueryWeekSql = "select count(1) from tb_cloud_query  where f_querytime  between  '" + startOfWeek + "' and '" + endOfWeek + "' ";
        cloudQueryAllCount = (Integer)this.jdbcTemplate.queryForObject(cloudQuerySql, Integer.class);
        cloudQueryWeekCount = (Integer)this.jdbcTemplate.queryForObject(cloudQueryWeekSql, Integer.class);
        resultMap.put("cloudQueryAllCount", cloudQueryAllCount);
        resultMap.put("cloudQueryWeekCount", cloudQueryWeekCount);
        return resultMap;
    }

    public Map<String, Object> getCloudQueryCountDetails() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String allSql = " select to_char(f_querytime, 'YYYY') as time, COUNT(*) as num,sum(f_area) as mj from tb_cloud_query group by time  order by time";
        List allData = this.jdbcTemplate.queryForList(allSql);
        resultMap.put("allData", allData);
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String yearSql = " select to_char(f_querytime, 'YYYY-MM') as time, COUNT(*) as num,sum(f_area)  as mj \nfrom tb_cloud_query\nwhere to_char(f_querytime, 'YYYY-MM-DD') >= '" + yearstart + "'\n  and to_char(f_querytime, 'YYYY-MM-DD') <= '" + yearend + "'\ngroup by time\norder by time";
        List yearData = this.jdbcTemplate.queryForList(yearSql);
        resultMap.put("yearData", yearData);
        String monthstart = BusinessStatisticsService.getFisrtDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthend = BusinessStatisticsService.getLastDayOfMonth(cal.get(1), cal.get(2) + 1);
        String monthSql = " select to_char(f_querytime, 'YYYY-MM-DD') as time, COUNT(*) as num,sum(f_area)  as mj \nfrom tb_cloud_query\nwhere to_char(f_querytime, 'YYYY-MM-DD') >= '" + monthstart + "'\n  and to_char(f_querytime, 'YYYY-MM-DD') <= '" + monthend + "'\ngroup by time\norder by time;";
        List monthData = this.jdbcTemplate.queryForList(monthSql);
        resultMap.put("monthData", monthData);
        return resultMap;
    }

    public Map<String, Object> getTaskClassCountDetails() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String XCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where f_appkey  ='XCYW' and f_parentid  ='-1'";
        List taskClassmap = this.jdbcTemplate.queryForList(XCYWSql);
        resultMap.put("XCYWTaskClassmap", this.handlyTaskClassMap(taskClassmap));
        String HCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where  f_parentid  ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        List taskClassmap1 = this.jdbcTemplate.queryForList(HCYWSql);
        resultMap.put("HCYWTaskClassmap", this.handlyTaskClassMap(taskClassmap1));
        return resultMap;
    }

    public void executeBusinessStatistics(TbBusinessStatistics record) {
        LocalDateTime now = LocalDateTime.now();
        if (record.getfNextUpdateTime() == null || this.datatimeToTimestamp(now) > record.getfNextUpdateTime().getTime()) {
            if (StringUtils.isNotBlank((CharSequence)record.getfType())) {
                JSONObject resultObject = new JSONObject();
                switch (record.getfType()) {
                    case "DCZX_ZHTJ": {
                        resultObject.put("YHZL", this.getUserCountByCurrenWeek());
                        resultObject.put("XSZL", this.getClueCountByCurrenWeek());
                        resultObject.put("RWZL", this.getTaskCountByCurrenWeek());
                        resultObject.put("TBZL", this.getTaskTBCountByCurrenWeek());
                        resultObject.put("CGZL", this.getTaskMediaCountByCurrenWeek());
                        resultObject.put("YCXZL", this.getCloudQueryCountByCurrenWeek());
                        break;
                    }
                    case "DCZX_YHTJ": {
                        resultObject.put("YHLB", this.getUserTaskClass());
                        resultObject.put("DWLX", this.getUserorganizationCountByCurrenWeek());
                        break;
                    }
                    case "DCZX_YCXTJ": {
                        resultObject.put("YCXTJ", this.getCloudQueryCountDetails());
                        break;
                    }
                    case "DCZX_YWTJ": {
                        resultObject.put("YWTJ", this.getTaskClassCountDetails());
                        break;
                    }
                    case "XSGL_HJGZ": {
                        resultObject.put("HJXS", this.getClueCountByDate());
                        resultObject.put("RHCL", this.getClueMergestatusCountByDate());
                        String fSqlscript = record.getfSqlscript();
                        JSONObject jsonObject = JSONObject.parseObject((String)fSqlscript);
                        resultObject.put("TSYY", this.getTSYYClueCountByDate(jsonObject.getString("TSYY")));
                        resultObject.put("XSLX", this.getClueTypeByDate());
                        break;
                    }
                    case "XSGL_XZQDM": {
                        resultObject.put("XZQDM", this.getClueXzqdmCountByDate());
                        break;
                    }
                    case "XSGL_XSZT": {
                        resultObject.put("XSZT", this.getClueStatusCountByDate());
                        break;
                    }
                }
                record.setfData(resultObject.toJSONString());
            }
            if (record.getfTimeType() != null && record.getfIntervalTime() != null) {
                if (record.getfTimeType() == 1) {
                    LocalDateTime nextMinutes = now.plusMinutes(record.getfIntervalTime().intValue());
                    record.setfNextUpdateTime(new Timestamp(this.datatimeToTimestamp(nextMinutes)));
                } else if (record.getfTimeType() == 2) {
                    LocalDateTime nextHour = now.plusHours(record.getfIntervalTime().intValue());
                    record.setfNextUpdateTime(new Timestamp(this.datatimeToTimestamp(nextHour)));
                } else if (record.getfTimeType() == 3) {
                    LocalDateTime nextDays = now.plusDays(record.getfIntervalTime().intValue());
                    record.setfNextUpdateTime(new Timestamp(this.datatimeToTimestamp(nextDays)));
                } else if (record.getfTimeType() == 4) {
                    LocalDateTime nextMonths = now.plusMonths(record.getfIntervalTime().intValue());
                    record.setfNextUpdateTime(new Timestamp(this.datatimeToTimestamp(nextMonths)));
                }
            }
            record.setfUpdateTime(new Timestamp(this.datatimeToTimestamp(now)));
        }
        record.setfStatus(Integer.valueOf(1));
        this.tbBusinessStatisticsRepository.gwAccessSelective((GiEntitySaveable)record);
    }

    public long datatimeToTimestamp(LocalDateTime ldt) {
        long timestamp = ldt.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return timestamp;
    }

    public LocalDateTime timestamToDatetime(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    private void completeClueChildren(JcClueSource jcClueSource, List<String> tableNames) {
        List jcClueSources = this.jcClueSourceMapper.queryByParentId(jcClueSource.getfId(), null);
        if (jcClueSources.size() > 0) {
            for (JcClueSource bean : jcClueSources) {
                if (StringUtils.isNotBlank((CharSequence)bean.getfTablename())) {
                    tableNames.add(bean.getfTablename());
                }
                this.completeClueChildren(bean, tableNames);
            }
        }
    }

    public static String getEndOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String EndOfDay = sdf.format(Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant()));
        return EndOfDay;
    }

    public static String getStartOfDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String StartOfDay = sdf.format(Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant()));
        return StartOfDay;
    }

    public static String getFisrtDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static String getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Object now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c.set(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(c.getTime()) + " 00:00:00";
        return time;
    }

    public static String getCurrentQuarterEndTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Object now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 31);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 31);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(c.getTime()) + "  23:59:59";
        return time;
    }

    public static Long converTime(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }

    public static String getCurrentDayStartTime() {
        LocalDate now = LocalDate.now();
        LocalDateTime todayStart = now.atStartOfDay();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("\u5f53\u5929\u5f00\u59cb\u65f6\u95f4 = " + todayStart.format(pattern));
        return todayStart.format(pattern);
    }

    public static String getCurrentDayEndTime() {
        LocalDate now = LocalDate.now();
        LocalDateTime todayEnd = LocalDateTime.of(now, LocalTime.MAX);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("\u5f53\u5929\u5f00\u59cb\u65f6\u95f4 = " + todayEnd.format(pattern));
        return todayEnd.format(pattern);
    }

    public static String getCurrentWeekStartStartTime() {
        LocalDate now = LocalDate.now();
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDateTime weekStart = monday.atStartOfDay();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return weekStart.format(pattern);
    }

    public static String getCurrentWeekStartEndTime() {
        LocalDate now = LocalDate.now();
        LocalDate sunday = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        LocalDateTime weekEnd = LocalDateTime.of(sunday, LocalTime.MAX);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return weekEnd.format(pattern);
    }

    public static void main(String[] args) {
        LocalDate now = LocalDate.now();
        LocalDateTime now1 = LocalDateTime.now();
        LocalDateTime nextSeconds = now1.plusSeconds(50L);
        LocalDateTime nextMinutes = now1.plusMinutes(10L);
        LocalDateTime nextHour = now1.plusHours(1L);
        LocalDateTime nextDays = now1.plusDays(1L);
        LocalDateTime nextMonths = now1.plusMonths(1L);
        LocalDateTime todayStart = now.atStartOfDay();
        LocalDateTime todayEnd = LocalDateTime.of(now, LocalTime.MAX);
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate sunday = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        LocalDateTime weekStart = monday.atStartOfDay();
        LocalDateTime weekEnd = LocalDateTime.of(sunday, LocalTime.MAX);
        LocalDate firstDayOfMonth = now.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = now.with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime firstDayOfMonthStart = firstDayOfMonth.atStartOfDay();
        LocalDateTime firstDayOfMonthEnd = LocalDateTime.of(lastDayOfMonth, LocalTime.MAX);
        LocalDate beginTime = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
        LocalDate endTiime = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());
        LocalDate yesterday2 = LocalDate.now().minusDays(1L);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("\u5f53\u524d\u65f6\u95f4 = " + now1.format(pattern));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u589e\u52a050\u79d2 = " + nextSeconds.format(pattern));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u589e\u52a010\u5206\u949f = " + nextMinutes.format(pattern));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u589e\u52a0\u4e00\u5c0f\u65f6 = " + nextHour.format(pattern));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u589e\u52a01\u5929 = " + nextDays.format(pattern));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u589e\u52a01\u6708 = " + nextMonths.format(pattern));
        System.out.println("\u5f53\u5929\u5f00\u59cb\u65f6\u95f4 = " + todayStart.format(pattern));
        System.out.println("\u5f53\u5929\u7ed3\u675f\u65f6\u95f4 = " + todayEnd.format(pattern));
        System.out.println("\u672c\u5468\u5f00\u59cb\u65f6\u95f4 = " + weekStart.format(pattern));
        System.out.println("\u672c\u5468\u7ed3\u675f\u65f6\u95f4 = " + weekEnd.format(pattern));
        System.out.println("\u672c\u6708\u5f00\u59cb\u65f6\u95f4 = " + firstDayOfMonthStart.format(pattern));
        System.out.println("\u672c\u6708\u7ed3\u675f\u65f6\u95f4 = " + firstDayOfMonthEnd.format(pattern));
    }

    public static List<Map<String, Object>> removeRepeatMapByKey(List<Map<String, Object>> list, String mapKey) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        HashMap<String, Map<String, Object>> msp = new HashMap<String, Map<String, Object>>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Map<String, Object> map = list.get(i);
            String id = (String)map.get(mapKey);
            map.remove(mapKey);
            if (msp.containsKey(id)) {
                map.put("count", Double.parseDouble(((Map)msp.get(id)).get("count").toString()) + Double.parseDouble(map.get("count").toString()));
            }
            msp.put(id, map);
        }
        Set mspKey = msp.keySet();
        for (String key : mspKey) {
            Map newMap = (Map)msp.get(key);
            newMap.put(mapKey, key);
            listMap.add(newMap);
        }
        return listMap;
    }

    public void executeZhddXshjStatistics(String type) {
        List tbBusinessStatistics = this.tbBusinessStatisticsRepository.queryByType(type);
        if (tbBusinessStatistics == null || tbBusinessStatistics.size() == 0) {
            return;
        }
        TbBusinessStatistics record = (TbBusinessStatistics)tbBusinessStatistics.get(0);
        switch (record.getfType()) {
            case "DCZX_ZHTJ": {
                break;
            }
            case "DCZX_YHTJ": {
                break;
            }
            case "DCZX_YCXTJ": {
                break;
            }
            case "DCZX_YWTJ": {
                break;
            }
            case "XSGL_HJGZ": {
                Timestamp timestamp = new Timestamp(new Date().getTime());
                TbZhddZdzbtj tbZhddZdzbtj1 = new TbZhddZdzbtj();
                Map<String, Object> allClueCountAndMj = this.getAllClueCountAndMj();
                tbZhddZdzbtj1.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj1.setModule("\u7ebf\u7d22\u6c47\u805a");
                tbZhddZdzbtj1.setType("\u7ebf\u7d22\u6c47\u805a");
                tbZhddZdzbtj1.setValue(allClueCountAndMj.get("count").toString());
                tbZhddZdzbtj1.setCalculatorvalue(allClueCountAndMj.get("mj").toString());
                tbZhddZdzbtj1.setCreatetime(timestamp);
                String fSqlscript = record.getfSqlscript();
                JSONObject jsonObject = JSONObject.parseObject((String)fSqlscript);
                Map<String, Object> tsyy = this.getTSYYClueCountAndMj(jsonObject.getString("TSYY"));
                TbZhddZdzbtj tbZhddZdzbtj2 = new TbZhddZdzbtj();
                tbZhddZdzbtj2.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj2.setModule("\u7ebf\u7d22\u6c47\u805a");
                tbZhddZdzbtj2.setType("\u63a8\u9001\u5904\u7f6e");
                tbZhddZdzbtj2.setValue(tsyy.get("count").toString());
                tbZhddZdzbtj2.setCalculatorvalue(tsyy.get("mj").toString());
                tbZhddZdzbtj2.setCreatetime(timestamp);
                Map<String, Object> clueMergestatusCountAndMj = this.getClueMergestatusCountAndMj();
                TbZhddZdzbtj tbZhddZdzbtj3 = new TbZhddZdzbtj();
                tbZhddZdzbtj3.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj3.setModule("\u7ebf\u7d22\u6c47\u805a");
                tbZhddZdzbtj3.setType("\u590d\u7528\u5206\u6790");
                tbZhddZdzbtj3.setValue(clueMergestatusCountAndMj.get("count").toString());
                tbZhddZdzbtj3.setCalculatorvalue(clueMergestatusCountAndMj.get("mj").toString());
                tbZhddZdzbtj3.setCreatetime(timestamp);
                ArrayList<TbZhddZdzbtj> list = new ArrayList<TbZhddZdzbtj>();
                list.add(tbZhddZdzbtj1);
                list.add(tbZhddZdzbtj2);
                list.add(tbZhddZdzbtj3);
                this.tbZhddZdzbtjRepository.saveAll(list);
                break;
            }
            case "XSGL_XZQDM": {
                break;
            }
            case "XSGL_XSZT": {
                break;
            }
        }
    }

    public List<Map<String, Object>> getTaskBaseInfoByClassId(Integer classId, String userId) {
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join  tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id)  where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid =" + classId + " and ttb.f_id in (select b.f_bizid from tbsys_user_biz2 b where b.f_userid='" + userId + "' and b.f_role = 1)";
        return this.jdbcTemplate.queryForList(taskSql);
    }

    public Map getTaskCountByClassIdAndTaskName(String taskName, Integer classId, int page, int rows) {
        boolean b = SQLInjectionUtil.containsSqlInjection((Object)taskName);
        boolean b1 = SQLInjectionUtil.containsSqlInjection((Object)classId);
        if (b || b1) {
            throw new GwValidateException("\u5b58\u5728sql\u6ce8\u5165\u98ce\u9669\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String classFilter = "";
        if (classId != null) {
            classFilter = " and ttb.f_classid = " + classId;
        }
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' " + classFilter;
        String countSql = "select count(1)  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' " + classFilter;
        if (StringUtils.isNotEmpty((CharSequence)taskName)) {
            taskSql = taskSql + " and ttb.f_name like '%" + taskName + "%'";
            countSql = countSql + " and ttb.f_name like '%" + taskName + "%'";
        }
        taskSql = taskSql + " limit " + rows + " offset " + (page - 1) * rows;
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        Integer total = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String allcount = " select count(1) from " + f_tablename;
            map2.put("taskTBCount", this.jdbcTemplate.queryForObject(allcount, Integer.class));
        }
        List list = taskMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("taskTBCount"), (Integer)e2.get("taskTBCount"))).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("total", total);
        return map;
    }

    public List<Map<String, Object>> getTaskCountByClassId(Long userId, Integer classId) {
        ArrayList<Long> classIds = new ArrayList<Long>();
        classIds.add(Long.valueOf(classId.intValue()));
        this.mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId.intValue()), classIds);
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String allcount = " select count(1) from " + f_tablename;
            map2.put("taskTBCount", this.jdbcTemplate.queryForObject(allcount, Integer.class));
        }
        List<Map<String, Object>> list = taskMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("taskTBCount"), (Integer)e2.get("taskTBCount"))).collect(Collectors.toList());
        return list;
    }

    public List<Map<String, Object>> getClassOption(String appsId) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        String taskClassSql = "select f_id ,f_name,f_imgurl  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            taskClassSql = taskClassSql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(taskClassSql);
        for (Map map1 : taskClassmap) {
            String imgurl;
            if (map1.get("f_id") == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String classId = map1.get("f_id").toString();
            String className = map1.get("f_name").toString();
            String string = imgurl = map1.get("f_imgurl") != null ? map1.get("f_imgurl").toString() : "";
            if (StringUtils.isNotBlank((CharSequence)imgurl) && !imgurl.contains("AccessKeyId")) {
                String url = this.temporarySignedUrlService.getTemporarySignedUrl("", imgurl, null);
                map.put("imgurl", url);
            } else {
                map.put("imgurl", imgurl);
            }
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(classId));
            boolean taskTBCount = false;
            boolean taskCount = false;
            map.put("classId", classId);
            map.put("className", className);
            resultMap.add(map);
        }
        return resultMap;
    }

    public List<Map<String, Object>> getClassTree(String appsId) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            taskClassSql = taskClassSql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(taskClassSql);
        for (Map map1 : taskClassmap) {
            if (map1.get("f_id") == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String classId = map1.get("f_id").toString();
            String className = map1.get("f_name").toString();
            map.put("value", classId);
            map.put("label", className);
            String sql2 = "select f_id ,f_name  from tbtsk_task_class ttc where f_parentid='" + classId + "'";
            List childList = this.jdbcTemplate.queryForList(sql2);
            if (childList != null && !childList.isEmpty()) {
                ArrayList children = new ArrayList();
                for (Map child : childList) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    String id = child.get("f_id").toString();
                    String name = child.get("f_name").toString();
                    temp.put("value", id);
                    temp.put("label", name);
                    children.add(temp);
                }
                map.put("children", children);
            }
            resultMap.add(map);
        }
        return resultMap;
    }

    public List<Map<String, Object>> getClassTaskCount(Long userId, String appsId) {
        ArrayList resultMap = new ArrayList();
        String taskClassSql = "select f_id ,f_name,f_imgurl  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            taskClassSql = taskClassSql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(taskClassSql);
        for (Map map1 : taskClassmap) {
            String imgurl;
            if (map1.get("f_id") == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String classId = map1.get("f_id").toString();
            String className = map1.get("f_name").toString();
            String string = imgurl = map1.get("f_imgurl") != null ? map1.get("f_imgurl").toString() : "";
            if (StringUtils.isNotBlank((CharSequence)imgurl) && !imgurl.contains("AccessKeyId")) {
                String url = this.temporarySignedUrlService.getTemporarySignedUrl("", imgurl, null);
                map.put("imgurl", url);
            } else {
                map.put("imgurl", imgurl);
            }
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(classId));
            int taskTBCount = 0;
            int taskCount = 0;
            map.put("classId", classId);
            map.put("className", className);
            map.put("taskTBCount", taskTBCount);
            map.put("taskCount", taskCount);
            this.mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId), classIds);
            String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
            List taskMap = this.jdbcTemplate.queryForList(taskSql);
            for (Map map2 : taskMap) {
                String f_tablename;
                if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
                String allcount = " select count(1) from " + f_tablename;
                taskTBCount += ((Integer)this.jdbcTemplate.queryForObject(allcount, Integer.class)).intValue();
            }
            map.put("taskTBCount", taskTBCount);
            map.put("taskCount", taskMap.size());
            resultMap.add(map);
        }
        List<Map<String, Object>> list = resultMap.stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.get("taskTBCount"), (Integer)e2.get("taskTBCount"))).collect(Collectors.toList());
        return list;
    }

    public Map<String, Object> getBusinessAndUserCount(Long userId, String appsId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if (StringUtils.isNotBlank((CharSequence)appsId)) {
            taskClassSql = taskClassSql + " and ttc.f_appkey ='" + appsId + "'";
        }
        List taskClassmap = this.jdbcTemplate.queryForList(taskClassSql);
        resultMap.put("businessCount", taskClassmap.size());
        String userSql = "select count(distinct(tub.f_userid)) from tbsys_user_biz2 tub ,tbsys_user tu  where tub.f_userid = tu.f_userid";
        resultMap.put("userCount", this.jdbcTemplate.queryForObject(userSql, Integer.class));
        return resultMap;
    }

    public List<Map<String, Object>> getTaskTbByRegion(Long userId, String taskId) {
        TbtskObjectinfo table = this.tskTaskBizService.findTableByTaskId(taskId);
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_xzqdmsys,1,6) as xzqdm,count(1) from " + table.getfTablename();
        String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List Allmaps = this.jdbcTemplate.queryForList(sql);
        return Allmaps;
    }

    public JSONObject zdzxCount(String name, List<Long> classIds) {
        ArrayList<Long> allclassIds = new ArrayList<Long>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        for (Long classId : classIds) {
            allclassIds.add(classId);
            this.mTbtskTaskClassService.queryClassIdByParentId(classId, allclassIds);
        }
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        ArrayList<Map<String, Object>> gdjcAllMap = new ArrayList<Map<String, Object>>();
        Long gdjcTbCount = 0L;
        Long gdjcMediaCount = 0L;
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
            String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + f_tablename + "  ";
            String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
            List Allmaps = this.jdbcTemplate.queryForList(sql);
            gdjcAllMap.addAll(Allmaps);
            String totalNum = " select count(1) from " + f_tablename;
            gdjcTbCount = gdjcTbCount + (Long)this.jdbcTemplate.queryForObject(totalNum, Long.class);
            String mediaNum = " select count(1) from tb_app_media tam , " + f_tablename + " tb where tb.f_id = tam.f_galleryid ";
            gdjcMediaCount = gdjcMediaCount + (Long)this.jdbcTemplate.queryForObject(mediaNum, Long.class);
        }
        jsonObject.put("gdjcTbCount", (Object)gdjcTbCount);
        jsonObject.put("gdjcMediaCount", (Object)gdjcMediaCount);
        List<Map<String, Object>> gdjcMap = BusinessStatisticsService.removeRepeatMapByKey(gdjcAllMap, "f_xzqdm");
        jsonObject.put("gdjcAllMap", gdjcMap);
        return jsonObject;
    }

    public Map<String, Object> getOverviewZdzx(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Long> gejcclassIds = new ArrayList<Long>();
        gejcclassIds.add(424L);
        gejcclassIds.add(398L);
        JSONObject gejcObject = this.zdzxCount("\u8015\u5730\u76d1\u6d4b", gejcclassIds);
        resultMap.put("gdjc", gejcObject);
        ArrayList<Long> zhjgclassIds = new ArrayList<Long>();
        zhjgclassIds.add(425L);
        zhjgclassIds.add(424L);
        JSONObject zhjgObject = this.zdzxCount("\u7efc\u5408\u76d1\u6d4b", zhjgclassIds);
        resultMap.put("zhjg", zhjgObject);
        ArrayList<Long> cgjcclassIds = new ArrayList<Long>();
        cgjcclassIds.add(425L);
        JSONObject cgjcObject = this.zdzxCount("\u5e38\u89c4\u76d1\u6d4b", cgjcclassIds);
        resultMap.put("cgjc", cgjcObject);
        ArrayList<Long> csjcclassIds = new ArrayList<Long>();
        csjcclassIds.add(34L);
        JSONObject csjcObject = this.zdzxCount("\u57ce\u5e02\u76d1\u6d4b", csjcclassIds);
        resultMap.put("csjc", csjcObject);
        ArrayList<Long> ghjgclassIds = new ArrayList<Long>();
        ghjgclassIds.add(15L);
        JSONObject ghjgObject = this.zdzxCount("\u4f9b\u540e\u76d1\u7ba1", ghjgclassIds);
        resultMap.put("ghjg", ghjgObject);
        JSONObject bgdcObject = this.zdzxCount("\u53d8\u66f4\u8c03\u67e5", ghjgclassIds);
        bgdcObject.put("name", (Object)"\u53d8\u66f4\u8c03\u67e5");
        ArrayList<Map<String, Object>> gdjcAllMap = new ArrayList<Map<String, Object>>();
        Long gdjcTbCount = 0L;
        Long gdjcMediaCount = 0L;
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1),sum(f_tbnum) from tb_business_statistics_bgdc ";
        String sql = Asql + Bsql + " group by xzqdm) select A.*,case when sum is null then 0 else sum end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List Allmaps = this.jdbcTemplate.queryForList(sql);
        gdjcAllMap.addAll(Allmaps);
        String totalNum = " select sum(f_tbnum) from  tb_business_statistics_bgdc";
        gdjcTbCount = gdjcTbCount + (Long)this.jdbcTemplate.queryForObject(totalNum, Long.class);
        String mediaNum = " select sum(f_mednum) from  tb_business_statistics_bgdc ";
        gdjcMediaCount = gdjcMediaCount + (Long)this.jdbcTemplate.queryForObject(mediaNum, Long.class);
        bgdcObject.put("gdjcTbCount", (Object)gdjcTbCount);
        bgdcObject.put("gdjcMediaCount", (Object)gdjcMediaCount);
        List<Map<String, Object>> gdjcMap = BusinessStatisticsService.removeRepeatMapByKey(gdjcAllMap, "f_xzqdm");
        bgdcObject.put("gdjcAllMap", gdjcMap);
        resultMap.put("bgdc", bgdcObject);
        return resultMap;
    }

    public JSONObject getAllClueCountByYear(String year) {
        JSONObject object = new JSONObject();
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        ArrayList<Map<String, Object>> AllMap = new ArrayList<Map<String, Object>>();
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        JSONObject object1 = new JSONObject();
        for (JcClueSource jcClueSource : list) {
            Long clueAllCount = 0L;
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String f_tablename : tableNames) {
                    String totalNum = "select count(1) from " + f_tablename + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
                    clueAllCount = clueAllCount + (Long)this.jdbcTemplate.queryForObject(totalNum, Long.class);
                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + f_tablename + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
                    String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                    List Allmaps = this.jdbcTemplate.queryForList(sql);
                    AllMap.addAll(Allmaps);
                }
            }
            object1.put(jcClueSource.getfName(), (Object)clueAllCount);
        }
        List<Map<String, Object>> regionMap = BusinessStatisticsService.removeRepeatMapByKey(AllMap, "f_xzqdm");
        object.put("regionMap", regionMap);
        object.put("xsMap", (Object)object1);
        return object;
    }

    public Map<String, Object> getOverviewXshj(Long userId) {
        String sourceId = "be7323d1-3968-463d-8d11-1893a82fd1d4,dd487e12-8e56-41e2-87f0-30965f8d234b";
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject xshjObject = new JSONObject();
        Map<String, Object> allClueCountAndMj = this.getAllClueCountAndMj();
        xshjObject.put("xshj", allClueCountAndMj);
        Map<String, Object> tsyy = this.getTSYYClueCountAndMj(sourceId);
        xshjObject.put("tsyy", tsyy);
        Map<String, Object> rhfx = this.getClueMergestatusCountAndMj();
        xshjObject.put("rhfx", rhfx);
        resultMap.put("xshj", xshjObject);
        List list = this.jcClueSourceMapper.getAllList(Integer.valueOf(2), null, null);
        ArrayList<Map<String, Object>> AllMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tsczMap = new ArrayList<Map<String, Object>>();
        ArrayList xssjList = new ArrayList();
        for (JcClueSource jcClueSource : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", jcClueSource.getfName());
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            Long xsCount = 0L;
            if (tableNames.size() > 0) {
                Iterator iterator = tableNames.iterator();
                while (iterator.hasNext()) {
                    String f_tablename = (String)iterator.next();
                    if (!StringUtils.isNotBlank((CharSequence)f_tablename)) continue;
                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + f_tablename + "  ";
                    String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                    List Allmaps = this.jdbcTemplate.queryForList(sql);
                    AllMap.addAll(Allmaps);
                    String totalNum = " select count(1) from " + f_tablename;
                    xsCount = xsCount + (Long)this.jdbcTemplate.queryForObject(totalNum, Long.class);
                }
            }
            map.put("xsCount", xsCount);
            xssjList.add(map);
        }
        resultMap.put("xssjList", xssjList);
        List<Map<String, Object>> xshjAllMap = BusinessStatisticsService.removeRepeatMapByKey(AllMap, "f_xzqdm");
        resultMap.put("xshjAllMap", xshjAllMap);
        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List list1 = this.jcClueSourceMapper.getCuleBysourceids(sourceIds);
        for (JcClueSource jcClueSource : list) {
            ArrayList<String> tableNames = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            this.completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() <= 0) continue;
            for (String s : tableNames) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from " + s + "  ";
                String sql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                List Allmaps = this.jdbcTemplate.queryForList(sql);
                tsczMap.addAll(Allmaps);
            }
        }
        List<Map<String, Object>> tsczAllMap = BusinessStatisticsService.removeRepeatMapByKey(tsczMap, "f_xzqdm");
        resultMap.put("tsczAllMap", tsczAllMap);
        return resultMap;
    }

    public Map<String, Object> getOverviewXsktdwjc(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject object_2020 = this.getAllClueCountByYear("2020");
        resultMap.put("2020", object_2020);
        JSONObject object_2021 = this.getAllClueCountByYear("2021");
        resultMap.put("2021", object_2021);
        JSONObject object_2022 = this.getAllClueCountByYear("2022");
        resultMap.put("2022", object_2022);
        JSONObject object_20203 = this.getAllClueCountByYear("2023");
        resultMap.put("2023", object_20203);
        JSONObject object_20204 = this.getAllClueCountByYear("2024");
        resultMap.put("2024", object_20204);
        return resultMap;
    }

    public Map<String, Object> getOverviewRwhz(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject levelObkect = new JSONObject();
        levelObkect.put("cityCount", (Object)0);
        levelObkect.put("countyCount", (Object)0);
        String levelsql = " select f_unifylevel,count(1) from tbtsk_task_biz ttb where f_unifylevel in ('2','3') group by f_unifylevel;";
        List levelMaps = this.jdbcTemplate.queryForList(levelsql);
        if (levelMaps.size() > 0) {
            for (Map map : levelMaps) {
                if ("2".equals(map.get("f_unifylevel").toString())) {
                    levelObkect.put("cityCount", map.get("count"));
                    continue;
                }
                if (!"3".equals(map.get("f_unifylevel").toString())) continue;
                levelObkect.put("countyCount", map.get("count"));
            }
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        String yearCitysql = "select count(1) from tbtsk_task_biz where f_unifylevel in ('3') and f_createtime between '" + yearstart + "' and '" + yearend + "'";
        String yearCountsql = "select count(1) from tbtsk_task_biz where f_unifylevel in ('2') and f_createtime between '" + yearstart + "' and '" + yearend + "'";
        Integer ingCount = (Integer)this.jdbcTemplate.queryForObject(yearCitysql, Integer.class);
        Integer oldCount = (Integer)this.jdbcTemplate.queryForObject(yearCountsql, Integer.class);
        levelObkect.put("ingCount", (Object)ingCount);
        levelObkect.put("oldCount", (Object)oldCount);
        resultMap.put("levelObkect", levelObkect);
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_unifycode,1,6) as xzqdm,count(1) from tbtsk_task_biz where f_unifylevel in ('3')  and f_createtime between '" + yearstart + "' and '" + yearend + "'";
        String newSql = Asql + Bsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List regionNewmaps = this.jdbcTemplate.queryForList(newSql);
        List<Map<String, Object>> newAllMap = BusinessStatisticsService.removeRepeatMapByKey(regionNewmaps, "f_xzqdm");
        List newAlllist = newAllMap.stream().sorted((e1, e2) -> -Long.compare((Long)e1.get("count"), (Long)e2.get("count"))).collect(Collectors.toList());
        resultMap.put("newAlllist", newAlllist);
        String Csql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Dsql = " ,B as (select SUBSTR(f_unifycode,1,6) as xzqdm,count(1) from tbtsk_task_biz where f_unifylevel in ('3')  ";
        String sql = Csql + Dsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List regionmaps = this.jdbcTemplate.queryForList(sql);
        List<Map<String, Object>> regionAllMap = BusinessStatisticsService.removeRepeatMapByKey(regionmaps, "f_xzqdm");
        List regionAlllist = regionAllMap.stream().sorted((e1, e2) -> -Long.compare((Long)e1.get("count"), (Long)e2.get("count"))).collect(Collectors.toList());
        resultMap.put("regionAlllist", regionAlllist);
        return resultMap;
    }

    public Map<String, Object> getOverviewCghz(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject allObject = new JSONObject();
        allObject.put("sjzcCount", (Object)3.56);
        String jztbsql = " select sum(ttb.f_total)    from tbtsk_task_biz ttb where ttb.f_isdel  is null";
        allObject.put("jztbCount", this.jdbcTemplate.queryForObject(jztbsql, Long.class));
        String fwzcsql = " select count(1) from tb_cloud_query tcq;";
        allObject.put("fwzcCount", this.jdbcTemplate.queryForObject(fwzcsql, Long.class));
        String jzzpsql = " select count(1) from tb_app_media tam;";
        allObject.put("jzzpCount", this.jdbcTemplate.queryForObject(jzzpsql, Long.class));
        resultMap.put("allObject", allObject);
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        JSONObject yearObject = new JSONObject();
        yearObject.put("shzcYearCount", (Object)3.56);
        String jzzpYearsql = "select count(1) from tb_app_media where f_xzqdm  is not null and f_time between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
        Long jzzpYearCount = (Long)this.jdbcTemplate.queryForObject(jzzpYearsql, Long.class);
        yearObject.put("jzzpYearCount", (Object)jzzpYearCount);
        String jztbYearsql = "select sum(ttb.f_total)  from tbtsk_task_biz ttb where ttb.f_isdel  is null and ttb.f_createtime between '" + yearstart + "' and '" + yearend + "'";
        Long jztbYearCount = (Long)this.jdbcTemplate.queryForObject(jztbYearsql, Long.class);
        yearObject.put("jztbYearCount", (Object)jztbYearCount);
        String fwzcYearsql = "select count(1) from tb_cloud_query where f_querytime between '" + yearstart + "' and '" + yearend + "'";
        Long fwzcYearCount = (Long)this.jdbcTemplate.queryForObject(fwzcYearsql, Long.class);
        yearObject.put("fwzcYearCount", (Object)fwzcYearCount);
        resultMap.put("yearObject", yearObject);
        JSONObject regionObject = new JSONObject();
        String Csql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Dsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from tb_app_media where f_xzqdm is not null  ";
        String sql = Csql + Dsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List regionmaps = this.jdbcTemplate.queryForList(sql);
        List<Map<String, Object>> regionAllMap = BusinessStatisticsService.removeRepeatMapByKey(regionmaps, "f_xzqdm");
        List regionAlllist = regionAllMap.stream().sorted((e1, e2) -> -Long.compare((Long)e1.get("count"), (Long)e2.get("count"))).collect(Collectors.toList());
        String Esql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Fsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from tb_cloud_query where f_xzqdm is not null  ";
        String sql1 = Esql + Fsql + " group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List regionmaps1 = this.jdbcTemplate.queryForList(sql1);
        List<Map<String, Object>> regionAllMap1 = BusinessStatisticsService.removeRepeatMapByKey(regionmaps1, "f_xzqdm");
        List regionAlllist1 = regionAllMap1.stream().sorted((e1, e2) -> -Long.compare((Long)e1.get("count"), (Long)e2.get("count"))).collect(Collectors.toList());
        regionObject.put("jzzpRegionCount", regionAlllist);
        regionObject.put("queryRegionCount", regionAlllist1);
        resultMap.put("regionObject", regionObject);
        return resultMap;
    }

    public Map<String, Object> getOverviewXskdyy(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject object_2020 = this.handlyXskdyy("2020");
        resultMap.put("2020", object_2020);
        JSONObject object_2021 = this.handlyXskdyy("2021");
        resultMap.put("2021", object_2021);
        JSONObject object_2022 = this.handlyXskdyy("2022");
        resultMap.put("2022", object_2022);
        JSONObject object_20203 = this.handlyXskdyy("2023");
        resultMap.put("2023", object_20203);
        JSONObject object_20204 = this.handlyXskdyy("2024");
        resultMap.put("2024", object_20204);
        return resultMap;
    }

    public JSONObject handlyXskdyy(String year) {
        JSONObject object = new JSONObject();
        ArrayList<Long> gejcclassIds = new ArrayList<Long>();
        gejcclassIds.add(424L);
        gejcclassIds.add(398L);
        object.put("gdjc", (Object)this.xskdyyCount(gejcclassIds, year));
        ArrayList<Long> cgjcclassIds = new ArrayList<Long>();
        cgjcclassIds.add(425L);
        object.put("cgjc", (Object)this.xskdyyCount(cgjcclassIds, year));
        ArrayList<Long> zhjgclassIds = new ArrayList<Long>();
        zhjgclassIds.add(425L);
        zhjgclassIds.add(424L);
        object.put("zhjc", (Object)this.xskdyyCount(zhjgclassIds, year));
        String bgdcNum = "select case when sum(f_tbnum) is null then 0 else sum(f_tbnum) end  as count  from tb_business_statistics_bgdc where f_year ='" + year + "'";
        object.put("bgdc", this.jdbcTemplate.queryForObject(bgdcNum, Long.class));
        return object;
    }

    public Long xskdyyCount(List<Long> classIds, String year) {
        Long TbCount = 0L;
        String yearstart = year + "-01-01 00:00:00";
        String yearend = year + "-12-31 23:59:59";
        ArrayList<Long> allclassIds = new ArrayList<Long>();
        for (Long classId : classIds) {
            allclassIds.add(classId);
            this.mTbtskTaskClassService.queryClassIdByParentId(classId, allclassIds);
        }
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
        List taskMap = this.jdbcTemplate.queryForList(taskSql);
        for (Map map2 : taskMap) {
            String f_tablename;
            if (map2.get("f_tablename") == null || !StringUtils.isNotBlank((CharSequence)(f_tablename = map2.get("f_tablename").toString()))) continue;
            String totalNum = "select count(1) from " + f_tablename + " where f_createtime between '" + BusinessStatisticsService.converTime(yearstart) + "' and '" + BusinessStatisticsService.converTime(yearend) + "'";
            TbCount = TbCount + (Long)this.jdbcTemplate.queryForObject(totalNum, Long.class);
        }
        return TbCount;
    }
}

