/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueGroupService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.dto.ClueInfoDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRelService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueTaskRelService;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ClueService {
    private final GiLoger logger = GwLoger.getLoger(ClueService.class);
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueImportRelService jcClueImportRelService;
    @Autowired
    JcClueTaskRelService jcClueTaskRelService;
    @Autowired
    MTaskRecordService taskRecordService;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    MJcClueService jcClueService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    MJcClueGroupService jcClueGroupService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Value(value="${system.regionCode:}")
    protected String systemRegionCode;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    AppMediaService appMediaService;
    @Value(value="${project.uploadDir:}")
    protected String uploadDir;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    SysConfigService sysConfigService;

    public void importClueToTaskByDatas(Long userId, String sourceId, String recordId, String importRel, String taskId, String clueIds) {
        int count;
        JcClueSource jcClueSource = this.jcClueSourceService.findOne(sourceId);
        if (jcClueSource == null) {
            throw new GwValidateException("\u7ebf\u7d22\u8868\u4e0d\u5b58\u5728");
        }
        String tableNameByBizId = this.tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank((CharSequence)tableNameByBizId)) {
            throw new GwValidateException("\u4efb\u52a1\u8868\u4e0d\u5b58\u5728");
        }
        List<String> clueIdList = Arrays.asList(clueIds.split(","));
        if (clueIdList.size() > 0 && (count = this.jcClueTaskRelService.getCuleTaskCountByClues(taskId, sourceId, recordId, clueIdList)) >= clueIdList.size()) {
            throw new GwValidateException("\u6570\u636e\u5df2\u5bfc\u5165\uff0c\u4e0d\u7528\u91cd\u590d\u5bfc\u5165\uff01");
        }
        String tablename = jcClueSource.getfTablename();
        String where = " clue.f_sourceid='" + sourceId + "'";
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            where = where + " and clue.f_import_recordid = '" + recordId + "'";
        }
        if (clueIdList.size() > 0) {
            where = where + " and clue.f_id in ( ";
            for (String s : clueIdList) {
                where = where + "'" + s + "',";
            }
            where = where.substring(0, where.length() - 1) + ") and  not exists (select null from jc_clue_task_rel r where r.f_clueid= clue.f_id and r.f_type='1'  and r.f_taskid = '" + taskId + "')";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\", \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
        stringBuffer.append(" select uuid_generate_v1(),'" + sourceId + "','" + recordId + "',clue.f_id,'" + taskId + "', uuid_generate_v1(),now(),null,'1' from " + tablename + " clue  where " + where);
        this.dataBizMapper.excuteSql(stringBuffer.toString());
        JSONObject params = new JSONObject();
        params.put("sourceId", (Object)sourceId);
        params.put("recordId", (Object)recordId);
        params.put("importRel", (Object)importRel);
        params.put("taskId", (Object)taskId);
        params.put("userId", (Object)userId);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTaskName("\u7ebf\u7d22\u6570\u636e\u5bfc\u5165\u5230\u6838\u67e5\u4efb\u52a1");
        record.setTasktype(JobConstants.JOB_TYPE_CULETASK_IMPORT);
        record.setStarttime(new Date());
        record.setBizId(sourceId);
        record.setRead(Integer.valueOf(0));
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
    }

    public JSONObject saveClue(ClueInfoDto clueInfoDto) throws Exception {
        JSONObject object = new JSONObject();
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(clueInfoDto.getTaskId());
        String sql = "select f_tablename from tbtsk_objectinfo where f_id  in (select f_tableid  from tbtsk_task_biz where f_id = ? )";
        String fTablename = (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{clueInfoDto.getTaskId()});
        if (ObjectUtils.isNotEmpty((Object)fTablename)) {
            String tbId = UUID.randomUUID().toString();
            String shapeSql = " SELECT  ST_Transform(ST_Buffer(ST_Transform(ST_SetSRID(ST_MakePoint(" + clueInfoDto.getGjdwjd() + "," + clueInfoDto.getGjdwwd() + "), 4490), 3857), 50), 4490) as shape";
            Map map = this.jdbcTemplate.queryForMap(shapeSql);
            String fShape = "";
            if (ObjectUtils.isNotEmpty((Object)map)) {
                String temp = String.valueOf(map.get("shape"));
                fShape = temp.replaceFirst("SRID=4490;", "");
            }
            Long fUserid = clueInfoDto.getUserId();
            shapeSql = "select f_xzqdm as xzqdm, f_xzqmc as xzqmc, f_level as level from tb_region where ST_Contains(     shape,     ST_SetSRID(ST_MakePoint(" + clueInfoDto.getGjdwjd() + ", " + clueInfoDto.getGjdwwd() + "), 4490) ) union all select xzqdm, xzqmc, f_level as level from tb_region_town where ST_Contains(     ST_Transform(geom, 4490),     ST_SetSRID(ST_MakePoint(" + clueInfoDto.getGjdwjd() + ", " + clueInfoDto.getGjdwwd() + "), 4490) ) union all select xzqdm, xzqmc, f_level as level from tb_region_village where ST_Contains(     ST_Transform(geom, 4490),     ST_SetSRID(ST_MakePoint(" + clueInfoDto.getGjdwjd() + ", " + clueInfoDto.getGjdwwd() + "), 4490) )";
            List mapList = this.jdbcTemplate.queryForList(shapeSql);
            String fXzqmc = "";
            String fXzqdm = "";
            String fXzqdmcity = "";
            String fXzqdmcounty = "";
            String fXzqdmvillage = "";
            String flocation = "";
            String fXzqdmtown = "";
            String fXzqmctown = "";
            String xjxzqmc = "";
            String xjxzqdm = "";
            if (ObjectUtils.isNotEmpty((Object)mapList)) {
                for (Map xzqMap : mapList) {
                    if (!ObjectUtils.isNotEmpty((Object)xzqMap)) continue;
                    String level = String.valueOf(xzqMap.get("level"));
                    if (level.equals("1")) {
                        flocation = flocation + String.valueOf(xzqMap.get("xzqmc"));
                        continue;
                    }
                    if (level.equals("2")) {
                        fXzqdmcity = String.valueOf(xzqMap.get("xzqdm"));
                        flocation = flocation + String.valueOf(xzqMap.get("xzqmc"));
                        continue;
                    }
                    if (level.equals("3")) {
                        xjxzqdm = fXzqdmcounty = String.valueOf(xzqMap.get("xzqdm"));
                        xjxzqmc = String.valueOf(xzqMap.get("xzqmc"));
                        flocation = flocation + xjxzqmc;
                        continue;
                    }
                    if (level.equals("4")) {
                        fXzqdmtown = String.valueOf(xzqMap.get("xzqdm"));
                        fXzqmctown = String.valueOf(xzqMap.get("xzqmc"));
                        flocation = flocation + fXzqmctown;
                        continue;
                    }
                    if (!level.equals("5")) continue;
                    fXzqmc = String.valueOf(xzqMap.get("xzqmc"));
                    fXzqdmvillage = fXzqdm = String.valueOf(xzqMap.get("xzqdm"));
                    flocation = flocation + fXzqmc;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)fTablename)) {
                HashMap<String, Object> dataRow = new HashMap<String, Object>();
                Date date = new Date();
                long currentTimestampMillis = System.currentTimeMillis();
                List<String> fields = this.getFieldsForTable(fTablename);
                for (String field : fields) {
                    if ((field = field.trim()).equalsIgnoreCase("f_committime")) {
                        dataRow.put(field, currentTimestampMillis);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_createtime")) {
                        dataRow.put(field, currentTimestampMillis);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_gjbh")) {
                        dataRow.put(field, clueInfoDto.getGjbh());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_gjdwjd")) {
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_gjdwwd")) {
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_gjlx")) {
                        dataRow.put(field, clueInfoDto.getGjlx());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_gjsj")) {
                        dataRow.put(field, clueInfoDto.getGjsj());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_jkdw")) {
                        dataRow.put(field, clueInfoDto.getJkdw());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_jkmc")) {
                        dataRow.put(field, clueInfoDto.getJkmc());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lat")) {
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lat_b")) {
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lat_g")) {
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lon")) {
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lon_b")) {
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_lon_g")) {
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_shape")) {
                        dataRow.put(field, fShape);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_shape1")) {
                        dataRow.put(field, fShape);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_submit_userid")) {
                        dataRow.put(field, fUserid);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_userid")) {
                        dataRow.put(field, fUserid);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xjxzqdm")) {
                        dataRow.put(field, xjxzqdm);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xjxzqmc")) {
                        dataRow.put(field, xjxzqmc);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqdm")) {
                        dataRow.put(field, fXzqdmtown);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqdmcity")) {
                        dataRow.put(field, fXzqdmcity);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqdmcounty")) {
                        dataRow.put(field, xjxzqdm);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqdmsys")) {
                        dataRow.put(field, fXzqdm);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqdmtown")) {
                        dataRow.put(field, fXzqdmtown);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqmc")) {
                        dataRow.put(field, fXzqmctown);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_xzqmc1")) {
                        dataRow.put(field, fXzqmctown);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_zlwz")) {
                        dataRow.put(field, clueInfoDto.getZlwz());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_id")) {
                        dataRow.put(field, tbId);
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_jzrq")) {
                        dataRow.put(field, clueInfoDto.getJzrq());
                        continue;
                    }
                    if (field.equalsIgnoreCase("f_status")) {
                        dataRow.put(field, 1);
                        continue;
                    }
                    dataRow.put(field, null);
                }
                this.insertData(fTablename, dataRow, fields);
                List<MultipartFile> files = clueInfoDto.getFiles();
                Integer typeType = this.getGroupTypeType(clueInfoDto.getTaskId());
                if (ObjectUtils.isNotEmpty(files)) {
                    for (MultipartFile file : files) {
                        String ossPath = "clueInfo/ttgjxscz/" + System.currentTimeMillis() + "/" + file.getOriginalFilename();
                        String url = this.ossOperatorService.sendObject2Oss(ossPath, file.getInputStream());
                        AppMedia appMedia = new AppMedia();
                        appMedia.setServerpath(url);
                        appMedia.setId(UUID.randomUUID().toString());
                        appMedia.setType(this.getMediaType(file.getOriginalFilename()));
                        DecimalFormat df = new DecimalFormat("0.00");
                        String ret = df.format((double)file.getSize() / 1024.0);
                        appMedia.setMediasize(Double.valueOf(ret));
                        appMedia.setMark(Integer.valueOf(0));
                        appMedia.setGalleryid(tbId);
                        appMedia.setBizId(clueInfoDto.getTaskId());
                        appMedia.setDeviceSource(Integer.valueOf(2));
                        appMedia.setUsername("\u544a\u8b66\u7ebf\u7d22\u6570\u636e\u5bfc\u5165");
                        appMedia.setTypetype(typeType);
                        appMedia.setTime(String.valueOf(System.currentTimeMillis()));
                        this.appMediaService.saveOne(appMedia);
                    }
                }
                String recordId = UUID.randomUUID().toString();
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", (Object)1);
                additionJson.put("addOrUpdate", (Object)"ADD");
                additionJson.put("taskMode", (Object)task.getMode());
                additionJson.put("curMode", (Object)"receive");
                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(recordId);
                parameter.setTaskId(clueInfoDto.getTaskId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                parameter.setMode(task.getMode().toString());
                TaskRecord record = new TaskRecord();
                record.setId(recordId);
                record.setParam(JSONObject.toJSONString((Object)parameter));
                record.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record.setStarttime(new Date());
                record.setState(Integer.valueOf(1));
                Long userId = 520031475L;
                record.setUserid(userId);
                this.taskRecordService.save(record);
                TaskRecordTemp temp = new TaskRecordTemp();
                temp.setId(UUID.randomUUID().toString());
                temp.setRecordid(recordId);
                temp.setDataid(tbId);
                this.taskRecordService.saveTaskRecordTemp(Arrays.asList(temp));
                object.put("info", (Object)(clueInfoDto.getJkmc() + "\u6570\u636e\u5165\u5e93"));
                object.put("status", (Object)"\u6570\u636e\u5165\u5e93\u6210\u529f\uff01");
            }
        } else {
            object.put("info", (Object)"\u544a\u8b66\u7ebf\u7d22\u4e1a\u52a1\u8868\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u4e1a\u52a1\u4eba\u5458\u521b\u5efa\u544a\u8b66\u7ebf\u7d22\u4e1a\u52a1\u8868");
            object.put("status", (Object)"\u6570\u636e\u5165\u5e93\u5931\u8d25\uff01");
        }
        return object;
    }

    public void insertData(String tableName, Map<String, Object> data, List<String> fields) {
        String sql = this.buildInsertSql(tableName, fields);
        Object[] params = fields.stream().map(field -> data.get(field)).toArray();
        this.jdbcTemplate.update(sql, params);
    }

    private List<String> getFieldsForTable(String tableName) {
        return this.jdbcTemplate.queryForList("SELECT f_fieldname FROM tbtsk_fields WHERE f_tablename = ? order by f_fieldname ", String.class, new Object[]{tableName});
    }

    private String buildInsertSql(String tableName, List<String> fields) {
        StringBuilder columns = new StringBuilder();
        StringBuilder placeholders = new StringBuilder();
        for (String field : fields) {
            if (columns.length() > 0) {
                columns.append(", ");
                placeholders.append(", ");
            }
            columns.append(field);
            if ("f_shape".equalsIgnoreCase(field)) {
                placeholders.append("ST_GeomFromText(?, 4490)");
                continue;
            }
            placeholders.append("?");
        }
        return String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns.toString(), placeholders.toString());
    }

    public Integer getMediaType(String fileName) {
        Integer result = null;
        if (fileName.endsWith(".jpg") || fileName.endsWith(".png") || fileName.endsWith(".jpeg")) {
            result = 1;
        } else if (fileName.endsWith(".mp4")) {
            result = 2;
        } else if (fileName.endsWith(".mp3")) {
            result = 3;
        } else if (fileName.endsWith(".osgb")) {
            result = 4;
        } else if (fileName.endsWith(".pdf")) {
            result = 5;
        } else if (fileName.endsWith(".txt")) {
            result = 6;
        } else if (fileName.endsWith(".docx") || fileName.endsWith(".doc")) {
            result = 7;
        } else if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            result = 8;
        } else if (fileName.endsWith(".ppt")) {
            result = 9;
        }
        return result;
    }

    private String getCurrentDayTime(Date date) {
        String formattedDate = "";
        if (ObjectUtils.isNotEmpty((Object)date)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formattedDate = formatter.format(date);
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formattedDate = formatter.format(new Date());
        }
        return formattedDate;
    }

    private Integer getGroupTypeType(String taskId) {
        Integer typeType;
        block3: {
            typeType = 1;
            SysConfig sysConfig = this.sysConfigService.findOne("GroupTypeType");
            try {
                if (!ObjectUtils.isNotEmpty((Object)sysConfig) || !StringUtils.isNotBlank((CharSequence)sysConfig.getValue())) break block3;
                JSONArray jsonArray = JSONArray.parseArray((String)sysConfig.getValue(), (Feature[])new Feature[0]);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (!ObjectUtils.isNotEmpty((Object)jsonObject)) continue;
                    String taskIdVal = jsonObject.getString("taskId");
                    String typeTypeVal = jsonObject.getString("typeType");
                    if (!StringUtils.isNotBlank((CharSequence)taskIdVal) || !taskIdVal.equalsIgnoreCase(taskId)) continue;
                    typeType = Integer.valueOf(typeTypeVal);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u83b7\u53d6\u9644\u4ef6\u5206\u7ec4\u7c7b\u578btypeType\u503c\u5931\u8d25\uff1a{}", new Object[]{e.getMessage()});
                System.err.println("Error \u9644\u4ef6\u5206\u7ec4\u7c7b\u578btypeType\u503c\u51fa\u9519 : " + e.getMessage());
            }
        }
        return typeType;
    }
}

