/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.aliyuncs.exceptions.ClientException;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.Doc;
import com.geoway.landteam.landcloud.repository.pub.DocRepository;
import com.gw.base.gpa.entity.GiEntitySaveable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DocService {
    @Autowired
    DefaultOssOperatorService stsService;
    @Autowired
    DocRepository docRepository;

    public Page<Doc> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.docRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public Doc findOne(String id) {
        return (Doc)this.docRepository.gwSearchByPK((Serializable)((Object)id));
    }

    public void deleteOne(String id) {
        this.docRepository.gwDeleteByPK((Serializable)((Object)id));
    }

    public void save2db(Doc doc, String fileName, byte[] docFile) throws ClientException {
        if (this.docRepository.gwExistsWithPK((Serializable)((Object)doc.getId()))) {
            Doc oldDoc = (Doc)this.docRepository.gwSearchByPK((Serializable)((Object)doc.getId()));
            doc.setEditTime(new Date());
            doc.setPath(oldDoc.getPath());
            doc.setFlength(Integer.valueOf(docFile.length));
        } else {
            if (docFile != null) {
                ByteArrayInputStream input = new ByteArrayInputStream(docFile);
                try {
                    String path = this.uploadFile2Oss(fileName, input);
                    doc.setPath(path);
                    doc.setFlength(Integer.valueOf(docFile.length));
                    ((InputStream)input).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            Date now = new Date();
            doc.setEditTime(now);
        }
        this.docRepository.gwAccess((GiEntitySaveable)doc);
    }

    private String uploadFile2Oss(String fileName, InputStream input) throws ClientException {
        String key = "pdf/" + fileName;
        String domain = this.stsService.getDomain();
        List docs = this.docRepository.queryByPath(domain + key);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String lastKey = key.substring(key.lastIndexOf("/") + 1);
        String guid = UUID.randomUUID().toString().substring(0, 8);
        String hisKey = String.format("doc/%s/%s/%s", df.format(new Date()), guid, lastKey);
        this.stsService.renameObjectInOss(key, hisKey);
        for (Doc doc : docs) {
            String sdfStr = df.format(new Date());
            String path = domain + "/" + hisKey;
            doc.setPath(path);
            this.docRepository.gwAccess((GiEntitySaveable)doc);
        }
        String path = this.stsService.sendObject2Oss(key, input);
        return path;
    }
}

