/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.BizCustomConfigRepository;
import com.geoway.landteam.customtask.repository.task.BizCustomFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.BizCustomConfig;
import com.geoway.landteam.customtask.task.entity.BizCustomFields;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import jxl.Cell;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ExcelService {
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    BizCustomConfigRepository bizCustomConfigRepository;
    @Autowired
    BizCustomFieldsRepository bizCustomFieldsRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    MTbtskFieldsService fieldsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customExcel(List<BizCustomConfig> list, String bizId, String xzqdm, HttpServletResponse response, String customFilter, String tempId) throws UnsupportedEncodingException {
        BizCustomConfig config = list.get(0);
        String viewName = config.getViewName();
        String url = config.getUrl();
        url = URLDecoder.decode(url, "UTF-8");
        String sql = config.getSQL();
        Integer enableSql = config.getEnableSQL();
        TskTaskBiz one = this.tskTaskBizRepository.findById((Object)bizId).orElse(null);
        if (one == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        TbtskObjectinfo tbtskObjectinfo = this.objectinfoRepository.findById((Object)one.getTableId()).orElse(null);
        String exportSql = "";
        if (!Integer.valueOf(1).equals(enableSql)) {
            exportSql = "select * from " + viewName;
        } else {
            exportSql = sql + " ";
            if (StringUtils.isNotBlank((CharSequence)xzqdm)) {
                xzqdm = xzqdm.endsWith("0000") ? xzqdm.substring(0, 2) + "%" : (xzqdm.endsWith("00") ? xzqdm.substring(0, 4) + "%" : (xzqdm.equals("1") ? "" : xzqdm + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)xzqdm)) {
                exportSql = exportSql + " and f_xzqdmsys like '" + xzqdm + "' ";
            }
        }
        exportSql = exportSql + this.parseFilterParam(customFilter, tbtskObjectinfo.getfTablename(), "tb");
        List result = this.jdbcTemplate.queryForList(exportSql);
        List fields = this.bizCustomFieldsRepository.getFieldsByBizId(bizId, tempId);
        String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
        HttpURLConnection httpURLConnection = null;
        Workbook book = null;
        WritableWorkbook workbook = null;
        try {
            URL url1 = new URL(uploadurl);
            URLConnection urlConnection = url1.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            book = Workbook.getWorkbook((InputStream)httpURLConnection.getInputStream());
            workbook = Workbook.createWorkbook((OutputStream)response.getOutputStream(), (Workbook)book);
            WritableSheet sheet = workbook.getSheet(0);
            int lastRow = sheet.getRows();
            int nullRow = 0;
            for (int i = 0; i < lastRow; ++i) {
                Cell[] row = sheet.getRow(i);
                if (row.length != 0) continue;
                ++nullRow;
            }
            lastRow -= nullRow;
            for (Map map : result) {
                int lastCol = 0;
                for (BizCustomFields field : fields) {
                    if (map.containsKey(field.getName())) {
                        sheet.addCell((WritableCell)new Label(lastCol, lastRow, map.get(field.getName()).toString()));
                        ++lastCol;
                        continue;
                    }
                    throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff0c\u914d\u7f6e\u6709\u8bef");
                }
                ++lastRow;
            }
            workbook.write();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
                if (book != null) {
                    book.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
        }
    }

    public String parseFilterParam(String filterParam, String tableName, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty((CharSequence)filterParam)) {
            JSONArray filterArray = JSONArray.parseArray((String)filterParam, (Feature[])new Feature[0]);
            List<TbtskFields> allFields = this.fieldsService.getAllFieldsByTables(tableName);
            for (int i = 0; i < filterArray.size(); ++i) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if ("".equals(val)) continue;
                Optional<TbtskFields> optional = allFields.stream().filter(r -> r.getfId().equals(field)).findFirst();
                if (optional.isPresent()) {
                    TbtskFields one = optional.get();
                    block7 : switch (one.getfFieldtype()) {
                        case "1": 
                        case "2": {
                            switch (ref) {
                                case "LK": {
                                    String[] tem = val.split(",");
                                    if (tem.length > 1) {
                                        filterStr = filterStr + "( ";
                                        for (String s : tem) {
                                            filterStr = filterStr + tableAlias + "." + one.getfFieldname() + " LIKE '%" + s + "%'  or ";
                                        }
                                        filterStr = filterStr.substring(0, filterStr.length() - 3) + ") ";
                                        break block7;
                                    }
                                    filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";
                                    break block7;
                                }
                                case "EQ": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                    break block7;
                                }
                                case "IN": {
                                    ArrayList<String> inValues = new ArrayList<String>();
                                    for (String s : val.split(",")) {
                                        inValues.add("'" + s + "'");
                                    }
                                    filterStr = tableAlias + "." + one.getfFieldname() + " IN (" + StringUtils.join(inValues, (String)",") + ") ";
                                    break block7;
                                }
                            }
                            break;
                        }
                        case "3": 
                        case "4": 
                        case "5": {
                            switch (ref) {
                                case "GT": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " > " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "EQ": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " = " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                                case "LT": {
                                    filterStr = tableAlias + "." + one.getfFieldname() + " < " + jsonObject.getString("val") + " ";
                                    break block7;
                                }
                            }
                            break;
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)filterStr)) continue;
                where = where + " AND " + filterStr;
            }
        }
        return where;
    }
}

