/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.DeviceTrack;
import com.geoway.landteam.landcloud.core.model.pub.entity.DeviceTrackUpload;
import com.geoway.landteam.landcloud.core.repository.pub.DeviceTrackRepository;
import com.geoway.landteam.landcloud.core.repository.pub.DeviceTrackUploadRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service
@Transactional(rollbackFor={Exception.class})
public class MDeviceTrackService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    DeviceTrackRepository deviceTrackDao;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DeviceTrackUploadRepository deviceTrackUploadRepository;

    public List<DeviceTrack> queryByTime(String deviceId, Long startMillion, Long endMillion) {
        String sortParam = "SORT_updateTime_ASC";
        String filterParam = "Q_deviceId_S_EQ=" + deviceId;
        if (startMillion != null) {
            filterParam = filterParam + "Q_updateTime_D_GT=" + startMillion;
        }
        if (endMillion != null) {
            filterParam = filterParam + ";Q_updateTime_D_LT=" + endMillion;
        }
        List results = this.deviceTrackDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        return results;
    }

    public DeviceTrack save(DeviceTrack track, boolean isFirst) {
        Date date = new Date();
        String filterParam = "Q_deviceId_S_EQ=" + track.getDeviceId() + ";Q_updateTime_D_GT=" + new Date(date.getYear(), date.getMonth(), date.getDate()).getTime();
        String sortParam = "SORT_updateTime_DESC";
        List tracks = this.deviceTrackDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)0, (int)1, (Sort)QueryParamUtil.parseSortParams((String)sortParam))).getContent();
        return (DeviceTrack)this.deviceTrackDao.save((Object)track);
    }

    private double distance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = lat1 * Math.PI / 180.0;
        double radLat2 = lat2 * Math.PI / 180.0;
        double a = radLat1 - radLat2;
        double b = (lon1 - lon2) * Math.PI / 180.0;
        double earthRadius = 6378137.0;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= earthRadius;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    public String saveUploadReport(HttpServletRequest request, Long userId) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> recordId = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile multipartFile = multiRequest.getFile((String)iter.next());
                if (multipartFile == null) continue;
                String parentDir = "locfile";
                File reportFile = this.getFileFromMultipartFile(multipartFile, ".txt", parentDir);
                JSONObject additionJson = new JSONObject();
                additionJson.put("file", (Object)(parentDir + File.separator + reportFile.getName()));
                TaskRecord record = new TaskRecord();
                record.setId(UUID.randomUUID().toString());
                record.setParam(JSONObject.toJSONString((Object)additionJson));
                record.setTasktype(JobConstants.JOB_TYPE_DEVICE_TRACK_UPDATE);
                record.setStarttime(new Date());
                record.setState(JobConstants.JOB_STATE_CREATE);
                record.setUserid(userId);
                this.taskRecordService.save(record);
                recordId.add(record.getId());
            }
        }
        return StringUtils.join(recordId, (String)",");
    }

    public boolean readLocFile(TaskRecord record) throws Exception {
        boolean flag = false;
        String paramater = record.getParam();
        if (StringUtils.isNotBlank((CharSequence)paramater)) {
            JSONObject param = JSONObject.parseObject((String)paramater);
            File locFile = new File(this.uploadDir + File.separator + param.getString("file"));
            if (locFile.exists()) {
                Long userid = record.getUserid();
                ArrayList<DeviceTrackUpload> list = new ArrayList<DeviceTrackUpload>();
                ArrayList<String> ids = new ArrayList<String>();
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(locFile), "UTF-8"));
                String lineTxt = null;
                while ((lineTxt = br.readLine()) != null) {
                    DeviceTrackUpload temp = this.convertTxtToTrack(lineTxt, userid);
                    if (StringUtils.isNotBlank((CharSequence)temp.getId()) && !this.deviceTrackUploadRepository.exists((Specification)temp) && !ids.contains(temp.getId())) {
                        list.add(temp);
                        ids.add(temp.getId());
                    }
                    if (list.size() <= 100) continue;
                    this.deviceTrackUploadRepository.saveAll(list);
                    list.clear();
                    ids.clear();
                }
                if (list.size() > 0) {
                    this.deviceTrackUploadRepository.saveAll(list);
                    list.clear();
                    ids.clear();
                }
                flag = true;
            }
        }
        return flag;
    }

    public Boolean checkId(String id) {
        boolean tag = false;
        List list = this.deviceTrackUploadRepository.findDeviceTrackUploadById(id);
        if (list != null && list.size() > 0) {
            tag = true;
        }
        return tag;
    }

    private DeviceTrackUpload convertTxtToTrack(String lineTxt, Long userId) {
        String[] strings;
        DeviceTrackUpload track = new DeviceTrackUpload();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : strings = lineTxt.split(",")) {
            map.put(string.split(":")[0], string.split(":")[1]);
        }
        track.setLat(Double.valueOf((String)map.get("lat")));
        track.setLon(Double.valueOf((String)map.get("lon")));
        track.setUpdateTime(new Date(Long.parseLong((String)map.get("timestamp"))));
        track.setUserId(userId);
        track.setDeviceId(String.valueOf(userId));
        track.setId((String)map.get("timestamp") + "-" + userId);
        if (map.containsKey("type")) {
            track.setType((String)map.get("type"));
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix, String parentDir) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + File.separator + parentDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }
}

