/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.entity.InterestGroup;
import com.geoway.landteam.landcloud.core.model.pub.entity.InterestPoint;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.pub.InterestGroupRepository;
import com.geoway.landteam.landcloud.core.repository.pub.InterestPointRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MInterestPointService {
    @Autowired
    RegionService regionService;
    @Autowired
    InterestPointRepository interestPointDao;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    InterestGroupRepository interestGroupDao;
    @Autowired
    RegionRepository regionRepository;

    public Page<InterestGroup> getMyInterestGroups(Long userId, int start, int limit) throws Exception {
        String filterParam = "Q_userId_N_EQ=" + userId + ";Q_isDeleted_N_EQ=0";
        String sortParam = "SORT_createTime_DESC";
        Page interestGroups = this.interestGroupDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (InterestGroup interestGroup : interestGroups) {
            Page<InterestPoint> interestPoints = this.getInterestPointsByGroupId(interestGroup.getId(), 0, 1000, "", "");
            interestGroup.setInterestPoints(interestPoints.getContent());
        }
        return interestGroups;
    }

    public InterestGroup createInterestGroup(Long userId, String groupName) throws Exception {
        Page<InterestGroup> myInterestGroups = this.getMyInterestGroups(userId, 0, 1000);
        for (InterestGroup interestGroup : myInterestGroups) {
            if (!interestGroup.getGroupName().equals(groupName)) continue;
            throw new RuntimeException("\u5174\u8da3\u7ec4\u540d\u91cd\u590d");
        }
        InterestGroup interestGroup = new InterestGroup();
        interestGroup.setId(UUID.randomUUID().toString());
        interestGroup.setUserId(userId);
        interestGroup.setGroupName(groupName);
        interestGroup.setCreateTime(new Date());
        interestGroup.setIsDeleted(Integer.valueOf(0));
        interestGroup.setIsDefault(Integer.valueOf(0));
        this.interestGroupDao.save((Object)interestGroup);
        return interestGroup;
    }

    public void deleteInterestGroup(String groupId, Long userid) throws Exception {
        InterestGroup interestGroup = (InterestGroup)this.interestGroupDao.gwSearchByPK((Serializable)((Object)groupId));
        if (userid.equals(interestGroup.getUserId())) {
            interestGroup.setIsDeleted(Integer.valueOf(1));
            List list = this.interestPointDao.getInterestPointsByGroupId(groupId);
            if (list.size() > 0) {
                for (InterestPoint interestPoint : list) {
                    interestPoint.setIsDeleted(Integer.valueOf(1));
                }
                this.interestPointDao.saveAll((Iterable)list);
            }
        } else {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void renameInterestGroup(String groupId, String groupName, Long userid) {
        InterestGroup interestGroup = (InterestGroup)this.interestGroupDao.gwSearchByPK((Serializable)((Object)groupId));
        if (!userid.equals(interestGroup.getUserId())) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
        interestGroup.setGroupName(groupName);
        this.interestGroupDao.save((Object)interestGroup);
    }

    public InterestPoint createInterestPoint(Long userId, String name, String groupId, String lat, String lon, Integer drawIndex) throws Exception {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        double dLon = Double.parseDouble(lon);
        double dLat = Double.parseDouble(lat);
        String wkt = "POINT(" + dLon + " " + dLat + ")";
        InterestPoint interestPoint = new InterestPoint();
        RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
        if (region != null) {
            interestPoint.setCity(region.getCode());
            interestPoint.setCityName(region.getName());
        } else {
            region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
            if (region != null) {
                interestPoint.setCity(region.getPcode());
                Region parentRegion = this.regionRepository.findByCodeAndVersion(region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                interestPoint.setCityName(parentRegion.getName());
            } else {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u7ecf\u7eac\u5ea6\u6570\u636e\u662f\u5426\u6b63\u786e");
            }
        }
        interestPoint.setId(UUID.randomUUID().toString());
        interestPoint.setUserId(userId);
        interestPoint.setName(name);
        interestPoint.setDrawIndex(drawIndex);
        if (!"default".equalsIgnoreCase(groupId)) {
            interestPoint.setTheGroup(groupId);
        } else {
            InterestGroup interestGroup = this.interestGroupDao.findDefaultWorkGroup(userId);
            if (interestGroup == null) {
                interestGroup = this.createInterestGroup(userId, "\u9ed8\u8ba4\u5174\u8da3\u7ec4");
                interestGroup.setIsDefault(Integer.valueOf(1));
                this.interestGroupDao.save((Object)interestGroup);
            }
            interestPoint.setTheGroup(interestGroup.getId());
        }
        Page<InterestPoint> interestPoints = this.getInterestPointsByGroupId(interestPoint.getTheGroup(), 0, 1000, "", "");
        for (InterestPoint point : interestPoints) {
            if (!point.getName().equals(name)) continue;
            throw new RuntimeException("\u5174\u8da3\u70b9\u540d\u91cd\u590d");
        }
        interestPoint.setLat(Double.valueOf(lat));
        interestPoint.setLon(Double.valueOf(lon));
        interestPoint.setCreateTime(new Date());
        interestPoint.setIsDeleted(Integer.valueOf(0));
        this.interestPointDao.save((Object)interestPoint);
        return interestPoint;
    }

    public Page<InterestPoint> getInterestPointsByGroupId(String groupId, int start, int limit, String filterParam, String sortType) throws Exception {
        if (!"".equals(filterParam)) {
            filterParam = filterParam + ";";
        }
        filterParam = filterParam + "Q_theGroup_S_EQ=" + groupId + ";Q_isDeleted_N_EQ=0";
        String sortParam = "asc".equals(sortType) ? "SORT_createTime_DESC" : "SORT_createTime_ASC";
        return this.interestPointDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    public void deleteInterestPoint(String ids, Long userId) throws Exception {
        String[] idArr;
        for (String id : idArr = ids.split(",")) {
            InterestPoint interestPoint = (InterestPoint)this.interestPointDao.gwSearchByPK((Serializable)((Object)id));
            if (!userId.equals(interestPoint.getUserId())) {
                throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
            }
            interestPoint.setIsDeleted(Integer.valueOf(1));
            this.interestPointDao.save((Object)interestPoint);
        }
    }

    public void updateInterestPoint(Long userId, String id, String name, String groupId, Integer drawIndex) throws Exception {
        InterestPoint interestPoint = (InterestPoint)this.interestPointDao.gwSearchByPK((Serializable)((Object)id));
        if (userId.equals(interestPoint.getUserId())) {
            if (name != null && !"".equals(name)) {
                interestPoint.setName(name);
            }
            if (groupId != null && !"".equals(groupId)) {
                if (!"default".equals(groupId)) {
                    interestPoint.setTheGroup(groupId);
                } else {
                    InterestGroup interestGroup = this.interestGroupDao.findDefaultWorkGroup(userId);
                    if (interestGroup == null) {
                        interestGroup = this.createInterestGroup(userId, "\u9ed8\u8ba4\u5174\u8da3\u7ec4");
                        interestGroup.setIsDefault(Integer.valueOf(1));
                        this.interestGroupDao.save((Object)interestGroup);
                    }
                    interestPoint.setTheGroup(interestGroup.getId());
                }
                Page<InterestPoint> interestPoints = this.getInterestPointsByGroupId(interestPoint.getTheGroup(), 0, 1000, "", "");
                for (InterestPoint point : interestPoints) {
                    if (!point.getName().equals(name)) continue;
                    throw new RuntimeException("\u5174\u8da3\u70b9\u540d\u91cd\u590d");
                }
            }
            if (drawIndex != null && drawIndex > 0) {
                interestPoint.setDrawIndex(drawIndex);
            }
        } else {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
        this.interestPointDao.save((Object)interestPoint);
    }

    public List<Map<String, Object>> getInterestPointCities(String groupId) throws Exception {
        ArrayList<Map<String, Object>> theList = new ArrayList<Map<String, Object>>();
        List list = this.interestPointDao.getInterestPointCities(groupId);
        for (Object object : list) {
            Object[] arr = (Object[])object;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("city", arr[0]);
            map.put("cityName", arr[1]);
            map.put("num", arr[2]);
            map.put("createTime", arr[3]);
            theList.add(map);
        }
        return theList;
    }

    public Page<InterestPoint> getInterestPointByCity(String groupId, String city, String sortType, int start, int limit) {
        String filterParam = "Q_theGroup_S_EQ=" + groupId + ";Q_city_S_EQ=" + city + ";Q_isDeleted_N_EQ=0";
        String sortParam = "asc".equals(sortType) ? "SORT_createTime_ASC" : "SORT_createTime_DESC";
        return this.interestPointDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }
}

