/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbsysInspectionRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbsysSignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbsysUserTrackRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbsysInspectionRecord;
import com.geoway.landteam.customtask.task.entity.TbsysSignRecord;
import com.geoway.landteam.customtask.task.entity.TbsysUserTrackRecord;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterUserTrackTranService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterZeroReportTransmitDataService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanContentMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeServiceMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanTaskMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolProgramMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.TbPatrolGzqkMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanTask;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolProgram;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.TbPatrolGzqk;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class MPatrolService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    OuterUserTrackTranService userTrackTranService;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaRepository;
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    TbsysSignRecordRepository tbsysSignRecordRepository;
    @Autowired
    TbsysInspectionRecordRepository tbsysInspectionRecordRepository;
    @Autowired
    OuterZeroReportTransmitDataService zeroReportTransmitDataService;
    @Autowired
    RegionService regionService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Resource
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbsysUserTrackRecordRepository tbsysUserTrackRecordRepository;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;
    @Autowired
    TbPatrolGzqkMapper tbPatrolGzqkMapper;

    public Map<String, Object> findPlanList(Long userId, String classId, int page, int rows) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int start = (page - 1) * rows;
        List list = new ArrayList();
        int count = 0;
        if (StringUtils.isNotBlank((CharSequence)classId)) {
            list = this.patrolPlanMapper.findLeftAreaByFUseridAndClassIdlimit(userId, classId, start, rows);
            count = this.patrolPlanMapper.findLeftAreaByFUseridAndClassIdcount(userId, classId);
        } else {
            list = this.patrolPlanMapper.findLeftAreaByFUseridlimit(userId, start, rows);
            count = this.patrolPlanMapper.findLeftAreaByFUseridcount(userId);
        }
        if (!list.isEmpty()) {
            List resultList = list.stream().filter(MPatrolService.distinctByKey(PatrolPlan::getfId)).collect(Collectors.toList());
            for (PatrolPlan patrolPlan : resultList) {
                patrolPlan.setTaskCount(this.patrolPlanTaskMapper.taskCount(patrolPlan.getfId()));
                patrolPlan.setCompleteCount(this.patrolPlanTaskMapper.completeCount(patrolPlan.getfId(), Integer.valueOf(2)));
            }
            result.put("data", resultList);
            result.put("totalCount", count);
        }
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public Map<String, Object> findPlanTaskList(Long userId, String planId, int page, int rows) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PatrolPlan one = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)planId);
        int start = (page - 1) * rows;
        List list = this.patrolPlanTaskMapper.findByFPlanidLimit(planId, start, rows);
        int totalCount = this.patrolPlanTaskMapper.findByFPlanidCount(planId);
        if (!list.isEmpty()) {
            List distinctList = list.stream().filter(MPatrolService.distinctByKey(PatrolPlanTask::getfId)).collect(Collectors.toList());
            List tskTaskBizs = this.tskTaskBizService.getTskTaskBizByClassId(Long.valueOf(Long.parseLong(one.getfPatrolbusiness())));
            String tableName = "";
            if (tskTaskBizs.isEmpty()) {
                throw new RuntimeException("\u4efb\u52a1\u8868\u4e0d\u5b58\u5728");
            }
            TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.findById((Object)((TskTaskBiz)tskTaskBizs.get(0)).getTableId()).orElse(null);
            tableName = tableInfo.getfTablename();
            for (PatrolPlanTask planTask : distinctList) {
                planTask.setSignCount(Integer.valueOf(this.tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, planTask.getfId())));
                planTask.setWorkReportCount(Integer.valueOf(this.tbPatrolGzqkMapper.findByFUseridAndFPlanidAndFXsrwidCount(Integer.valueOf(userId.intValue()), planId, planTask.getfId())));
                String sql = "select count(1) from " + tableName + " where f_xsrwid = '" + planTask.getfId() + "' and f_userid ='" + userId + "'";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
                planTask.setXsCount(count);
            }
            result.put("data", distinctList);
            result.put("totalCount", totalCount);
            return result;
        }
        result.put("data", list);
        result.put("totalCount", totalCount);
        return result;
    }

    public int userClockIn(Long userId, String lon, String lat, String planId, String xsrwId) {
        int signCount = 1;
        String wkt = "POINT(" + lon + " " + lat + ")";
        try {
            Geometry geometry = WKTUtil.wktToGeom((String)wkt);
            String code = "";
            String codeName = "";
            RegionVillage regionVillage = this.regionService.queryRegionVillageByCoor(geometry);
            if (regionVillage != null) {
                code = regionVillage.getCode();
                codeName = regionVillage.getName();
            } else {
                RegionTown regionTown = this.regionService.queryRegionTownCotain(geometry);
                if (regionTown != null) {
                    code = regionTown.getCode();
                    codeName = regionTown.getName();
                } else {
                    RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                    if (region != null) {
                        code = region.getCode();
                        codeName = region.getName();
                    }
                }
            }
            TbsysSignRecord bean = new TbsysSignRecord();
            bean.setUserId(userId);
            bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bean.setRegionCode(code);
            bean.setAddr(codeName);
            bean.setLat(Double.valueOf(Double.parseDouble(lat)));
            bean.setLon(Double.valueOf(Double.parseDouble(lon)));
            bean.setPlanId(planId);
            bean.setXsrwId(xsrwId);
            this.tbsysSignRecordRepository.save((Object)bean);
            signCount = this.tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, xsrwId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signCount;
    }

    public TbsysInspectionRecord submitInspection(String regionCode, Long userId, String planId, String xsrwId) throws Exception {
        TbsysInspectionRecord bean = new TbsysInspectionRecord();
        bean.setUserId(userId);
        bean.setRegionCode(regionCode);
        bean.setState(Integer.valueOf(0));
        bean.setRemark("\u672c\u6b21\u5de1\u67e5\u65e0\u95ee\u9898");
        bean.setPlanId(planId);
        bean.setXsrwId(xsrwId);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        TbsysInspectionRecord save = (TbsysInspectionRecord)this.tbsysInspectionRecordRepository.save((Object)bean);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"zeroReport");
        jsonObject.put("operUserId", (Object)userId);
        jsonObject.put("TbsysInspectionRecord", (Object)JSONObject.toJSONString((Object)save, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.zeroReportTransmitDataService.zeroReportData(jsonObject);
        return save;
    }

    public JSONArray findUserClockInDatas(Long userId, String xsrwId, int pageIndex, int pageSize) {
        JSONArray jsonArray = new JSONArray();
        int start = (pageIndex - 1) * pageSize;
        String sql = "SELECT\n\tto_char( f_createtime, 'yyyy-MM-dd' ) AS d,\n\tCOUNT ( 1 ) AS signCount \nFROM\n\ttbsys_sign_record \nWHERE\n\tf_xsrwid = '" + xsrwId + "' \n\tAND f_userid = '" + userId + "' GROUP BY d order by d desc limit " + pageSize + " offset " + start;
        List maps = this.dataBizService.queryDataBySql(sql);
        if (!maps.isEmpty()) {
            for (Map map : maps) {
                String date = map.get("d").toString();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("date", (Object)date);
                jsonObject.put("count", (Object)map.get("signcount").toString());
                String sql1 = "select f_regioncode,f_addr,f_lat,f_lon,f_createtime from tbsys_sign_record  where  f_userid = '" + userId + "'  and to_char( f_createtime, 'yyyy-MM-dd' ) ='" + date + "' order by f_createtime desc";
                List map1s = this.jdbcTemplate.queryForList(sql1);
                jsonObject.put("signs", (Object)map1s);
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    public List<TbsysInspectionRecord> findUserZeroReports(Long userId, String xsrwId, int pageIndex, int pageSize) {
        int start = (pageIndex - 1) * pageSize;
        List recordList = this.tbsysInspectionRecordRepository.findByUserIdAndXsrwIdLimt(userId, xsrwId, start, pageSize);
        return recordList;
    }

    public void saveUserTracks(HttpServletRequest request, Long userId) throws Exception {
        MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
        String name = fileOfDB.getOriginalFilename();
        String key = String.format("userTrackdData/%s/%s", userId, name);
        String url = this.ossOperatorService.sendObject2Oss(key, fileOfDB.getInputStream());
        if (url == null || "".equals(url)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        JSONObject params = new JSONObject();
        params.put("userId", (Object)userId);
        params.put("url", (Object)url);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_USER_TRACK);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUserTracks(TaskRecord record) {
        HttpURLConnection conn = null;
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            Long userId = paramsObject.getLongValue("userId");
            String dataUrl = paramsObject.getString("url");
            String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", dataUrl, null);
            URL url = new URL(uploadurl);
            if (url != null) {
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("Charset", "UTF-8");
                File tempUploadFile = this.buildTempUploadFile(userId.toString());
                FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)tempUploadFile);
                SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
                Connection connection = connPool.getConnection();
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(" select * from track");
                ArrayList<TbsysUserTrackRecord> tbsysUserTrackRecordList = new ArrayList<TbsysUserTrackRecord>();
                while (rs.next()) {
                    TbsysUserTrackRecord bean = new TbsysUserTrackRecord();
                    bean.setId(rs.getString("f_id"));
                    bean.setLat(Double.valueOf(rs.getDouble("f_lat")));
                    bean.setLon(Double.valueOf(rs.getDouble("f_lon")));
                    bean.setPlanId(rs.getString("f_jhid"));
                    bean.setXsrwId(rs.getString("f_xsrwid"));
                    if (rs.findColumn("f_batch") > 0) {
                        bean.setBatch(rs.getString("f_batch"));
                    }
                    bean.setUserId(userId);
                    bean.setCreateTime(new Timestamp(Long.valueOf(rs.getString("f_createtime"))));
                    tbsysUserTrackRecordList.add(bean);
                    if (tbsysUserTrackRecordList.size() < 500) continue;
                    this.tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                    tbsysUserTrackRecordList.clear();
                }
                if (tbsysUserTrackRecordList.size() > 0) {
                    this.tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                }
                connPool.closeAll(connection, statement, rs);
                tempUploadFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("track-%s-%s-%s.db", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(this.uploadDir, fileName);
    }

    public Map<String, Object> getPlanDetails(Long userId, String planId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PatrolPlan patrolPlan = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)planId);
        PatrolProgram patrolProgram = (PatrolProgram)this.patrolProgramMapper.gwSearchByPK((Serializable)((Object)patrolPlan.getfRelprogram()));
        List patrolPlanContents = this.patrolPlanContentMapper.getListByPlanId(planId);
        List patrolPlanScopeServices = this.patrolPlanScopeServiceMapper.findByPlanId(planId);
        List patrolPlanScopes = new ArrayList();
        if (!patrolPlanScopeServices.isEmpty()) {
            List ids = patrolPlanScopeServices.stream().map(p -> p.getfScopeid()).collect(Collectors.toList());
            patrolPlanScopes = this.patrolPlanScopeMapper.selectByIds(ids);
        }
        String sql = " select area.f_area regioncode,case \n        when length(area.f_area)=6 then (select f_xzqmc from tb_region where f_xzqdm = area.f_area)\n        when length(area.f_area)=9 then (select xzqmc from tb_region_town where xzqdm = area.f_area)\n        when length(area.f_area)=12 then (select xzqmc from tb_region_village where xzqdm = area.f_area)\n        end as regionName\nfrom  tb_patrol_plan_area area where area.f_role ='3' and area.f_planid ='" + planId + "' and area.f_userid ='" + userId + "' ";
        List maps = this.dataBizService.queryDataBySql(sql);
        result.put("patrolPlan", patrolPlan);
        result.put("patrolPlanContents", patrolPlanContents);
        result.put("patrolPlanScopes", patrolPlanScopes);
        result.put("regionScopes", maps);
        result.put("patrolProgram", patrolProgram);
        return result;
    }

    public void patrolCaseSubmit(Long userId, TbPatrolGzqk patrolGzqk) {
        if (patrolGzqk != null) {
            patrolGzqk.setfCreatetime(new Date());
            patrolGzqk.setfUserid(Integer.valueOf(userId.intValue()));
            patrolGzqk.setfId(UUID.randomUUID().toString());
            this.tbPatrolGzqkMapper.insert((Object)patrolGzqk);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"patrolCase");
            jsonObject.put("operUserId", (Object)userId);
            jsonObject.put("PatrolGzqk", (Object)JSONObject.toJSONString((Object)patrolGzqk, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            try {
                this.zeroReportTransmitDataService.zeroReportData(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TbPatrolGzqk getPatrolCase(Long userId, String planId, String xsrwId) {
        TbPatrolGzqk patrolGzqk = this.tbPatrolGzqkMapper.findByFUseridAndFPlanidAndFXsrwid(Integer.valueOf(userId.intValue()), planId, xsrwId);
        return patrolGzqk;
    }
}

